/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.fa.facade.app.AbstractFaBaseServiceFacadeControllerBean;
import com.kingdee.eas.fi.fa.facade.app.base.CompanyDataImpl;
import com.kingdee.eas.fi.fa.facade.app.base.DataProvider;
import com.kingdee.eas.fi.fa.facade.app.base.FaBatchServiceImpl;
import com.kingdee.eas.fi.fa.facade.app.base.MainOrgFilterImpl;
import com.kingdee.eas.fi.fa.facade.app.depre.FaDepCalServiceImpl;
import com.kingdee.eas.fi.fa.facade.app.model.IModelCreate;
import com.kingdee.eas.fi.fa.facade.app.model.ModelCreateContext;
import com.kingdee.eas.fi.fa.facade.app.util.FasBosUtils;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaWebException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaBaseServiceFacadeControllerBean
extends AbstractFaBaseServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.facade.app.FaBaseServiceFacadeControllerBean");

    @Override
    protected Map<String, Object> _batchOperation(Context ctx, String bosType, String methodName, String[] billIDs) throws BOSException, EASBizException {
        return new FaBatchServiceImpl(ctx).batchOperation(bosType, methodName, billIDs);
    }

    @Override
    protected IObjectValue _getCompanyOrgData(Context ctx, String companyOrgUnitId, String selector, String permissionItem) throws BOSException, EASBizException {
        return new CompanyDataImpl(ctx).getCompanyOrgData(companyOrgUnitId, selector, permissionItem);
    }

    @Override
    protected IObjectValue _getExchangeRate(Context ctx, String targetCurrencyId, String currencyId, String exchangeTableId, String date) throws BOSException, EASBizException {
        return new DataProvider(ctx).getExchangeRate(targetCurrencyId, currencyId, exchangeTableId, date);
    }

    @Override
    protected IObjectValue _getMainOrgFilter(Context ctx, String permissionItem) throws BOSException, EASBizException {
        return new MainOrgFilterImpl(ctx).getMainOrgFilter(permissionItem);
    }

    @Override
    protected IObjectValue _createModel(Context ctx, String bosType, String mainOrgUnitId) throws BOSException, EASBizException {
        IModelCreate creator = ModelCreateContext.getModelCreator(bosType);
        return creator.createModel(bosType, mainOrgUnitId, ctx);
    }

    @Override
    protected IObjectValue _getDataInfo(Context ctx, String bosType, String id, String selector) throws BOSException, EASBizException {
        return new DataProvider(ctx).getDataInfo(bosType, id, selector);
    }

    @Override
    protected IObjectValue _billCopy(Context ctx, AbstractObjectValue dataObject) throws BOSException, EASBizException {
        return new DataProvider(ctx).billCopy(dataObject);
    }

    @Override
    protected IObjectValue _getCompanyAndParamsData(Context ctx, String companyOrgUnitId) throws BOSException, EASBizException {
        return new CompanyDataImpl(ctx).getCompanyAndParamsData(companyOrgUnitId);
    }

    @Override
    protected IObjectValue _getDataCollection(Context ctx, String bosType, String oql) throws BOSException, EASBizException {
        return new DataProvider(ctx).getDataCollection(bosType, oql);
    }

    @Override
    protected CompanyOrgUnitCollection _getFuncPermissionOrgs(Context ctx, String permissionItem) throws BOSException, EASBizException {
        return new CompanyDataImpl(ctx)._getFuncPermissionOrgs(ctx, permissionItem);
    }

    @Override
    protected Map<String, Object> _getCompanyAndPeriod(Context ctx, String permissionItem) throws BOSException, EASBizException {
        return new CompanyDataImpl(ctx).getCompanyAndPeriod(permissionItem);
    }

    @Override
    protected String _getCompanyIDSQL(Context ctx, String permissionItem) throws BOSException, EASBizException {
        return new CompanyDataImpl(ctx).getCompanyIDSQL(ctx, permissionItem);
    }

    @Override
    protected IObjectValue _getPrePeriodInfo(Context ctx, String companyid) throws BOSException, EASBizException {
        PeriodInfo[] periods = FaPeriodCloseFacadeFactory.getLocalInstance((Context)ctx).getLastestPeriod(companyid);
        PeriodInfo periodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)periods[1]);
        return periodInfo;
    }

    @Override
    protected AdminOrgUnitInfo _getPrimaryAdminOrg(Context ctx, String personId) throws BOSException {
        return new CompanyDataImpl(ctx).getPrimaryAdminOrg(personId);
    }

    @Override
    protected List _getCompanyAndParamsDataList(Context ctx, String companyOrgUnitIds) throws BOSException, EASBizException {
        return new CompanyDataImpl(ctx).getCompanyAndParamsDataList(companyOrgUnitIds);
    }

    @Override
    protected String _getOrgDataFilter(Context ctx, boolean share, String bosType) throws BOSException, EASBizException {
        String permItem = ModelCreateContext.getModelPermissionView(bosType);
        StringBuffer orgDataFilter = new StringBuffer("id in ( ");
        CompanyOrgUnitCollection companyOrgUnitCollection = new CompanyOrgUnitCollection();
        if (!share) {
            CompanyOrgUnitInfo current = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
            if ("fa_facat_list".equals(permItem) || "fa_deppolicy_list".equals(permItem) || "fa_usestatus_list".equals(permItem) || "fa_altermode_list".equals(permItem) || "fa_economic_list".equals(permItem)) {
                companyOrgUnitCollection.add(current);
            } else {
                if (!current.isIsBizUnit()) {
                    throw new FaWebException(FaWebException.CUORGVIRTUAL);
                }
                if (current.isIsBizUnit()) {
                    boolean isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(current.getId().toString()), permItem);
                    if (!isPermission) {
                        throw new FaWebException(FaWebException.NO_VIEW_PERMISSION);
                    }
                    if (current.isIsSealUp()) {
                        throw new FaWebException(FaWebException.CUORGSEALED);
                    }
                    if (current.getInvalidDate() != null && DateTimeUtils.dayBefore((Date)current.getInvalidDate(), (Date)new Date())) {
                        String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Disabled");
                        throw new EASBizException(new NumericExceptionSubItem("Company_Disabled", strMsg));
                    }
                    ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)current.getId().toString()));
                    PeriodInfo currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)orgPk);
                    if (currenctPeriod == null) {
                        String strMsg = EASCommonResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notConfigStartPeriod", (Locale)ctx.getOriginLocale());
                        throw new CasWebException(new NumericExceptionSubItem("1", strMsg));
                    }
                    boolean isInitEnd = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)current);
                    if (!("fa_evascheme_view".equals(permItem) || "fa_init_view".equals(permItem) || isInitEnd)) {
                        String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.FaCurCardEditUI_FANotEndInit");
                        throw new EASBizException(new NumericExceptionSubItem("FaCurCardEditUI_FANotEndInit", strMsg));
                    }
                    companyOrgUnitCollection.add(current);
                }
            }
        } else {
            companyOrgUnitCollection = this.getOrgsByPermission(ctx, permItem);
        }
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            CompanyOrgUnitInfo orgInfo = companyOrgUnitCollection.get(i);
            orgDataFilter.append("'" + orgInfo.getId().toString() + "',");
        }
        if (orgDataFilter.toString().equals("id in ( ")) {
            orgDataFilter = new StringBuffer("id in ('NE')");
        } else {
            orgDataFilter.deleteCharAt(orgDataFilter.length() - 1);
            orgDataFilter.append(") ");
        }
        return orgDataFilter.toString();
    }

    public CompanyOrgUnitCollection getOrgsByPermission(Context ctx, String permItem) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitCollection collection = new CompanyOrgUnitCollection();
        CompanyOrgUnitCollection permCollection = new CompanyOrgUnitCollection();
        collection = this.getAuthrizedCompanyOrg(ctx, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), permItem, false);
        Iterator iterator = collection.iterator();
        boolean i = false;
        while (iterator.hasNext()) {
            CompanyOrgUnitInfo orgInfo = (CompanyOrgUnitInfo)iterator.next();
            if (!orgInfo.isIsBizUnit() || orgInfo.isIsSealUp()) continue;
            permCollection.add(orgInfo);
        }
        if (permCollection == null || permCollection.size() <= 0) {
            throw new FaWebException(FaWebException.NO_VIEW_PERMISSION_ALL);
        }
        CompanyOrgUnitCollection isInitEndCollection = new CompanyOrgUnitCollection();
        for (int j = 0; j < permCollection.size(); ++j) {
            CompanyOrgUnitInfo orgInfo = permCollection.get(j);
            boolean isInitEnd = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)orgInfo);
            if (!isInitEnd) continue;
            isInitEndCollection.add(orgInfo);
        }
        if (isInitEndCollection == null || isInitEndCollection.size() == 0) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.FaCurCardEditUI_FANotEndInit");
            throw new EASBizException(new NumericExceptionSubItem("FaCurCardEditUI_FANotEndInit", strMsg));
        }
        return isInitEndCollection;
    }

    protected CompanyOrgUnitCollection getAuthrizedCompanyOrg(Context ctx, String userID, String permItemName, boolean includeVirtual) throws BOSException, EASBizException {
        FullOrgUnitCollection collection;
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        String orgTreeId = OrgCommonUtils.getOrgTreeId((OrgType)OrgType.Company);
        ObjectUuidPK orgTreePK = null;
        if (orgTreeId != null) {
            orgTreePK = new ObjectUuidPK(orgTreeId);
        }
        if ((collection = iPermission.getAuthorizedOrg(ctx.getCaller(), OrgType.Company, (IObjectPK)orgTreePK, permItemName)).size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            idSet.add(collection.get(i).getId().toString());
        }
        FasBosUtils.EntityViewBuilder viewBuilder = FasBosUtils.entityViewBuilder();
        viewBuilder.select("id", "number", "name", "longNumber", "level", "isBizUnit", "isIsSealUp").sort("longNumber", SortType.ASCEND).sort("number", SortType.ASCEND).filter("id", idSet, CompareType.INCLUDE);
        if (!includeVirtual) {
            viewBuilder.filter("isBizUnit", true, CompareType.EQUALS);
        }
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(viewBuilder.build());
        return coll;
    }

    @Override
    protected void _FaBaseServiceFacade(Context ctx) throws BOSException {
    }

    @Override
    protected IObjectValue _createModel(Context ctx, String bosType, Map filterMap) throws BOSException, EASBizException {
        IModelCreate creator = ModelCreateContext.getModelCreator(bosType);
        return creator.createModel(bosType, filterMap, ctx);
    }

    @Override
    protected Map<String, Object> _checkPermission(Context ctx, String orgID, String permItemName) throws BOSException, EASBizException {
        return new FaDepCalServiceImpl(ctx).checkPermission(orgID, permItemName);
    }

    @Override
    protected String _getOrgDataFilterNoPermission(Context ctx, boolean share, String bosType) throws BOSException, EASBizException {
        return null;
    }
}

