/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationRuleEnum;
import com.kingdee.eas.fi.fa.facade.app.AbstractFaClearBillServiceFacadeControllerBean;
import com.kingdee.eas.fi.fa.facade.app.util.FaServerUtil;
import com.kingdee.eas.fi.fa.manage.FaBakCardCollection;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBillOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaChangeStatusEnmu;
import com.kingdee.eas.fi.fa.manage.FaClearBillCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillException;
import com.kingdee.eas.fi.fa.manage.FaClearBillFactory;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaClearBill;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FaClearBillServiceFacadeControllerBean
extends AbstractFaClearBillServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.facade.app.FaClearBillServiceFacadeControllerBean");
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static String className = "com.kingdee.eas.fi.fa.manage.FaCardResource";

    protected ICoreBase getBizInterface(Context ctx) throws BOSException, EASBizException {
        return FaClearBillFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected Map<String, Object> _getPreDecTTerm(Context ctx, String faCurCardId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FaCurCardInfo cardInfo = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(faCurCardId), this.getCurCardSelectors());
        BigDecimal preDecTTerm = this.getPreDectTerm(ctx, cardInfo);
        result.put("preDecTTerm", preDecTTerm);
        return result;
    }

    @Override
    protected Map<String, Object> _getPreDecTTerm(Context ctx, IObjectValue faCurCardInfo) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FaCurCardInfo cardInfo = (FaCurCardInfo)faCurCardInfo;
        BigDecimal preDecTTerm = this.getPreDectTerm(ctx, cardInfo);
        result.put("preDecTTerm", preDecTTerm);
        return result;
    }

    @Override
    protected Map<String, Object> _getCurcardInfoCollection(Context ctx, String existId, String curcardIds, String pageStatus) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> existIds = Arrays.asList(existId.split(","));
        List<String> curcardId = Arrays.asList(curcardIds.split(","));
        HashSet<String> idset = new HashSet<String>();
        for (int i = 0; i < curcardId.size(); ++i) {
            if (existIds.contains(curcardId.get(i))) continue;
            idset.add(curcardId.get(i));
        }
        SelectorItemCollection sic = this.getCurCardSelectors();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        view.setFilter(f);
        view.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSorter(sorter);
        FaCurCardCollection curcardColection = new FaCurCardCollection();
        if ("VIEW".equals(pageStatus)) {
            FaBakCardCollection bakCardCollection = FaBakCardFactory.getLocalInstance((Context)ctx).getFaBakCardCollection(view);
            for (FaBakCardInfo bakCardInfo : bakCardCollection) {
                FaCurCardInfo curCardInfo = FaManageUtils.BakCard2CurCard((FaBakCardInfo)bakCardInfo);
                curCardInfo.setId(bakCardInfo.getFaCurCard().getId());
                curcardColection.add(curCardInfo);
            }
        } else {
            curcardColection = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardCollection(view);
        }
        if (curcardColection != null) {
            for (int i = 0; i < curcardColection.size(); ++i) {
                FaCurCardInfo entryInfo = curcardColection.get(i);
                String lastUpdateTime = entryInfo.getLastUpdateTime().toString();
                if (entryInfo.getTreatmentIncome() == null) {
                    entryInfo.setTreatmentIncome(BigDecimal.ZERO);
                }
                entryInfo.put("lastUpdateTime", (Object)lastUpdateTime);
            }
        }
        result.put("curcardCollection", curcardColection);
        return result;
    }

    @Override
    protected String _saveClearBill(Context ctx, IObjectValue faClearBillInfo) throws BOSException, EASBizException {
        IFaClearBill iFactory = (IFaClearBill)this.getBizInterface(ctx);
        FaClearBillInfo clearBillInfo = (FaClearBillInfo)faClearBillInfo;
        FaClearBillEntryCollection entry = clearBillInfo != null ? clearBillInfo.getClearBillEntry() : null;
        this.setEntryId(clearBillInfo, entry, ctx);
        this.setExtraPropertyValue(entry);
        IObjectPK pk = iFactory.save((CoreBaseInfo)clearBillInfo);
        return pk == null ? "" : pk.toString();
    }

    @Override
    protected String _submitClearBill(Context ctx, IObjectValue faClearBillInfo) throws BOSException, EASBizException {
        FaClearBillInfo clearBillInfo = (FaClearBillInfo)faClearBillInfo;
        FaClearBillEntryCollection entry = clearBillInfo != null ? clearBillInfo.getClearBillEntry() : null;
        this.checkBeforeSubmit(ctx, clearBillInfo);
        IObjectPK pk = FaClearBillFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)clearBillInfo);
        return pk == null ? "" : pk.toString();
    }

    @Override
    protected Map<String, Object> _batchSubmitClearBill(Context ctx, String[] billIds) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> idList = new ArrayList<String>(billIds.length);
        HashSet<String> idset = new HashSet<String>();
        for (int i = 0; i < billIds.length; ++i) {
            idList.add(billIds[i]);
            idset.add(billIds[i]);
        }
        BatchExecuteResult exeResult = new BatchExecuteResult(idList.size());
        FaClearBillCollection clearBillCollection = null;
        IFaClearBill iFactory = (IFaClearBill)this.getBizInterface(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        view.setSelector(this.getClearBillSelectors());
        clearBillCollection = iFactory.getFaClearBillCollection(view);
        if (clearBillCollection != null) {
            for (int i = 0; i < clearBillCollection.size(); ++i) {
                FaClearBillInfo clearBillInfo = clearBillCollection.get(i);
                try {
                    this.checkBeforeSubmit(ctx, clearBillInfo);
                    iFactory.submit((CoreBaseInfo)clearBillInfo);
                    exeResult.setException(i, null);
                    continue;
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    exeResult.setException(i, (Throwable)ex);
                }
            }
        }
        if (exeResult.getBatchResult() == null) {
            Throwable[] exps = exeResult.getExceptions();
            int errorCount = result.size();
            for (int i = 0; i < exps.length; ++i) {
                if (exps[i] == null) continue;
                ++errorCount;
                result.put(clearBillCollection.get(i).getId().toString(), EASResource.getString((String)className, (String)"billNumber") + " " + clearBillCollection.get(i).getNumber() + "  " + exps[i].getMessage());
            }
            result.put("ERROR_COUNT", String.valueOf(errorCount));
        } else {
            result.put("ERROR_COUNT", 0);
        }
        return result;
    }

    @Override
    protected boolean _checkStatusValid(Context ctx, String billId) throws BOSException, EASBizException {
        boolean result = false;
        IFaClearBill iFactory = (IFaClearBill)this.getBizInterface(ctx);
        FaClearBillInfo clearBillInfo = iFactory.getFaClearBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getClearBillSelectors());
        result = iFactory.checkStatusValid((CoreBaseInfo)clearBillInfo);
        return result;
    }

    @Override
    protected boolean _checkBeforeVoucher(Context ctx, String billId) throws BOSException, EASBizException {
        boolean isSplitOrCombineNoVourcher;
        FaClearBillInfo billInfo;
        int i;
        if (StringUtils.isEmpty((String)billId)) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)className, (String)"pleaseSelectOneLine")));
        }
        String[] ids = billId.split(",");
        if (ids == null || ids != null && ids.length <= 0 || ids[0].equals("")) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)className, (String)"pleaseSelectOneLine")));
        }
        IFaClearBill iFactory = (IFaClearBill)this.getBizInterface(ctx);
        FaClearBillInfo clearBillInfo = iFactory.getFaClearBillInfo((IObjectPK)new ObjectUuidPK(ids[0]));
        CompanyOrgUnitInfo currCompany = clearBillInfo.getCompany();
        ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)currCompany.getId().toString()));
        PermissionFactory.getRemoteInstance().checkFunctionPermission(ctx.getCaller(), (IObjectPK)orgPk, "fa_cardclean_genvoucher");
        BOSUuid id = currCompany != null ? currCompany.getId() : null;
        boolean isRelAccount = SystemStatusCtrolUtils.isRelAccount(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)currCompany);
        if (!isRelAccount) {
            throw new FaCardException(FaCardException.CANNOT_GEN_VOUCHER);
        }
        HashMap<String, FaClearBillInfo> clearBillInfoMap = new HashMap<String, FaClearBillInfo>();
        if (ids.length == 1) {
            FaClearBillInfo billInfo2 = iFactory.getFaClearBillInfo((IObjectPK)new ObjectUuidPK(ids[0]));
            clearBillInfoMap.put(ids[0], billInfo2);
            if (billInfo2.isFiVouchered()) {
                throw new FaClearBillException(FaClearBillException.HAS_GENERATED_VOUCHER);
            }
        } else {
            boolean isExist = true;
            for (i = 0; i < ids.length; ++i) {
                billInfo = iFactory.getFaClearBillInfo((IObjectPK)new ObjectUuidPK(ids[i]));
                clearBillInfoMap.put(ids[i], billInfo);
                if (billInfo.isFiVouchered()) continue;
                isExist = false;
                break;
            }
            if (isExist) {
                throw new FaClearBillException(FaClearBillException.HAS_GENERATED_VOUCHER);
            }
        }
        if (isSplitOrCombineNoVourcher = "true".equals(this.gethmParam(id).get("FA_048").toString())) {
            for (i = 0; i < ids.length; ++i) {
                billInfo = (FaClearBillInfo)clearBillInfoMap.get(ids[i]);
                if (billInfo == null || billInfo.getBillType() != FaBillOriginEnum.FROM_SPLIT && billInfo.getBillType() != FaBillOriginEnum.FROM_COMBIN) continue;
                throw new FaClearBillException(FaClearBillException.NEED_NOT_VOURCHER);
            }
        }
        return true;
    }

    @Override
    protected boolean _checkBeforeDelVoucher(Context ctx, String billId) throws BOSException, EASBizException {
        return true;
    }

    @Override
    protected Map<String, Object> _getCurcardInfoByBarcodeAndCompany(Context ctx, String barcode, String companyId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        EntityViewInfo view = this.getBarcodeAndCompanyEntityView(barcode, companyId);
        IFaCurCard iFactory = FaCurCardFactory.getLocalInstance((Context)ctx);
        FaCurCardCollection curcardCollection = iFactory.getFaCurCardCollection(view);
        for (int i = 0; i < curcardCollection.size(); ++i) {
            FaCurCardInfo curcardInfo = curcardCollection.get(i);
            String cardStatusAlias = this.getCurcardInfoStatusAlias(curcardInfo);
            curcardInfo.put("statusAlias", (Object)cardStatusAlias);
        }
        result.put("curcardInfoCollection", curcardCollection);
        return result;
    }

    @Override
    protected IObjectValue _getMainOrgUnitInfo(Context ctx, String mainOrgUnitId, String permissionItem) throws BOSException, EASBizException {
        CompanyOrgUnitInfo mainOrgUnit = null;
        if (mainOrgUnitId != null) {
            SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
            mainOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgUnitId), sic);
        } else {
            mainOrgUnit = (CompanyOrgUnitInfo)FaServerUtil.getDefaultMainBizOrg(ctx, OrgType.Company, permissionItem);
        }
        return mainOrgUnit;
    }

    @Override
    protected boolean _checkBeforeCreateTo(Context ctx, String billId) throws BOSException, EASBizException {
        if (StringUtils.isBlank((String)billId) || "undefined".equals(billId)) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)className, (String)"pleaseSelectOneLine")));
        }
        IFaClearBill iFactory = (IFaClearBill)this.getBizInterface(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        String[] billIds = billId.split(",");
        for (int i = 0; i < billIds.length; ++i) {
            FaClearBillInfo clearBillInfo = iFactory.getFaClearBillInfo((IObjectPK)new ObjectUuidPK(billIds[i]), sic);
            if (clearBillInfo == null) continue;
            if (2 != clearBillInfo.getCheckedStatus().getValue()) {
                throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)className, (String)"hasUnAudit")));
            }
            String aMsg = EASResource.getString((String)className, (String)"hasGenBill");
            StringTokenizer token = new StringTokenizer(aMsg, "!");
            String head = token.nextToken();
            String[][] destBillMsg = new String[][]{{"48DA3A71", head + token.nextToken(), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"3_FaClearBillListUI")}, {"FC910EF3", head + token.nextToken(), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"4_FaClearBillListUI")}, {"FA44FD5B", head + token.nextToken(), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"5_FaClearBillListUI")}, {"40284E81", head + token.nextToken(), EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"6_FaClearBillListUI")}};
            for (int j = 0; j < 4; ++j) {
                ArrayList arrayList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(clearBillInfo.getId().toString(), destBillMsg[j][0]);
                if (arrayList == null || arrayList.size() <= 0) continue;
                String msg = MessageFormat.format(EASResource.getString((String)className, (String)"canNotCreatTo"), destBillMsg[j][1]);
                throw new EASBizException(new NumericExceptionSubItem("1", msg));
            }
        }
        return true;
    }

    private HashMap gethmParam(BOSUuid companyId) throws EASBizException, BOSException {
        HashMap hmParam = new HashMap();
        hmParam = FaManageUtils.getFAParameter((BOSUuid)companyId);
        return hmParam;
    }

    private void setExtraPropertyValue(FaClearBillEntryCollection entry) throws EASBizException, BOSException {
        if (entry != null) {
            for (int i = 0; i < entry.size(); ++i) {
                FaClearBillEntryInfo entryInfo = entry.get(i);
                String cardUpdateTime = (String)entryInfo.get("cardUpdateTime");
                try {
                    Timestamp lastUpdateTime = Timestamp.valueOf(cardUpdateTime);
                    entryInfo.put("cardUpdateTime", (Object)lastUpdateTime);
                    String curCardAccountDate = (String)entryInfo.get("curCardAccountDate");
                    Date accountDate = DateTimeUtils.parseDate((String)curCardAccountDate);
                    entryInfo.put("curCardAccountDate", (Object)accountDate);
                    Boolean canDoClear = (Boolean)entryInfo.get("canDoClear");
                    entryInfo.put("canDoClear", (Object)canDoClear);
                    BigDecimal assetAmount = (BigDecimal)entryInfo.get("assetAmount");
                    entryInfo.put("assetAmount", (Object)assetAmount);
                    continue;
                }
                catch (Exception ex) {
                    throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)className, (String)"entryExtHandleErr")));
                }
            }
        }
    }

    private void checkBeforeSubmit(Context ctx, FaClearBillInfo clearBillInfo) throws EASBizException, BOSException {
        int i;
        FaClearBillEntryCollection entry;
        StringBuffer errorMessage = new StringBuffer(100);
        String companyId = clearBillInfo.getCompany().getId().toString();
        Date clearDate = clearBillInfo.getClearDate();
        if (clearDate == null) {
            errorMessage.append(EASResource.getString((String)className, (String)"FaClearBillEditUI_ClearDateIsNull"));
        } else {
            CompanyOrgUnitInfo companyInfo = clearBillInfo.getCompany();
            PeriodInfo currentPeriod = this.getCurrentPeriod(ctx, companyInfo);
            if (currentPeriod != null && (DateTimeUtils.dayBefore((Date)clearDate, (Date)currentPeriod.getBeginDate()) || DateTimeUtils.dayAfter((Date)clearDate, (Date)currentPeriod.getEndDate()))) {
                errorMessage.append("<br/>" + EASResource.getString((String)className, (String)"FaClearBillEditUI_ClearDateError"));
            }
        }
        if (clearBillInfo.getClearMode() == null) {
            errorMessage.append("<br/>" + EASResource.getString((String)className, (String)"FaClearBillEditUI_ClearModeIsNull"));
        }
        if ((entry = clearBillInfo.getClearBillEntry()) == null || entry.size() < 1) {
            errorMessage.append("<br/>" + EASResource.getString((String)className, (String)"FaClearBillEditUI_EntryIsNull"));
        }
        HashSet<String> curcardIdSet = new HashSet<String>();
        if (entry != null) {
            for (int i2 = 0; i2 < entry.size(); ++i2) {
                FaClearBillEntryInfo entryInfo = entry.get(i2);
                String curcardId = entryInfo.getCurCard().getId().toString();
                curcardIdSet.add(curcardId);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", curcardIdSet, CompareType.INCLUDE));
        view.setSelector(this.getCurCardSelectors());
        FaCurCardCollection curcardCollection = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardCollection(view);
        HashMap<String, FaCurCardInfo> curcardMap = new HashMap<String, FaCurCardInfo>();
        if (curcardCollection != null) {
            for (i = 0; i < curcardCollection.size(); ++i) {
                if (curcardMap.get(curcardCollection.get(i).toString()) != null) continue;
                curcardMap.put(curcardCollection.get(i).getId().toString(), curcardCollection.get(i));
            }
        }
        if (entry != null) {
            for (i = 0; i < entry.size(); ++i) {
                FaClearBillEntryInfo entryInfo = entry.get(i);
                String curcardId = entryInfo.getCurCard().getId().toString();
                BigDecimal clrQty = entryInfo.getClrQty();
                BigDecimal clrOriginal = entryInfo.getClrOriginal();
                BigDecimal clrAddupDep = entryInfo.getClrAddupDep();
                BigDecimal clrDec = entryInfo.getClrDecPrep();
                String dateValue = entryInfo.get("curCardAccountDate").toString();
                String dateValueNew = dateValue.substring(0, dateValue.indexOf(" "));
                SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
                Date accountDate = null;
                try {
                    accountDate = df1.parse(dateValueNew);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                Boolean canDoClear = (Boolean)entryInfo.get("canDoClear");
                BigDecimal assetAmount = (BigDecimal)entryInfo.get("assetAmount");
                String cardUpdateTimeValue = entryInfo.get("cardUpdateTime").toString();
                String cardUpdateTimeNew = dateValue.substring(0, dateValue.indexOf(" "));
                SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
                Date lastUpdateTime = null;
                try {
                    lastUpdateTime = df1.parse(dateValueNew);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                String facurcard = (String)entryInfo.get("facurcard");
                FaCurCardInfo curCard = (FaCurCardInfo)curcardMap.get(curcardId);
                if (curCard != null && (accountDate == null || canDoClear == null || assetAmount == null || lastUpdateTime == null || facurcard == null)) {
                    accountDate = curCard.getAccountDate();
                    assetAmount = curCard.getAssetAmt();
                    canDoClear = this.checkDeprePolicy(curCard, 0);
                    entryInfo.put("cardUpdateTime", (Object)curCard.getLastUpdateTime());
                    entryInfo.put("facurcard", (Object)curCard.getId().toString());
                }
                if (accountDate != null && DateTimeUtils.dayBefore((Date)clearDate, (Date)accountDate)) {
                    errorMessage.append("<br/>" + EASResource.getString((String)className, (String)"FaClearBillEditUI_ClearDateBeforeAccountDate") + "[" + DateTimeUtils.format((Date)accountDate, (String)"yyyy-MM-dd") + "]");
                }
                if (clrQty == null || clrQty.compareTo(ZERO) <= 0 || clrOriginal == null || clrAddupDep == null || clrDec == null) {
                    errorMessage.append("<br/>" + EASResource.getString((String)className, (String)"FaClearBillEditUI_ClearQuantityError"));
                }
                if (clrQty != null && clrQty.compareTo(assetAmount) > 1) {
                    errorMessage.append("<br/>" + EASResource.getString((String)className, (String)"FaClearBillEditUI_ClearQuantityTooBig"));
                }
                if (!canDoClear.booleanValue() && clrQty != null && clrQty.compareTo(assetAmount) == -1) {
                    errorMessage.append("<br/>" + EASResource.getString((String)className, (String)"FaClearBillEditUI_CanNotPartClear"));
                }
                boolean isAlreadyDep = curCard.getDeprTTerm() != null && curCard.getDeprTTerm().compareTo(ZERO) != 0;
                boolean isHasNew = curCard.isHasNew();
                if (curCard == null || curCard.getDeprMethod() == null || isHasNew || !isAlreadyDep || this.isNeedReDepr(curCard) || !this.checkDepreVoucher(ctx, companyId)) continue;
                errorMessage.append("<br/>" + EASResource.getString((String)className, (String)"FaClearBillEditUI_isDepVoucher"));
                break;
            }
        }
        if (StringUtils.isNotBlank((String)errorMessage.toString())) {
            throw new EASBizException(new NumericExceptionSubItem("1", errorMessage.toString()));
        }
    }

    private boolean checkDepreVoucher(Context ctx, String companyId) throws BOSException, EASBizException {
        return ((IFaClearBill)this.getBizInterface(ctx)).isAlreadyDepVoucher(companyId);
    }

    private boolean isNeedReDepr(FaCurCardInfo curCardInfo) {
        return curCardInfo.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
    }

    private PeriodInfo getCurrentPeriod(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyInfo);
    }

    private BigDecimal getPreDectTerm(Context ctx, FaCurCardInfo cardInfo) throws EASBizException, BOSException {
        BigDecimal preDecTTerm = ZERO;
        FaCurCardCollection cards = new FaCurCardCollection();
        cards.add(cardInfo);
        if (!FaDepCalFacadeFactory.getLocalInstance((Context)ctx).isNeedDep(cards)) {
            return preDecTTerm;
        }
        if (!(cardInfo.getAssetCat().getDepreciationPolicy().getDeprRule() == FaDepreciationRuleEnum.YES_REGARDLESS_USESTATUS || cardInfo.getAssetCat().getDepreciationPolicy().getDeprRule() == FaDepreciationRuleEnum.DECIDE_BY_USESTATUS && cardInfo.getUseStatus().isIsDepreciation())) {
            return preDecTTerm;
        }
        HashMap map = FaDepCalFacadeFactory.getLocalInstance((Context)ctx).calOneCardDep(cardInfo.getId().toString());
        if (map != null && (BigDecimal)map.get(new Integer(1)) != null) {
            preDecTTerm = (BigDecimal)map.get(new Integer(1));
        }
        return preDecTTerm;
    }

    private SelectorItemCollection getCurCardSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        sic.add(new SelectorItemInfo("assetCat.name"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.OldChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.TotalDeprChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DevalueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.LeaveValueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.ChargeAccoutChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UsedLifeChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprMethodChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.EvaluateChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.CostCenterChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UseStatusChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.TailDispose"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprRule"));
        sic.add(new SelectorItemInfo("deprMethod.period"));
        sic.add(new SelectorItemInfo("deprMethod.isCustom"));
        sic.add(new SelectorItemInfo("deprMethod.depValuePolicy"));
        sic.add(new SelectorItemInfo("deprMethod.isWorkload"));
        sic.add(new SelectorItemInfo("deprMethod.id"));
        sic.add(new SelectorItemInfo("deprMethod.name"));
        sic.add(new SelectorItemInfo("deprMethod.number"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        sic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        sic.add(new SelectorItemInfo("evalDeprMode.period"));
        sic.add(new SelectorItemInfo("evalDeprMode.number"));
        sic.add(new SelectorItemInfo("evalDeprMode.name"));
        sic.add(new SelectorItemInfo("evalDeprMode.depValuePolicy"));
        sic.add(new SelectorItemInfo("evalDeprMode.isWorkload"));
        sic.add(new SelectorItemInfo("evalDeprMode.isCustom"));
        sic.add(new SelectorItemInfo("evalDeprMode.id"));
        return sic;
    }

    private SelectorItemCollection getClearBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("clearMode.id"));
        sic.add(new SelectorItemInfo("clearMode.name"));
        sic.add(new SelectorItemInfo("clearMode.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("handler.number"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("clearBillEntry.*"));
        return sic;
    }

    private boolean checkDeprePolicy(FaCurCardInfo curCard, int queryType) throws EASBizException, BOSException {
        boolean policy;
        boolean result = false;
        boolean oldChange = curCard.getAssetCat().getDepreciationPolicy().isOldChange();
        boolean totalDeprChange = curCard.getAssetCat().getDepreciationPolicy().isTotalDeprChange();
        boolean devalueChange = curCard.getAssetCat().getDepreciationPolicy().isDevalueChange();
        boolean leaveValueChange = curCard.getAssetCat().getDepreciationPolicy().isLeaveValueChange();
        boolean usedLifeChange = curCard.getAssetCat().getDepreciationPolicy().isUsedLifeChange();
        boolean deprMethodChange = curCard.getAssetCat().getDepreciationPolicy().isDeprMethodChange();
        boolean evaluateChange = curCard.getAssetCat().getDepreciationPolicy().isEvaluateChange();
        boolean costCenterChange = curCard.getAssetCat().getDepreciationPolicy().isCostCenterChange();
        boolean useStatusChange = curCard.getAssetCat().getDepreciationPolicy().isUseStatusChange();
        boolean startDeprTime = curCard.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
        boolean hasChanged = curCard.getHasChanged() != FaChangeStatusEnmu.HasNotChanged;
        FaClearStatusEnum hasCleared = curCard.getHasCleared();
        boolean bl = policy = !oldChange && !totalDeprChange && !devalueChange && !leaveValueChange && !useStatusChange && !usedLifeChange && !deprMethodChange && !evaluateChange && !costCenterChange && startDeprTime;
        if (policy) {
            result = true;
        } else {
            if (queryType == 1) {
                boolean bl2 = result = hasCleared == FaClearStatusEnum.HasNotCleared;
            }
            if (queryType == 0) {
                result = !hasChanged;
            }
        }
        return result;
    }

    private EntityViewInfo getBarcodeAndCompanyEntityView(String barCode, String companyId) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("hasDisabled"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("blockedStatus"));
        sic.add(new SelectorItemInfo("assetName"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("keeper.id"));
        sic.add(new SelectorItemInfo("dept.id"));
        sic.add(new SelectorItemInfo("faCurDepartment.*"));
        sic.add(new SelectorItemInfo("isBorrowing"));
        sic.add(new SelectorItemInfo("isRequisitioned"));
        sic.add(new SelectorItemInfo("barCode"));
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("barCode", (Object)barCode, CompareType.EQUALS));
        fic.add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        view.setFilter(filter);
        return view;
    }

    private String getCurcardInfoStatusAlias(FaCurCardInfo faCurCardInfo) {
        String cardStatus = "";
        Iterator iter = FaBizStatusEnum.iterator();
        while (iter.hasNext()) {
            FaBizStatusEnum faBS = (FaBizStatusEnum)iter.next();
            if (!faBS.getValue().equals(faCurCardInfo.getBizStatus().getValue().toString())) continue;
            cardStatus = faBS.getAlias();
            break;
        }
        return cardStatus;
    }

    @Override
    protected Map _getSumAmount(Context ctx, String filter) throws BOSException, EASBizException {
        HashMap<String, IRowSet> rstData = new HashMap<String, IRowSet>();
        try {
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.fa.manage.FaClearBillQuery"));
            queryExecutor.setObjectView(filter);
            IRowSet rowSet = queryExecutor.executeQuery();
            rstData.put("rowSet", rowSet);
        }
        catch (BOSException e2) {
            e2.printStackTrace();
        }
        return rstData;
    }

    @Override
    protected String _checkSubmit(Context ctx, IObjectValue faClearBill) throws BOSException, EASBizException {
        FaClearBillInfo clearBillInfo = (FaClearBillInfo)faClearBill;
        FaClearBillEntryCollection entry = clearBillInfo != null ? clearBillInfo.getClearBillEntry() : null;
        this.setExtraPropertyValue(entry);
        this.checkBeforeSubmit(ctx, clearBillInfo);
        return null;
    }

    private FaClearBillEntryCollection setEntryId(FaClearBillInfo clearBillInfo, FaClearBillEntryCollection entry, Context ctx) throws BOSException, EASBizException {
        if (clearBillInfo != null && clearBillInfo.getId() != null) {
            String sql = "SELECT FID,FBIZCARDID,FCURCARDID FROM T_FA_CLEARBILLENTRY  WHERE FENTRYID  = '" + clearBillInfo.getId().toString() + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashMap<String, String> entryMap = new HashMap<String, String>();
            HashMap<String, String> bentryMap = new HashMap<String, String>();
            try {
                while (rowSet.next()) {
                    entryMap.put(rowSet.getString("FCURCARDID"), rowSet.getString("FID"));
                    bentryMap.put(rowSet.getString("FCURCARDID"), rowSet.getString("FBIZCARDID"));
                }
                if (entry != null) {
                    for (int i = 0; i < entry.size(); ++i) {
                        FaClearBillEntryInfo entryInfo = entry.get(i);
                        if (entryInfo.getCurCard() == null || entryInfo.getCurCard().getId() == null || !entryMap.containsKey(entryInfo.getCurCard().getId().toString())) continue;
                        entryInfo.put("id", entryMap.get(entryInfo.getCurCard().getId().toString()));
                        FaBizCardInfo fabizcardInfo = new FaBizCardInfo();
                        fabizcardInfo.setId(BOSUuid.read((String)((String)bentryMap.get(entryInfo.getCurCard().getId().toString()))));
                        entryInfo.setBizCard(fabizcardInfo);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return entry;
    }
}

