/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.facade.app.AbstractFaDAPTransStrategy;
import com.kingdee.eas.fi.fa.manage.FaBakCardCollection;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaBakCard;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.framework.BillBaseInfo;

public class FaDAPCardStrategy
extends AbstractFaDAPTransStrategy {
    @Override
    public BillBaseInfo process4DAP(BillBaseInfo bill, Context ctx) throws BOSException, EASBizException {
        FaCurCardInfo curCardInfo = (FaCurCardInfo)bill;
        BOSUuid uuid = curCardInfo.getId();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("faCurCard", (Object)curCardInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("billType", (Object)new Integer(1)));
        viewInfo.setFilter(filterInfo);
        IFaBakCard iFaBakCard = FaBakCardFactory.getLocalInstance((Context)ctx);
        FaBakCardCollection bakCardCol = iFaBakCard.getFaBakCardCollection(viewInfo);
        if (bakCardCol == null || bakCardCol.size() == 0) {
            throw new FaCardException(FaCardException.CANNOT_BE_GENVOUCHER);
        }
        FaBakCardInfo bakCardInfo = bakCardCol.get(0);
        SelectorItemCollection bakSic = PrcFaCoreManager.getBakCardSelectors();
        bakSic.add(new SelectorItemInfo("faBakCostCenter.asstActType.id"));
        bakSic.add(new SelectorItemInfo("faBakCostCenter.asstActItem.id"));
        bakCardInfo = iFaBakCard.getFaBakCardInfo((IObjectPK)new ObjectUuidPK(bakCardInfo.getId()), bakSic);
        try {
            curCardInfo.getFaCurCostCenter().clear();
            curCardInfo.getFaCurFacility().clear();
            curCardInfo.getFaCurDepartment().clear();
            FaManageUtils.copyValueBetweenCard((FaCardInfo)bakCardInfo, (FaCardInfo)curCardInfo, (boolean)true);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("account.*"));
        FaAlterModeInfo alterModeInfo = FaAlterModeFactory.getLocalInstance((Context)ctx).getFaAlterModeInfo((IObjectPK)new ObjectUuidPK(curCardInfo.getOriginMethod().getId()), sic);
        curCardInfo.setOriginMethod(alterModeInfo);
        curCardInfo.put("originMethod.account", (Object)alterModeInfo.getAccount());
        curCardInfo.put("forDAP", (Object)new Boolean(true));
        curCardInfo.setId(uuid);
        return curCardInfo;
    }
}

