/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.AbstractFaDAPTransStrategy;
import com.kingdee.eas.fi.fa.facade.app.FaDAPCardStrategy;
import com.kingdee.eas.fi.fa.facade.app.FaDAPChangeBillStrategy;
import com.kingdee.eas.fi.fa.facade.app.FaDAPClearBillStrategy;
import com.kingdee.eas.fi.fa.facade.app.FaDAPDepreStrategy;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;

public class FaDAPFacade {
    private static final DAPVoucherTypeEnum voucherTpye = DAPVoucherTypeEnum.FIVoucher;
    private AbstractFaDAPTransStrategy faBillDAPTransStrategy;
    private BillBaseInfo billInfo;

    public void setBill(BillBaseInfo bill) {
        this.billInfo = bill;
    }

    public void setFaBillDAPTransStrategy(AbstractFaDAPTransStrategy dapTransStrategy) {
        this.faBillDAPTransStrategy = dapTransStrategy;
    }

    public AbstractFaDAPTransStrategy getFaBillDAPTransStrategy() {
        return this.faBillDAPTransStrategy;
    }

    public void generateVourcherViaDAP(Context ctx, DAPVoucherTypeEnum voucherType) throws BOSException, EASBizException, DAPException {
        IDAPTransformer dapTransformer = null;
        BillBaseInfo sourceBill = this.billInfo;
        BillBaseInfo bill = this.faBillDAPTransStrategy.process4DAP(sourceBill, ctx);
        dapTransformer = DAPTransformerFactory.getLocalInstance((Context)ctx);
        if (this.faBillDAPTransStrategy instanceof FaDAPCardStrategy) {
            FaCurCardInfo faCurCard = (FaCurCardInfo)bill;
            dapTransformer.generateVoucher((CoreBillBaseInfo)faCurCard, voucherType);
        }
        if (this.faBillDAPTransStrategy instanceof FaDAPClearBillStrategy) {
            FaClearBillInfo faClearBill = (FaClearBillInfo)bill;
            dapTransformer.generateVoucher((CoreBillBaseInfo)faClearBill, voucherType);
        }
        if (this.faBillDAPTransStrategy instanceof FaDAPDepreStrategy) {
            FaDepreciationInfo faDeperBill = (FaDepreciationInfo)bill;
            dapTransformer.generateVoucher((CoreBillBaseInfo)faDeperBill, voucherType);
        }
        if (this.faBillDAPTransStrategy instanceof FaDAPChangeBillStrategy) {
            FaChangeBillInfo faChangeBillBill = (FaChangeBillInfo)bill;
            dapTransformer.generateVoucher((CoreBillBaseInfo)faChangeBillBill, voucherType);
        }
    }
}

