/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.facade.app.AbstractFaDispatchServiceFacadeControllerBean;
import com.kingdee.eas.fi.fa.facade.app.util.FaServerUtil;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillInfo;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaDispatchServiceFacadeControllerBean
extends AbstractFaDispatchServiceFacadeControllerBean {
    private static final long serialVersionUID = 5460460033215590727L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.facade.app.FaDispatchServiceFacadeControllerBean");
    private static final String FA_DEF_PROJECT_ID = "tBj8Gt3jAcrgQ8CoPwoByiyY1lE=";

    @Override
    protected Map _addNewCardToEditUiGrid(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> loadData = new ArrayList<Map<String, Object>>();
        String newSelectedIdSetString = paramMap.get("newSelectedIdSetString").toString();
        String curcardIDsInCurrentDispatchBillEdit = paramMap.get("curcardIDsInCurrentDispatchBillEdit").toString();
        String[] cardIdAfterMerge = new String[]{};
        for (String newSelectedId : cardIdAfterMerge = this.getStringIntersection(newSelectedIdSetString, curcardIDsInCurrentDispatchBillEdit)) {
            FaCurCardInfo curCard = this.getCurCardInfo(newSelectedId, ctx);
            if (this.isNeedDepreciation(curCard, ctx)) {
                mapResult.put("error", FaResUtil.getRes((String)"hasNoDpr"));
                return mapResult;
            }
            EffectedStatusEnum effectedStatus = curCard.getEffectedStatus();
            CheckedStatusEnum checkedStatus = curCard.getCheckedStatus();
            BlockedStatusEnum blockedStatus = curCard.getBlockedStatus();
            DeletedStatusEnum deletedStatus = curCard.getDeletedStatus();
            FaBizStatusEnum bizStatus = curCard.getBizStatus();
            if (effectedStatus == null || effectedStatus != EffectedStatusEnum.EFFECTED || checkedStatus == null || checkedStatus != CheckedStatusEnum.AUDITED || blockedStatus == null || blockedStatus != BlockedStatusEnum.UNBLOCKED || deletedStatus == null || deletedStatus != DeletedStatusEnum.NORMAL || !bizStatus.getValue().endsWith("99")) continue;
            PeriodInfo curPeriod = this.getCurrentPeriod(curCard.getCompany().getId().toString(), ctx);
            boolean isStartDeprTime = curCard.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
            boolean isDep = FaDepreciationEntryFactory.getLocalInstance((Context)ctx).exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
            if (!isDep) {
                isDep = FaEvalDepreciationEntryFactory.getLocalInstance((Context)ctx).exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
            }
            FaDispatchBillEntryInfo billInfo = this.calOtherBillData(curCard, isStartDeprTime, isDep, curPeriod);
            Map<String, Object> row = this.convtDisEntryBillToRow(billInfo);
            loadData.add(row);
        }
        mapResult.put("onloadData", loadData);
        return mapResult;
    }

    private String[] getStringIntersection(String newSelectedIdSetString, String curcardIDsInCurrentDispatchBillEdit) {
        String[] cardIdAfterMerge;
        if (!curcardIDsInCurrentDispatchBillEdit.equals("")) {
            String notRepeatIdStrInNewSelectedCard = "";
            String[] newSelectedIdSetStringArray = newSelectedIdSetString.split(",");
            String[] curcardIDsInCurrentDispatchBillEditArray = curcardIDsInCurrentDispatchBillEdit.split(",");
            for (String newSelectedId : newSelectedIdSetStringArray) {
                boolean isSame = false;
                for (String curcardIDInCurrentDispatchBill : curcardIDsInCurrentDispatchBillEditArray) {
                    if (!newSelectedId.equals(curcardIDInCurrentDispatchBill)) continue;
                    isSame = true;
                }
                if (isSame) continue;
                notRepeatIdStrInNewSelectedCard = notRepeatIdStrInNewSelectedCard + newSelectedId + ",";
            }
            cardIdAfterMerge = (notRepeatIdStrInNewSelectedCard + curcardIDsInCurrentDispatchBillEdit).split(",");
        } else {
            cardIdAfterMerge = newSelectedIdSetString.split(",");
        }
        return cardIdAfterMerge;
    }

    @Override
    protected String _save(Context ctx, IObjectValue dataObject) throws BOSException, EASBizException {
        FaDispatchBillInfo info = (FaDispatchBillInfo)dataObject;
        CompanyOrgUnitInfo mainOrgUnit = this.getCurrentOrgUnitInfo(ctx);
        info.setCompany(mainOrgUnit);
        PeriodInfo item = this.getCurrentPeriod(mainOrgUnit.getId().toString(), ctx);
        info.setPeriod(item);
        IObjectPK objectPK = null;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection relations = new BOTRelationCollection();
        FaDispatchBillEntryCollection entryCollection = info.getFaDispatchBillEntry();
        BOTRelationCollection btpRelationCollection = new BOTRelationCollection();
        if (info.getId() != null) {
            btpRelationCollection = iBTPManager.getRelationCollection(info.getId().toString());
        }
        for (int i = 0; i < entryCollection.size(); ++i) {
            FaDispatchBillEntryInfo entryInfo = entryCollection.get(i);
            if (!((Boolean)entryInfo.get("isnewdata")).booleanValue()) {
                entryInfo.setId(BOSUuid.read((String)entryInfo.get("entryid").toString()));
            }
            FaCurCardInfo faCurCardInfo = this.getFaCurCard(entryInfo);
            entryInfo.setFaCurCard(faCurCardInfo);
            this.setBizCardInfoForEntry(entryInfo, ctx);
        }
        objectPK = iBTPManager.saveRelations((CoreBillBaseInfo)info, relations);
        return objectPK.toString();
    }

    private CompanyOrgUnitInfo getCurrentOrgUnitInfo(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo mainOrgUnit = null;
        mainOrgUnit = (CompanyOrgUnitInfo)FaServerUtil.getDefaultMainBizOrg(ctx, OrgType.Company, "fa_card_addNew");
        return mainOrgUnit;
    }

    @Override
    protected String _submit(Context ctx, IObjectValue dataObject) throws BOSException, EASBizException {
        FaDispatchBillInfo info = (FaDispatchBillInfo)dataObject;
        PeriodInfo item = this.getCurrentPeriod(info.getCompany().getId().toString(), ctx);
        info.setPeriod(item);
        IObjectPK objectPK = null;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection relations = new BOTRelationCollection();
        FaDispatchBillEntryCollection entryCollection = info.getFaDispatchBillEntry();
        BOTRelationCollection btpRelationCollection = new BOTRelationCollection();
        if (info.getId() != null) {
            btpRelationCollection = iBTPManager.getRelationCollection(info.getId().toString());
        }
        for (int i = 0; i < entryCollection.size(); ++i) {
            FaDispatchBillEntryInfo entryInfo = entryCollection.get(i);
            if (!((Boolean)entryInfo.get("isnewdata")).booleanValue()) {
                entryInfo.setId(BOSUuid.read((String)entryInfo.get("entryid").toString()));
            }
            FaCurCardInfo faCurCardInfo = this.getFaCurCard(entryInfo);
            entryInfo.setFaCurCard(faCurCardInfo);
            this.setBizCardInfoForEntry(entryInfo, ctx);
        }
        objectPK = iBTPManager.submitRelations((CoreBillBaseInfo)info, relations);
        return objectPK.toString();
    }

    private void setBizCardInfoForEntry(FaDispatchBillEntryInfo entryInfo, Context ctx) throws EASBizException, BOSException {
        if (entryInfo.get("faBizCardId") == null || entryInfo.get("faBizCardId").toString().equals("")) {
            FaBizCardInfo faBizCardInfo = new FaBizCardInfo();
            FaCurCardInfo curCard = this.getCurCardInfo(entryInfo.get("facurcardid").toString(), ctx);
            faBizCardInfo = FaManageUtils.CurCard2BizCard((FaCurCardInfo)curCard);
            faBizCardInfo.setId(BOSUuid.create((BOSObjectType)faBizCardInfo.getBOSType()));
            FaBizCardFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)faBizCardInfo);
            entryInfo.setFaBizCard(faBizCardInfo);
        } else {
            FaBizCardInfo faBizCardInfo = new FaBizCardInfo();
            faBizCardInfo.setId(BOSUuid.read((String)entryInfo.get("faBizCardId").toString()));
            entryInfo.setFaBizCard(faBizCardInfo);
        }
    }

    private FaCurCardInfo getFaCurCard(FaDispatchBillEntryInfo entryInfo) {
        FaCurCardInfo faCurCardInfo = new FaCurCardInfo();
        faCurCardInfo.setId(BOSUuid.read((String)entryInfo.get("facurcardid").toString()));
        return faCurCardInfo;
    }

    private FaDispatchBillEntryInfo calOtherBillData(FaCurCardInfo curCard, boolean isStartDeprTime, boolean isDep, PeriodInfo curPeriod) throws EASBizException, BOSException {
        FaDispatchBillEntryInfo billEntryInfo = new FaDispatchBillEntryInfo();
        billEntryInfo.setFaBizCard(FaManageUtils.CurCard2BizCard((FaCurCardInfo)curCard));
        billEntryInfo.setFaCurCard(curCard);
        billEntryInfo.setQuantity(curCard.getAssetAmt());
        billEntryInfo.setAssetValue(curCard.getAssetValue());
        if (!isDep || isStartDeprTime) {
            billEntryInfo.setNeatValue(curCard.getNeatValue());
            billEntryInfo.setAccuDepr(curCard.getAccuDepr());
        } else {
            BigDecimal zero = new BigDecimal("0");
            BigDecimal termDepr = curCard.getDeprTTerm() == null ? zero : curCard.getDeprTTerm();
            billEntryInfo.setNeatValue(curCard.getNeatValue().add(termDepr));
            billEntryInfo.setAccuDepr(curCard.getAccuDepr().subtract(termDepr));
        }
        billEntryInfo.setEvaluateValue(curCard.getInitEvalValue());
        billEntryInfo.put("curCardIsDep", (Object)isDep);
        return billEntryInfo;
    }

    protected FaCurCardInfo getCurCardInfo(String curCardID, Context ctx) throws EASBizException, BOSException {
        FaCurCardInfo curCardInfo = new FaCurCardInfo();
        SelectorItemCollection sic = this.getFaDefPropertySelectors(this.getCurCardSelectors(0), ctx);
        curCardInfo = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardInfo((IObjectPK)new ObjectUuidPK(curCardID), sic);
        return curCardInfo;
    }

    private PeriodInfo getCurrentPeriod(String orgIDs, Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgIDs));
        ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
        list.add(aCompanyOrgUnitInfo);
        HashMap zipData = FaDepreciationFactory.getLocalInstance((Context)ctx).getZipDataForRPC(list);
        PeriodInfo currentPeriod = (PeriodInfo)zipData.get("currPeriod");
        return currentPeriod;
    }

    protected boolean isNeedDepreciation(FaCurCardInfo cardInfo, Context ctx) throws EASBizException, BOSException {
        FaCurCardCollection cardCollection = new FaCurCardCollection();
        cardCollection.add(cardInfo);
        return this.isNeedDepreciation(cardCollection, ctx);
    }

    protected boolean isNeedDepreciation(FaCurCardCollection cardCollection, Context ctx) throws EASBizException, BOSException {
        boolean result = false;
        result = FaDepCalFacadeFactory.getLocalInstance((Context)ctx).isNeedDep(cardCollection);
        return result;
    }

    private Map<String, Object> convtDisEntryBillToRow(FaDispatchBillEntryInfo billInfo) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("number", billInfo.getFaBizCard().getNumber() == null ? "" : billInfo.getFaBizCard().getNumber());
        row.put("groupNumber", billInfo.getFaBizCard().getGroupNumber() == null ? "" : billInfo.getFaBizCard().getGroupNumber());
        row.put("barCode", billInfo.getFaCurCard().getBarCode() == null ? "" : billInfo.getFaCurCard().getBarCode());
        row.put("assetName", billInfo.getFaBizCard().getAssetName() == null ? "" : billInfo.getFaBizCard().getAssetName());
        row.put("assetCat", billInfo.getFaBizCard().getAssetCat() == null ? "" : billInfo.getFaBizCard().getAssetCat().getName());
        row.put("specs", billInfo.getFaBizCard().getSpecs() == null ? "" : billInfo.getFaBizCard().getSpecs());
        row.put("useStatus", billInfo.getFaBizCard().getUseStatus() == null ? "" : billInfo.getFaBizCard().getUseStatus().getName());
        row.put("storeCity", billInfo.getFaBizCard().getStoreCity() == null ? "" : billInfo.getFaBizCard().getStoreCity().getName());
        row.put("keeper", billInfo.getFaBizCard().getKeeper() == null ? "" : billInfo.getFaBizCard().getKeeper().getName());
        row.put("measureUnit", billInfo.getFaBizCard().getMeasureUnit() == null ? "" : billInfo.getFaBizCard().getMeasureUnit().getName());
        row.put("assetAmt", billInfo.getFaBizCard().getAssetAmt() == null ? "" : billInfo.getFaBizCard().getAssetAmt());
        row.put("quantity", billInfo.getQuantity() == null ? "" : billInfo.getQuantity());
        row.put("assetValue", billInfo.getAssetValue() == null ? "" : billInfo.getAssetValue());
        row.put("accuDepr", billInfo.getAccuDepr() == null ? "" : billInfo.getAccuDepr());
        row.put("neatValue", billInfo.getNeatValue() == null ? "" : billInfo.getNeatValue());
        row.put("evaluateValue", billInfo.getEvaluateValue() == null ? "" : billInfo.getEvaluateValue());
        if (billInfo.getDescription() != null) {
            row.put("description", billInfo.getDescription() == null ? "" : billInfo.getDescription());
        }
        if (billInfo.getFaBizCard().getId() != null) {
            row.put("faBizCardId", billInfo.getFaBizCard() == null ? "" : billInfo.getFaBizCard().getId().toString());
        }
        row.put("faCurCardId", billInfo.getFaCurCard() == null ? "" : billInfo.getFaCurCard().getId().toString());
        row.put("initEvalValue", billInfo.getFaBizCard().getInitEvalValue());
        row.put("isEvaledBefore", billInfo.getFaBizCard().get("isEvaledBefore").toString());
        row.put("calcuByEvaluate", billInfo.getFaBizCard().getAssetCat().get("calcuByEvaluate").toString());
        row.put("curCardIsDep", billInfo.get("curCardIsDep").toString());
        row.put("isNewData", "true");
        row.put("depStartDeprTimeValue", billInfo.getFaCurCard().getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue());
        row.put("faCurCard.assetAmt", billInfo.getFaCurCard().getAssetAmt() == null ? Integer.valueOf(0) : billInfo.getFaCurCard().getAssetAmt());
        row.put("faCurCard.assetValue", billInfo.getFaCurCard().getAssetValue() == null ? Integer.valueOf(0) : billInfo.getFaCurCard().getAssetValue());
        row.put("faCurCard.accuDepr", billInfo.getFaCurCard().getAccuDepr() == null ? Integer.valueOf(0) : billInfo.getFaCurCard().getAccuDepr());
        row.put("faCurCard.deprTTerm", billInfo.getFaCurCard().getDeprTTerm() == null ? Integer.valueOf(0) : billInfo.getFaCurCard().getDeprTTerm());
        row.put("faCurCard.initEvalValue", billInfo.getFaCurCard().getInitEvalValue() == null ? Integer.valueOf(0) : billInfo.getFaCurCard().getInitEvalValue());
        return row;
    }

    public SelectorItemCollection getCurCardSelectors(int cardType) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("assetCat.id"));
        sic.add(new SelectorItemInfo("assetCat.number"));
        sic.add(new SelectorItemInfo("assetCat.name"));
        sic.add(new SelectorItemInfo("assetCat.useLimit"));
        sic.add(new SelectorItemInfo("assetCat.prePureRate"));
        sic.add(new SelectorItemInfo("assetCat.depreRule"));
        sic.add(new SelectorItemInfo("assetCat.isLeaf"));
        sic.add(new SelectorItemInfo("assetCat.numberRule"));
        sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        sic.add(new SelectorItemInfo("assetCat.displayName"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.OldChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.TotalDeprChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DevalueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.LeaveValueChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.ChargeAccoutChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UsedLifeChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprMethodChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.EvaluateChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.CostCenterChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.UseStatusChange"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.TailDispose"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprRule"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.StartDeprTime"));
        sic.add(new SelectorItemInfo("measureUnit.id"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        sic.add(new SelectorItemInfo("measureUnit.number"));
        sic.add(new SelectorItemInfo("storeCity.id"));
        sic.add(new SelectorItemInfo("storeCity.name"));
        sic.add(new SelectorItemInfo("storeCity.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("dept.id"));
        sic.add(new SelectorItemInfo("dept.name"));
        sic.add(new SelectorItemInfo("dept.number"));
        sic.add(new SelectorItemInfo("keeper.id"));
        sic.add(new SelectorItemInfo("keeper.name"));
        sic.add(new SelectorItemInfo("keeper.number"));
        sic.add(new SelectorItemInfo("originType"));
        sic.add(new SelectorItemInfo("originMethod.id"));
        sic.add(new SelectorItemInfo("originMethod.name"));
        sic.add(new SelectorItemInfo("originMethod.number"));
        sic.add(new SelectorItemInfo("originMethod.isLeaf"));
        sic.add(new SelectorItemInfo("useStatus.id"));
        sic.add(new SelectorItemInfo("useStatus.name"));
        sic.add(new SelectorItemInfo("useStatus.number"));
        sic.add(new SelectorItemInfo("useStatus.isLeaf"));
        sic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        sic.add(new SelectorItemInfo("economicPurp.id"));
        sic.add(new SelectorItemInfo("economicPurp.name"));
        sic.add(new SelectorItemInfo("economicPurp.number"));
        sic.add(new SelectorItemInfo("economicPurp.isLeaf"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.isoCode"));
        sic.add(new SelectorItemInfo("currency.sign"));
        sic.add(new SelectorItemInfo("currency.baseUnit"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("deprMethod.*"));
        sic.add(new SelectorItemInfo("measureUnitWL.id"));
        sic.add(new SelectorItemInfo("measureUnitWL.name"));
        sic.add(new SelectorItemInfo("measureUnitWL.number"));
        sic.add(new SelectorItemInfo("accountAsset.id"));
        sic.add(new SelectorItemInfo("accountAsset.name"));
        sic.add(new SelectorItemInfo("accountAsset.number"));
        sic.add(new SelectorItemInfo("accountAsset.isLeaf"));
        sic.add(new SelectorItemInfo("accountAccuDepr.id"));
        sic.add(new SelectorItemInfo("accountAccuDepr.name"));
        sic.add(new SelectorItemInfo("accountAccuDepr.number"));
        sic.add(new SelectorItemInfo("accountAccuDepr.isLeaf"));
        sic.add(new SelectorItemInfo("accountDecValue.id"));
        sic.add(new SelectorItemInfo("accountDecValue.name"));
        sic.add(new SelectorItemInfo("accountDecValue.number"));
        sic.add(new SelectorItemInfo("accountDecValue.isLeaf"));
        sic.add(new SelectorItemInfo("company.baseCurrency.*"));
        sic.add(new SelectorItemInfo("accountAsset.longName"));
        sic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        sic.add(new SelectorItemInfo("accountDecValue.longName"));
        sic.add(new SelectorItemInfo("period.beginDate"));
        sic.add(new SelectorItemInfo("period.endDate"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("evalDeprMode.number"));
        sic.add(new SelectorItemInfo("evalDeprMode.name"));
        sic.add(new SelectorItemInfo("evalDeprMode.isWorkload"));
        sic.add(new SelectorItemInfo("evalDeprMode.isCustom"));
        sic.add(new SelectorItemInfo("evalDeprMode.depValuePolicy"));
        sic.add(new SelectorItemInfo("evalDeprMode.id"));
        sic.add(new SelectorItemInfo("evalDeprMode.period"));
        sic.add(new SelectorItemInfo("evalDeprPeriodNum"));
        sic.add(new SelectorItemInfo("evalMonthRate"));
        sic.add(new SelectorItemInfo("evalAddDepr"));
        sic.add(new SelectorItemInfo("evalRemValue"));
        sic.add(new SelectorItemInfo("evalYearDepr"));
        sic.add(new SelectorItemInfo("evalDecValue"));
        sic.add(new SelectorItemInfo("evalUseTermCount"));
        sic.add(new SelectorItemInfo("evalNeatValue"));
        sic.add(new SelectorItemInfo("evalNeatAmt"));
        sic.add(new SelectorItemInfo("evalAssetValue"));
        sic.add(new SelectorItemInfo("evalTaxLeftPeriod"));
        sic.add(new SelectorItemInfo("evalDeprTTerm"));
        sic.add(new SelectorItemInfo("evalNeatLeftRate"));
        String card = cardType == 0 ? "faCur" : (cardType == 1 ? "faBiz" : "faBak");
        sic.add(card + "Facility.id");
        sic.add(card + "Facility.seq");
        sic.add(card + "Facility.facilityNumber");
        sic.add(card + "Facility.facilityName");
        sic.add(card + "Facility.facilityModel");
        sic.add(card + "Facility.registerDate");
        sic.add(card + "Facility.quantity");
        sic.add(card + "Facility.amount");
        sic.add(card + "Facility.remark");
        sic.add(card + "Facility.measureUnit.id");
        sic.add(card + "Facility.measureUnit.number");
        sic.add(card + "Facility.measureUnit.name");
        sic.add(card + "Facility.storePlace.id");
        sic.add(card + "Facility.storePlace.name");
        sic.add(card + "Facility.storePlace.number");
        sic.add(card + "Facility.keeper.name");
        sic.add(card + "Facility.keeper.number");
        sic.add(card + "CostCenter.id");
        sic.add(card + "CostCenter.apportionScale");
        sic.add(card + "CostCenter.accountView.name");
        sic.add(card + "CostCenter.accountView.number");
        sic.add(card + "CostCenter.accountView.isLeaf");
        sic.add(card + "CostCenter." + card + "AsstActComposit.seq");
        sic.add(card + "CostCenter." + card + "AsstActComposit.asstActType.*");
        sic.add(card + "CostCenter." + card + "AsstActComposit.asstActItem.*");
        sic.add(card + "CostCenter.asstActType.*");
        sic.add(card + "CostCenter.asstActItem.*");
        sic.add(card + "CostCenter.seq");
        sic.add(card + "CostCenter.remark");
        sic.add(card + "CostCenter.accountView.longName");
        sic.add(card + "Department.id");
        sic.add(card + "Department.usage");
        sic.add(card + "Department.remark");
        sic.add(card + "Department.useDepartment.id");
        sic.add(card + "Department.useDepartment.name");
        sic.add(card + "Department.useDepartment.number");
        sic.add(card + "Department.useDepartment.displayName");
        sic.add(card + "Department.usePerson.id");
        sic.add(card + "Department.usePerson.name");
        sic.add(card + "Department.usePerson.name");
        sic.add(card + "Department.usePerson.number");
        return sic;
    }

    private SelectorItemCollection getFaDefPropertySelectors(SelectorItemCollection sic, Context ctx) {
        EntityObjectInfo pv = FaDispatchServiceFacadeControllerBean.loadEntity("com.kingdee.eas.fi.fa.def.app.FaDefPropertyValue", ctx);
        PropertyCollection propertyCol = pv.getProperties();
        if (propertyCol.size() > 0) {
            for (int i = 0; i < propertyCol.size(); ++i) {
                PropertyInfo info = propertyCol.get(i);
                if (info instanceof LinkPropertyInfo) {
                    sic.add("propertyValue." + info.getName() + ".id");
                    sic.add("propertyValue." + info.getName() + ".number");
                    sic.add("propertyValue." + info.getName() + ".name");
                    continue;
                }
                sic.add("propertyValue." + info.getName());
            }
        }
        sic.add("propertyValue.id");
        return sic;
    }

    private static EntityObjectInfo loadEntity(String pk, Context ctx) {
        Project depend = new Project(FA_DEF_PROJECT_ID);
        if (ctx == null) {
            return UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(pk), (Project)depend);
        }
        IMetaDataLoader loader = FaDispatchServiceFacadeControllerBean.getMDloader(ctx);
        BOSObjectType type = MetaDataTypeList.ENTITY;
        Project.Projects projects = Project.Projects.getProjects((Project[])new Project[]{depend}, null);
        EntityObjectInfo entity = (EntityObjectInfo)loader.get(type, (IMetaDataPK)MetaDataPK.create((String)pk), projects);
        return entity;
    }

    private static IMetaDataLoader getMDloader(Context ctx) {
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
    }

    @Override
    protected IObjectCollection _getDispatchEntryByCard(Context ctx, String billIds) throws BOSException, EASBizException {
        FaDispatchBillEntryCollection entryCol = new FaDispatchBillEntryCollection();
        String newSelectedIdSetString = billIds;
        String[] cardIdAfterMerge = new String[]{};
        for (String newSelectedId : cardIdAfterMerge = this.getStringIntersection(newSelectedIdSetString, "")) {
            FaCurCardInfo curCard = this.getCurCardInfo(newSelectedId, ctx);
            if (this.isNeedDepreciation(curCard, ctx)) {
                return null;
            }
            EffectedStatusEnum effectedStatus = curCard.getEffectedStatus();
            CheckedStatusEnum checkedStatus = curCard.getCheckedStatus();
            BlockedStatusEnum blockedStatus = curCard.getBlockedStatus();
            DeletedStatusEnum deletedStatus = curCard.getDeletedStatus();
            FaBizStatusEnum bizStatus = curCard.getBizStatus();
            if (effectedStatus == null || effectedStatus != EffectedStatusEnum.EFFECTED || checkedStatus == null || checkedStatus != CheckedStatusEnum.AUDITED || blockedStatus == null || blockedStatus != BlockedStatusEnum.UNBLOCKED || deletedStatus == null || deletedStatus != DeletedStatusEnum.NORMAL || !bizStatus.getValue().endsWith("99")) continue;
            PeriodInfo curPeriod = this.getCurrentPeriod(curCard.getCompany().getId().toString(), ctx);
            boolean isStartDeprTime = curCard.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0;
            boolean isDep = FaDepreciationEntryFactory.getLocalInstance((Context)ctx).exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
            if (!isDep) {
                isDep = FaEvalDepreciationEntryFactory.getLocalInstance((Context)ctx).exists("select fid where LnkFaDepreEntry.period.id='" + curPeriod.getId().toString() + "' and LnkFaDepreEntry.company.id='" + curCard.getCompany().getId().toString() + "' and faCurCard.id='" + curCard.getId().toString() + "'");
            }
            FaDispatchBillEntryInfo entryInfo = this.calOtherBillData(curCard, isStartDeprTime, isDep, curPeriod);
            entryInfo.put("isNewData", (Object)"true");
            entryCol.add(entryInfo);
        }
        return entryCol;
    }
}

