/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceCollection;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceFactory;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.IFaAccountBalance;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import java.math.BigDecimal;

public class FafacadeLocalUtils
extends FaLocalUtils {
    public static BigDecimal getBalanceKeyValue(Context ctx, String key, String company, int year, int periodNumber, String assertCat, String assertNumber, String dept, String currency) throws BOSException, EASBizException {
        BigDecimal result = new BigDecimal("0");
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo(key));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)company, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)new Integer(year), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        if (assertCat != null && assertCat.trim().length() != 0) {
            filter.getFilterItems().add(new FilterItemInfo("faCurCard.assetCat", (Object)assertCat, CompareType.EQUALS));
        }
        if (assertNumber != null && assertNumber.trim().length() != 0) {
            filter.getFilterItems().add(new FilterItemInfo("faCurCard.number", (Object)assertNumber, CompareType.EQUALS));
        }
        if (dept != null && dept.trim().length() != 0) {
            filter.getFilterItems().add(new FilterItemInfo("faCurCard.dept", (Object)dept, CompareType.EQUALS));
        }
        view.setFilter(filter);
        IFaAccountBalance accountBalance = FaAccountBalanceFactory.getLocalInstance((Context)ctx);
        FaAccountBalanceCollection c = accountBalance.getFaAccountBalanceCollection(view);
        for (int i = 0; i < c.size(); ++i) {
            FaAccountBalanceInfo balance = c.get(i);
            BigDecimal yc = balance.getBigDecimal(key);
            if (yc == null) continue;
            result = result.add(yc);
        }
        return result;
    }

    public static BigDecimal getBalanceKeyValue(Context ctx, String key, String company, int year, int periodNumber, String assertCat, String currency) throws BOSException, EASBizException {
        return FafacadeLocalUtils.getBalanceKeyValue(ctx, key, company, year, periodNumber, assertCat, null, null, currency);
    }

    public static BigDecimal getBalanceKeyValue(Context ctx, String key, String company, int startYear, int startPeriod, int endYear, int endPeriod, String assertCat) throws BOSException, EASBizException {
        BigDecimal result = new BigDecimal("0");
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo(key));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)company, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("faCurCard.assetCat", (Object)assertCat, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)new Integer(startYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)new Integer(startPeriod), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)new Integer(startYear), CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)new Integer(endYear), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)new Integer(endYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)new Integer(endPeriod), CompareType.LESS_EQUALS));
        filter.setMaskString("#0 and #1 and ((#2 and #3) or (#4 and #5) or (#6 and #7))");
        view.setFilter(filter);
        IFaAccountBalance accountBalance = FaAccountBalanceFactory.getLocalInstance((Context)ctx);
        FaAccountBalanceCollection c = accountBalance.getFaAccountBalanceCollection(view);
        for (int i = 0; i < c.size(); ++i) {
            FaAccountBalanceInfo balance = c.get(i);
            BigDecimal yc = balance.getBigDecimal(key);
            if (yc == null) continue;
            result = result.add(yc);
        }
        return result;
    }
}

