/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.base;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.AdminOrgRangeFilterUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.base.FaCommonObject;
import com.kingdee.eas.fi.fa.facade.app.util.FaServerUtil;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CompanyDataImpl {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.facade.app.base.CompanyDataImpl");
    private Context context = null;

    public CompanyDataImpl(Context context) {
        this.context = context;
    }

    public IObjectValue getCompanyOrgData(String companyOrgUnitId, String selector, String permissionItem) throws BOSException, EASBizException {
        FaCommonObject info = new FaCommonObject();
        SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitId), sic);
        info.put("company", company);
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.context, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
        info.put("period", currentPeriodInfo);
        HashMap orgParam = FaManageUtils.getFAParameter4CurCard((BOSUuid)BOSUuid.read((String)companyOrgUnitId), (Context)this.context);
        info.put("orgparam", orgParam);
        String permItemId = FaServerUtil.getFuncPermissionId(this.context, permissionItem);
        String mainOrgFilter = "id in (SELECT cp.fid " + FaServerUtil.getCompanyFilterSQL(this.context.getCaller().toString(), permItemId, true, null, null, true) + ") ";
        info.put("mainorgfilter", mainOrgFilter);
        String adminRangeFilter = this.getUserAdminOrgRangeFilter();
        info.put("adminrangefilter", adminRangeFilter);
        String adminOrgFilter = this.getAdminOrgUnitRangeFilter();
        info.put("adminorgfilter", adminOrgFilter);
        String profitCenterFilter = this.getProfitCenterFilter(companyOrgUnitId);
        info.put("profitCenterFilter", profitCenterFilter);
        return info;
    }

    private String getProfitCenterFilter(String companyId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" id IN (SELECT FFromUnitId FROM T_ORG_UnitRelation ");
        sql.append(" WHERE FTypeRelationId = (SELECT fid FROM T_ORG_TypeRelation WHERE FFromType = 6 AND FToType = 1) ");
        sql.append(" AND FToUnitId = '").append(companyId).append("') ");
        sql.append(" AND id IN (SELECT ssc.FprofitCenterId FROM T_BD_SystemStatusCtrol ssc ");
        sql.append(" INNER JOIN T_BD_SystemStatus ss on ss.FId = ssc.FSystemStatusId ");
        sql.append(" where ss.FName = ").append(1006);
        sql.append(" AND ssc.FStartPeriodId IS NOT NULL) ");
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)this.context);
        sql.append(" AND id IN (SELECT FOrgId FROM T_PM_OrgRange WHERE FUserId = '").append(curUser.getId().toString()).append("' ");
        sql.append(" AND ftype = 10) ");
        return sql.toString();
    }

    public List<Integer> getPeriodYearRange(CompanyOrgUnitInfo company) throws BOSException {
        ArrayList<Integer> years = new ArrayList<Integer>();
        Integer minYear = null;
        Integer maxYear = null;
        if (company == null || company.getAccountPeriodType() == null) {
            return years;
        }
        String periodTypeId = company.getAccountPeriodType().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select min(fperiodyear) fminYear, max(fperiodyear) fmaxYear from t_bd_period where ftypeid ='");
        sql.append(periodTypeId).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)this.context, (String)sql.toString());
        try {
            if (rs.next()) {
                minYear = rs.getInt("fminYear");
                maxYear = rs.getInt("fmaxYear");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (minYear != null && maxYear != null) {
            for (int i = minYear.intValue(); i <= maxYear; ++i) {
                years.add(i);
            }
        }
        return years;
    }

    public String getAdminOrgUnitRangeFilter() throws EASBizException, BOSException {
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.org.app", (String)"NewOrgF7Query");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(this.getOrgStructureFilter());
        String querySql = FaServerUtil.getQueryExecutor(this.context, (IMetaDataPK)queryPK, viewInfo).getSQL();
        StringBuffer orgSql = new StringBuffer();
        orgSql.append("id in (select \"ORGSTRUCTURE\".FUnitId ");
        orgSql.append(querySql.substring(querySql.indexOf("FROM"), querySql.indexOf("ORDER BY")));
        orgSql.append(") ");
        return orgSql.toString();
    }

    private FilterInfo getOrgStructureFilter() throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        String rootUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        String treeId = "00000000-0000-0000-0000-0000000000034F2827FD";
        oql.append("select unit.longnumber where unit.id = '").append(rootUnitId).append("' and tree.id = '").append(treeId).append("'");
        OrgStructureInfo structInfo = OrgStructureFactory.getLocalInstance((Context)this.context).getOrgStructureInfo(oql.toString());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeId, CompareType.EQUALS));
        String[] rootLongNumbers = new String[]{structInfo.getUnit().getLongNumber()};
        FilterInfo longNumberFilter = new FilterInfo();
        if (rootLongNumbers != null && rootLongNumbers.length > 0) {
            longNumberFilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)rootLongNumbers[0], CompareType.EQUALS));
            longNumberFilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(rootLongNumbers[0] + "!%"), CompareType.LIKE));
            longNumberFilter.setMaskString("(#0 or #1)");
        }
        filter.mergeFilter(longNumberFilter, "and");
        return filter;
    }

    public String getUserAdminOrgRangeFilter() throws BOSException {
        Set adminOrgs = null;
        try {
            adminOrgs = AdminOrgRangeFilterUtil.getCurrentUserAdminOrgRange((Context)this.context);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer orgIds = new StringBuffer("id in ('null'");
        if (adminOrgs != null) {
            Iterator iter = adminOrgs.iterator();
            while (iter.hasNext()) {
                orgIds.append(", '").append((String)iter.next()).append("'");
            }
        }
        orgIds.append(") ");
        return orgIds.toString();
    }

    public IObjectValue getCompanyAndParamsData(String companyOrgUnitId) throws BOSException, EASBizException {
        FaCommonObject info = new FaCommonObject();
        logger.error((Object)("getCompanyAndParamsData begin FaServerUtil.getOrgInfoSelector:" + FaServerUtil.getOrgInfoSelector(OrgType.Company)));
        SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
        logger.error((Object)"getCompanyAndParamsData end");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitId), sic);
        info.put("company", company);
        HashMap orgParam = FaManageUtils.getFAParameter((BOSUuid)BOSUuid.read((String)companyOrgUnitId), (Context)this.context);
        info.put("orgparam", orgParam);
        PeriodInfo period = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.context, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
        info.put("period", period);
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)this.context, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
        info.put("isStartPeriod", period.getNumber() == startPeriod.getNumber());
        return info;
    }

    public static HashMap getFAParameter(BOSUuid id, Context ctx) throws EASBizException, BOSException {
        String depr;
        if (id == null) {
            return new HashMap();
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("FA_008", pk);
        paramKeyMap.put("FA_043", pk);
        Set set = paramKeyMap.keySet();
        Object[] paramObject = set.toArray();
        String[] paramNumber = new String[paramObject.length];
        for (int i = 0; i < paramObject.length; ++i) {
            paramNumber[i] = (String)paramObject[i];
        }
        HashMap result = ParamManager.getParamHashMap((Context)ctx, (String[])paramNumber, (String)id.toString());
        if (result != null && ((depr = (String)result.get("FA_007")) == null || depr.trim().length() == 0)) {
            result.put("FA_007", "2");
        }
        return result == null ? new HashMap() : result;
    }

    public List getCompanyAndParamsDataList(String companyOrgUnitIds) throws BOSException, EASBizException {
        HashMap companyData = new HashMap();
        HashMap precisionMap = new HashMap();
        HashMap paramsData = new HashMap();
        ArrayList<FaCommonObject> list = new ArrayList<FaCommonObject>();
        String[] companyOrgUnitIdsList = companyOrgUnitIds.split(",");
        for (int i = 0; i < companyOrgUnitIdsList.length; ++i) {
            FaCommonObject info = new FaCommonObject();
            String companyOrgUnitId = companyOrgUnitIdsList[i];
            SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitId), sic);
            HashMap orgParam = CompanyDataImpl.getFAParameter(BOSUuid.read((String)companyOrgUnitId), this.context);
            info.put("orgparam", orgParam);
            info.put("company", company);
            info.put("companyid", company.getId().toString());
            list.add(info);
        }
        return list;
    }

    public CompanyOrgUnitCollection _getFuncPermissionOrgs(Context ctx, String permissionItem) throws BOSException, EASBizException {
        String userId = ctx.getCaller().toString();
        String permItemId = FaServerUtil.getFuncPermissionId(ctx, permissionItem);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT cp.fid as FID ");
        sql.append(FaServerUtil.getCompanyFilterSQL(userId, permItemId, true, null, null, true));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (rowSet.next()) {
                idSet.add(rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection result = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        OrgUnitInfo orgInfo = (OrgUnitInfo)ctx.get((Object)OrgType.getEnum((int)OrgType.Company.getValue()));
        for (int i = 0; i < result.size(); ++i) {
            if (orgInfo == null || !orgInfo.getId().equals((Object)result.get(i).getId())) continue;
            CompanyOrgUnitInfo newCompany = new CompanyOrgUnitInfo();
            CompanyOrgUnitInfo companyFst = result.get(0);
            CompanyOrgUnitInfo companyTmp = result.get(i);
            result.set(0, newCompany);
            result.set(i, companyFst);
            result.set(0, companyTmp);
        }
        return result;
    }

    public Map<String, Object> getCompanyAndPeriod(String permissionItem) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CompanyOrgUnitInfo mainOrgUnit = (CompanyOrgUnitInfo)FaServerUtil.getDefaultMainBizOrg(this.context, OrgType.Company, permissionItem);
        result.put("company", mainOrgUnit);
        PeriodInfo period = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.context, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)mainOrgUnit);
        result.put("period", period);
        return result;
    }

    public String getCompanyIDSQL(Context ctx, String permissionItem) throws BOSException, EASBizException {
        Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.facade.app.base.CompanyDataImpl");
        logger.error((Object)("CompanyDataImpl ,FaServerUtil.getFuncPermissionId,permissionItem:" + permissionItem));
        String permissionId = FaServerUtil.getFuncPermissionId(ctx, permissionItem);
        logger.error((Object)"CompanyDataImpl ,ContextUtil.getCurrentUserInfo begin");
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        logger.error((Object)"CompanyDataImpl ,ContextUtil.getCurrentUserInfo end");
        StringBuffer sql = new StringBuffer();
        sql.append(" select cp.fid ");
        logger.error((Object)"CompanyDataImpl ,FaServerUtil.getCompanyFilterSQL begin");
        sql.append(FaServerUtil.getCompanyFilterSQL(userId, permissionId, true, null, null, true));
        logger.error((Object)"CompanyDataImpl ,FaServerUtil.getCompanyFilterSQL end");
        return sql.toString();
    }

    public AdminOrgUnitInfo getPrimaryAdminOrg(String personId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("position.adminOrgUnit.id");
        view.getSelector().add("position.adminOrgUnit.name");
        view.getSelector().add("position.adminOrgUnit.number");
        view.getSelector().add("position.adminOrgUnit.displayName");
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        f.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
        view.setFilter(f);
        PositionMemberCollection cols = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(view);
        if (cols != null && cols.size() > 0) {
            AdminOrgUnitInfo org = cols.get(0).getPosition().getAdminOrgUnit();
            return org;
        }
        return null;
    }
}

