/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.base;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.base.FaCommonObject;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DataProvider {
    private Context context = null;

    public DataProvider(Context context) {
        this.context = context;
    }

    public IObjectValue getDataInfo(String bosType, String id, String selector) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (selector != null) {
            String[] selectorItems = selector.split(",");
            for (int i = 0; i < selectorItems.length; ++i) {
                sic.add(new SelectorItemInfo(selectorItems[i]));
            }
        } else {
            sic.add(new SelectorItemInfo("*"));
        }
        return DynamicObjectFactory.getLocalInstance((Context)this.context).getValue(new BOSObjectType(bosType), (IObjectPK)new ObjectUuidPK(id), sic);
    }

    public IObjectValue getDataCollection(String bosType, String oql) throws BOSException {
        FaCommonObject info = new FaCommonObject();
        IObjectCollection dataCol = DynamicObjectFactory.getLocalInstance((Context)this.context).getCollection(new BOSObjectType(bosType), oql);
        for (int i = 0; i < dataCol.size(); ++i) {
            info.put("data" + i, dataCol.getObject(i));
        }
        return info;
    }

    public IObjectValue billCopy(AbstractObjectValue dataObject) throws BOSException {
        BOSObjectType bosType = dataObject.getBOSType();
        EntitySelect select = new EntitySelect(bosType);
        select.selectPKFields();
        SimpleEntity entity = MetaDataAccessFactory.getLocalInstance((Context)this.context).select(select);
        String[] pks = entity.getPKFields();
        this.removePKField(dataObject, pks);
        dataObject.setBOSUuid("id", BOSUuid.create((BOSObjectType)dataObject.getBOSType()));
        return dataObject;
    }

    public ExchangeRateInfo getExchangeRate(String targetCurrencyId, String currencyId, String exchangeTableId, String date) throws EASBizException, BOSException {
        ExchangeRateInfo data = new ExchangeRateInfo();
        Date exDate = null;
        try {
            exDate = new SimpleDateFormat("yyyy-MM-dd").parse(date);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        ExchangeRateInfo exchangeRate = ExchangeRateFactory.getLocalInstance((Context)this.context).getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTableId), (IObjectPK)new ObjectUuidPK(currencyId), (IObjectPK)new ObjectUuidPK(targetCurrencyId), exDate);
        data.put("exchangeRate", (Object)exchangeRate);
        return data;
    }

    private void removePKField(AbstractObjectValue dataObject, String[] pks) {
        if (dataObject == null) {
            return;
        }
        dataObject.remove(dataObject.getPKField());
        if (pks != null) {
            for (int i = 0; i < pks.length; ++i) {
                String[] path = StringUtils.split((String)pks[i], (String)".");
                List<AbstractObjectValue> ovs = new ArrayList<AbstractObjectValue>(1);
                ovs.add(dataObject);
                for (int j = 0; j < path.length && (ovs = this.findSubObject(ovs, path[j])) != null; ++j) {
                }
                if (ovs == null) continue;
                for (AbstractObjectValue ov : ovs) {
                    ov.remove(ov.getPKField());
                }
            }
        }
    }

    private List<AbstractObjectValue> findSubObject(List<AbstractObjectValue> dataObjects, String prop) {
        if (dataObjects == null || dataObjects.size() <= 0 || prop == null) {
            return null;
        }
        ArrayList<AbstractObjectValue> subs = new ArrayList<AbstractObjectValue>();
        int size = dataObjects.size();
        for (int i = 0; i < size; ++i) {
            AbstractObjectValue ov;
            Object sub = dataObjects.get(i).get(prop);
            if (sub == null) continue;
            if (sub instanceof AbstractObjectValue) {
                ov = (AbstractObjectValue)sub;
                subs.add(ov);
                continue;
            }
            if (!(sub instanceof AbstractObjectCollection)) continue;
            AbstractObjectCollection oc = (AbstractObjectCollection)sub;
            int s = oc.size();
            for (int j = 0; j < s; ++j) {
                ov = (AbstractObjectValue)oc.getObject(j);
                subs.add(ov);
            }
        }
        return subs;
    }
}

