/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.clearBill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.SplithDealModeEnum;
import com.kingdee.eas.fi.fa.facade.app.base.DataProvider;
import com.kingdee.eas.fi.fa.facade.app.model.IModelCreate;
import com.kingdee.eas.fi.fa.facade.app.util.FaServerUtil;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillException;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FaClearBillModelCreator
implements IModelCreate {
    private static BigDecimal ZERO = new BigDecimal("0.00");
    private String resource = "com.kingdee.eas.fi.fa.facade.FaFacadeResource";
    private Context context = null;

    @Override
    public IObjectValue createModel(String bosType, String mainOrgUnitId, Context context) throws BOSException, EASBizException {
        FaClearBillInfo obj = null;
        this.context = context;
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("companyId", mainOrgUnitId);
        if ("25F51970".equals(bosType)) {
            obj = this.createFaClearBillInfo(filterMap);
        }
        return obj;
    }

    @Override
    public IObjectValue copyModel(IObjectValue dataObject) throws BOSException, EASBizException {
        IObjectValue srcObj = dataObject;
        IObjectValue objCopy = new DataProvider(this.context).billCopy((AbstractObjectValue)srcObj);
        this.setFieldsNull(objCopy);
        return objCopy;
    }

    private FaClearBillInfo createFaClearBillInfo(Map filterMap) throws BOSException, EASBizException {
        String mainOrgUnitId = (String)filterMap.get("companyId");
        String billIds = (String)filterMap.get("billIds");
        FaClearBillInfo clearBillInfo = new FaClearBillInfo();
        clearBillInfo.setId(BOSUuid.create((BOSObjectType)clearBillInfo.getBOSType()));
        CompanyOrgUnitInfo mainOrgUnit = null;
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)this.context);
        boolean hasFunctionperm = false;
        if (!StringUtils.isEmpty((String)mainOrgUnitId)) {
            hasFunctionperm = PermissionFactory.getLocalInstance((Context)this.context).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(mainOrgUnitId), "fa_cardclean_addnew");
        }
        if (!StringUtils.isEmpty((String)mainOrgUnitId) && hasFunctionperm) {
            SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
            mainOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgUnitId), sic);
        } else {
            mainOrgUnit = (CompanyOrgUnitInfo)FaServerUtil.getDefaultMainBizOrg(this.context, OrgType.Company, "fa_cardclean_addnew");
        }
        if (mainOrgUnit == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"NO_PERM_ORG", (Locale)this.context.getOriginLocale())));
        }
        PeriodInfo currenctPeriod = this.getCurrentPeriod(mainOrgUnit);
        Date today = new Date(System.currentTimeMillis());
        today = DateTimeUtils.truncateDate((Date)today);
        today = FaServerUtil.getBizDate(mainOrgUnit, currenctPeriod);
        clearBillInfo.setPeriod(currenctPeriod);
        clearBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        clearBillInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        clearBillInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        clearBillInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        clearBillInfo.setFiVouchered(false);
        clearBillInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)this.context));
        clearBillInfo.setCompany(mainOrgUnit);
        clearBillInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)this.context));
        clearBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)this.context));
        clearBillInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        clearBillInfo.setClearDate(this.getAccountDate(mainOrgUnit, currenctPeriod));
        this.setRuleNumber(clearBillInfo, mainOrgUnit);
        if (!StringUtils.isEmpty((String)billIds)) {
            FaClearBillEntryCollection entryCollection = new FaClearBillEntryCollection();
            String[] curcard = billIds.split(",");
            for (int i = 0; i < curcard.length; ++i) {
                FaClearBillEntryInfo entryInfo = new FaClearBillEntryInfo();
                FaCurCardInfo curcardInfo = new FaCurCardInfo();
                curcardInfo.setId(BOSUuid.read((String)curcard[i]));
                entryInfo.setCurCard(curcardInfo);
                entryInfo.setSplithDeal(SplithDealModeEnum.SPLITH_SALE);
                entryCollection.add(entryInfo);
            }
            clearBillInfo.put("clearBillEntry", (Object)entryCollection);
        }
        return clearBillInfo;
    }

    private Date getAccountDate(CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo currenctPeriod) throws EASBizException, BOSException {
        Date today = new Date(System.currentTimeMillis());
        if (currenctPeriod == null) {
            return today;
        }
        if (today.before(currenctPeriod.getBeginDate())) {
            today = currenctPeriod.getBeginDate();
        }
        if (today.after(currenctPeriod.getEndDate())) {
            today = currenctPeriod.getEndDate();
        }
        return today;
    }

    protected PeriodInfo getCurrentPeriod(CompanyOrgUnitInfo mainOrgUnit) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)this.context, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)mainOrgUnit);
    }

    private void setFieldsNull(IObjectValue obj) {
        FaClearBillInfo clearBillInfo = (FaClearBillInfo)obj;
        clearBillInfo.setNumber(null);
        clearBillInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        clearBillInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
    }

    private void setRuleNumber(FaClearBillInfo faClearBillInfo, CompanyOrgUnitInfo mainOrgUnit) throws EASBizException, BOSException {
        String number = null;
        CompanyOrgUnitInfo company = mainOrgUnit;
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.context);
            boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)faClearBillInfo, company.getId().toString());
            boolean isViewCodeRule = iCodingRuleManager.isAddView((IObjectValue)faClearBillInfo, company.getId().toString());
            number = isCodingRule && isViewCodeRule ? iCodingRuleManager.readNumber((IObjectValue)faClearBillInfo, company.getId().toString()) : "";
            faClearBillInfo.setNumber(number);
        }
        catch (Exception ex) {
            if (ex instanceof CodingRuleException && ex.getMessage() != null && ex.getMessage().indexOf("\u6307\u5b9a\u7684\u7f16\u7801\u89c4\u5219\u672a\u5b9a\u4e49\u6216\u672a\u542f\u7528") != -1) {
                throw new FaClearBillException(FaClearBillException.NO_NUMBERRULE, new Object[]{" [" + company.getName() + "] "});
            }
            throw new BOSException((Throwable)ex);
        }
    }

    @Override
    public IObjectValue createModel(String bosType, Map filterMap, Context context) throws BOSException, EASBizException {
        this.context = context;
        FaClearBillInfo obj = null;
        if ("25F51970".equals(bosType)) {
            obj = this.createFaClearBillInfo(filterMap);
        }
        return obj;
    }
}

