/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.curcard;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.def.FaDefCommonFacadeFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyValueInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaChangeStatusEnmu;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityCollection;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaCurInitDataCollection;
import com.kingdee.eas.fi.fa.manage.FaLeaseStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaMonCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaMonDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaMonDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaMonFacilityCollection;
import com.kingdee.eas.fi.fa.manage.FaMonFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaMonInitDataCollection;
import com.kingdee.eas.fi.fa.manage.FaMonInitDataInfo;
import com.kingdee.eas.fi.fa.manage.IFaCard;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BatchAddCardImpl {
    private static BigDecimal ZERO = new BigDecimal("0.00");
    private Context context = null;
    private String resource = "com.kingdee.eas.fi.fa.facade.FaFacadeResource";
    private String motherNumber = "";
    private boolean isNeedGenNumber = false;
    private boolean isNeddGenGroupNumber = false;

    public BatchAddCardImpl(Context context) {
        this.context = context;
    }

    public Map<String, Object> batchAddCard(String bosType, String cardId, int addNumber) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        IFaCard faCardBiz = (IFaCard)BOSObjectFactory.createBOSObject((Context)this.context, (BOSObjectType)BOSObjectType.create((String)bosType));
        CoreBaseInfo cardInfo = faCardBiz.getValue((IObjectPK)new ObjectUuidPK(cardId));
        this.resetSrcCard((FaCardInfo)cardInfo);
        CoreBaseCollection cardCol = new CoreBaseCollection();
        for (int i = 0; i < addNumber; ++i) {
            FaCardInfo cardAdd = this.createFaCard((FaCardInfo)cardInfo, i);
            if (cardAdd == null) continue;
            cardCol.addObject((IObjectValue)cardAdd);
        }
        if (cardInfo instanceof FaCurCardInfo) {
            Result addResult = faCardBiz.setNumberAndSaveForBatch((IObjectCollection)cardCol);
            result.put("status", addResult.getResult());
        } else if (cardInfo instanceof FaMonCardInfo) {
            Result addResult = FaMonCardFactory.getRemoteInstance().setNumberAndSaveForBatch((IObjectCollection)cardCol);
            result.put("status", addResult.getResult());
        }
        return result;
    }

    private FaCardInfo createFaCard(FaCardInfo cardInfo, int i) throws EASBizException, BOSException {
        FaCardInfo cardCloned = new FaCardInfo();
        boolean isCurrencyDisable = this.isCurrencyDisable(cardInfo.getCurrency());
        if (cardInfo instanceof FaCurCardInfo) {
            if (this.isNeedGenNumber) {
                cardCloned = (FaCurCardInfo)cardInfo.clone();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                cardCloned.setNumber(this.motherNumber + formatter.format(new Date()) + "-" + i);
                cardCloned.setLaterPeriodData(false);
                if (!this.isNeddGenGroupNumber) {
                    String groupNumber = FaCurCardFactory.getLocalInstance((Context)this.context).getBMGroupNumber((FaCurCardInfo)cardCloned);
                    cardCloned.setGroupNumber(groupNumber);
                }
                if (isCurrencyDisable) {
                    cardCloned.setCurrency(null);
                }
            }
            if (!this.isNeedGenNumber) {
                cardCloned = (FaCurCardInfo)cardInfo.clone();
                if (isCurrencyDisable) {
                    cardCloned.setCurrency(null);
                }
                cardCloned.setLaterPeriodData(false);
            }
        } else if (cardInfo instanceof FaMonCardInfo) {
            if (this.isNeedGenNumber) {
                cardCloned = (FaMonCardInfo)cardInfo.clone();
                cardCloned.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                cardCloned.setNumber(this.motherNumber + formatter.format(new Date()) + "-" + i);
                if (!this.isNeddGenGroupNumber) {
                    String groupNumber = FaMonCardFactory.getLocalInstance((Context)this.context).getBMGroupNumber((FaMonCardInfo)cardCloned);
                    cardCloned.setGroupNumber(groupNumber);
                }
                if (isCurrencyDisable) {
                    cardCloned.setCurrency(null);
                }
            }
            if (!this.isNeedGenNumber) {
                cardCloned = (FaMonCardInfo)cardInfo.clone();
                cardCloned.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
                if (isCurrencyDisable) {
                    cardCloned.setCurrency(null);
                }
            }
        }
        cardCloned.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        return cardCloned;
    }

    private void resetSrcCard(FaCardInfo cardInfo) throws BOSException, EASBizException {
        FaDepreciationModeInfo faDepreciationModeInfo;
        CompanyOrgUnitInfo company = cardInfo.getCompany();
        String companyId = company.getId().toString();
        HashMap<String, String> paramKeyMap = new HashMap<String, String>();
        paramKeyMap.put("FA_001", companyId);
        paramKeyMap.put("FA_189", companyId);
        HashMap hmParam = ParamManager.getParamHashMap((Context)this.context, paramKeyMap);
        Object result = null;
        this.isNeddGenGroupNumber = hmParam != null && hmParam.get("FA_189") != null && "false".equals(hmParam.get("FA_189"));
        if (hmParam != null && hmParam.get("FA_001") != null && "false".equals(hmParam.get("FA_001"))) {
            this.motherNumber = cardInfo.getGroupNumber() != null ? cardInfo.getGroupNumber() : "";
            this.isNeedGenNumber = true;
        } else {
            this.isNeedGenNumber = false;
        }
        if (cardInfo.getPropertyValue() != null) {
            if (cardInfo.getPropertyValue().getPropertyValueMap().size() == 0) {
                String id = cardInfo.getPropertyValue().getId().toString();
                FaDefPropertyValueInfo pv = FaDefCommonFacadeFactory.getLocalInstance((Context)this.context).getPropertyValueById(id);
                cardInfo.setPropertyValue(pv);
            }
            if (cardInfo.getPropertyValue() != null) {
                cardInfo.getPropertyValue().setId(null);
            }
        }
        PeriodInfo currenctPeriod = null;
        Date bizDate = new Date();
        try {
            currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.context, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
            bizDate = this.getBizDate(company, currenctPeriod);
        }
        catch (Exception ex) {
            SysUtil.abort();
        }
        if (currenctPeriod == null) {
            throw new BOSException(EASResource.getString((String)this.resource, (String)"orgNoStartPeriod"));
        }
        cardInfo.setId(null);
        cardInfo.setNumber(null);
        cardInfo.setDescription(null);
        if (cardInfo instanceof FaCurCardInfo) {
            cardInfo.setOriginFlag(FaCardOriginEnum.ADDNEW);
            cardInfo.setOriginDif(cardInfo.getAssetValue());
            cardInfo.setOriginAccuDif(cardInfo.getAssetValue());
            cardInfo.setAccuDeprChg(cardInfo.getAccuDepr());
            cardInfo.setAccuDeprAccuChg(cardInfo.getAccuDepr());
            cardInfo.setAccuDeprChgTYear(cardInfo.getAccuDeprTYear());
            cardInfo.setAccuDeprAccuChgTYear(cardInfo.getAccuDeprTYear());
            cardInfo.setDecValueChg(cardInfo.getDecValue());
            cardInfo.setDecValueAccuChg(cardInfo.getDecValue());
            cardInfo.setPeriod(currenctPeriod);
            cardInfo.setBoolean("forDAP", false);
            cardInfo.setNull("faCurCardSum");
            FaCurCardInfo curCardInfo = (FaCurCardInfo)cardInfo;
            FaCurFacilityCollection facilityColl = curCardInfo.getFaCurFacility();
            int size = facilityColl.size();
            for (int i = 0; i < size; ++i) {
                FaCurFacilityInfo aFaCurFacilityInfo = facilityColl.get(i);
                aFaCurFacilityInfo.setId(null);
                aFaCurFacilityInfo.setFaCurCard(curCardInfo);
            }
            FaCurCostCenterCollection costCenterColl = curCardInfo.getFaCurCostCenter();
            int size2 = costCenterColl.size();
            for (int i = 0; i < size2; ++i) {
                FaCurCostCenterInfo aFaCurCostCenterInfo = costCenterColl.get(i);
                aFaCurCostCenterInfo.setId(null);
                aFaCurCostCenterInfo.setFaCurCard(curCardInfo);
                int sizeAsstAct = aFaCurCostCenterInfo.getFaCurAsstActComposit().size();
                for (int j = 0; j < sizeAsstAct; ++j) {
                    aFaCurCostCenterInfo.getFaCurAsstActComposit().get(j).setId(null);
                }
            }
            FaCurDepartmentCollection departmentColl = curCardInfo.getFaCurDepartment();
            int size3 = departmentColl.size();
            for (int i = 0; i < size3; ++i) {
                FaCurDepartmentInfo aFaCurDepartmentInfo = departmentColl.get(i);
                aFaCurDepartmentInfo.setId(null);
                aFaCurDepartmentInfo.setFaCurCard(curCardInfo);
            }
            FaCurInitDataCollection initDataColl = curCardInfo.getFaCurInitData();
            if (initDataColl != null && initDataColl.size() > 0) {
                curCardInfo.getFaCurInitData().clear();
            }
        } else if (cardInfo instanceof FaMonCardInfo) {
            cardInfo.setOriginFlag(FaCardOriginEnum.INITIAL);
            cardInfo.setOriginDif(ZERO);
            cardInfo.setAccuDeprChg(ZERO);
            cardInfo.setAccuDeprChgTYear(ZERO);
            cardInfo.setDecValueChg(ZERO);
            cardInfo.setAccuDeprAccuChg(ZERO);
            cardInfo.setAccuDeprAccuClean(ZERO);
            cardInfo.setDecValueAccuChg(ZERO);
            cardInfo.setOriginAccuDif(ZERO);
            cardInfo.setPeriod(null);
            cardInfo.setAccuDeprAccuChgTYear(ZERO);
            FaMonCardInfo monCardInfo = (FaMonCardInfo)cardInfo;
            monCardInfo.setFaCurCard(null);
            monCardInfo.setAccuDeprForCal(null);
            FaMonFacilityCollection facilityColl = monCardInfo.getFaMonFacility();
            int size = facilityColl.size();
            for (int i = 0; i < size; ++i) {
                FaMonFacilityInfo aFaMonFacilityInfo = facilityColl.get(i);
                aFaMonFacilityInfo.setId(null);
                aFaMonFacilityInfo.setFaMonCard(monCardInfo);
            }
            FaMonCostCenterCollection costCenterColl = monCardInfo.getFaMonCostCenter();
            int size4 = costCenterColl.size();
            for (int i = 0; i < size4; ++i) {
                FaMonCostCenterInfo aFaMonCostCenterInfo = costCenterColl.get(i);
                aFaMonCostCenterInfo.setId(null);
                aFaMonCostCenterInfo.setFaMonCard(monCardInfo);
                int sizeAsstAct = aFaMonCostCenterInfo.getFaMonAsstActComposit().size();
                for (int j = 0; j < sizeAsstAct; ++j) {
                    aFaMonCostCenterInfo.getFaMonAsstActComposit().get(j).setId(null);
                }
            }
            FaMonDepartmentCollection departmentColl = monCardInfo.getFaMonDepartment();
            int size5 = departmentColl.size();
            for (int i = 0; i < size5; ++i) {
                FaMonDepartmentInfo aFaMonDepartmentInfo = departmentColl.get(i);
                aFaMonDepartmentInfo.setId(null);
                aFaMonDepartmentInfo.setFaMonCard(monCardInfo);
            }
            FaMonInitDataCollection initDataColl = monCardInfo.getFaMonInitData();
            if (initDataColl != null && initDataColl.size() > 0) {
                for (int i = 0; i < initDataColl.size(); ++i) {
                    FaMonInitDataInfo aFaMonInitDataInfo = initDataColl.get(i);
                    aFaMonInitDataInfo.setId(null);
                    aFaMonInitDataInfo.setFaMonCard(monCardInfo);
                }
            }
        }
        cardInfo.setLeaseStatus(FaLeaseStatusEnum.NO_LEASE);
        cardInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        cardInfo.setHasDisabled(false);
        cardInfo.setBizStatus(FaBizStatusEnum.ADDING);
        cardInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        cardInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        cardInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        cardInfo.setHasCleared(FaClearStatusEnum.HasNotCleared);
        cardInfo.setFiVouchered(false);
        cardInfo.setIsNeedReDepr(false);
        cardInfo.setLastBillID(null);
        cardInfo.setHasSplited(false);
        cardInfo.setHasEvaled(false);
        cardInfo.setHasChanged(FaChangeStatusEnmu.HasNotChanged);
        cardInfo.setCompany(company);
        cardInfo.setHandler(SysContext.getSysContext().getCurrentUserInfo());
        cardInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        cardInfo.setAuditor(null);
        cardInfo.setCreateTime(null);
        cardInfo.setBizDate(bizDate);
        if (cardInfo instanceof FaCurCardInfo) {
            cardInfo.setHasNew(true);
        } else if (cardInfo instanceof FaMonCardInfo) {
            cardInfo.setHasNew(false);
        }
        cardInfo.setSourceBillId(null);
        cardInfo.setDeprTTerm(null);
        cardInfo.setMonthDepreRate(null);
        if (cardInfo.getUseTermCount() != null && cardInfo.getDeprTermCount() != null) {
            cardInfo.setIsOveraged(cardInfo.getUseTermCount().doubleValue() <= cardInfo.getDeprTermCount().doubleValue());
        }
        cardInfo.setWellDeprValue(ZERO);
        cardInfo.setAccuDeprAccuClean(ZERO);
        cardInfo.setAccuDeprAccuCleanTYear(ZERO);
        cardInfo.setAccuDeprForCal(null);
        cardInfo.setLeftYear(0);
        cardInfo.setLeftYearUp(0);
        cardInfo.setDeprCount(0);
        cardInfo.setLastPeriodCount(0);
        cardInfo.setEvalDeprTTerm(null);
        if (cardInfo.getEvalDeprMode() != null && !FaUtils.isStraightTaxMethod((FaDepreciationModeInfo)(faDepreciationModeInfo = FaDepreciationModeFactory.getRemoteInstance().getFaDepreciationModeInfo((IObjectPK)new ObjectUuidPK(cardInfo.getEvalDeprMode().getId()))))) {
            cardInfo.setEvalMonthRate(null);
        }
        cardInfo.setVoucher(null);
        cardInfo.setVoucherNumber(null);
        cardInfo.setVoucherAbstract(null);
        cardInfo.setGroupNumber(null);
        cardInfo.setBarCode(null);
        cardInfo.setLeftYearTwo(ZERO);
    }

    private Date getBizDate(CompanyOrgUnitInfo company, PeriodInfo currenctPeriod) {
        Date bizDate = new Date(System.currentTimeMillis());
        bizDate = DateTimeUtils.truncateDate((Date)bizDate);
        if (currenctPeriod == null || company == null) {
            return bizDate;
        }
        if (DateTimeUtils.dayBefore((Date)bizDate, (Date)currenctPeriod.getBeginDate())) {
            bizDate = currenctPeriod.getBeginDate();
        }
        if (DateTimeUtils.dayAfter((Date)bizDate, (Date)currenctPeriod.getEndDate())) {
            bizDate = currenctPeriod.getEndDate();
        }
        bizDate = new Date(bizDate.getTime());
        return bizDate;
    }

    private boolean isCurrencyDisable(CurrencyInfo currencyInfo) throws EASBizException, BOSException {
        boolean isDisable = false;
        if (currencyInfo != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)currencyInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)"2", CompareType.EQUALS));
            isDisable = CurrencyFactory.getLocalInstance((Context)this.context).exists(filter);
        }
        return isDisable;
    }
}

