/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.curcard;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.fa.basedata.FACardDefaultValueCollection;
import com.kingdee.eas.fi.fa.basedata.FACardDefaultValueFactory;
import com.kingdee.eas.fi.fa.basedata.FACardDefaultValueInfo;
import com.kingdee.eas.fi.fa.facade.app.base.DataProvider;
import com.kingdee.eas.fi.fa.facade.app.model.IModelCreate;
import com.kingdee.eas.fi.fa.facade.app.util.FaServerUtil;
import com.kingdee.eas.fi.fa.manage.BarCodeStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaChangeStatusEnmu;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaFromUnitCatEnum;
import com.kingdee.eas.fi.fa.manage.GroupNumberStatusEnum;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class FaCardModelCreator
implements IModelCreate {
    private static BigDecimal ZERO = new BigDecimal("0.00");
    private Context context = null;

    @Override
    public IObjectValue createModel(String bosType, String mainOrgUnitId, Context context) throws BOSException, EASBizException {
        this.context = context;
        FaCurCardInfo obj = null;
        if ("42AC39EC".equals(bosType)) {
            obj = this.createFaCurCard(mainOrgUnitId);
        }
        return obj;
    }

    @Override
    public IObjectValue copyModel(IObjectValue dataObject) throws BOSException, EASBizException {
        IObjectValue srcObj = dataObject;
        IObjectValue objCopy = new DataProvider(this.context).billCopy((AbstractObjectValue)srcObj);
        this.setFieldsNull(objCopy);
        return objCopy;
    }

    private FaCurCardInfo createFaCurCard(String mainOrgUnitId) throws BOSException, EASBizException {
        FaCurCardInfo aFaCurCardInfo = new FaCurCardInfo();
        aFaCurCardInfo.setId(BOSUuid.create((BOSObjectType)aFaCurCardInfo.getBOSType()));
        CompanyOrgUnitInfo mainOrgUnit = null;
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)this.context);
        boolean hasFunctionperm = false;
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)this.context);
        if (!StringUtils.isEmpty((String)mainOrgUnitId)) {
            hasFunctionperm = iPermission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(mainOrgUnitId), "fa_card_addNew");
        }
        if (!StringUtils.isEmpty((String)mainOrgUnitId) && hasFunctionperm) {
            SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
            mainOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgUnitId), sic);
        } else {
            CompanyOrgUnitInfo currCompanyInfo = ContextUtil.getCurrentFIUnit((Context)this.context);
            if (currCompanyInfo.isIsBizUnit() && iPermission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(currCompanyInfo.getId()), "fa_card_addNew")) {
                SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
                mainOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(currCompanyInfo.getId()), sic);
            } else {
                mainOrgUnit = (CompanyOrgUnitInfo)FaServerUtil.getDefaultMainBizOrg(this.context, OrgType.Company, "fa_card_addNew");
            }
        }
        if (mainOrgUnit == null) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"NO_PERM_ORG", (Locale)this.context.getOriginLocale())));
        }
        PeriodInfo currenctPeriod = this.getCurrentPeriod(mainOrgUnit);
        if (currenctPeriod == null) {
            String strMsg = EASCommonResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notConfigStartPeriod", (Locale)this.context.getOriginLocale());
            throw new CasWebException(new NumericExceptionSubItem("1", strMsg));
        }
        boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)this.context, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)mainOrgUnit);
        if (!isInitEnd) {
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaCurCardEditUI_FANotEndInit", (Locale)this.context.getOriginLocale())));
        }
        Date today = new Date(System.currentTimeMillis());
        today = DateTimeUtils.truncateDate((Date)today);
        today = FaServerUtil.getBizDate(mainOrgUnit, currenctPeriod);
        aFaCurCardInfo.setPeriod(currenctPeriod);
        aFaCurCardInfo.setAccountDate(today);
        aFaCurCardInfo.setFiAccountDate(today);
        aFaCurCardInfo.put("isFromCardUI", (Object)Boolean.TRUE);
        aFaCurCardInfo.setStartUseDate(today);
        aFaCurCardInfo.setUseYears(ZERO);
        aFaCurCardInfo.setAssetAmt(ZERO);
        aFaCurCardInfo.setOriginAmt(ZERO);
        aFaCurCardInfo.setAddons(null);
        aFaCurCardInfo.setAssetValue(ZERO);
        aFaCurCardInfo.setBuyValue(ZERO);
        aFaCurCardInfo.setBuyAccuDepr(ZERO);
        aFaCurCardInfo.setUseTermCount(ZERO);
        aFaCurCardInfo.setDeprTermCount(ZERO);
        aFaCurCardInfo.setAccuDepr(ZERO);
        aFaCurCardInfo.setNeatRemValue(ZERO);
        aFaCurCardInfo.setAccuDeprTYear(ZERO);
        aFaCurCardInfo.setDecValue(ZERO);
        aFaCurCardInfo.setNeatValue(ZERO);
        aFaCurCardInfo.setNeatAmt(ZERO);
        aFaCurCardInfo.setAccuDeprAccuCleanTYear(ZERO);
        aFaCurCardInfo.setOriginDif(ZERO);
        aFaCurCardInfo.setAccuDeprChg(ZERO);
        aFaCurCardInfo.setAccuDeprChgTYear(ZERO);
        aFaCurCardInfo.setDecValueChg(ZERO);
        aFaCurCardInfo.setInitEvalValue(ZERO);
        aFaCurCardInfo.setEvalLeftPeriod(ZERO);
        aFaCurCardInfo.setAccuDeprAccuChg(ZERO);
        aFaCurCardInfo.setAccuDeprAccuClean(ZERO);
        aFaCurCardInfo.setDeprTTerm(ZERO);
        aFaCurCardInfo.setAccuDeprAccuChgTYear(ZERO);
        aFaCurCardInfo.setAccuDeprAll(ZERO);
        aFaCurCardInfo.setDecValueAccuChg(ZERO);
        aFaCurCardInfo.setTreatmentIncome(null);
        aFaCurCardInfo.setFairValue(ZERO);
        aFaCurCardInfo.setLeftYearUp(0);
        aFaCurCardInfo.setDeprCount(0);
        aFaCurCardInfo.setLastPeriodCount(0);
        aFaCurCardInfo.setLastBillID(null);
        aFaCurCardInfo.setIsEvaledBefore(false);
        aFaCurCardInfo.setHasSplited(false);
        aFaCurCardInfo.setHasEvaled(false);
        aFaCurCardInfo.setHasChanged(FaChangeStatusEnmu.HasNotChanged);
        aFaCurCardInfo.setHasCleared(FaClearStatusEnum.HasNotCleared);
        aFaCurCardInfo.setHasDisabled(false);
        aFaCurCardInfo.setBizStatus(FaBizStatusEnum.ADDING);
        aFaCurCardInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        aFaCurCardInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        aFaCurCardInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        aFaCurCardInfo.setGroupNumberStatus(GroupNumberStatusEnum.EFFECTED);
        aFaCurCardInfo.setBarCodeStatus(BarCodeStatusEnum.EFFECTED);
        aFaCurCardInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        aFaCurCardInfo.setFiVouchered(false);
        aFaCurCardInfo.setOriginType(FaFromUnitCatEnum.NULL);
        aFaCurCardInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)this.context));
        aFaCurCardInfo.setCompany(mainOrgUnit);
        aFaCurCardInfo.setHandler(ContextUtil.getCurrentUserInfo((Context)this.context));
        aFaCurCardInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)this.context));
        aFaCurCardInfo.setBizDate(today);
        aFaCurCardInfo.setHasNew(true);
        aFaCurCardInfo.setOriginFlag(FaCardOriginEnum.ADDNEW);
        aFaCurCardInfo.setIsNeedReDepr(false);
        aFaCurCardInfo.setSpecs("");
        aFaCurCardInfo.setMfr("");
        aFaCurCardInfo.setPaperNo("");
        aFaCurCardInfo.setRemark("");
        aFaCurCardInfo.setAssetName("");
        aFaCurCardInfo.setPArea("");
        aFaCurCardInfo.setUseStatus(null);
        aFaCurCardInfo.setKeeper(null);
        aFaCurCardInfo.setAccountAsset(null);
        aFaCurCardInfo.setMeasureUnitWL(null);
        aFaCurCardInfo.setAccountAccuDepr(null);
        aFaCurCardInfo.setOriginUnit("");
        aFaCurCardInfo.setStoreCity(null);
        aFaCurCardInfo.setMeasureUnit(null);
        aFaCurCardInfo.setDeprMethod(null);
        aFaCurCardInfo.setAccountDecValue(null);
        aFaCurCardInfo.setDept(null);
        aFaCurCardInfo.setAssetCat(null);
        aFaCurCardInfo.setOriginMethod(null);
        CurrencyInfo currency = this.getBaseCurrency(mainOrgUnit);
        aFaCurCardInfo.setCurrency(currency);
        aFaCurCardInfo.setExRate(new BigDecimal(1.0));
        aFaCurCardInfo.setEvalAssetValue(ZERO);
        aFaCurCardInfo.setEvalTaxLeftPeriod(ZERO);
        aFaCurCardInfo.setEvalReInAccountDate(today);
        aFaCurCardInfo.setEvalDeprPeriodNum(ZERO);
        aFaCurCardInfo.setEvalMonthRate(ZERO);
        aFaCurCardInfo.setEvalRemValue(ZERO);
        aFaCurCardInfo.setEvalAddDepr(ZERO);
        aFaCurCardInfo.setEvalDecValue(ZERO);
        aFaCurCardInfo.setEvalYearDepr(ZERO);
        aFaCurCardInfo.setEvalNeatLeftRate(ZERO);
        aFaCurCardInfo.setEvalUseTermCount(ZERO);
        aFaCurCardInfo.setInputTax(ZERO);
        FaCurCostCenterInfo aFaCurCostCenterInfo = new FaCurCostCenterInfo();
        aFaCurCostCenterInfo.setApportionScale(new BigDecimal("100.00"));
        aFaCurCostCenterInfo.setSeq(1);
        FaCurCostCenterInfo costCenterInfo2 = new FaCurCostCenterInfo();
        aFaCurCostCenterInfo.setSeq(2);
        FaCurCostCenterInfo costCenterInfo3 = new FaCurCostCenterInfo();
        aFaCurCostCenterInfo.setSeq(3);
        FaCurCostCenterCollection costCenterColl = new FaCurCostCenterCollection();
        costCenterColl.add(aFaCurCostCenterInfo);
        costCenterColl.add(costCenterInfo2);
        costCenterColl.add(costCenterInfo3);
        aFaCurCardInfo.put("faCurCostCenter", (Object)costCenterColl);
        this.setDefaultValue(aFaCurCardInfo);
        return aFaCurCardInfo;
    }

    private void setDefaultValue(FaCurCardInfo faCurCardInfo) throws BOSException {
        CompanyOrgUnitInfo mainOrgUnit = faCurCardInfo.getCompany();
        FACardDefaultValueCollection coll = FACardDefaultValueFactory.getLocalInstance((Context)this.context).getFACardDefaultValueCollection("select id,assetAmt,originMethod.name,originMethod.number,useStatus.name,useStatus.number,economicPurp.name,economicPurp.number,storeCity.name,storeCity.number, dept.name,dept.number,dept.displayname,useDept.name,useDept.number,useDept.displayname where company.id = '" + mainOrgUnit.getId().toString() + "'");
        if (coll == null || coll.size() == 0) {
            return;
        }
        FACardDefaultValueInfo defaultValue = coll.get(0);
        faCurCardInfo.setAssetAmt(defaultValue.getAssetAmt());
        faCurCardInfo.setOriginMethod(defaultValue.getOriginMethod());
        faCurCardInfo.setUseStatus(defaultValue.getUseStatus());
        faCurCardInfo.setEconomicPurp(defaultValue.getEconomicPurp());
        faCurCardInfo.setStoreCity(defaultValue.getStoreCity());
        faCurCardInfo.setDept(defaultValue.getDept());
        if (defaultValue.getUseDept() != null) {
            FaCurCardInfo parentCardInfo = new FaCurCardInfo();
            parentCardInfo.setId(faCurCardInfo.getId());
            FaCurDepartmentInfo useDeptInfo = new FaCurDepartmentInfo();
            BOSUuid id = BOSUuid.create((BOSObjectType)useDeptInfo.getBOSType());
            useDeptInfo.setId(id);
            useDeptInfo.setFaCurCard(parentCardInfo);
            useDeptInfo.setUseDepartment(defaultValue.getUseDept());
            useDeptInfo.setSeq(1);
            FaCurDepartmentCollection departmentColl = faCurCardInfo.getFaCurDepartment();
            departmentColl.clear();
            departmentColl.add(useDeptInfo);
        }
    }

    private CurrencyInfo getBaseCurrency(CompanyOrgUnitInfo mainOrgUnit) {
        return mainOrgUnit.getBaseCurrency();
    }

    protected PeriodInfo getCurrentPeriod(CompanyOrgUnitInfo mainOrgUnit) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)this.context, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)mainOrgUnit);
    }

    private void setFieldsNull(IObjectValue obj) {
        FaCurCardInfo cardInfo = (FaCurCardInfo)obj;
        cardInfo.setNumber(null);
        cardInfo.setGroupNumber(null);
        cardInfo.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        cardInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
    }

    @Override
    public IObjectValue createModel(String bosType, Map filterMap, Context context) throws BOSException, EASBizException {
        return null;
    }
}

