/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.curcard;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.util.FaServerUtil;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardValidatorImpl;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityCollection;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class FaCardSubmit {
    private String RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private Context context = null;

    public FaCardSubmit(Context context) {
        this.context = context;
    }

    public String submitFaCard(IObjectValue dataObject) throws BOSException, EASBizException {
        IFaCurCard faCardBiz = FaCurCardFactory.getLocalInstance((Context)this.context);
        IObjectValue objectValue = dataObject;
        FaCurCardInfo cardInfo = (FaCurCardInfo)objectValue;
        this.setAddtionInfo(cardInfo);
        this.checkBeforeSubmit((FaCardInfo)objectValue);
        IObjectPK objectPK = faCardBiz.submit((CoreBaseInfo)objectValue);
        return objectPK.toString();
    }

    private void setAddtionInfo(FaCurCardInfo cardInfo) throws BOSException, EASBizException {
        FaCurCostCenterCollection costCenters;
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cardInfo.getCompany().getId()), FaServerUtil.getOrgInfoSelector(OrgType.Company));
        cardInfo.setCompany(company);
        if (cardInfo.getAssetCat() != null) {
            cardInfo.getAssetCat().setIsLeaf(true);
        }
        if (cardInfo.getOriginMethod() != null) {
            cardInfo.getOriginMethod().setIsLeaf(true);
        }
        if (cardInfo.getUseStatus() != null) {
            cardInfo.getUseStatus().setIsLeaf(true);
        }
        if (cardInfo.getAccountAsset() != null) {
            cardInfo.getAccountAsset().setIsLeaf(true);
        }
        if (cardInfo.getAccountAccuDepr() != null) {
            cardInfo.getAccountAccuDepr().setIsLeaf(true);
        }
        if (cardInfo.getAccountDecValue() != null) {
            cardInfo.getAccountDecValue().setIsLeaf(true);
        }
        if ((costCenters = cardInfo.getFaCurCostCenter()) != null) {
            for (int i = 0; i < costCenters.size(); ++i) {
                AccountViewInfo accountView = costCenters.get(i).getAccountView();
                if (accountView == null) continue;
                accountView.setIsLeaf(true);
            }
        }
        FaCurDepartmentCollection departments = cardInfo.getFaCurDepartment();
        FaCurDepartmentCollection newDepartments = new FaCurDepartmentCollection();
        for (int i = 0; i < departments.size(); ++i) {
            FaCurDepartmentInfo department = departments.get(i);
            if (department.getUseDepartment() == null && department.getUsage() == null && department.getUsePerson() == null && department.getRemark() == null) continue;
            newDepartments.add(department);
        }
        cardInfo.put("faCurDepartment", (Object)newDepartments);
        FaCurFacilityCollection curFacilityCollection = cardInfo.getFaCurFacility();
        FaCurFacilityCollection newCurFacilityCollection = new FaCurFacilityCollection();
        for (int i = 0; i < curFacilityCollection.size(); ++i) {
            FaCurFacilityInfo curFacility = curFacilityCollection.get(i);
            if (curFacility.getFacilityNumber() == null && curFacility.getFacilityName() == null && curFacility.getFacilityModel() == null && curFacility.getRegisterDate() == null && curFacility.getQuantity() == null && curFacility.getAmount() == null && curFacility.getRemark() == null && curFacility.getMeasureUnit() == null && curFacility.getStorePlace() == null && curFacility.getKeeper() == null) continue;
            newCurFacilityCollection.add(curFacility);
        }
        cardInfo.put("faCurFacility", (Object)newCurFacilityCollection);
    }

    public void checkBeforeSubmit(FaCardInfo faCardInfo) throws BOSException, EASBizException {
        String dependMsg = this.checkDepend((FaCurCardInfo)faCardInfo);
        if (dependMsg != null && dependMsg.length() > 0) {
            throw new BOSException(dependMsg);
        }
        StringBuffer errorMsg = new StringBuffer();
        String departMsg = this.checkDepartment((FaCurCardInfo)faCardInfo);
        if (departMsg != null && departMsg.length() > 0) {
            errorMsg.append(departMsg);
        }
        FaCardValidatorImpl validator = new FaCardValidatorImpl(this.context, (BillBaseInfo)faCardInfo, false);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("verifySubmit", Boolean.TRUE);
        params.put("Company", (Boolean)faCardInfo.getCompany());
        validator.setParam(params);
        FaCurCardInfo verifyBill = (FaCurCardInfo)faCardInfo;
        if (faCardInfo instanceof FaMonCardInfo) {
            verifyBill = FaManageUtils.MonCard2CurCard((FaMonCardInfo)((FaMonCardInfo)faCardInfo));
            verifyBill.setId(faCardInfo.getId());
        }
        validator.setBillInfo((BillBaseInfo)verifyBill);
        if (!validator.validate()) {
            errorMsg.append(validator.getInvalidMsg());
        }
        if (errorMsg.length() > 0) {
            throw new BOSException(errorMsg.toString());
        }
    }

    private String checkDepartment(FaCurCardInfo cardInfo) {
        int count = cardInfo.getFaCurDepartment().size();
        String chongfu = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"chongfu", (Locale)this.context.getLocale());
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String msg;
            FaCurDepartmentInfo curDepartmentInfo = cardInfo.getFaCurDepartment().get(i);
            AdminOrgUnitInfo dept = curDepartmentInfo.getUseDepartment();
            PersonInfo user = curDepartmentInfo.getUsePerson();
            if (dept == null) {
                PersonInfo person = user;
                if (person == null || !map.containsKey(person.getId().toString())) continue;
                msg = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"exitUser", (Locale)this.context.getLocale());
                return msg + "\"" + person.getName() + "\"" + chongfu;
            }
            AdminOrgUnitInfo deptInfo = dept;
            if (list.contains(deptInfo.getId().toString())) {
                msg = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"exitDepartmennt", (Locale)this.context.getLocale());
                return msg + "\"" + dept.getName() + "\"" + chongfu;
            }
            if (user == null) {
                if (list.contains(deptInfo.getId().toString())) {
                    msg = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"exitDepartmennt", (Locale)this.context.getLocale());
                    msg = msg + "\"" + dept.getName() + "\"" + chongfu;
                    return msg;
                }
                list.add(deptInfo.getId().toString());
                if (!map.containsValue(deptInfo.getId().toString())) continue;
                msg = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"exitDepartmennt", (Locale)this.context.getLocale());
                return msg + "\"" + dept.getName() + "\"" + chongfu;
            }
            PersonInfo person = user;
            if (map.containsKey(person.getId().toString())) {
                String msg2 = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"exitUser", (Locale)this.context.getLocale());
                return msg2 + "\"" + person.getName() + "\"" + chongfu;
            }
            map.put(person.getId().toString(), deptInfo.getId().toString());
        }
        return null;
    }

    private String checkDepend(FaCurCardInfo cardInfo) throws BOSException, EASBizException {
        return null;
    }
}

