/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.depre;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamException;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationPeriodEnum;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationRuleEnum;
import com.kingdee.eas.fi.fa.basedata.FaParamFacadeFactory;
import com.kingdee.eas.fi.fa.basedata.FaParamInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.basedata.IFaParamFacade;
import com.kingdee.eas.fi.fa.manage.FaBillTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaDepAsstActCompositFactory;
import com.kingdee.eas.fi.fa.manage.FaDepAsstActCompositInfo;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepDistributeCollection;
import com.kingdee.eas.fi.fa.manage.FaDepDistributeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepDistributeInfo;
import com.kingdee.eas.fi.fa.manage.FaDepEntryStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaDepreciationCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaPeriodException;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadCollection;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadFactory;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadInfo;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaDepAsstActComposit;
import com.kingdee.eas.fi.fa.manage.IFaDepCalFacade;
import com.kingdee.eas.fi.fa.manage.IFaDepreciation;
import com.kingdee.eas.fi.fa.manage.IFaMonCard;
import com.kingdee.eas.fi.fa.manage.IFaWorkLoad;
import com.kingdee.eas.fi.fa.manage.app.FaDepCalExecutor;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepStrategyFactory;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.IFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.ui.ModelMap;

public class FaDepCalServiceImpl {
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaDepreciationResource";
    private Context ctx = null;
    private static String FA_MUTEX_LOCK = "FI_FA_Mutex_Lock";
    public static final String DATAGRID_ENTITYVIEW = "DataGridEntityView";
    public static final String DATAGRID_SELECTOR = "selector";

    public FaDepCalServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    public Map<String, Object> checkBeforeCal(String orgID) throws BOSException, EASBizException {
        boolean alreadyCal = false;
        alreadyCal = this._checkBeforeCal(orgID);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("alreadyCal", alreadyCal + "");
        if (alreadyCal) {
            result.put("msg", EASResource.getString((String)RES_PATH, (String)"FaDepCal_AlreadyCal", (Locale)this.ctx.getLocale()));
        }
        return result;
    }

    protected boolean _checkBeforeCal(String orgID) throws BOSException, EASBizException {
        FaDepCalExecutor executor = new FaDepCalExecutor(orgID);
        return executor._checkBeforeCal(this.ctx);
    }

    public Map<String, Object> hasCardOfDeprMethod(String isCurcard, String isAudit, String orgID) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap hmPara = this.constructHasCardDMParameter(isCurcard, isAudit);
        boolean hasCardOfDeprMethodNull = false;
        hasCardOfDeprMethodNull = this._hasCardOfDeprMethodNull(this.ctx, hmPara, orgID);
        result.put("hasCardOfDeprMethod", hasCardOfDeprMethodNull + "");
        result.put("msg", EASResource.getString((String)RES_PATH, (String)"FaDepCal_hasCardOfDeprMethodNull", (Locale)this.ctx.getLocale()));
        return result;
    }

    private HashMap constructHasCardDMParameter(String isCurcard, String isAudit) {
        HashMap<String, Comparable<Boolean>> hmPara = new HashMap<String, Comparable<Boolean>>();
        hmPara.put("all", Boolean.valueOf(!Boolean.parseBoolean(isCurcard)));
        hmPara.put("useSQL", Boolean.valueOf(true));
        hmPara.put("isNeedAudit", Boolean.valueOf(!Boolean.parseBoolean(isAudit)));
        hmPara.put("threadCount", new Integer(1));
        return hmPara;
    }

    protected boolean _hasCardOfDeprMethodNull(Context ctx, HashMap hmPara, String orgID) throws BOSException, EASBizException {
        FaDepCalExecutor executor = new FaDepCalExecutor(orgID);
        return executor._hasCardOfDeprMethodNull(ctx, hmPara);
    }

    public Map<String, Object> getCurrencyScale(String orgID) throws BOSException, EASBizException {
        int scale = 2;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("baseCurrency.precision"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID), selector);
        scale = company.getBaseCurrency().getPrecision();
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> faDecNumPreciseResult = this.queryFaDecNumPrecise(orgID);
        result.put("scale", scale + "");
        result.put("faDecNumPrecise", faDecNumPreciseResult.get("faDecNumPrecise").toString());
        return result;
    }

    public Map<String, Object> queryFaDecNumPrecise(String companyid) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.initialParamItemDataByOrgID(companyid);
        EntityViewInfo ev = this.getQueryFaDecNumPreciseFilter(companyid);
        ParamItemCollection paramItemCollection = ParamItemFactory.getLocalInstance((Context)this.ctx).getParamItemCollection(ev);
        this.queryFaDecNumPreciseParam(result, paramItemCollection);
        return result;
    }

    private void queryFaDecNumPreciseParam(Map<String, Object> result, ParamItemCollection paramItemCollection) {
        String faDecNumPrecise = "";
        for (int i = 0; i < paramItemCollection.size(); ++i) {
            ParamItemInfo ParamItemInfo2 = paramItemCollection.get(i);
            if (!ParamItemInfo2.getKeyID().getNumber().equals("FA_008")) continue;
            faDecNumPrecise = ParamItemInfo2.getValue();
        }
        if (faDecNumPrecise.equals("")) {
            faDecNumPrecise = "2";
        }
        result.put("faDecNumPrecise", faDecNumPrecise);
    }

    private EntityViewInfo getQueryFaDecNumPreciseFilter(String companyid) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)companyid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"FA_008", CompareType.EQUALS));
        String mask = new String("#0 and #1");
        filterInfo.setMaskString(mask);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("keyID.*"));
        sic.add(new SelectorItemInfo("*"));
        ev.setSelector(sic);
        return ev;
    }

    public Map<String, Object> saveConfig(String isCurcard, String isAudit, String companyid) throws BOSException, EASBizException {
        EntityViewInfo ev = this.getQueryDecalConfigFilter(companyid);
        ParamItemCollection paramItemCollection = ParamItemFactory.getLocalInstance((Context)this.ctx).getParamItemCollection(ev);
        for (int i = 0; i < paramItemCollection.size(); ++i) {
            ParamItemInfo ParamItemInfo2 = paramItemCollection.get(i);
            if (ParamItemInfo2.getKeyID().getNumber().equals("FA_052")) {
                this.saveDepCalConfig(isCurcard, ParamItemInfo2);
                continue;
            }
            if (!ParamItemInfo2.getKeyID().getNumber().equals("FA_053")) continue;
            this.saveDepCalConfig(isAudit, ParamItemInfo2);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("curcardop", isCurcard);
        result.put("auditop", isAudit);
        return result;
    }

    private void saveDepCalConfig(String isCurcard, ParamItemInfo paramItemInfo) throws BOSException, EASBizException {
        paramItemInfo.setValue(isCurcard);
        ParamItemFactory.getLocalInstance((Context)this.ctx).save((CoreBaseInfo)paramItemInfo);
    }

    private EntityViewInfo getQueryDecalConfigFilter(String companyid) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)companyid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"FA_052", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"FA_053", CompareType.EQUALS));
        String mask = new String("#0 and (#1 or #2)");
        filterInfo.setMaskString(mask);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("keyID.*"));
        sic.add(new SelectorItemInfo("*"));
        ev.setSelector(sic);
        return ev;
    }

    public Map<String, Object> queryDepCalConfig(String companyid) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.initialParamItemDataByOrgID(companyid);
        EntityViewInfo ev = this.getQueryDecalConfigFilter(companyid);
        ParamItemCollection paramItemCollection = ParamItemFactory.getLocalInstance((Context)this.ctx).getParamItemCollection(ev);
        this.queryAndSetDepCalParam(result, paramItemCollection);
        return result;
    }

    private void queryAndSetDepCalParam(Map<String, Object> result, ParamItemCollection paramItemCollection) {
        String isCurcardStr = "";
        String isAuditStr = "";
        for (int i = 0; i < paramItemCollection.size(); ++i) {
            ParamItemInfo ParamItemInfo2 = paramItemCollection.get(i);
            if (ParamItemInfo2.getKeyID().getNumber().equals("FA_052")) {
                isCurcardStr = ParamItemInfo2.getValue();
            }
            if (!ParamItemInfo2.getKeyID().getNumber().equals("FA_053")) continue;
            isAuditStr = ParamItemInfo2.getValue();
        }
        if (isCurcardStr.equals("")) {
            isCurcardStr = "false";
        }
        if (isAuditStr.equals("")) {
            isAuditStr = "false";
        }
        result.put("isCurcard", isCurcardStr);
        result.put("isAudit", isAuditStr);
    }

    private void initialParamItemDataByOrgID(String companyid) throws BOSException, EASBizException, ParamException {
        CompanyOrgUnitInfo CompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        ParamControlFactory.getLocalInstance((Context)this.ctx).getParamsBySubSysAndOrgType("com.kingdee.eas.fi.fa.fa", 1, (OrgUnitInfo)CompanyOrgUnit, null);
    }

    public Map<String, Object> checkPermission(String orgID, String permItemName) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)userInfo.getId().toString()));
        ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)orgID));
        PermissionFactory.getLocalInstance((Context)this.ctx).checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, permItemName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }

    public Map<String, Object> depCal(String isCurcard, String isAudit, String orgID) throws BOSException, EASBizException {
        Uuid mutexUuid = Uuid.create();
        try {
            String mutexActionName = "faDepAudit";
            CompanyOrgUnitInfo currCompany = null;
            ICompanyOrgUnit comOrg = null;
            comOrg = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
            currCompany = comOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
            MutexParameter mutexParam = FaDepCalServiceImpl.setMutexParameter(mutexUuid, mutexActionName, currCompany, this.ctx);
            if (FaDepCalServiceImpl.requestMutex(mutexParam, this.ctx)) {
                IFaDepCalFacade depCalFacade = FaDepCalFacadeFactory.getLocalInstance((Context)this.ctx);
                HashMap<String, Object> result = new HashMap<String, Object>();
                HashMap hmPara = this.getDepCalParameter(isCurcard, isAudit);
                long start = System.currentTimeMillis();
                HashMap hm = depCalFacade.calDep(hmPara, orgID);
                long end = System.currentTimeMillis();
                long total = (end - start) / 1000L;
                Map<String, Object> map = this.makeReturnMessage(result, hm, total);
                return map;
            }
            try {
                throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)this.ctx, (String)RES_PATH, (String)"Fa_Mutex_Is_InProcess")));
            }
            catch (BOSException e) {
                throw e;
            }
            catch (EASBizException e) {
                throw e;
            }
        }
        finally {
            this.releaseLockHandle(mutexUuid);
        }
    }

    private HashMap getDepCalParameter(String isCurcard, String isAudit) {
        HashMap<String, Comparable<Boolean>> hmPara = new HashMap<String, Comparable<Boolean>>();
        hmPara.put("all", Boolean.valueOf(!Boolean.parseBoolean(isCurcard)));
        hmPara.put("useSQL", Boolean.valueOf(Boolean.parseBoolean("true")));
        hmPara.put("isNeedAudit", Boolean.valueOf(!Boolean.parseBoolean(isAudit)));
        hmPara.put("threadCount", new Integer(1));
        return hmPara;
    }

    private Map<String, Object> makeReturnMessage(Map<String, Object> result, HashMap hm, long total) throws EASBizException, BOSException {
        String msg = (String)hm.get("msg");
        if (msg != null && msg.length() > 0) {
            String title = EASResource.getString((String)RES_PATH, (String)"later_period_exists_business", (Locale)this.ctx.getLocale());
            result.put("title", title);
            result.put("msgType", 1);
            result.put("msg", EASResource.getString((String)RES_PATH, (String)"Fail_To_Operate", (Locale)this.ctx.getLocale()));
            return result;
        }
        int scale = 2;
        if (SysContext.getSysContext().getCurrentFIUnit() != null && SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency() != null) {
            scale = FaClientUtils.getCurrencyScale();
        }
        String patten = this.getFormatPattern(scale);
        DecimalFormat format = new DecimalFormat(patten);
        String str = EASResource.getString((String)RES_PATH, (String)"FaDepCal_Message1", (Locale)this.ctx.getLocale()) + "<br>";
        str = str + EASResource.getString((String)RES_PATH, (String)"FaDepCal_Message2", (Locale)this.ctx.getLocale());
        Object depCount = hm.get("DepCount");
        str = MessageFormat.format(str, depCount) + "<br>";
        str = str + EASResource.getString((String)RES_PATH, (String)"FaDepCal_Message4", (Locale)this.ctx.getLocale());
        String depAmount = format.format(hm.get("DepAmount") != null ? ((BigDecimal)hm.get("DepAmount")).setScale(scale, 4) : new BigDecimal("0.00"));
        str = MessageFormat.format(str, depAmount) + "<br>";
        str = str + FaResUtil.getRes((String)"totalTime");
        str = MessageFormat.format(str, total) + "\uff01";
        result.put("msg", str);
        return result;
    }

    private String getFormatPattern(int scale) {
        String pattern = null;
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        return pattern;
    }

    public Map<String, Object> submit(String orgID, String updateRowDataStr) throws BOSException, EASBizException {
        String[] args = updateRowDataStr.split("@");
        HashMap workloadSchemes = FaUtils.getUserDepreciationMode((Context)this.ctx, (boolean)true);
        HashMap<String, Object> result = new HashMap<String, Object>();
        FaDepreciationEntryCollection depEntry = this.getEnryByIDSet(args);
        FaDepreciationEntryCollection depEntryByUI = this.getEntryCollectionByUIParameter(args, workloadSchemes, depEntry);
        Map valideResultMap = this.validate(depEntryByUI, args);
        if (valideResultMap.get("result").equals("false")) {
            return this.getResultMap(result, false, valideResultMap.get("msg").toString());
        }
        try {
            if (this.checkHasUnAuditedBill(depEntryByUI, orgID)) {
                return this.getResultMap(result, false, EASResource.getString((String)RES_PATH, (String)"FaDepMnt_DepNotBeNull", (Locale)this.ctx.getLocale()));
            }
        }
        catch (Exception e) {
            return this.getResultMap(result, false, e.getMessage());
        }
        try {
            this.updateEntryCollection(depEntryByUI, orgID);
        }
        catch (Exception e) {
            return this.getResultMap(result, false, e.getMessage());
        }
        return this.getResultMap(result, true, null);
    }

    private Map<String, Object> getResultMap(Map<String, Object> result, boolean type, String message) {
        if (type) {
            result.put("result", "true");
        } else {
            result.put("result", "false");
            result.put("msg", message);
        }
        return result;
    }

    private Map validate(FaDepreciationEntryCollection depEntry, String[] args) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (int i = 0; i < depEntry.size(); ++i) {
            String cardNumber;
            FaDepreciationEntryInfo entryInfo = depEntry.get(i);
            if (entryInfo.getDepDistribute() == null || entryInfo.getDepDistribute().size() <= 0) continue;
            FaDepDistributeCollection disCollection = entryInfo.getDepDistribute();
            BigDecimal totalDisDep = new BigDecimal("0");
            for (int j = 0; j < disCollection.size(); ++j) {
                totalDisDep = totalDisDep.add(disCollection.get(j).getAmount());
            }
            BigDecimal newDep = entryInfo.getDepreciation();
            String string = cardNumber = entryInfo.get("needReCalRate") == null ? "" : entryInfo.get("needReCalRate").toString();
            if (newDep.compareTo(totalDisDep) == 0) continue;
            resultMap.put("result", "false");
            resultMap.put("msg", cardNumber + EASResource.getString((String)RES_PATH, (String)"FaDepMnt_DepSum", (Locale)this.ctx.getLocale()));
            return resultMap;
        }
        resultMap.put("result", "true");
        return resultMap;
    }

    boolean checkHasUnAuditedBill(FaDepreciationEntryCollection c, String orgID) throws Exception, EASBizException {
        FaDepCalExecutor executor = new FaDepCalExecutor(orgID);
        executor._checkBeforeCal(this.ctx);
        FilterInfo filter = new FilterInfo();
        StringBuffer mask = new StringBuffer("#0 and (");
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)"%99", CompareType.LIKE));
        for (int i = 1; i <= c.size(); ++i) {
            FaDepreciationEntryInfo element = c.get(i - 1);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)element.getFaCurCard().getId().toString(), CompareType.EQUALS));
            mask.append("#" + i);
            if (i == c.size()) {
                mask.append(")");
                continue;
            }
            mask.append(" or ");
        }
        filter.setMaskString(mask.toString());
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        FaCurCardCollection cCard = FaCurCardFactory.getLocalInstance((Context)this.ctx).getFaCurCardCollection(ev);
        return cCard == null || cCard.size() < c.size();
    }

    protected void updateEntryCollection(FaDepreciationEntryCollection c, String orgIDs) throws Exception {
        PeriodInfo currentPeriod = this.getCurrentPeriod(orgIDs);
        IFaDepreciation iFaDep = FaDepreciationFactory.getLocalInstance((Context)this.ctx);
        iFaDep.updateEntryCollection(currentPeriod, c);
    }

    private PeriodInfo getCurrentPeriod(String orgIDs) throws BOSException, EASBizException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgIDs));
        ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
        list.add(aCompanyOrgUnitInfo);
        HashMap zipData = FaDepreciationFactory.getLocalInstance((Context)this.ctx).getZipDataForRPC(list);
        PeriodInfo currentPeriod = (PeriodInfo)zipData.get("currPeriod");
        return currentPeriod;
    }

    private FaDepreciationEntryCollection getEntryCollectionByUIParameter(String[] args, HashMap workloadSchemes, FaDepreciationEntryCollection depEntry) throws BOSException {
        FaDepreciationEntryCollection entryCollection = new FaDepreciationEntryCollection();
        FaDepreciationEntryInfo info = new FaDepreciationEntryInfo();
        for (int i = 0; i < args.length; ++i) {
            if (i % 8 == 0) {
                info = new FaDepreciationEntryInfo();
                info.setId(BOSUuid.read((String)args[i]));
                if (!depEntry.contains((Object)BOSUuid.read((String)args[i]))) continue;
                info.setState(depEntry.get((Object)BOSUuid.read((String)args[i])).getState());
                continue;
            }
            if (i % 8 == 1) {
                FaCurCardInfo card = new FaCurCardInfo();
                card.setId(BOSUuid.read((String)args[i]));
                info.setFaCurCard(card);
                continue;
            }
            if (i % 8 == 2) {
                info.setDepreciation(new BigDecimal(args[i].replace(",", "")));
                continue;
            }
            if (i % 8 == 3) {
                info.setNotDepre(new BigDecimal(args[i].replace(",", "")));
                continue;
            }
            if (i % 8 == 4) continue;
            if (i % 8 == 5) {
                BigDecimal assetValue;
                String deprModeNumber = args[i - 1];
                if (deprModeNumber != null && (deprModeNumber.equals("001") || deprModeNumber.equals("010") || deprModeNumber.equals("002") || workloadSchemes.containsKey(deprModeNumber)) && (assetValue = new BigDecimal(args[i].replace(",", ""))) != null && assetValue.intValue() > 0) {
                    info.put("needReCalRate", (Object)true);
                    info.getFaCurCard().setAssetValue(assetValue);
                }
                this.makeDepCompositeInfoForWrong(this.ctx, info);
                continue;
            }
            if (i % 8 == 6) {
                String lnkFaDepreEntryStateStr = args[i];
                int lnkFaDepreEntryStateInt = Integer.parseInt(lnkFaDepreEntryStateStr);
                FaDepEntryStatusEnum state = FaDepEntryStatusEnum.getEnum((int)lnkFaDepreEntryStateInt);
                info.setState(state);
                continue;
            }
            if (i % 8 != 7) continue;
            if (!args[i].equals("")) {
                String distributeInfoString = args[i];
                String[] distributeArray = distributeInfoString.split(",");
                FaDepDistributeInfo faDepDistributeInfo = new FaDepDistributeInfo();
                for (int j = 0; j < distributeArray.length; ++j) {
                    if (j % 2 == 0 && depEntry.contains((Object)BOSUuid.read((String)args[i - 7]))) {
                        if (depEntry.get((Object)BOSUuid.read((String)args[i - 7])).getDepDistribute().contains((Object)BOSUuid.read((String)distributeArray[j]))) {
                            // empty if block
                        }
                        faDepDistributeInfo = depEntry.get((Object)BOSUuid.read((String)args[i - 7])).getDepDistribute().get((Object)BOSUuid.read((String)distributeArray[j]));
                    }
                    if (j % 2 != 1) continue;
                    faDepDistributeInfo.setAmount(new BigDecimal(distributeArray[j].replace(",", "")));
                    info.getDepDistribute().add(faDepDistributeInfo);
                }
            } else {
                FaDepDistributeCollection faDepDistributeCollection = depEntry.get((Object)BOSUuid.read((String)args[i - 7])).getDepDistribute();
                for (int z = 0; z < faDepDistributeCollection.size(); ++z) {
                    info.getDepDistribute().add(faDepDistributeCollection.get(z));
                }
            }
            entryCollection.add(info);
        }
        return entryCollection;
    }

    protected void makeDepCompositeInfoForWrong(Context ctx, FaDepreciationEntryInfo entryInfo) throws BOSException {
        IFaDepAsstActComposit iFaDepAsstActComposit = FaDepAsstActCompositFactory.getLocalInstance((Context)ctx);
        FaDepAsstActCompositCollection depAsstActCompositCollection = null;
        FaDepDistributeCollection disCollection = entryInfo.getDepDistribute();
        for (int i = 0; i < disCollection.size(); ++i) {
            FaDepDistributeInfo depDistributeInfo = disCollection.get(i);
            depAsstActCompositCollection = depDistributeInfo.getDepAsstActComposit();
            depAsstActCompositCollection = iFaDepAsstActComposit.getFaDepAsstActCompositCollection(this.getDepAsstActCompositView(depDistributeInfo.getId()));
            if (depAsstActCompositCollection == null || depAsstActCompositCollection.size() <= 0) continue;
            depDistributeInfo.getDepAsstActComposit().addCollection(depAsstActCompositCollection);
        }
    }

    private EntityViewInfo getDepAsstActCompositView(Object pk) {
        EntityViewInfo depAsstActCompositView = null;
        if (depAsstActCompositView == null) {
            depAsstActCompositView = new EntityViewInfo();
            depAsstActCompositView.getSelector().add("*");
            depAsstActCompositView.getSelector().add(new SelectorItemInfo("asstActType.*"));
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billid", pk, CompareType.EQUALS));
        depAsstActCompositView.setFilter(filterInfo);
        return depAsstActCompositView;
    }

    private FaDepreciationEntryCollection getEnryByIDSet(String[] args) throws BOSException {
        Set idSet = this.getIDSetFromArgs(args);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection coll = this.getFaDepreciationEntrySelectors();
        view.setSelector(coll);
        view.setFilter(filter);
        FaDepreciationEntryCollection depEntry = new FaDepreciationEntryCollection();
        depEntry = FaDepreciationEntryFactory.getLocalInstance((Context)this.ctx).getFaDepreciationEntryCollection(view);
        return depEntry;
    }

    private Set getIDSetFromArgs(String[] args) {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            if (i % 8 != 0) continue;
            idSet.add(args[i]);
        }
        return idSet;
    }

    protected static HashSet getLastPeriodChangeCard(Context ctx, FaDepreciationEntryCollection depEntry) throws BOSException {
        HashSet<String> cardSet = new HashSet<String>();
        for (int i = 0; i < depEntry.size(); ++i) {
            FaDepreciationEntryInfo entryInfo = depEntry.get(i);
            cardSet.add(entryInfo.getFaCurCard().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        filter.getFilterItems().add(new FilterItemInfo("id", cardSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("lastPeriodChange", (Object)new Integer(0)));
        FaCurCardCollection cards = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardCollection(view);
        cardSet.clear();
        for (int i = 0; i < cards.size(); ++i) {
            cardSet.add(cards.get(i).getId().toString());
        }
        return cardSet;
    }

    private SelectorItemCollection getFaDepreciationEntrySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("depDistribute.*"));
        return sic;
    }

    public Map<String, Object> audit(String orgID, String lnkfadepreentryID) throws BOSException, EASBizException {
        Uuid mutexUuid = Uuid.create();
        try {
            String mutexActionName = "faDepAudit";
            CompanyOrgUnitInfo currCompany = null;
            ICompanyOrgUnit comOrg = null;
            comOrg = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
            currCompany = comOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
            MutexParameter mutexParam = FaDepCalServiceImpl.setMutexParameter(mutexUuid, mutexActionName, currCompany, this.ctx);
            if (FaDepCalServiceImpl.requestMutex(mutexParam, this.ctx)) {
                HashMap<String, Object> result;
                this.checkPermission(orgID, "fa_dep_audit");
                String id = this.getDepIDByEntryID(lnkfadepreentryID);
                PeriodInfo currentPeriod = this.getCurrentPeriod(orgID);
                FaDepCalFacadeFactory.getLocalInstance((Context)this.ctx).auditBill(currentPeriod.getId().toString(), orgID, id);
                HashMap<String, Object> hashMap = result = new HashMap<String, Object>();
                return hashMap;
            }
            try {
                throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)this.ctx, (String)RES_PATH, (String)"Fa_Mutex_Is_InProcess")));
            }
            catch (BOSException e) {
                throw e;
            }
            catch (EASBizException e) {
                throw e;
            }
        }
        finally {
            this.releaseLockHandle(mutexUuid);
        }
    }

    private String getDepIDByEntryID(String lnkfadepreentryID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)lnkfadepreentryID));
        view.setFilter(filter);
        FaDepreciationEntryCollection depCollection = new FaDepreciationEntryCollection();
        depCollection = FaDepreciationEntryFactory.getLocalInstance((Context)this.ctx).getFaDepreciationEntryCollection(view);
        String Depid = depCollection.get(0).getLnkFaDepreEntry().getId().toString();
        return Depid;
    }

    public Map<String, Object> unDep(String orgID) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = this.getCurrentPeriod(orgID);
        this.checkBeforeUnAudit(this.ctx, currentPeriod.getId().toString(), orgID);
        FaDepCalExecutor executor = new FaDepCalExecutor(orgID);
        executor._undoDep(this.ctx);
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }

    void checkBeforeUnAudit(Context ctx, String periodID, String companyID) throws BOSException, EASBizException {
        PeriodInfo[] periods;
        String canUnAudit = (String)FaManageUtils.getFAParameter((BOSUuid)BOSUuid.read((String)companyID), (Context)ctx).get("FA_010");
        if (canUnAudit != null && Boolean.valueOf(canUnAudit).booleanValue()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("fiVouchered"));
            sic.add(new SelectorItemInfo("company.id"));
            FaDepreciationInfo depInfo = this.getDepreciationInfo(ctx, sic, companyID);
            if (depInfo == null) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, RES_PATH, "FaDepCal_UnauditErr_nodep")));
            }
            if (FaDepCalServiceImpl.queryNoAudit(ctx, depInfo.getId().toString(), periodID, companyID) > 0) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, RES_PATH, "FaDepCal_UnauditErr_noaudit")));
            }
            int billType = FaDepCalServiceImpl.bakCardHasDepValue(ctx, periodID, companyID);
            if (billType > -1) {
                throw new EASBizException(new NumericExceptionSubItem("1", this.getResource(ctx, RES_PATH, "FaDepCal_UnauditErr_hasbiz")), new Object[]{FaBillTypeEnum.getEnum((int)billType)});
            }
        }
        if (!(periods = FaPeriodCloseFacadeFactory.getLocalInstance((Context)ctx).getLastestPeriod(companyID))[0].getId().toString().equals(periods[1].getId().toString())) {
            throw new FaPeriodException(FaPeriodException.UNAUDITDEPNOTALLOW);
        }
    }

    static int queryNoAudit(Context ctx, String depID, String periodID, String companyID) throws EASBizException, BOSException {
        int result = 0;
        StringBuffer sql = new StringBuffer();
        try {
            IRowSet rowSet;
            if (depID != null) {
                sql.append("SELECT count(ffacurcardid) AS COUNT \n");
                sql.append("  FROM t_fa_fadepreciationentry \n");
                sql.append(" WHERE fstate <> 3 AND flnkfadepreentry = ? \n");
                Object[] sqlPara = new Object[]{depID};
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlPara);
                if (rowSet.next()) {
                    result = rowSet.getInt("COUNT");
                }
            }
            if (result < 1) {
                sql = new StringBuffer();
                sql.append("SELECT count(e.ffacurcardid) AS COUNT \n");
                sql.append("  FROM t_fa_faevaldepreciationentry e inner join t_fa_faevaldepreciation b on b.fid=e.flnkfadepreentry\n");
                sql.append(" WHERE e.fstate <> 3 AND b.fperiod = ? and b.fcompanyid=?\n");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{periodID, companyID});
                if (rowSet.next()) {
                    result = rowSet.getInt("COUNT");
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    static int bakCardHasDepValue(Context ctx, String periodID, String companyID) throws BOSException, EASBizException {
        int billType = -1;
        String clearBill = " SELECT CASE WHEN e.fassetamt = b.fclrqty THEN 4 ELSE 3 END billtype, a.fnumber billnumber, a.fid billid, e.fdeprtterm FROM t_fa_clearbill a LEFT OUTER JOIN t_fa_clearbillentry b ON a.fid = b.fentryid ";
        String changeBill = " SELECT 2 billtype, a.fnumber billnumber, a.fid billid, e.fdeprtterm FROM t_fa_fachangebill a LEFT OUTER JOIN t_fa_fachangebillentry b ON a.fid = b.fchangebillid ";
        String evaBill = " SELECT 6 billtype, a.fnumber billnumber, a.fid billid, e.fdeprtterm FROM t_fa_faevaluatebill a LEFT JOIN t_fa_faevaluatebillentry b ON b.ffaevaluatebillid = a.fid ";
        String splitBill = " SELECT 5 billtype, a.fnumber billnumber, a.fid billid, e.fdeprtterm FROM t_fa_fasplitbill a LEFT OUTER JOIN t_fa_fabizcard c ON a.FFaBizCardID = c.fid LEFT OUTER JOIN t_fa_fabakcard e ON c.ffabakcardid = e.fid WHERE a.fperiodid = ? AND a.fcompanyid = ? AND e.fdeprtterm != 0  ";
        String combinBill = " SELECT 8 billtype, a.fnumber billnumber, a.fid billid, e.fdeprtterm FROM t_fa_facombinbill a LEFT JOIN t_fa_facombinbillentry b ON b.FFaCombinBill = a.fid ";
        String dispatchBill = " SELECT 9 billtype, a.fnumber billnumber, a.fid billid, e.fdeprtterm FROM t_fa_fadispatchbill a LEFT JOIN t_fa_fadispatchbillentry b ON b.FFaDispatchBillID = a.fid ";
        String parameter = " LEFT OUTER JOIN t_fa_fabizcard c ON b.fbizcardid = c.fid LEFT OUTER JOIN t_fa_fabakcard e ON c.ffabakcardid = e.fid INNER JOIN t_fa_depreciationmode f ON e.fdeprmethodid = f.fid WHERE a.fperiodid = ? AND a.fcompanyid = ? AND (e.fdeprtterm != 0 or e.FEvalDeprTTerm != 0) AND f.fnumber != '006'";
        StringBuffer result = new StringBuffer();
        result.append(" SELECT TOP 1 * FROM ( ");
        result.append(clearBill + parameter);
        result.append(" UNION ALL \n");
        result.append(changeBill + parameter);
        result.append(" UNION ALL \n");
        result.append(evaBill + parameter);
        result.append(" UNION ALL \n");
        result.append(splitBill);
        result.append(" UNION ALL \n");
        result.append(combinBill + parameter);
        result.append(" UNION ALL \n");
        result.append(dispatchBill + parameter + " and a.FDispatchDirection=1 ");
        result.append(") A Order By A.billnumber");
        Object[] sqlPara = new Object[]{periodID, companyID, periodID, companyID, periodID, companyID, periodID, companyID, periodID, companyID, periodID, companyID};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)result.toString(), (Object[])sqlPara);
            if (rowSet.next()) {
                billType = rowSet.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return billType;
    }

    String getResource(Context ctx, String s1, String s2) {
        Locale l = ctx.getOriginLocale();
        return ResourceBase.getString((String)s1, (String)s2, (Locale)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FaDepreciationInfo getDepreciationInfo(Context ctx, SelectorItemCollection sic, String companyID) throws BOSException, EASBizException {
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)this.getCurrentPeriod(companyID).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)BOSUuid.read((String)companyID), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("depType", (Object)new Integer(0), CompareType.EQUALS));
        entityView.setFilter(filter);
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            FaDepreciationCollection c = (FaDepreciationCollection)this.getDAO(ctx, cn).getCollectionNoChild(entityView);
            if (c.size() < 1) {
                FaDepreciationInfo faDepreciationInfo = null;
                return faDepreciationInfo;
            }
            FaDepreciationInfo faDepreciationInfo = c.get(0);
            return faDepreciationInfo;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private IORMappingDAO getDAO(Context ctx, Connection cn) throws BOSException {
        return ORMappingDAO.getInstance((BOSObjectType)this.getBOSType(), (Context)ctx, (Connection)cn);
    }

    protected BOSObjectType getBOSType() {
        return BOSObjectType.create((String)"FD47C291");
    }

    public Map<String, Object> getDistributeInfo(String orgID, String lnkFaDepreEntryId, String realDep, String precision) throws BOSException, EASBizException {
        String scale = this.getCurrencyScale(orgID).get("scale").toString();
        IRowSet editRowSet = null;
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.fa.manage", "FaDepreationQuery"));
        EntityViewInfo view = this.getFilter(lnkFaDepreEntryId);
        this.setExec(exec, view);
        editRowSet = exec.executeQuery();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            this.setReturnData(orgID, editRowSet, realDep, result, precision);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.setIsRelAccount(orgID, result);
        this.configDistributeView(lnkFaDepreEntryId, view);
        FaDepreciationEntryCollection depCollection = new FaDepreciationEntryCollection();
        FaDepDistributeCollection faDepDistributeCollection = this.setDistributeInfo(view, result, realDep, precision);
        this.getActCompositInitData(result, faDepDistributeCollection);
        return result;
    }

    private void setIsRelAccount(String orgID, Map<String, Object> result) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx);
        String isRelAccount = "" + ictrol.isRelatedAccount(orgID, SystemEnum.FIXEDASSETS);
        result.put("isRelAccount", isRelAccount);
        HashMap hmResult = FaManageUtils.getFAParameter((Context)this.ctx, (String[])new String[]{"GL_111"}, (String)orgID);
        String canShowProfit = hmResult != null && hmResult.get("GL_111") != null ? (String)hmResult.get("GL_111") : "false";
        result.put("canShowProfit", canShowProfit);
    }

    private FaDepDistributeCollection setDistributeInfo(EntityViewInfo view, Map<String, Object> result, String realDep, String precision) throws BOSException {
        FaDepreciationEntryCollection depCollection = FaDepreciationEntryFactory.getLocalInstance((Context)this.ctx).getFaDepreciationEntryCollection(view);
        FaDepDistributeCollection faDepDistributeCollection = depCollection.get(0).getDepDistribute();
        ArrayList distributeInfoLoadData = new ArrayList();
        BigDecimal realAmount = new BigDecimal(realDep);
        int maxApportionIndex = 0;
        BigDecimal maxApportion = new BigDecimal(0);
        BigDecimal totalAmount = new BigDecimal(0);
        for (int i = 0; i < faDepDistributeCollection.size(); ++i) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            FaDepDistributeInfo faDepDistributeInfo = faDepDistributeCollection.get(i);
            row.put("distributeInfoId", faDepDistributeInfo.getId().toString());
            row.put("accountView", faDepDistributeInfo.getAccountView().toString());
            row.put("profitCenter", faDepDistributeInfo.getProfitCenter());
            BigDecimal apportionScale = faDepDistributeInfo.getApportionScale() == null ? new BigDecimal("0.00") : faDepDistributeInfo.getApportionScale();
            apportionScale.setScale(2, 4);
            DecimalFormat df = new DecimalFormat("0.00");
            row.put("apportionScale", df.format(apportionScale));
            if (apportionScale.compareTo(maxApportion) > 0) {
                maxApportion = apportionScale;
                maxApportionIndex = i;
            }
            BigDecimal amount = realAmount.multiply(apportionScale).divide(new BigDecimal(100.0), Integer.parseInt(precision), 4);
            row.put("amount", amount);
            totalAmount = totalAmount.add(amount);
            row.put("remark", faDepDistributeInfo.getRemark());
            distributeInfoLoadData.add(row);
        }
        if (!totalAmount.equals(realAmount)) {
            Map maxApportionRow = (Map)distributeInfoLoadData.get(maxApportionIndex);
            maxApportionRow.put("amount", ((BigDecimal)maxApportionRow.get("amount")).add(realAmount).subtract(totalAmount));
        }
        result.put("faDepDistributeInitData", distributeInfoLoadData);
        return faDepDistributeCollection;
    }

    private void configDistributeView(String lnkFaDepreEntryId, EntityViewInfo view) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)lnkFaDepreEntryId));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("depDistribute.*"));
        coll.add(new SelectorItemInfo("depDistribute.accountView.*"));
        coll.add(new SelectorItemInfo("depDistribute.profitCenter.*"));
        coll.add(new SelectorItemInfo("depDistribute.DepAsstActComposit.*"));
        coll.add(new SelectorItemInfo("depDistribute.DepAsstActComposit.asstActType.*"));
        view.setSelector(coll);
        view.setFilter(filter);
    }

    private void getActCompositInitData(Map<String, Object> result, FaDepDistributeCollection faDepDistributeCollection) throws BOSException {
        if (faDepDistributeCollection.size() == 0) {
            result.put("asstActCompositInitData", "");
            return;
        }
        FaDepDistributeInfo depDistributeInfoForActC = faDepDistributeCollection.get(0);
        FaDepAsstActCompositCollection asstActCompositCollection = depDistributeInfoForActC.getDepAsstActComposit();
        String getAsstActItemObjSql = "select t.FNAME_L2 from T_FA_AssistActItem t where t.FID = ? and t.FASSTACTTYPE = ?";
        ArrayList asstActCompositLoadData = new ArrayList();
        for (int i = 0; i < asstActCompositCollection.size(); ++i) {
            FaDepAsstActCompositInfo asstActCompositInfo = asstActCompositCollection.get(i);
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("asstActCompositInfoId", asstActCompositInfo.getId().toString());
            row.put("asstActType", asstActCompositInfo.getAsstActType().toString());
            ArrayList<String> params = new ArrayList<String>();
            params.add(asstActCompositInfo.getAsstActItem());
            params.add(asstActCompositInfo.getAsstActType().getId().toString());
            IRowSet asstActItemObjSet = DbUtil.executeQuery((Context)this.ctx, (String)getAsstActItemObjSql, (Object[])params.toArray());
            String asstActItemObj = null;
            try {
                asstActItemObjSet.next();
                asstActItemObj = asstActItemObjSet.getString("FNAME_L2");
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            row.put("asstActItemObj", asstActItemObj);
            asstActCompositLoadData.add(row);
        }
        result.put("asstActCompositInitData", asstActCompositLoadData);
    }

    private void setReturnData(String orgID, IRowSet editRowSet, String realDep, Map<String, Object> result, String precision) throws SQLException, EASBizException, BOSException {
        editRowSet.next();
        String faCurCardNumber = editRowSet.getString("faCurCard.number");
        String assetCatName = editRowSet.getString("assetCat.name");
        String faCurCardAssetName = editRowSet.getString("faCurCard.assetName");
        String faCurCardSpecs = editRowSet.getString("faCurCard.specs");
        result.put("faCurCardNumber", faCurCardNumber);
        result.put("assetCatName", assetCatName);
        result.put("faCurCardAssetName", faCurCardAssetName);
        result.put("faCurCardSpecs", faCurCardSpecs);
        result.put("lnkFaDepreEntryDepreciation", realDep);
        result.put("precision", precision);
        result.put("currentPeriodYear", editRowSet.getString("period.periodYear"));
        result.put("currentPeriodNumber", editRowSet.getString("period.periodNumber"));
    }

    private void setExec(IQueryExecutor exec, EntityViewInfo view) {
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isIgnorePermissionCheck = true;
        exec.setObjectView(view);
    }

    private EntityViewInfo getFilter(String lnkFaDepreEntryId) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("lnkFaDepreEntry.id", (Object)lnkFaDepreEntryId, CompareType.EQUALS));
        view.setFilter(filter);
        return view;
    }

    public Map<String, Object> getAccountingItemInfoByDisId(String distributeInfoId) throws BOSException, EASBizException {
        EntityViewInfo view = this.getDistrbuteForAccItemsByIdView(distributeInfoId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        FaDepDistributeCollection faDepDistributeCollection = new FaDepDistributeCollection();
        faDepDistributeCollection = FaDepDistributeFactory.getLocalInstance((Context)this.ctx).getFaDepDistributeCollection(view);
        this.getActCompositInitData(result, faDepDistributeCollection);
        return result;
    }

    private EntityViewInfo getDistrbuteForAccItemsByIdView(String distributeInfoId) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)distributeInfoId));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("DepAsstActComposit.*"));
        coll.add(new SelectorItemInfo("DepAsstActComposit.asstActType.*"));
        view.setFilter(filter);
        view.setSelector(coll);
        return view;
    }

    public Map<String, Object> getWorkLoad(String orgID, String periodType, String filterItems) throws BOSException, EASBizException {
        PeriodInfo period = this.decidePeriod(orgID, periodType);
        FaWorkLoadCollection workLoadCollection = this.queryWorkLoadCollection(orgID, period.getPeriodYear() + "", period.getPeriodNumber() + "", filterItems);
        HashMap<String, Object> result = new HashMap<String, Object>();
        return this.getReturnValue(workLoadCollection, result);
    }

    private PeriodInfo decidePeriod(String orgID, String periodType) throws BOSException, EASBizException {
        PeriodInfo period = new PeriodInfo();
        period = this.getCurrentPeriod(orgID);
        if (periodType.equals("1")) {
            period = PeriodUtils.getPrePeriodInfo((PeriodInfo)period);
        }
        return period;
    }

    private Map<String, Object> getReturnValue(FaWorkLoadCollection workLoadCollection, Map<String, Object> result) {
        if (workLoadCollection == null) {
            result.put("faWorkLoadData", "");
            return result;
        }
        ArrayList faWorkLoadData = new ArrayList();
        for (int i = 0; i < workLoadCollection.size(); ++i) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            FaWorkLoadInfo workLoadInfo = workLoadCollection.get(i);
            if (workLoadInfo.getId() == null) {
                row.put("id", "");
            } else {
                row.put("id", workLoadInfo.getId().toString());
            }
            row.put("cardCat", workLoadInfo.getCurCard().getAssetCat().getName());
            row.put("number", workLoadInfo.getCurCard().getNumber());
            row.put("name", workLoadInfo.getCurCard().getAssetName());
            row.put("correntWorkLoad", workLoadInfo.getCurrentWorkLoad());
            row.put("totalWorkLoad", workLoadInfo.getTotalWorkLoad());
            row.put("sumWorkLoad", workLoadInfo.getSumWorkLoad());
            row.put("lastWorkLoad", workLoadInfo.getLastWorkLoad());
            row.put("cardId", workLoadInfo.getCurCard().getId().toString());
            row.put("oricorrentWorkLoad", workLoadInfo.getCurrentWorkLoad());
            faWorkLoadData.add(row);
        }
        result.put("faWorkLoadData", faWorkLoadData);
        return result;
    }

    private FaWorkLoadCollection queryWorkLoadCollection(String orgID, String periodPeriodYear, String periodPeriodNumber) throws BOSException, EASBizException {
        return this.queryWorkLoadCollection(orgID, periodPeriodYear, periodPeriodNumber, null);
    }

    private FaWorkLoadCollection queryWorkLoadCollection(String orgID, String periodPeriodYear, String periodPeriodNumber, String filterItems) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo viewFilter = new FilterInfo();
        view.setFilter(viewFilter);
        FilterInfo workFilter = this.getWorkFilterInfo(periodPeriodYear, periodPeriodNumber);
        if (!StringUtils.isEmpty((String)filterItems)) {
            FilterInfo filterInfo = null;
            try {
                filterInfo = new FilterInfo(filterItems);
            }
            catch (ParserException e) {
                filterInfo = null;
            }
            if (filterInfo != null) {
                for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                    FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                    String filterStr = filterItemInfo.toString();
                    if (filterStr.indexOf("period.id") != -1 || filterStr.indexOf("company.id") != -1) continue;
                    filterStr = filterStr.replace("faCurCard", "curcard");
                    if (!FilterUtility.hasFilterItem((FilterInfo)workFilter)) continue;
                    workFilter.getFilterItems().add(new FilterItemInfo(filterStr));
                }
            }
        }
        FaWorkLoadCollection workLoadCollection = null;
        workLoadCollection = (FaWorkLoadCollection)this.findWorkLoad(this.ctx, view, workFilter, orgID);
        return workLoadCollection;
    }

    protected IObjectCollection findWorkLoad(Context ctx, EntityViewInfo view, FilterInfo workFilter, String orgID) throws BOSException, EASBizException {
        CoreBaseCollection cardCollection;
        IFaWorkLoad workLoad = FaWorkLoadFactory.getLocalInstance((Context)ctx);
        String strCompanyId = orgID;
        view.getSelector().clear();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("useTermCount"));
        view.getSelector().add(new SelectorItemInfo("deprTermCount"));
        view.getSelector().add(new SelectorItemInfo("measureUnitWL.name"));
        view.getSelector().add(new SelectorItemInfo("assetCat.name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("assetName"));
        view.getSelector().add(new SelectorItemInfo("deprMethod"));
        view.getSelector().add(new SelectorItemInfo("tempDeprMethod"));
        view.getSelector().add(new SelectorItemInfo("tempUseTermCount"));
        view.getSelector().add(new SelectorItemInfo("tempDeprTermCount"));
        view.getSelector().add(new SelectorItemInfo("facurcard.id"));
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("number");
        sortInfo.setSortType(SortType.ASCEND);
        sic.add(sortInfo);
        view.setSorter(sic);
        FilterInfo filter = view.getFilter();
        int maskCount = filter.getFilterItems().size();
        StringBuffer sb = new StringBuffer(filter.getMaskString() == null ? "" : filter.getMaskString());
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)CheckedStatusEnum.AUDITED, CompareType.EQUALS));
        for (int i = maskCount; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        int periodYear = 0;
        int periodNumber = 0;
        PeriodInfo curPeriod = FaLocalUtils.getCurrentPeriod((Context)ctx, (String)orgID);
        FilterItemInfo cardNumberFilterItem = null;
        for (int i = 0; i < workFilter.getFilterItems().size(); ++i) {
            if (workFilter.getFilterItems().get(i).getPropertyName().equalsIgnoreCase("period.periodYear")) {
                periodYear = (Integer)workFilter.getFilterItems().get(i).getCompareValue();
            }
            if (workFilter.getFilterItems().get(i).getPropertyName().equalsIgnoreCase("period.periodNumber")) {
                periodNumber = (Integer)workFilter.getFilterItems().get(i).getCompareValue();
            }
            if (!workFilter.getFilterItems().get(i).getPropertyName().equalsIgnoreCase("curcard.number")) continue;
            cardNumberFilterItem = workFilter.getFilterItems().get(i);
        }
        boolean isCurrentperiod = curPeriod.getPeriodNumber() == periodNumber && curPeriod.getPeriodYear() == periodYear;
        filter.getFilterItems().add(new FilterItemInfo("deprMethod.isWorkload", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deprMethod.isWorkload", (Object)new Integer(1), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tempDeprMethod", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tempDeprMethod", (Object)new String(" "), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tempDeprMethod", (Object)new String("null"), CompareType.NOTEQUALS));
        sb.append(" and (#" + (filter.getFilterItems().size() - 5) + " or (#" + (filter.getFilterItems().size() - 4) + " and #" + (filter.getFilterItems().size() - 3) + " and #" + (filter.getFilterItems().size() - 2) + " and #" + (filter.getFilterItems().size() - 1) + "))");
        if (isCurrentperiod) {
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)DeletedStatusEnum.DELETED, CompareType.NOTEQUALS));
            sb.append(" and #" + (filter.getFilterItems().size() - 1));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("faperiod.periodyear", (Object)new Integer(periodYear)));
            filter.getFilterItems().add(new FilterItemInfo("faperiod.periodnumber", (Object)new Integer(periodNumber)));
            sb.append(" and #" + (filter.getFilterItems().size() - 2) + " and #" + (filter.getFilterItems().size() - 1));
        }
        if (cardNumberFilterItem != null) {
            String filterStr = cardNumberFilterItem.toString();
            filterStr = filterStr.replace("curcard.", "");
            filter.getFilterItems().add(new FilterItemInfo(filterStr));
            sb.append(" and #" + (filter.getFilterItems().size() - 1));
        }
        filter.setMaskString(sb.toString());
        IFaCurCard icard = FaCurCardFactory.getLocalInstance((Context)ctx);
        IFaMonCard imoncard = FaMonCardFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection coreBaseCollection = cardCollection = isCurrentperiod ? icard.getCollection(view) : imoncard.getCollection(view);
        if (cardCollection.size() == 0) {
            return null;
        }
        HashSet<BOSUuid> cardId = new HashSet<BOSUuid>();
        for (FaCardInfo card : cardCollection) {
            cardId.add(isCurrentperiod ? card.getId() : ((FaMonCardInfo)card).getFaCurCard().getId());
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("currentWorkLoad"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("lastWorkLoad"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("totalWorkLoad"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("sumWorkLoad"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("curcard.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("period.periodYear"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("period.periodNumber"));
        workFilter.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId, CompareType.EQUALS));
        workFilter.getFilterItems().add(new FilterItemInfo("curcard", cardId, CompareType.INCLUDE));
        entityViewInfo.setFilter(workFilter);
        FaWorkLoadCollection workLoadCollection = workLoad.getFaWorkLoadCollection(entityViewInfo);
        HashMap<String, FaWorkLoadInfo> hm = new HashMap<String, FaWorkLoadInfo>();
        for (FaWorkLoadInfo workLoadInfo : workLoadCollection) {
            hm.put(workLoadInfo.getCurCard().getId().toString(), workLoadInfo);
        }
        FaWorkLoadCollection returnValue = new FaWorkLoadCollection();
        for (Object o : cardCollection) {
            FaWorkLoadInfo workLoadInfo;
            FaCurCardInfo card;
            FaCurCardInfo faCurCardInfo = card = isCurrentperiod ? (FaCurCardInfo)o : ((FaMonCardInfo)o).getFaCurCard();
            if (!isCurrentperiod) {
                try {
                    FaManageUtils.copyValueBetweenCard((FaCardInfo)((FaCardInfo)o), (FaCardInfo)card, (boolean)false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!FaLocalUtils.isWorkLoadMethod((FaDepreciationModeInfo)card.getDeprMethod())) {
                card.setUseTermCount(card.getTempUseTermCount());
                card.setDeprTermCount(card.getTempDeprTermCount());
            }
            if (hm.get(card.getId().toString()) != null) {
                workLoadInfo = (FaWorkLoadInfo)hm.get(card.getId().toString());
                workLoadInfo.setCurCard(card);
                workLoadInfo.setTotalWorkLoad(card.getUseTermCount() == null ? new BigDecimal("0") : card.getUseTermCount());
                workLoadInfo.setLastWorkLoad(workLoadInfo.getTotalWorkLoad().subtract(workLoadInfo.getSumWorkLoad()));
                returnValue.add(workLoadInfo);
                continue;
            }
            if (!isCurrentperiod) continue;
            workLoadInfo = new FaWorkLoadInfo();
            workLoadInfo.setCurCard(card);
            workLoadInfo.setCurrentWorkLoad(new BigDecimal("0"));
            workLoadInfo.setTotalWorkLoad(card.getUseTermCount() == null ? new BigDecimal("0") : card.getUseTermCount());
            workLoadInfo.setSumWorkLoad(card.getDeprTermCount() == null ? new BigDecimal("0") : card.getDeprTermCount());
            workLoadInfo.setLastWorkLoad(workLoadInfo.getTotalWorkLoad().subtract(workLoadInfo.getSumWorkLoad()));
            returnValue.add(workLoadInfo);
        }
        return returnValue;
    }

    public FilterInfo getWorkFilterInfo(String periodPeriodYear, String periodPeriodNumber) {
        FilterInfo workFilterInfo = new FilterInfo();
        FilterItemCollection filterItems = workFilterInfo.getFilterItems();
        FilterItemInfo filterItemInfo = new FilterItemInfo("period.periodYear", (Object)Integer.parseInt(periodPeriodYear));
        filterItems.add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("period.periodNumber", (Object)Integer.parseInt(periodPeriodNumber));
        filterItems.add(filterItemInfo);
        return workFilterInfo;
    }

    public Map<String, Object> workLoadSubmit(String orgID, String submitRlDataStr, String periodType) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<String> set = new HashSet<String>();
        String[] inputArray = submitRlDataStr.split("@");
        for (int i = 0; i < inputArray.length; i += 4) {
            if (inputArray[i] == null) continue;
            set.add(inputArray[i]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        PeriodInfo currentPeriod = this.getCurrentPeriod(orgID);
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("period.id", (Object)currentPeriod.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        FaDepreciationInfo depreciationInfo = null;
        FaDepreciationCollection depreciationCollection = FaDepreciationFactory.getLocalInstance((Context)this.ctx).getFaDepreciationCollection(viewInfo);
        if (depreciationCollection != null && depreciationCollection.size() > 0) {
            depreciationInfo = depreciationCollection.get(0);
            FilterInfo filterInfo1 = new FilterInfo();
            filterInfo1.getFilterItems().add(new FilterItemInfo("faCurCard.id", set, CompareType.INCLUDE));
            filterInfo1.getFilterItems().add(new FilterItemInfo("LnkFaDepreEntry", (Object)depreciationInfo.getId().toString()));
            if (FaDepreciationEntryFactory.getLocalInstance((Context)this.ctx).exists(filterInfo1)) {
                result.put("msg", EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"52_FaWorkLoadEditUI", (Locale)this.ctx.getLocale()));
                return result;
            }
        }
        FaWorkLoadCollection entryCollection = new FaWorkLoadCollection();
        PeriodInfo period = this.decidePeriod(orgID, periodType);
        entryCollection = this.queryWorkLoadCollection(orgID, period.getPeriodYear() + "", period.getPeriodNumber() + "");
        for (int i = 0; i < entryCollection.size(); ++i) {
            for (int j = 0; j < inputArray.length; j += 4) {
                if (!entryCollection.get(i).getCurCard().getId().toString().equals(inputArray[j])) continue;
                entryCollection.get(i).setCurrentWorkLoad(new BigDecimal(inputArray[j + 1]));
                entryCollection.get(i).setSumWorkLoad(new BigDecimal(inputArray[j + 2]));
                entryCollection.get(i).setLastWorkLoad(new BigDecimal(inputArray[j + 3]));
            }
        }
        this.batchUpdate(this.ctx, (IObjectCollection)entryCollection, orgID);
        result.put("msg", "");
        return result;
    }

    protected void batchUpdate(Context ctx, IObjectCollection model, String orgID) throws BOSException, EASBizException {
        PeriodInfo[] p;
        IFaWorkLoad workLoad = FaWorkLoadFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
        boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        if (!isInitEnd) {
            throw new FaPeriodException(FaPeriodException.FANOTENDINIT);
        }
        if (model == null) {
            return;
        }
        IFaCurCard iCard = FaCurCardFactory.getLocalInstance((Context)ctx);
        HashSet<String> cardSet = new HashSet<String>();
        for (int i = 0; i < model.size(); ++i) {
            FaWorkLoadInfo info = (FaWorkLoadInfo)model.getObject(i);
            if (info == null) continue;
            if (info.getId() == null) {
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            }
            info.setPeriod(this.getCurrentPeriod(orgID));
            CompanyOrgUnitInfo currentCompany = new CompanyOrgUnitInfo();
            currentCompany.setId(BOSUuid.read((String)orgID));
            info.setCompany(currentCompany);
            workLoad.submit((CoreBaseInfo)info);
            FaCurCardInfo card = info.getCurCard();
            cardSet.add(card.getId().toString());
            FaCurCardInfo bakCard = iCard.getFaCurCardInfo((IObjectPK)new ObjectUuidPK(card.getId()), FaDepLocalUtils.getDepCardSelector());
            BigDecimal currentWorkLoad = info.getCurrentWorkLoad();
            BigDecimal zero = new BigDecimal(0.0);
            if (currentWorkLoad.compareTo(zero) == 1) {
                if (this.ifNeedReDep(ctx, bakCard, orgID)) {
                    bakCard.setIsNeedReDepr(true);
                }
            } else {
                bakCard.setIsNeedReDepr(false);
            }
            if (!FaLocalUtils.isWorkLoadMethod((FaDepreciationModeInfo)bakCard.getDeprMethod()) && bakCard.getTempDeprMethod() != null && bakCard.getTempDeprMethod().length() != 0) {
                bakCard.setTempDeprTermCount(info.getSumWorkLoad());
            } else {
                bakCard.setDeprTermCount(info.getSumWorkLoad());
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isNeedReDepr"));
            selector.add(new SelectorItemInfo("tempDeprTermCount"));
            selector.add(new SelectorItemInfo("deprTermCount"));
            iCard.updatePartial((CoreBaseInfo)bakCard, selector);
        }
        if (cardSet.size() > 0 && !(p = FaPeriodCloseFacadeFactory.getLocalInstance((Context)ctx).getLastestPeriod(orgID))[0].getId().toString().equals(p[1].getId().toString())) {
            HashSet periodSet = FaLocalUtils.getLaterPeriodIdSet((Context)ctx, (String)p[1].getId().toString());
            FaLocalUtils.hasLaterPeriodDep((Context)ctx, (String)orgID, (HashSet)periodSet, cardSet);
            FaLocalUtils.hasFANewBiz((Context)ctx, (HashSet)periodSet, cardSet, (String)orgID);
            String ids = FaLocalUtils.handleIdArray(cardSet);
            FaLastPeriodChangeUtils.updateCurCardLastPeriodChange((Context)ctx, (String)ids);
        }
    }

    private boolean ifNeedReDep(Context ctx, FaCurCardInfo card, String orgID) throws BOSException, EASBizException {
        Date accountDate;
        String newGovermentAccountingSystem;
        PeriodInfo periodInfo = this.getCurrentPeriod(orgID);
        boolean redoDep = FaDepLocalUtils.ifAlreadyCal((Context)ctx, (PeriodInfo)periodInfo, (String)orgID);
        boolean yearLastPeriod = FaDepLocalUtils.ifYearLastPeriod((Context)ctx, (PeriodInfo)periodInfo);
        Date periodBegindDate = periodInfo.getBeginDate();
        Timestamp periodEndDate = periodInfo.getEndDate();
        Map paramMap = FaDepLocalUtils.getParamNewGovermentAccSystem((Context)ctx);
        String string = newGovermentAccountingSystem = paramMap.get(AccountConstant.GovermentAccountingSystem) != null ? (String)paramMap.get(AccountConstant.GovermentAccountingSystem) : "false";
        if ("true".equalsIgnoreCase(newGovermentAccountingSystem) && card.getAssetCat().isNotCalDep()) {
            return false;
        }
        if (card.getDeprMethod().getPeriod().equals((Object)FaDepreciationPeriodEnum.getEnum((int)2)) && !yearLastPeriod) {
            return false;
        }
        if (card.getAssetCat().getDepreciationPolicy().getDeprRule() == FaDepreciationRuleEnum.NO_REGARDLESS_USESTATUS || card.getAssetCat().getDepreciationPolicy().getDeprRule() == FaDepreciationRuleEnum.DECIDE_BY_USESTATUS && !card.getUseStatus().isIsDepreciation()) {
            return false;
        }
        if (card.getAssetCat().getDepreciationPolicy().getStartDeprTime().getValue() != 0 ? (accountDate = card.getFiAccountDate()).compareTo(periodBegindDate) >= 0 && accountDate.compareTo(periodEndDate) <= 0 : card.getHasCleared().equals((Object)FaClearStatusEnum.HasAllCleared)) {
            return false;
        }
        if (redoDep && card.getDeprTTerm() != null && card.getDeprTTerm().compareTo(new BigDecimal("0")) != 0 && (card.getHasCleared().equals((Object)FaClearStatusEnum.HasPartCleared) || card.getHasCleared().equals((Object)FaClearStatusEnum.HasAllCleared))) {
            return false;
        }
        IFaDepCalStrategy strategy = FaDepStrategyFactory.getStrategyByMethod((FaDepreciationModeInfo)card.getDeprMethod());
        IFaDepCalStrategy evalStrategy = FaDepStrategyFactory.getStrategyByMethod((FaDepreciationModeInfo)card.getEvalDeprMode());
        FaDepreCalculator calculator = new FaDepreCalculator();
        calculator.setDefaultDpereStrategy(strategy, evalStrategy);
        return calculator.isHaveAmountAndLifeForDep(card, ctx);
    }

    public Map<String, Object> queryUndepPermission(String orgID) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FaParamInfo aFaPasramInfo = this.queryCompanyParamItemInfo(orgID);
        if (aFaPasramInfo != null) {
            result.put("canDepUnAudit", aFaPasramInfo.isCanDepUnAudit());
        } else {
            result.put("canDepUnAudit", false);
        }
        return result;
    }

    private FaParamInfo queryCompanyParamItemInfo(String orgID) throws BOSException, EASBizException {
        FaParamInfo aFaPasramInfo = null;
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
        IFaParamFacade iFaParamFacade = FaParamFacadeFactory.getLocalInstance((Context)this.ctx);
        aFaPasramInfo = iFaParamFacade.getFaParamInfo(aCompanyOrgUnitInfo);
        return aFaPasramInfo;
    }

    public PeriodInfo[] getPeriodParam(String orgID) throws EASBizException, BOSException {
        PeriodInfo prePeriodInfo;
        PeriodInfo[] periods = new PeriodInfo[3];
        PeriodInfo[] LastRelatePeriod = FaPeriodCloseFacadeFactory.getLocalInstance((Context)this.ctx).getLastestPeriod(orgID);
        periods[0] = LastRelatePeriod[0];
        periods[1] = LastRelatePeriod[1];
        periods[2] = prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (PeriodInfo)periods[1]);
        return periods;
    }

    public static MutexParameter setMutexParameter(Uuid uuid, String actionName, CompanyOrgUnitInfo currentCompanyInfo, Context ctx) {
        MutexParameter param = new MutexParameter();
        param.setRequestId(uuid);
        param.setMutexName(FA_MUTEX_LOCK);
        param.setActionName(actionName);
        param.setUserID(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        param.setOrgUnitID(currentCompanyInfo.getId());
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        param.setDcName(ContextUtil.getDbType((Context)ctx));
        return param;
    }

    private boolean requestMutexHandle(CompanyOrgUnitInfo currCompany, Uuid mutexUuid) throws EASBizException, BOSException {
        MutexParameter mutexParam = FaDepCalServiceImpl.setMutexParameter(mutexUuid, "checkout", currCompany, this.ctx);
        return FaDepCalServiceImpl.requestMutex(mutexParam, this.ctx);
    }

    public static boolean requestMutex(MutexParameter param, Context ctx) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        return mutexService.requestMutex(param);
    }

    private void releaseLockHandle(Uuid mutexUuid) {
        try {
            FaDepCalServiceImpl.releaseMutex(mutexUuid, this.ctx);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public static void releaseMutex(Uuid id, Context ctx) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexService.releaseMutex(id);
    }

    public Map<String, Object> queryDepData(Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String periodType = paramMap.get("periodType").toString();
        String filterItems = paramMap.get("filterItems").toString();
        String companyID = paramMap.get("companyID").toString();
        PeriodInfo[] periods = this.getPeriodParam(companyID);
        boolean isPeriodLastOne = this.decideIsOrgCurrentPeriod(periods);
        this.repalacePeriodFilterItems(paramMap, periodType, filterItems, periods);
        this.decideReplaceFilterItemsWithBotpFilter(paramMap);
        List gridData = this.getDataMySelf(paramMap);
        Map<String, Object> depConfigMap = this.queryDepCalConfig(companyID);
        Map<String, Object> currencyMap = this.getCurrencyScale(companyID);
        Map<String, Object> undepPermissionMap = this.queryUndepPermission(companyID);
        resultMap.put("isPeriodLastOne", isPeriodLastOne);
        resultMap.put("gridData", gridData);
        resultMap.put("depConfigData", depConfigMap);
        resultMap.put("scaleData", currencyMap);
        resultMap.put("undepPermission", undepPermissionMap);
        resultMap.put("periodYear", periods[1].getPeriodYear());
        resultMap.put("periodNumber", periods[1].getPeriodNumber());
        return resultMap;
    }

    private void decideReplaceFilterItemsWithBotpFilter(Map paramMap) {
        String botpFilterLocal;
        if (paramMap.get("botpFilterLocal") != null && !(botpFilterLocal = paramMap.get("botpFilterLocal").toString()).equals("null") && !botpFilterLocal.equals("")) {
            paramMap.remove("filterItems");
            paramMap.put("filterItems", botpFilterLocal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getDataMySelf(Map paramMap) {
        ModelMap modelMap = new ModelMap();
        System.out.println("Start query:" + System.currentTimeMillis());
        String selector = null;
        if (selector != null && !selector.equals("")) {
            selector = null;
        }
        String queryPK = paramMap.get("queryPK").toString();
        String filterItems = null;
        if (paramMap.get("botpFilterItems") != null && !paramMap.get("botpFilterItems").equals("")) {
            filterItems = paramMap.get("botpFilterItems").toString();
        } else if (paramMap.get("filterItems") != null && !paramMap.get("filterItems").equals("")) {
            filterItems = paramMap.get("filterItems").toString();
        }
        String sorterItems = null;
        if (paramMap.get("sorterItems") != null && !paramMap.get("sorterItems").equals("") && !paramMap.get("sorterItems").equals("null")) {
            sorterItems = paramMap.get("sorterItems").toString();
        } else if (paramMap.get("sidx") != null && !paramMap.get("sidx").equals("")) {
            sorterItems = paramMap.get("sidx") + " " + paramMap.get("sord");
        }
        LinkedList data = new LinkedList();
        try {
            SecureRandom secureRandom = new SecureRandom();
            double flag = secureRandom.nextDouble();
            System.out.println("begin query data:" + flag + ":" + System.currentTimeMillis());
            IQueryExecutor QueryExecutor = this.getQueryExecutor(modelMap, queryPK, selector, filterItems, sorterItems);
            IRowSet rowSet = QueryExecutor.executeQuery();
            IRowSetMetaData md = rowSet.getRowSetMetaData();
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                int count = md.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    String columnName = md.getColumnName(i);
                    Object value = rowSet.getObject(i);
                    map.put(columnName, value);
                }
                map.put("adjDepre", "0");
                data.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            data = new LinkedList();
        }
        finally {
            System.out.println("end query:" + System.currentTimeMillis());
        }
        return data;
    }

    private IQueryExecutor getQueryExecutor(ModelMap modelMap, String queryPK, String selector, String filterItems, String sorterItems) throws EASBizException, BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        EntityViewInfo entityViewInfo = this.getEntityViewInfo(modelMap, selector, filterItems, sorterItems);
        exec.setObjectView(entityViewInfo);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        return exec;
    }

    protected EntityViewInfo getEntityViewInfo(ModelMap modelMap, String selector, String filterItems, String sorterItems) throws EASBizException {
        EntityViewInfo entityViewInfo = (EntityViewInfo)modelMap.get((Object)DATAGRID_ENTITYVIEW);
        if (entityViewInfo == null) {
            entityViewInfo = new EntityViewInfo();
        }
        if (filterItems != null && filterItems.length() > 0) {
            try {
                FilterInfo filterInfo = new FilterInfo(filterItems);
                if (FilterUtility.hasFilterItem((FilterInfo)entityViewInfo.getFilter())) {
                    entityViewInfo.getFilter().mergeFilter(filterInfo, "AND");
                } else {
                    entityViewInfo.setFilter(new FilterInfo(filterItems));
                }
            }
            catch (Exception filterInfo) {
                // empty catch block
            }
        }
        if (sorterItems != null) {
            SorterItemCollection sorterItemCollection = new SorterItemCollection();
            if (sorterItems.toLowerCase().indexOf("order by") == -1) {
                sorterItems = "ORDER BY " + sorterItems;
            }
            try {
                sorterItemCollection.getSorter().decode(sorterItems);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            entityViewInfo.setSorter(sorterItemCollection);
        }
        return entityViewInfo;
    }

    private void repalacePeriodFilterItems(Map paramMap, String periodType, String filterItems, PeriodInfo[] periods) throws EASBizException {
        String periodID = "";
        periodID = this.decidePeriodIDByPeriodType(periodType, periods);
        filterItems = filterItems.substring(0, filterItems.indexOf("period.id")) + "period.id = '" + periodID + "'";
        paramMap.remove("filterItems");
        paramMap.put("filterItems", filterItems);
    }

    private boolean decideIsOrgCurrentPeriod(PeriodInfo[] periods) {
        boolean isPeriodLastOne = periods[0].equals((Object)periods[1]);
        return isPeriodLastOne;
    }

    private String decidePeriodIDByPeriodType(String periodType, PeriodInfo[] periods) throws EASBizException {
        String periodID = "";
        if (periodType.equals("0")) {
            periodID = periods[1].getId().toString();
        } else if (periodType.equals("1")) {
            periodID = periods[2].getId().toString();
        } else {
            throw new EASBizException(new NumericExceptionSubItem("1", "period Param error"));
        }
        return periodID;
    }
}

