/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.dispatch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.FaDispatchServiceFacadeFactory;
import com.kingdee.eas.fi.fa.facade.app.model.IModelCreate;
import com.kingdee.eas.fi.fa.facade.app.util.FaServerUtil;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillFactory;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillInfo;
import com.kingdee.eas.fi.fa.manage.IFaDispatchBill;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FaDispatchBillModeCreator
implements IModelCreate {
    @Override
    public IObjectValue createModel(String bosType, String mainOrgUnitId, Context ctx) throws BOSException, EASBizException {
        IObjectValue obj = null;
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("companyId", mainOrgUnitId);
        if ("DF0214A5".equals(bosType)) {
            obj = this.createFaDispatchBill(filterMap, ctx);
        }
        return obj;
    }

    @Override
    public IObjectValue copyModel(IObjectValue dataObject) throws BOSException, EASBizException {
        return null;
    }

    private IObjectValue createFaDispatchBill(Map filterMap, Context ctx) throws EASBizException, BOSException {
        String mainOrgUnitId = (String)filterMap.get("companyId");
        String billIds = (String)filterMap.get("billIds");
        FaDispatchBillInfo info = new FaDispatchBillInfo();
        CompanyOrgUnitInfo mainOrgUnit = this.getDefaultMainOrgInfo(mainOrgUnitId, ctx);
        if (mainOrgUnit == null) {
            return info;
        }
        Date defaultDispatchDate = new Date();
        PeriodInfo currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)mainOrgUnit);
        info.setPeriod(currenctPeriod);
        defaultDispatchDate = FaServerUtil.getBizDate(mainOrgUnit, currenctPeriod);
        info.setOutCompany(mainOrgUnit);
        info.setCompany(mainOrgUnit);
        info.setDispatchDate(defaultDispatchDate);
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        info.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        info.setDeletedStatus(DeletedStatusEnum.NORMAL);
        info.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        info.setFiVouchered(false);
        UserInfo aUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        info.setOutPrincipal(aUserInfo.getPerson());
        info.setHandler(aUserInfo);
        info.setCreator(aUserInfo);
        info.setNumber(this.getRuleNumber((FaBillBaseInfo)info, ctx, mainOrgUnitId));
        if (!StringUtils.isEmpty((String)billIds)) {
            FaDispatchBillEntryCollection entryAdd = FaDispatchServiceFacadeFactory.getLocalInstance(ctx).getDispatchEntryByCard(billIds);
            FaDispatchBillEntryCollection entryCol = info.getFaDispatchBillEntry();
            entryCol.addCollection(entryAdd);
        }
        return info;
    }

    protected String getRuleNumber(FaBillBaseInfo baseInfo, Context ctx, String mainOrgUnitId) throws EASBizException, BOSException {
        String number = null;
        ICodingRuleManager iCodingRuleManager = null;
        CompanyOrgUnitInfo company = this.getDefaultMainOrgInfo(mainOrgUnitId, ctx);
        if (baseInfo.getCompany() == null) {
            baseInfo.setCompany(company);
        }
        iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        boolean isCodingRule = iCodingRuleManager.isExist((IObjectValue)baseInfo, company.getId().toString());
        boolean isViewCodeRule = iCodingRuleManager.isAddView((IObjectValue)baseInfo, company.getId().toString());
        number = isCodingRule && isViewCodeRule ? (baseInfo.getId() != null ? iCodingRuleManager.readNumber((IObjectValue)baseInfo, baseInfo.getId().toString()) : this.getBillInfoNumber(ctx, (BillBaseInfo)baseInfo)) : "";
        return number;
    }

    private String getBillInfoNumber(Context ctx, BillBaseInfo caller) throws EASBizException, BOSException {
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = (String)caller.get("number");
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + caller.getCompany().getId() + "'").getCU());
        int maxCycleNum = 100;
        IFaDispatchBill iDisp = FaDispatchBillFactory.getLocalInstance((Context)ctx);
        String filterString = "where dispatchDirection = 1 and number = '" + number + "' and company.id = '" + strCompanyID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        while (number == null || number.equals("") || iDisp.exists(filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            number = iCodingRuleManager.getNumber((IObjectValue)caller, strCompanyID);
            filterString = "where dispatchDirection = 1 and number = '" + number + "' and company.id = '" + strCompanyID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        }
        return number;
    }

    protected boolean isNeedCodeRule() {
        return false;
    }

    private CompanyOrgUnitInfo getDefaultMainOrgInfo(String mainOrgUnitId, Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo mainOrgUnit = null;
        if (mainOrgUnitId != null) {
            SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
            mainOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgUnitId), sic);
        } else {
            mainOrgUnit = (CompanyOrgUnitInfo)FaServerUtil.getDefaultMainBizOrg(ctx, OrgType.Company, "fa_card_addNew");
        }
        return mainOrgUnit;
    }

    @Override
    public IObjectValue createModel(String bosType, Map filterMap, Context ctx) throws BOSException, EASBizException {
        IObjectValue obj = null;
        if ("DF0214A5".equals(bosType)) {
            obj = this.createFaDispatchBill(filterMap, ctx);
        }
        return obj;
    }
}

