/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.facontrast;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.app.XmlTrans;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.fa.basedata.FaCatCollection;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.facade.app.base.CompanyDataImpl;
import com.kingdee.eas.fi.fa.facade.app.base.MainOrgFilterImpl;
import com.kingdee.eas.fi.fa.facade.app.facontrast.FaContrastCollection;
import com.kingdee.eas.fi.fa.facade.app.facontrast.FaContrastEntry;
import com.kingdee.eas.fi.fa.facade.app.facontrast.FaContrastSolutionEntry;
import com.kingdee.eas.fi.fa.facade.app.util.FaServerUtil;
import com.kingdee.eas.fi.fa.manage.FaContrastCaclFactory;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionCollection;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionFactory;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionInfo;
import com.kingdee.eas.fi.fa.manage.IFaContrastCacl;
import com.kingdee.eas.fi.fa.manage.IFaContrastSolution;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FaContrastCalculator {
    private static final String FA_CONTRAST_RESOUSE = "com.kingdee.eas.fi.fa.manage.FaContrastResource";
    private Context context = null;
    private int periodYear = 0;
    private int periodNumber = 0;
    private String isIncludeUnposted = null;
    private String isUseEvaValue = null;

    public FaContrastCalculator(Context context) {
        this.context = context;
    }

    public Map<String, Object> initFaContrastData(String mainOrgUnitId, String permissionItem) throws BOSException, EASBizException {
        HashMap<String, Object> info = new HashMap<String, Object>();
        CompanyOrgUnitInfo mainOrgUnit = null;
        if (mainOrgUnitId != null) {
            SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
            mainOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgUnitId), sic);
        } else {
            mainOrgUnit = (CompanyOrgUnitInfo)FaServerUtil.getDefaultMainBizOrg(this.context, OrgType.Company, permissionItem);
        }
        info.put("company", mainOrgUnit);
        if (mainOrgUnit != null) {
            String filter = new MainOrgFilterImpl(this.context).getMainOrgFilterOql(permissionItem);
            info.put("mainorgfilter", filter);
            String oql = "select orgID,ownerID,name,params where orgID='" + mainOrgUnit.getId().toString() + "' order by name";
            IObjectCollection solutions = DynamicObjectFactory.getLocalInstance((Context)this.context).getCollection(new BOSObjectType("0CE4859F"), oql);
            info.put("solutions", solutions);
            this.markDefaultSolution(solutions);
            List<Integer> years = new CompanyDataImpl(this.context).getPeriodYearRange(mainOrgUnit);
            info.put("years", years);
            PeriodInfo period = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.context, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)mainOrgUnit);
            info.put("period", period);
            String sql = "select FPrecision from t_bd_currency c inner join t_org_company o on o.FBaseCurrencyId=c.FID  where o.FID='" + mainOrgUnit.getId().toString() + "' ";
            IRowSet rs = DbUtil.executeQuery((Context)this.context, (String)sql);
            int precision = 0;
            try {
                if (rs.next()) {
                    precision = rs.getInt("FPrecision");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            info.put("precision", precision);
        }
        return info;
    }

    public Map<String, Object> initFaContrastData2(String periodId, String permissionItem, boolean share) throws BOSException, EASBizException {
        HashMap<String, Object> onloadData = new HashMap<String, Object>();
        String errorMsg = null;
        try {
            CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
            CompanyOrgUnitCollection coll = this.getUserOrgRangesWithRange(this.context, permissionItem);
            if (!share) {
                CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)this.context.get((Object)OrgType.Company);
                for (int i = 0; i < coll.size(); ++i) {
                    CompanyOrgUnitInfo rowCompany = coll.get(i);
                    if (rowCompany.getId().equals((Object)currentCompany.getId())) continue;
                    coll.removeObject(i);
                    --i;
                }
                if (coll.size() == 0) {
                    throw new CasWebException(CasWebException.NO_CASHCONTRASTGL_AUTHRIZED);
                }
            }
            CompanyOrgUnitCollection initColl = new CompanyOrgUnitCollection();
            if (coll != null) {
                ArrayList loadData = new ArrayList();
                PeriodCollection commonPeriodCollAll = new PeriodCollection();
                StringBuffer periodFilter = new StringBuffer("id in ('NE')");
                for (int i = 0; i < coll.size(); ++i) {
                    PeriodInfo startPeriod;
                    PeriodCollection commonPeriodColl = null;
                    CompanyOrgUnitInfo info = coll.get(i);
                    if (!info.isIsBizUnit() || info.isIsOUSealUp() || info.isIsAssistantOrg() || null == (startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)this.context, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)info))) continue;
                    commonPeriodColl = this.getFaGlPeriod(this.context, info);
                    if (commonPeriodColl.size() == 0) {
                        if (share) continue;
                        onloadData.put("errorMsg", EASResource.getString((String)FA_CONTRAST_RESOUSE, (String)"noFaContrastPeriod", (Locale)this.context.getOriginLocale()));
                        continue;
                    }
                    if (commonPeriodCollAll.size() == 0 && null != commonPeriodColl) {
                        commonPeriodCollAll = commonPeriodColl;
                        onloadData.put("period", commonPeriodColl.get(0));
                    } else {
                        for (int j = 0; j < commonPeriodColl.size(); ++j) {
                            PeriodInfo glPeriod = null;
                            glPeriod = commonPeriodColl.get(j);
                            for (int z = 0; z < commonPeriodCollAll.size() && (commonPeriodCollAll.get(z).getPeriodYear() != glPeriod.getPeriodYear() || commonPeriodCollAll.get(z).getNumber() != glPeriod.getNumber()); ++z) {
                                if (z != commonPeriodCollAll.size() - 1) continue;
                                commonPeriodCollAll.add(glPeriod);
                            }
                        }
                    }
                    if (periodId == null) {
                        initColl.add(coll.get(i));
                        continue;
                    }
                    PeriodInfo period = new PeriodInfo();
                    period.setId(BOSUuid.read((String)periodId));
                    period = PeriodFactory.getLocalInstance((Context)this.context).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
                    onloadData.put("period", period);
                    period = this.getPeriodInfo(this.context, info, period.getPeriodYear(), period.getPeriodNumber());
                    if (!commonPeriodColl.contains(period)) continue;
                    companyColl.add(info);
                    HashMap<String, String> row = new HashMap<String, String>();
                    row.put("id", info.getId().toString());
                    row.put("companyId", info.getId().toString());
                    row.put("company_name", info.getName());
                    loadData.add(row);
                }
                if (commonPeriodCollAll != null) {
                    PeriodCollection newCommonPeriodCollDescAll = new PeriodCollection();
                    int maxIndex = 0;
                    PeriodInfo max = commonPeriodCollAll.get(0);
                    while (commonPeriodCollAll.size() > 0) {
                        for (int j = 1; j < commonPeriodCollAll.size(); ++j) {
                            if (commonPeriodCollAll.get(j).getNumber() <= max.getNumber()) continue;
                            maxIndex = j;
                            max = commonPeriodCollAll.get(j);
                        }
                        commonPeriodCollAll.removeObject(maxIndex);
                        newCommonPeriodCollDescAll.add(max);
                        if (commonPeriodCollAll.size() <= 0) continue;
                        maxIndex = 0;
                        max = commonPeriodCollAll.get(0);
                    }
                    onloadData.put("commonPeriodCollAll", newCommonPeriodCollDescAll);
                    periodFilter = new StringBuffer("id in (");
                    PeriodInfo initPeriod = new PeriodInfo();
                    initPeriod.setId(BOSUuid.read((String)newCommonPeriodCollDescAll.get(0).getId().toString()));
                    initPeriod = PeriodFactory.getLocalInstance((Context)this.context).getPeriodInfo((IObjectPK)new ObjectUuidPK(initPeriod.getId().toString()));
                    if (periodId == null) {
                        onloadData.put("period", initPeriod);
                    }
                    for (int k = 0; k < newCommonPeriodCollDescAll.size(); ++k) {
                        periodFilter.append("'" + newCommonPeriodCollDescAll.get(k).getId().toString() + "',");
                        if (initPeriod.getNumber() >= newCommonPeriodCollDescAll.get(k).getNumber()) continue;
                        initPeriod = newCommonPeriodCollDescAll.get(k);
                        if (periodId != null) continue;
                        onloadData.put("period", initPeriod);
                    }
                    periodFilter.deleteCharAt(periodFilter.length() - 1);
                    periodFilter.append(") ");
                    if (periodId == null) {
                        PeriodCollection commonPeriodInitColl = null;
                        for (int l = 0; l < initColl.size(); ++l) {
                            CompanyOrgUnitInfo info = initColl.get(l);
                            commonPeriodInitColl = this.getFaGlPeriod(this.context, info);
                            PeriodInfo period = new PeriodInfo();
                            period = PeriodFactory.getLocalInstance((Context)this.context).getPeriodInfo((IObjectPK)new ObjectUuidPK(initPeriod.getId().toString()));
                            if (!commonPeriodInitColl.contains(period = this.getPeriodInfo(this.context, info, period.getPeriodYear(), period.getPeriodNumber()))) continue;
                            companyColl.add(info);
                            HashMap<String, String> row = new HashMap<String, String>();
                            row.put("id", info.getId().toString());
                            row.put("companyId", info.getId().toString());
                            row.put("company_name", info.getName());
                            loadData.add(row);
                        }
                    }
                } else {
                    errorMsg = CASWebUtil.getResource((Context)this.context, (String)"NoContrastPeriod");
                }
                onloadData.put("onloadData", loadData);
                onloadData.put("periodF7Filter", periodFilter.toString());
                onloadData.put("errorMsg", errorMsg);
                return onloadData;
            }
        }
        catch (Exception e) {
            EASBizException be;
            if (e instanceof EASBizException && (be = (EASBizException)((Object)e)).getMainCode().equals("20") && be.getSubCode().equals("013")) {
                throw be;
            }
            e.printStackTrace();
            errorMsg = e.getMessage();
        }
        onloadData.put("errorMsg", errorMsg);
        return onloadData;
    }

    private CompanyOrgUnitCollection getUserOrgRangesWithRange(Context ctx, String permissionItem) throws BOSException, EASBizException {
        IPermission permission;
        HashSet<String> idSet = new HashSet<String>();
        UserInfo userInfo = null;
        if (ctx == null) {
            userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
            permission = PermissionFactory.getRemoteInstance();
        } else {
            userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            permission = PermissionFactory.getLocalInstance((Context)ctx);
        }
        FullOrgUnitCollection mainOrgs = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem);
        for (int i = 0; i < mainOrgs.size(); ++i) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)mainOrgs.getObject(i);
            idSet.add(orgUnit.getId().toString());
        }
        if (idSet.size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        view.setFilter(filter2);
        filter2.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("baseCurrency.id");
        sic.add("baseCurrency.number");
        sic.add("baseCurrency.name");
        sic.add("accountTable.id");
        sic.add("accountTable.name");
        view.setSelector(sic);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("number"));
        view.setSorter(sorterColl);
        if (ctx == null) {
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        }
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
    }

    private PeriodCollection getFaGlPeriod(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodCollection faPeriodColl = this.getPeriodColl(ctx, companyInfo, SystemEnum.FIXEDASSETS);
        return faPeriodColl;
    }

    private PeriodCollection getPeriodColl(Context ctx, CompanyOrgUnitInfo companyInfo, SystemEnum system) throws EASBizException, BOSException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)system, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)system, (CompanyOrgUnitInfo)companyInfo);
        if (startPeriod == null || currPeriod == null) {
            return new PeriodCollection();
        }
        ObjectUuidPK pkFrom = new ObjectUuidPK(startPeriod.getId());
        ObjectUuidPK pkTo = new ObjectUuidPK(currPeriod.getId());
        ObjectUuidPK companyPk = new ObjectUuidPK(companyInfo.getId());
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection periodColl = iPeriod.getPeriodCollection((IObjectPK)pkFrom, (IObjectPK)pkTo, (IObjectPK)companyPk);
        return periodColl;
    }

    private PeriodInfo getPeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo, int PeriodYear, int PeriodNumber) throws EASBizException, BOSException {
        PeriodTypeInfo periodType = companyInfo.getAccountPeriodType();
        return PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(PeriodYear, PeriodNumber, periodType);
    }

    private void markDefaultSolution(IObjectCollection solutions) throws BOSException {
        for (int i = 0; i < solutions.size(); ++i) {
            FaContrastSolutionInfo solutionInfo = (FaContrastSolutionInfo)solutions.getObject(i);
            String params = solutionInfo.getParams();
            if (params == null) continue;
            try {
                boolean isDefaultSolution;
                HashMap loadInfo = XmlTrans.TransStrToCustParams((String)params);
                boolean bl = isDefaultSolution = loadInfo == null ? false : Boolean.valueOf((String)loadInfo.get("IsDefaultSolution"));
                if (!isDefaultSolution) continue;
                solutionInfo.put("isdefault", (Object)true);
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public Map<String, Object> calculate(String solutionId, int periodYear, int periodNumber) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FaContrastSolutionInfo solution = this.getContrastSolution(solutionId);
        String companyId = solution.getOrgID();
        Map<String, Object> parameter = this.getParamFromSolution(solution);
        CompanyOrgUnitInfo companyInfo = this.getCompanyOrgUnitInfo(companyId);
        boolean isIncludeUnposted = this.getBooleanFromSolution(parameter, "isIncludeUnposted");
        boolean isUseEvaValue = this.getBooleanFromSolution(parameter, "isUseEvaValue");
        boolean isUseCatNumber = this.getBooleanFromSolution(parameter, "isUseCatNumber");
        boolean isUseCardAcct = this.getBooleanFromSolution(parameter, "isUseCardAcct");
        HashMap accountMap = this.getAccountMap(solution);
        HashMap catMap = this.getCatMap(solution);
        IFaContrastCacl faContrast = FaContrastCaclFactory.getLocalInstance((Context)this.context);
        HashMap contrastMap = null;
        contrastMap = isUseCardAcct ? faContrast.faAcctDetail(companyId, accountMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue) : faContrast.faAcct(companyId, accountMap, catMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue, isUseCatNumber);
        this.periodYear = periodYear;
        this.periodNumber = periodNumber;
        this.isIncludeUnposted = String.valueOf(isIncludeUnposted);
        this.isUseEvaValue = String.valueOf(isUseEvaValue);
        if (isUseCatNumber) {
            this.setResultWithCat(result, contrastMap, companyInfo);
        } else if (isUseCardAcct) {
            this.setResultWithCardAcct(result, contrastMap, companyInfo);
        } else {
            this.setResult(result, contrastMap, companyInfo);
        }
        return result;
    }

    public Map<String, Object> contrast(String companyId, String periodId, String diffValue) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap parameter = this.getDefaultContrastSolution(this.getContrastSolutions(companyId));
        CompanyOrgUnitInfo companyInfo = this.getCompanyOrgUnitInfo(companyId);
        PeriodInfo periodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        int periodYear = periodInfo.getPeriodYear();
        int periodNumber = periodInfo.getPeriodNumber();
        boolean isIncludeUnposted = this.getBooleanFromSolution(parameter, "isIncludeUnposted");
        boolean isUseEvaValue = this.getBooleanFromSolution(parameter, "isUseEvaValue");
        boolean isUseCatNumber = this.getBooleanFromSolution(parameter, "isUseCatNumber");
        boolean isUseCardAcct = this.getBooleanFromSolution(parameter, "isUseCardAcct");
        HashMap accountMap = parameter.get("AccountMap") != null ? (HashMap)parameter.get("AccountMap") : new HashMap();
        HashMap catMap = parameter.get("CatMap") != null ? (HashMap)parameter.get("CatMap") : new HashMap();
        IFaContrastCacl faContrast = FaContrastCaclFactory.getLocalInstance((Context)this.context);
        HashMap contrastMap = null;
        contrastMap = isUseCardAcct ? faContrast.faAcctDetail(companyId, accountMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue) : faContrast.faAcct(companyId, accountMap, catMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue, isUseCatNumber);
        this.periodYear = periodYear;
        this.periodNumber = periodNumber;
        this.isIncludeUnposted = String.valueOf(isIncludeUnposted);
        this.isUseEvaValue = String.valueOf(isUseEvaValue);
        if (isUseCatNumber) {
            this.setResultWithCat(result, contrastMap, companyInfo);
        } else if (isUseCardAcct) {
            this.setResultWithCardAcct(result, contrastMap, companyInfo);
        } else {
            this.setResult(result, contrastMap, companyInfo);
        }
        List list = (List)result.get("rows");
        FaContrastEntry faContrastEntry = null;
        Integer currencyScale = (Integer)contrastMap.get("currencyScale");
        BigDecimal zero = new BigDecimal("0");
        zero = zero.setScale((int)currencyScale, 4);
        List containList = new ArrayList();
        if (diffValue == null || "0".equals(diffValue)) {
            containList = list;
        } else {
            for (int i = 0; i < list.size(); ++i) {
                int j;
                faContrastEntry = (FaContrastEntry)list.get(i);
                if ("1".equals(diffValue) && "sumEnd".equals(faContrastEntry.getAspectDC()) && !faContrastEntry.getDiff().equals(zero)) {
                    for (j = 0; j < 4; ++j) {
                        containList.add(list.remove(i - 3));
                    }
                    i -= 4;
                    continue;
                }
                if (!"2".equals(diffValue) || !"sumEnd".equals(faContrastEntry.getAspectDC()) || !faContrastEntry.getDiff().equals(zero)) continue;
                for (j = 0; j < 4; ++j) {
                    containList.add(list.remove(i - 3));
                }
                i -= 4;
            }
        }
        result.put("rows", containList);
        result.put("currencyScale", currencyScale);
        result.put("labelCompany", companyInfo.getName());
        result.put("labelPeriod", periodYear + EASResource.getString((String)FA_CONTRAST_RESOUSE, (String)"year", (Locale)this.context.getOriginLocale()) + periodNumber + EASResource.getString((String)FA_CONTRAST_RESOUSE, (String)"period", (Locale)this.context.getOriginLocale()));
        return result;
    }

    public Map<String, Object> contrast2(String companyIds, String periodId) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] idArr = companyIds.split(",");
        int totalCount = idArr.length;
        int notBalance = 0;
        int balance = 0;
        int solutionIsNull = 0;
        ArrayList resultList = new ArrayList();
        for (int j = 0; j < idArr.length; ++j) {
            HashMap<String, String> checkRow = new HashMap<String, String>();
            String companyId = idArr[j];
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            checkRow.put("check_msg", CASWebUtil.getResource((Context)this.context, (String)"Balance"));
            checkRow.put("company_name", companyInfo.getName());
            checkRow.put("id", (String)companyInfo.getId());
            HashMap parameter = this.getDefaultContrastSolution(this.getContrastSolutions(companyId));
            if (parameter == null) {
                checkRow.put("check_msg", EASResource.getString((String)FA_CONTRAST_RESOUSE, (String)"noDefaultContrastSchema", (Locale)this.context.getOriginLocale()));
                resultList.add(checkRow);
                ++solutionIsNull;
                continue;
            }
            PeriodInfo periodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
            int periodYear = periodInfo.getPeriodYear();
            int periodNumber = periodInfo.getPeriodNumber();
            boolean isIncludeUnposted = this.getBooleanFromSolution(parameter, "isIncludeUnposted");
            boolean isUseEvaValue = this.getBooleanFromSolution(parameter, "isUseEvaValue");
            boolean isUseCatNumber = this.getBooleanFromSolution(parameter, "isUseCatNumber");
            boolean isUseCardAcct = this.getBooleanFromSolution(parameter, "isUseCardAcct");
            boolean flag = false;
            HashMap accountMap = parameter.get("AccountMap") != null ? (HashMap)parameter.get("AccountMap") : new HashMap();
            HashMap catMap = parameter.get("CatMap") != null ? (HashMap)parameter.get("CatMap") : new HashMap();
            IFaContrastCacl faContrast = FaContrastCaclFactory.getLocalInstance((Context)this.context);
            HashMap contrastMap = null;
            try {
                contrastMap = isUseCardAcct ? faContrast.faAcctDetail(companyId, accountMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue) : faContrast.faAcctBySumEnd(companyId, accountMap, catMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue, isUseCatNumber);
            }
            catch (Exception e) {
                checkRow.put("check_msg", e.getMessage());
                resultList.add(checkRow);
                continue;
            }
            this.periodYear = periodYear;
            this.periodNumber = periodNumber;
            this.isIncludeUnposted = String.valueOf(isIncludeUnposted);
            this.isUseEvaValue = String.valueOf(isUseEvaValue);
            Integer scale = (Integer)contrastMap.get("currencyScale");
            if (isUseCatNumber) {
                this.setResultWithCat(result, contrastMap, companyInfo);
            } else if (isUseCardAcct) {
                this.setResultWithCardAcct(result, contrastMap, companyInfo);
            } else {
                this.setResult(result, contrastMap, companyInfo);
            }
            List list = (List)result.get("rows");
            FaContrastEntry faContrastEntry = null;
            BigDecimal zero = new BigDecimal("0");
            zero = zero.setScale((int)scale, 4);
            for (int i = 0; i < list.size(); ++i) {
                faContrastEntry = (FaContrastEntry)list.get(i);
                if (!"sumEnd".equals(faContrastEntry.getAspectDC()) || faContrastEntry.getDiff().equals(zero)) continue;
                checkRow.put("check_msg", CASWebUtil.getResource((Context)this.context, (String)"Unbalance"));
                ++notBalance;
                resultList.add(checkRow);
                flag = true;
                break;
            }
            if (flag) continue;
            resultList.add(checkRow);
            ++balance;
        }
        result.put("checkMsg", resultList);
        if (solutionIsNull == 0) {
            result.put("resultMsg", MessageFormat.format(EASResource.getString((String)FA_CONTRAST_RESOUSE, (String)"contrastResult1", (Locale)this.context.getOriginLocale()), totalCount, balance, notBalance));
        } else {
            result.put("resultMsg", MessageFormat.format(EASResource.getString((String)FA_CONTRAST_RESOUSE, (String)"contrastResult2", (Locale)this.context.getOriginLocale()), totalCount, balance, notBalance, solutionIsNull));
        }
        return result;
    }

    public HashMap getDefaultContrastSolution(FaContrastSolutionCollection collection) throws BOSException {
        if (collection == null) {
            return null;
        }
        for (int i = 0; i < collection.size(); ++i) {
            FaContrastSolutionInfo solutionInfo = collection.get(i);
            String params = solutionInfo.getParams();
            if (params == null) continue;
            try {
                boolean isDefaultSolution;
                HashMap loadInfo = XmlTrans.TransStrToCustParams((String)params);
                boolean bl = isDefaultSolution = loadInfo == null ? false : Boolean.valueOf((String)loadInfo.get("IsDefaultSolution"));
                if (!isDefaultSolution) continue;
                return loadInfo;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    public FaContrastSolutionCollection getContrastSolutions(String companyID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)companyID));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        IFaContrastSolution isolution = FaContrastSolutionFactory.getLocalInstance((Context)this.context);
        FaContrastSolutionCollection solutions = isolution.getFaContrastSolutionCollection(entityViewInfo);
        this.markDefaultSolution((IObjectCollection)solutions);
        return solutions;
    }

    public FaContrastSolutionInfo getSolution(String solutionId) throws EASBizException, BOSException {
        FaContrastSolutionInfo solution = FaContrastSolutionFactory.getLocalInstance((Context)this.context).getFaContrastSolutionInfo((IObjectPK)new ObjectUuidPK(solutionId));
        HashMap<String, Serializable> info = new HashMap<String, Serializable>();
        Map<String, Object> parameter = this.getParamFromSolution(solution);
        HashMap accountMap = this.getAccountMap(solution);
        HashMap catMap = this.getCatMap(solution);
        String[] accountKeys = new String[]{"ASSET", "DEPRE", "DECVALUE"};
        HashMap<String, Object> accountFaCat = new HashMap<String, Object>();
        this.getAccountFaCatCol(accountFaCat, accountKeys, accountMap, catMap);
        AccountViewCollection accountCol = (AccountViewCollection)accountFaCat.get("accountCol");
        FaCatCollection catCol = (FaCatCollection)accountFaCat.get("catCol");
        ArrayList<FaContrastSolutionEntry> assetentry = new ArrayList<FaContrastSolutionEntry>();
        ArrayList<FaContrastSolutionEntry> depreentry = new ArrayList<FaContrastSolutionEntry>();
        ArrayList<FaContrastSolutionEntry> decvalueentry = new ArrayList<FaContrastSolutionEntry>();
        for (int i = 0; i < accountKeys.length; ++i) {
            String accountKey = accountKeys[i];
            Set keySet = ((Map)accountMap.get(accountKey)).keySet();
            List keyList = Arrays.asList((Object[])keySet.toArray());
            Collections.sort(keyList);
            ArrayList accountIdList = new ArrayList();
            for (int j = 0; j < keyList.size(); ++j) {
                accountIdList.add(((Map)accountMap.get(accountKey)).get(keyList.get(j)));
            }
            for (String accountId : accountIdList) {
                AccountViewInfo accountInfo = (AccountViewInfo)FaServerUtil.getInfoById((IObjectCollection)accountCol, accountId);
                ArrayList<FaCatInfo> assetCats = new ArrayList<FaCatInfo>();
                FaContrastSolutionEntry entry = new FaContrastSolutionEntry();
                entry.setAccount(accountInfo);
                Map catIdMap = (Map)catMap.get(accountKey + "_" + accountId);
                if (catIdMap != null) {
                    Iterator catIds = catIdMap.values().iterator();
                    while (catIds.hasNext()) {
                        FaCatInfo catInfo = (FaCatInfo)FaServerUtil.getInfoById((IObjectCollection)catCol, (String)catIds.next());
                        assetCats.add(catInfo);
                    }
                    entry.setAssetCats(assetCats);
                }
                if ("ASSET".equals(accountKey)) {
                    assetentry.add(entry);
                    continue;
                }
                if ("DEPRE".equals(accountKey)) {
                    depreentry.add(entry);
                    continue;
                }
                decvalueentry.add(entry);
            }
        }
        info.put("assetentry", assetentry);
        info.put("depreentry", depreentry);
        info.put("decvalueentry", decvalueentry);
        info.put("isIncludeUnposted", Boolean.valueOf(this.getBooleanFromSolution(parameter, "isIncludeUnposted")));
        info.put("isUseEvaValue", Boolean.valueOf(this.getBooleanFromSolution(parameter, "isUseEvaValue")));
        info.put("isUseCatNumber", Boolean.valueOf(this.getBooleanFromSolution(parameter, "isUseCatNumber")));
        info.put("isUseCardAcct", Boolean.valueOf(this.getBooleanFromSolution(parameter, "isUseCardAcct")));
        info.put("IsDefaultSolution", Boolean.valueOf(this.getBooleanFromSolution(parameter, "IsDefaultSolution")));
        solution.put("queryParams", info);
        solution.setParams(null);
        return solution;
    }

    public FaContrastSolutionInfo saveSolution(FaContrastSolutionInfo solutionObj) throws EASBizException, BOSException {
        String solutionId;
        FaContrastSolutionInfo solution = solutionObj;
        String string = solutionId = solution.getId() != null ? solution.getId().toString() : null;
        if (solution.getOwnerID() == null) {
            solution.setOwnerID(this.context.getCaller().toString());
        }
        IFaContrastSolution bizInterface = FaContrastSolutionFactory.getLocalInstance((Context)this.context);
        Map queryParams = (Map)solution.get("queryparams");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)solution.getOrgID()));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)solution.getName()));
        boolean isExists = bizInterface.exists(filterInfo);
        if (!isExists) {
            solution.setId(null);
        } else {
            FaContrastSolutionInfo existsInfo = bizInterface.getFaContrastSolutionInfo("select id where orgID = '" + solution.getOrgID() + "' and name = '" + solution.getName() + "'");
            solution.setId(existsInfo.getId());
        }
        boolean isDefault = (Boolean)queryParams.get("IsDefaultSolution");
        if (isDefault) {
            String oql = "select id, params where orgID='" + solution.getOrgID() + "' ";
            FaContrastSolutionCollection solutions = bizInterface.getFaContrastSolutionCollection(oql);
            for (int i = 0; i < solutions.size(); ++i) {
                FaContrastSolutionInfo existedInfo = solutions.get(i);
                Map<String, Object> parameter = this.getParamFromSolution(existedInfo);
                boolean isExistsDefault = this.getBooleanFromSolution(parameter, "IsDefaultSolution");
                if (!isExistsDefault || existedInfo.getId().equals((Object)solution.getId())) continue;
                parameter.put("IsDefaultSolution", false);
                String params = this.setNewSolution(parameter);
                FaContrastSolutionInfo info = new FaContrastSolutionInfo();
                info.setId(existedInfo.getId());
                info.setParams(params);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("params"));
                bizInterface.updatePartial(info, selector);
            }
        }
        List assetEntry = (List)queryParams.get("assetentry");
        List depreEntry = (List)queryParams.get("depreentry");
        List decvalueEntry = (List)queryParams.get("decvalueentry");
        CustomerParams assetAccount = new CustomerParams();
        CustomerParams depreAccount = new CustomerParams();
        CustomerParams decValueAccount = new CustomerParams();
        CustomerParams accountMap = new CustomerParams();
        CustomerParams catMap = new CustomerParams();
        this.setAccountCat(assetEntry, assetAccount, accountMap, catMap, "ASSET", queryParams);
        this.setAccountCat(depreEntry, depreAccount, accountMap, catMap, "DEPRE", queryParams);
        this.setAccountCat(decvalueEntry, decValueAccount, accountMap, catMap, "DECVALUE", queryParams);
        String params = this.createXMLParams(queryParams, accountMap, catMap);
        solution.setParams(params);
        if (isExists) {
            bizInterface.update((IObjectPK)new ObjectUuidPK(solution.getId()), solution);
            solutionId = solution.getId().toString();
        } else {
            IObjectPK id = bizInterface.addnew(solution);
            solutionId = id.toString();
        }
        return bizInterface.getFaContrastSolutionInfo("select name where id ='" + solutionId + "' ");
    }

    public String setNewSolution(Map<String, Object> queryParams) throws BOSException {
        Map accMap = queryParams.get("AccountMap") == null ? new HashMap() : (Map)queryParams.get("AccountMap");
        HashMap<String, Object> assetEntry = accMap.get("ASSET") == null ? new HashMap() : (Map)accMap.get("ASSET");
        HashMap<String, Object> depreEntry = accMap.get("DEPRE") == null ? new HashMap() : (Map)accMap.get("DEPRE");
        HashMap<String, Object> decvalueEntry = accMap.get("DECVALUE") == null ? new HashMap() : (Map)accMap.get("DECVALUE");
        HashMap<String, Object> catEntry = queryParams.get("CatMap") == null ? new HashMap() : (Map)queryParams.get("CatMap");
        CustomerParams assetAccount = new CustomerParams();
        CustomerParams depreAccount = new CustomerParams();
        CustomerParams decValueAccount = new CustomerParams();
        CustomerParams accountMap = new CustomerParams();
        CustomerParams catMap = new CustomerParams();
        this.setNewAccount(assetEntry, assetAccount, accountMap, "ASSET");
        this.setNewAccount(depreEntry, depreAccount, accountMap, "DEPRE");
        this.setNewAccount(decvalueEntry, decValueAccount, accountMap, "DECVALUE");
        this.setNewFaCat(catEntry, catMap);
        String params = this.createXMLParams(queryParams, accountMap, catMap);
        return params;
    }

    public FaContrastSolutionCollection getSolutions(String orgUnitId) throws BOSException, EASBizException {
        String oql = "select orgID,ownerID,name where orgID='" + orgUnitId + "' order by name";
        return FaContrastSolutionFactory.getLocalInstance((Context)this.context).getFaContrastSolutionCollection(oql);
    }

    public void deleteSolution(String solutionId) throws EASBizException, BOSException {
        FaContrastSolutionFactory.getLocalInstance((Context)this.context).delete((IObjectPK)new ObjectUuidPK(solutionId));
    }

    private String createXMLParams(Map<String, Object> queryParams, CustomerParams accountMap, CustomerParams catMap) throws BOSException {
        CustomerParams custParams = new CustomerParams();
        custParams.putMe("AccountMap", accountMap);
        custParams.putMe("CatMap", catMap);
        custParams.putBoolean("isIncludeUnposted", Boolean.valueOf(queryParams.get("isIncludeUnposted").toString()).booleanValue());
        custParams.putBoolean("IsDefaultSolution", Boolean.valueOf(queryParams.get("IsDefaultSolution").toString()).booleanValue());
        custParams.putBoolean("isUseEvaValue", Boolean.valueOf(queryParams.get("isUseEvaValue").toString()).booleanValue());
        custParams.putBoolean("isUseCatNumber", Boolean.valueOf(queryParams.get("isUseCatNumber").toString()).booleanValue());
        custParams.putBoolean("isUseCardAcct", Boolean.valueOf(queryParams.get("isUseCardAcct").toString()).booleanValue());
        String params = null;
        if (custParams != null) {
            Collection keys = custParams.getKeys();
            Collection values = custParams.getValues();
            if (keys.size() > 0) {
                try {
                    params = XMLBean.CreateXMLStrRecursion((Collection)keys, (Collection)values);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return params;
    }

    private void setAccountCat(List<Map<String, Object>> assetCatEntry, CustomerParams assetAccount, CustomerParams accountMap, CustomerParams catMap, String preFix, Map<String, Object> queryParams) {
        boolean isUserCatNumber = (Boolean)queryParams.get("isUseCatNumber");
        for (int i = 0; i < assetCatEntry.size(); ++i) {
            Map<String, Object> entry = assetCatEntry.get(i);
            String accountId = "";
            if (entry.get("account") == null || entry.get("account") instanceof String) continue;
            Map accountInfo = (Map)entry.get("account");
            accountId = (String)accountInfo.get("id");
            assetAccount.addCustomerParam("account" + i, accountId);
            if (!isUserCatNumber) continue;
            CustomerParams assetCat = new CustomerParams();
            if (entry.get("assetCats") != null && !(entry.get("assetCats") instanceof String)) {
                if (entry.get("assetCats") instanceof Map) {
                    Map catInfo = (Map)entry.get("assetCats");
                    assetCat.addCustomerParam("cat0", (String)catInfo.get("id"));
                } else if (entry.get("assetCats") instanceof List) {
                    List assetCatsEntry = (List)entry.get("assetCats");
                    for (int j = 0; j < assetCatsEntry.size(); ++j) {
                        Map catInfo = (Map)assetCatsEntry.get(j);
                        assetCat.addCustomerParam("cat" + j, (String)catInfo.get("id"));
                    }
                }
            }
            if (assetCat.getValues().size() <= 0) continue;
            catMap.putMe(preFix + "_" + accountId, assetCat);
        }
        accountMap.putMe(preFix, assetAccount);
    }

    private void setNewAccount(Map<String, Object> accountEntry, CustomerParams assetAccount, CustomerParams accountMap, String preFix) {
        Set<String> keySet = accountEntry.keySet();
        for (String key : keySet) {
            assetAccount.addCustomerParam(key, (String)accountEntry.get(key));
        }
        accountMap.putMe(preFix, assetAccount);
    }

    private void setNewFaCat(Map<String, Object> catEntry, CustomerParams catMap) {
        Set<String> keySet = catEntry.keySet();
        for (String key : keySet) {
            Map map = (Map)catEntry.get(key);
            Set set = map.keySet();
            Iterator itor = set.iterator();
            CustomerParams tempMap = new CustomerParams();
            while (itor.hasNext()) {
                String akey = (String)itor.next();
                tempMap.addCustomerParam(akey, (String)map.get(akey));
            }
            catMap.putMe(key, tempMap);
        }
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfo(String companyId) throws EASBizException, BOSException {
        String oql = "select name,baseCurrency.number,baseCurrency.name where id='" + companyId + "' ";
        return (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getValue(oql);
    }

    private FaContrastSolutionInfo getContrastSolution(String solutionId) throws EASBizException, BOSException {
        String oql = "select orgID,name,params where id='" + solutionId + "' ";
        return (FaContrastSolutionInfo)FaContrastSolutionFactory.getLocalInstance((Context)this.context).getValue(oql);
    }

    private Map<String, Object> getParamFromSolution(FaContrastSolutionInfo solution) throws BOSException {
        HashMap parameter = new HashMap();
        String params = solution.getParams();
        if (params == null || params.length() == 0) {
            return parameter;
        }
        try {
            parameter = XmlTrans.TransStrToCustParams((String)params);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return parameter;
    }

    private boolean getBooleanFromSolution(Map<String, Object> parameter, String key) {
        return parameter.get(key) != null ? Boolean.valueOf((String)parameter.get(key)) : false;
    }

    private HashMap getAccountMap(FaContrastSolutionInfo solution) throws BOSException {
        HashMap cp;
        HashMap accounts = new HashMap();
        String params = solution.getParams();
        if (params == null || params.length() == 0) {
            return accounts;
        }
        try {
            cp = XmlTrans.TransStrToCustParams((String)solution.getParams());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HashMap accountMap = (HashMap)cp.get("AccountMap");
        if (accountMap != null && accountMap.size() > 0) {
            return accountMap;
        }
        return accounts;
    }

    private HashMap getCatMap(FaContrastSolutionInfo solution) throws BOSException {
        HashMap cp;
        HashMap catMap = new HashMap();
        String params = solution.getParams();
        if (params == null || params.length() == 0) {
            return catMap;
        }
        try {
            cp = XmlTrans.TransStrToCustParams((String)solution.getParams());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HashMap assetCats = (HashMap)cp.get("CatMap");
        if (assetCats != null && assetCats.size() > 0) {
            return assetCats;
        }
        return catMap;
    }

    private void setResult(Map<String, Object> result, Map<String, Object> contrastMap, CompanyOrgUnitInfo companyInfo) {
        String currencyName = companyInfo.getBaseCurrency() != null ? companyInfo.getBaseCurrency().getName() : null;
        String[] detaiItemKeys = new String[]{"sumBegin_ASSET", "sumDebit_ASSET", "sumCredit_ASSET", "sumEnd_ASSET", "sumBegin_DEPRE", "sumDebit_DEPRE", "sumCredit_DEPRE", "sumEnd_DEPRE", "sumBegin_DECVALUE", "sumDebit_DECVALUE", "sumCredit_DECVALUE", "sumEnd_DECVALUE"};
        FaContrastCollection col = new FaContrastCollection();
        for (int i = 0; i < detaiItemKeys.length; ++i) {
            FaContrastEntry entry = new FaContrastEntry();
            BigDecimal assetSum = (BigDecimal)contrastMap.get(detaiItemKeys[i] + "_ASSET");
            BigDecimal glSum = (BigDecimal)contrastMap.get(detaiItemKeys[i] + "_GL");
            entry.setAssetSum(assetSum);
            entry.setGlSum(glSum);
            entry.calcDifferent();
            String itemKeyRes = null;
            String accountType = null;
            String aspectDC = this.getAspectDC(detaiItemKeys[i]);
            if (detaiItemKeys[i].endsWith("_ASSET")) {
                itemKeyRes = "FixedAssets_OriginalValue";
                accountType = "ASSET";
            } else if (detaiItemKeys[i].endsWith("_DEPRE")) {
                itemKeyRes = "Accu_Depreciation";
                accountType = "DEPRE";
            } else {
                itemKeyRes = "DecValue";
                accountType = "DECVALUE";
            }
            String detailItemNameRes = detaiItemKeys[i].substring(0, detaiItemKeys[i].indexOf("_"));
            entry.setCurrency(currencyName);
            entry.setItem(FaLocalUtils.getResource((Context)this.context, (String)FA_CONTRAST_RESOUSE, (String)itemKeyRes));
            entry.setDetailItemName(FaLocalUtils.getResource((Context)this.context, (String)FA_CONTRAST_RESOUSE, (String)detailItemNameRes));
            entry.setAccountNumber("Nothing");
            entry.setAccountType(accountType);
            entry.setAspectDC(aspectDC);
            entry.setFaCatNumber("noCat");
            entry.setCompanyId(companyInfo.getId().toString());
            entry.setPeriodYear(this.periodYear);
            entry.setPeriodNumber(this.periodNumber);
            entry.setIsUseCatNumber("false");
            entry.setIsUseCardAcct("false");
            entry.setFid(BOSUuid.create((String)"00000000").toString());
            entry.setIsIncludeUnposted(this.isIncludeUnposted);
            entry.setIsUseEvaValue(this.isUseEvaValue);
            col.add(entry);
        }
        result.put("rows", col.getList());
    }

    private String getAspectDC(String detaiItemKey) {
        if (detaiItemKey.indexOf("Begin") > 0) {
            return "sumBegin";
        }
        if (detaiItemKey.indexOf("Credit") > 0) {
            return "sumCredit";
        }
        if (detaiItemKey.indexOf("Debit") > 0) {
            return "sumDebit";
        }
        return "sumEnd";
    }

    private void setResultWithCat(Map<String, Object> result, Map<String, Object> contrastMap, CompanyOrgUnitInfo companyInfo) throws BOSException {
        String currencyName = companyInfo.getBaseCurrency() != null ? companyInfo.getBaseCurrency().getName() : null;
        Map accountMap = (Map)contrastMap.get("AccountMap");
        Map catMap = (Map)contrastMap.get("CatMap");
        String[] accountKeys = new String[]{"ASSET", "DEPRE", "DECVALUE"};
        HashMap<String, Object> accountFaCat = new HashMap<String, Object>();
        this.getAccountFaCatCol(accountFaCat, accountKeys, accountMap, catMap);
        AccountViewCollection accountCol = (AccountViewCollection)accountFaCat.get("accountCol");
        FaCatCollection catCol = (FaCatCollection)accountFaCat.get("catCol");
        String[] detailItemKeys = new String[]{"sumBegin", "sumDebit", "sumCredit", "sumEnd"};
        FaContrastCollection col = new FaContrastCollection();
        for (int i = 0; i < accountKeys.length; ++i) {
            String accountKey = accountKeys[i];
            Set keySet = ((Map)accountMap.get(accountKey)).keySet();
            List keyList = Arrays.asList((Object[])keySet.toArray());
            Collections.sort(keyList);
            ArrayList accountIdList = new ArrayList();
            for (int j = 0; j < keyList.size(); ++j) {
                accountIdList.add(((Map)accountMap.get(accountKey)).get(keyList.get(j)));
            }
            for (String accountId : accountIdList) {
                AccountViewInfo accountInfo = (AccountViewInfo)FaServerUtil.getInfoById((IObjectCollection)accountCol, accountId);
                Map catIdMap = (Map)catMap.get(accountKey + "_" + accountId);
                for (int k = 0; k < 4; ++k) {
                    FaContrastEntry entry = new FaContrastEntry();
                    StringBuffer item = new StringBuffer();
                    StringBuffer catNumber = new StringBuffer();
                    if (catIdMap != null) {
                        Iterator catIds = catIdMap.values().iterator();
                        while (catIds.hasNext()) {
                            FaCatInfo catInfo = (FaCatInfo)FaServerUtil.getInfoById((IObjectCollection)catCol, (String)catIds.next());
                            if (item.length() > 0) {
                                item.append(";");
                            }
                            item.append(catInfo.getNumber()).append("(").append(catInfo.getName()).append(")");
                            if (catNumber.length() > 0) {
                                catNumber.append(";");
                            }
                            catNumber.append(catInfo.getNumber());
                        }
                    }
                    item.append("\n").append(accountInfo.getNumber()).append("(").append(accountInfo.getLongName()).append(")");
                    entry.setFaCatNumber(catNumber.toString());
                    String assetSumKey = detailItemKeys[k] + "_" + accountKey + "_ASSET_" + accountInfo.getNumber();
                    String glSumKey = detailItemKeys[k] + "_GL_" + accountInfo.getNumber() + "_" + accountKey;
                    BigDecimal assetSum = (BigDecimal)contrastMap.get(assetSumKey);
                    BigDecimal glSum = (BigDecimal)contrastMap.get(glSumKey);
                    entry.setAssetSum(assetSum);
                    entry.setGlSum(glSum);
                    entry.calcDifferent();
                    entry.setCurrency(currencyName);
                    entry.setItem(item.toString());
                    entry.setDetailItemName(FaLocalUtils.getResource((Context)this.context, (String)FA_CONTRAST_RESOUSE, (String)detailItemKeys[k]));
                    entry.setAccountNumber(accountInfo.getNumber());
                    entry.setAccountType(accountKey);
                    entry.setAspectDC(detailItemKeys[k]);
                    entry.setCompanyId(companyInfo.getId().toString());
                    entry.setPeriodYear(this.periodYear);
                    entry.setPeriodNumber(this.periodNumber);
                    entry.setIsUseCatNumber("true");
                    entry.setIsUseCardAcct("false");
                    entry.setFid(BOSUuid.create((String)"00000000").toString());
                    entry.setIsIncludeUnposted(this.isIncludeUnposted);
                    entry.setIsUseEvaValue(this.isUseEvaValue);
                    col.add(entry);
                }
            }
        }
        result.put("rows", col.getList());
    }

    private void setResultWithCardAcct(Map<String, Object> result, Map<String, Object> contrastMap, CompanyOrgUnitInfo companyInfo) {
        String[] detailItemKeys = new String[]{"sumBegin", "sumDebit", "sumCredit", "sumEnd"};
        String[] itemKeys = new String[]{"ASSET", "DECVALUE", "DEPRE"};
        String currencyName = companyInfo.getBaseCurrency() != null ? companyInfo.getBaseCurrency().getName() : null;
        List accountList = (List)contrastMap.get("AccountMap");
        FaContrastCollection col = new FaContrastCollection();
        for (int i = 0; i < accountList.size(); ++i) {
            List accounts = (List)accountList.get(i);
            for (int j = 0; j < accounts.size(); ++j) {
                AccountViewInfo accountInfo = (AccountViewInfo)accounts.get(j);
                for (int k = 0; k < 4; ++k) {
                    FaContrastEntry entry = new FaContrastEntry();
                    String assetSumKey = itemKeys[i] + "_" + detailItemKeys[k] + "_ASSET_" + accountInfo.getNumber();
                    String glSumKey = itemKeys[i] + "_" + detailItemKeys[k] + "_GL_" + accountInfo.getNumber();
                    BigDecimal assetSum = (BigDecimal)contrastMap.get(assetSumKey);
                    BigDecimal glSum = (BigDecimal)contrastMap.get(glSumKey);
                    entry.setAssetSum(assetSum);
                    entry.setGlSum(glSum);
                    entry.calcDifferent();
                    entry.setCurrency(currencyName);
                    entry.setItem(accountInfo.getNumber() + "(" + accountInfo.getLongName() + ")");
                    entry.setDetailItemName(FaLocalUtils.getResource((Context)this.context, (String)FA_CONTRAST_RESOUSE, (String)detailItemKeys[k]));
                    entry.setAccountNumber(accountInfo.getNumber());
                    String accountType = null;
                    accountType = "DECVALUE".equals(itemKeys[i]) ? "DEPRE" : ("DEPRE".equals(itemKeys[i]) ? "DECVALUE" : "ASSET");
                    entry.setAccountType(accountType);
                    entry.setAspectDC(detailItemKeys[k]);
                    entry.setFaCatNumber("noCat");
                    entry.setCompanyId(companyInfo.getId().toString());
                    entry.setPeriodYear(this.periodYear);
                    entry.setPeriodNumber(this.periodNumber);
                    entry.setIsUseCatNumber("false");
                    entry.setIsUseCardAcct("true");
                    entry.setFid(BOSUuid.create((String)"00000000").toString());
                    entry.setIsIncludeUnposted(this.isIncludeUnposted);
                    entry.setIsUseEvaValue(this.isUseEvaValue);
                    col.add(entry);
                }
            }
        }
        result.put("rows", col.getList());
    }

    private void getAccountFaCatCol(Map<String, Object> accountFaCat, String[] accountKeys, Map<String, Map<String, String>> accountMap, Map<String, Map<String, String>> catMap) throws BOSException {
        StringBuffer accountIdStr = new StringBuffer("'null'");
        StringBuffer catIdStr = new StringBuffer("'null'");
        for (int i = 0; i < accountKeys.length; ++i) {
            String accountKey = accountKeys[i];
            for (String accountId : accountMap.get(accountKey).values()) {
                accountIdStr.append(",'").append(accountId).append("' ");
                Map<String, String> catIdMap = catMap.get(accountKey + "_" + accountId);
                if (catIdMap == null) continue;
                Iterator<String> catIds = catIdMap.values().iterator();
                while (catIds.hasNext()) {
                    catIdStr.append(",'").append(catIds.next()).append("' ");
                }
            }
        }
        String accountQql = "select number,name,longname where id in (" + accountIdStr + ") ";
        AccountViewCollection accountCol = AccountViewFactory.getLocalInstance((Context)this.context).getAccountViewCollection(accountQql);
        String catOql = "select number,name where id in (" + catIdStr + ") ";
        FaCatCollection catCol = FaCatFactory.getLocalInstance((Context)this.context).getFaCatCollection(catOql);
        accountFaCat.put("accountCol", accountCol);
        accountFaCat.put("catCol", catCol);
    }
}

