/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.periodclose;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.abs.AbstractPeriodCloseValidateBase;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaBooksPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaChangeBillPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaClearbillPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaCombinBillPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaContrastPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaCurCardPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaDecValuePeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaDepreciationPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaDispatchBillPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaEvaluateBillPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaLeaseBalancePeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaLeaseBillPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaLeaseInBillPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaMaintainPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaMortagBillPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaSplitBillPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaStocktakingBillPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaStocktakingPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.FaStocktakingTaskPeriodCloseValidateImpl;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.HasCheckOutFunctionPermission;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.HasNextPeriod;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.Init;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.IsPeriodNull;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl.MonthEnd;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.vo.PeriodCloseValidateCheckParam;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.vo.PeriodCloseValidateResult;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseBatchFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.IFaPeriodCloseBatchFacade;
import com.kingdee.eas.fi.fa.manage.IFaPeriodCloseFacade;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FaFinalCheckOutServiceImpl {
    private Context ctx = null;
    private Object comIdList;
    private static String FA_MUTEX_LOCK = "FI_FA_Mutex_Lock";

    public FaFinalCheckOutServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    public Map<String, Object> getShowData() throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List dataList = new ArrayList();
        dataList = this.getFacade().getInitData();
        ArrayList loadData = new ArrayList();
        if (dataList != null && dataList.size() > 0) {
            for (int i = 0; i < dataList.size(); ++i) {
                Map recordMap = (Map)dataList.get(i);
                if (!SystemStatusCtrolUtils.isStart((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)recordMap.get("id").toString())))) continue;
                HashMap row = new HashMap();
                row.put("id", recordMap.get("id"));
                row.put("companyId", recordMap.get("id"));
                row.put("number", recordMap.get("number"));
                row.put("orgName", recordMap.get("name"));
                row.put("curPeriod", recordMap.get("curPeriod"));
                loadData.add(row);
            }
            result.put("onloadData", loadData);
        }
        return result;
    }

    private IFaPeriodCloseBatchFacade getFacade() throws BOSException {
        return FaPeriodCloseBatchFacadeFactory.getLocalInstance((Context)this.ctx);
    }

    public Map<String, Object> checkout(String companyIDs) throws BOSException, EASBizException {
        List comIdList = this.buildComIDListByRquestComIdStr(companyIDs);
        HashMap companyWorkResultMap = new HashMap();
        ArrayList companyIds = new ArrayList();
        this.checkOutHandle(comIdList, companyWorkResultMap, companyIds);
        Map<String, Object> result = this.queryCheckOutDataByRequestComIdStr(companyWorkResultMap, companyIds, comIdList);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOutHandle(List comIdList, Map companyWorkResultMap, List companyIds) throws BOSException, EASBizException {
        ICompanyOrgUnit comOrg = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
        IFaPeriodCloseFacade periodClose = FaPeriodCloseFacadeFactory.getLocalInstance((Context)this.ctx);
        List<PeriodCloseValidateResult> list = null;
        for (int i = 0; i < comIdList.size(); ++i) {
            String comId = (String)comIdList.get(i);
            CompanyOrgUnitInfo currCompany = comOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(comId));
            Uuid mutexUuid = Uuid.create();
            try {
                list = this.checkOutHandleProcessPerOrg(periodClose, list, currCompany, mutexUuid);
                continue;
            }
            catch (Exception ex) {
                list = this.checkOutUnThinkExeptionHandle(ex);
                continue;
            }
            finally {
                this.checkOutExcetionFinalHandle(companyWorkResultMap, companyIds, list, comId, mutexUuid);
            }
        }
    }

    private List<PeriodCloseValidateResult> checkOutHandleProcessPerOrg(IFaPeriodCloseFacade periodClose, List<PeriodCloseValidateResult> list, CompanyOrgUnitInfo currCompany, Uuid mutexUuid) throws EASBizException, BOSException, Exception {
        if (this.requestMutexHandle(currCompany, mutexUuid)) {
            list = this.checkBeforePeriodClose(currCompany);
            if (list.size() == 0) {
                periodClose.periodCloseHandle(currCompany);
            }
        } else {
            throw new Exception(FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"Fa_Mutex_Is_InProcess"));
        }
        return list;
    }

    private boolean requestMutexHandle(CompanyOrgUnitInfo currCompany, Uuid mutexUuid) throws EASBizException, BOSException {
        MutexParameter mutexParam = FaFinalCheckOutServiceImpl.setMutexParameter(mutexUuid, "checkout", currCompany, this.ctx);
        return FaFinalCheckOutServiceImpl.requestMutex(mutexParam, this.ctx);
    }

    private void checkOutExcetionFinalHandle(Map companyWorkResultMap, List companyIds, List<PeriodCloseValidateResult> list, String comId, Uuid mutexUuid) {
        try {
            companyIds.add(comId);
            companyWorkResultMap.put(comId, list);
            FaFinalCheckOutServiceImpl.releaseMutex(mutexUuid, this.ctx);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    private List<PeriodCloseValidateResult> checkOutUnThinkExeptionHandle(Exception ex) {
        ArrayList<PeriodCloseValidateResult> list = new ArrayList<PeriodCloseValidateResult>();
        PeriodCloseValidateResult PeriodCloseValidateResult2 = new PeriodCloseValidateResult(ex.getMessage(), null, false);
        list.add(PeriodCloseValidateResult2);
        return list;
    }

    private List<PeriodCloseValidateResult> checkBeforePeriodClose(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        ArrayList<PeriodCloseValidateResult> resultList = new ArrayList<PeriodCloseValidateResult>();
        PeriodCloseValidateCheckParam periodCloseValidateCheckParam = this.getParamForPeriodCloseCheck(company);
        List<AbstractPeriodCloseValidateBase> checkList = this.getPeriodCheckHandleSet();
        for (AbstractPeriodCloseValidateBase periodCloseValidate : checkList) {
            PeriodCloseValidateResult periodCloseValidateResult = periodCloseValidate.validate(this.ctx, periodCloseValidateCheckParam);
            this.removeSuccesCheckResult(resultList, periodCloseValidateResult);
        }
        return resultList;
    }

    private void removeSuccesCheckResult(List<PeriodCloseValidateResult> resultList, PeriodCloseValidateResult periodCloseValidateResult) {
        if (!periodCloseValidateResult.isHasPassValidate()) {
            resultList.add(periodCloseValidateResult);
        }
    }

    private List<AbstractPeriodCloseValidateBase> getPeriodCheckHandleSet() {
        ArrayList<AbstractPeriodCloseValidateBase> list = new ArrayList<AbstractPeriodCloseValidateBase>();
        list.add(new HasCheckOutFunctionPermission());
        list.add(new MonthEnd());
        list.add(new IsPeriodNull());
        list.add(new Init());
        list.add(new HasNextPeriod());
        list.add(new FaCurCardPeriodCloseValidateImpl());
        list.add(new FaChangeBillPeriodCloseValidateImpl());
        list.add(new FaClearbillPeriodCloseValidateImpl());
        list.add(new FaSplitBillPeriodCloseValidateImpl());
        list.add(new FaCombinBillPeriodCloseValidateImpl());
        list.add(new FaDispatchBillPeriodCloseValidateImpl());
        list.add(new FaEvaluateBillPeriodCloseValidateImpl());
        list.add(new FaMortagBillPeriodCloseValidateImpl());
        list.add(new FaMaintainPeriodCloseValidateImpl());
        list.add(new FaLeaseInBillPeriodCloseValidateImpl());
        list.add(new FaLeaseBillPeriodCloseValidateImpl());
        list.add(new FaLeaseBalancePeriodCloseValidateImpl());
        list.add(new FaStocktakingTaskPeriodCloseValidateImpl());
        list.add(new FaStocktakingBillPeriodCloseValidateImpl());
        list.add(new FaStocktakingPeriodCloseValidateImpl());
        list.add(new FaDecValuePeriodCloseValidateImpl());
        list.add(new FaDepreciationPeriodCloseValidateImpl());
        list.add(new FaContrastPeriodCloseValidateImpl());
        list.add(new FaBooksPeriodCloseValidateImpl());
        return list;
    }

    private PeriodCloseValidateCheckParam getParamForPeriodCloseCheck(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        PeriodInfo period = this.getCurrentPeriod(this.ctx, company.getId().toString());
        HashMap<String, Boolean> periodCloseControlParamHM = this.getControlParamForPeriodCloseCheck(company);
        PeriodCloseValidateCheckParam periodCloseValidateCheckParam = new PeriodCloseValidateCheckParam(company, period, periodCloseControlParamHM);
        return periodCloseValidateCheckParam;
    }

    private HashMap<String, Boolean> getControlParamForPeriodCloseCheck(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        boolean isRelAccount;
        HashMap hmPara = this.gethmParam(this.ctx, company);
        boolean isCheckVoucher = isRelAccount = SystemStatusCtrolUtils.isRelAccount((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)company);
        boolean isCheckDep = true;
        boolean isCheckGL = isRelAccount;
        if (hmPara != null) {
            String checkGL;
            String checkDep;
            String checkVoucher = (String)hmPara.get("FA_006");
            if (checkVoucher != null && checkVoucher.trim().length() > 0) {
                boolean bl = isCheckVoucher = Boolean.valueOf(checkVoucher.trim()) != false && isRelAccount;
            }
            if ((checkDep = (String)hmPara.get("FA_005")) != null && checkDep.trim().length() > 0) {
                isCheckDep = Boolean.valueOf(checkDep.trim());
            }
            if ((checkGL = (String)hmPara.get("FA_004")) != null && checkGL.trim().length() > 0) {
                boolean bl = isCheckGL = Boolean.valueOf(checkGL.trim()) != false && isRelAccount;
            }
        }
        if (this.getCurrentPeriod(this.ctx, company.getId().toString()).isIsAdjustPeriod()) {
            isCheckDep = false;
        }
        boolean allowPassPeriodAudit = hmPara.get("FA_022") == null ? false : Boolean.valueOf(hmPara.get("FA_022").toString());
        HashMap<String, Boolean> paramHM = new HashMap<String, Boolean>();
        paramHM.put("allowPassPeriodAudit", allowPassPeriodAudit);
        paramHM.put("isCheckVoucher", isCheckVoucher);
        paramHM.put("isCheckDep", isCheckDep);
        paramHM.put("isCheckGL", isCheckGL);
        return paramHM;
    }

    private PeriodInfo getNextPeriod(Context ctx, String companyId) throws BOSException, EASBizException {
        return PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)this.getCurrentPeriod(ctx, companyId));
    }

    private PeriodInfo getCurrentPeriod(Context ctx, String companyId) throws BOSException, EASBizException {
        return FaDepLocalUtils.getCurrentPeriod((Context)ctx, (String)companyId);
    }

    private String getResource(Context ctx, String s1, String s2) {
        Locale l = ctx.getLocale();
        return ResourceBase.getString((String)s1, (String)s2, (Locale)l);
    }

    private HashMap gethmParam(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashMap hmParam = null;
        ObjectUuidPK pk = new ObjectUuidPK(company.getId());
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("FA_004", pk);
        paramKeyMap.put("FA_005", pk);
        paramKeyMap.put("FA_006", pk);
        paramKeyMap.put("FA_022", pk);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        hmParam = iParamControl.getParamHashMap(paramKeyMap);
        return hmParam;
    }

    private Map<String, Object> queryCheckOutDataByRequestComIdStr(Map companyWorkResultMap, List companyIds, List comIdList) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map periodIds = new HashMap();
        periodIds = this.getFacade().getperiodList(companyIds);
        List dataList = this.getFacade().getInitData();
        ArrayList<Map<String, Object>> loadData = new ArrayList<Map<String, Object>>();
        if (dataList != null && dataList.size() > 0) {
            for (int i = 0; i < dataList.size(); ++i) {
                Map recordMap = (Map)dataList.get(i);
                if (!comIdList.contains(recordMap.get("id"))) continue;
                HashMap row = new HashMap();
                row.put("id", recordMap.get("id"));
                row.put("companyId", recordMap.get("id"));
                row.put("orgName", recordMap.get("name"));
                if (periodIds.containsKey(recordMap.get("id"))) {
                    row.put("curPeriod", periodIds.get(recordMap.get("id")));
                } else {
                    row.put("curPeriod", recordMap.get("curPeriod"));
                }
                row.put("handleResult", "");
                row.put("isPassPeriodCloseOrgInfo", "true");
                if (companyWorkResultMap.containsKey(recordMap.get("id"))) {
                    row.put("hasPassPeriodCloseCheck", "false");
                    loadData.add(row);
                    this.addCheckHandleResultToGrid(recordMap.get("id").toString(), companyWorkResultMap, loadData);
                    continue;
                }
                row.put("hasPassPeriodCloseCheck", "true");
                loadData.add(row);
            }
            result.put("onloadData", loadData);
        }
        return result;
    }

    private void addCheckHandleResultToGrid(String orgID, Map companyWorkResultMap, List<Map<String, Object>> loadData) {
        ArrayList list = (ArrayList)companyWorkResultMap.get(orgID);
        int i = 1;
        for (PeriodCloseValidateResult validateRst : list) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("id", orgID + i);
            row.put("orgName", validateRst.getMessage());
            row.put("curPeriod", "");
            row.put("url", validateRst.getUrl());
            row.put("isPassPeriodCloseOrgInfo", "false");
            row.put("handleResult", "checkDetailContent");
            loadData.add(row);
            ++i;
        }
    }

    private List buildComIDListByRquestComIdStr(String companyIDs) {
        String[] comIdArrays;
        ArrayList<String> comIdList = new ArrayList<String>();
        for (String comId : comIdArrays = companyIDs.split(",")) {
            comIdList.add(comId);
        }
        return comIdList;
    }

    public static boolean requestMutex(MutexParameter param, Context ctx) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        return mutexService.requestMutex(param);
    }

    protected String buildSumText(CompanyOrgUnitInfo currCompany, PeriodInfo period, int sumType) throws Exception {
        int scale = FaFinalCheckOutServiceImpl.getCurrencyScale(currCompany.getBaseCurrency().getId(), this.ctx);
        StringBuffer sb = new StringBuffer();
        HashMap sumValue = FaPeriodCloseFacadeFactory.getLocalInstance((Context)this.ctx).getFASum(currCompany.getId().toString(), period.getId().toString(), sumType);
        DecimalFormat format = new DecimalFormat(FaFinalCheckOutServiceImpl.getFormatPattern(scale));
        sb.append(period.getPeriodYear() + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"yearNo") + period.getPeriodNumber() + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"period") + (sumType == 1 ? FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"periodBegin") : FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"periodEnd")) + "\n");
        sb.append(FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"assetValueSum") + ":" + format.format(((BigDecimal)sumValue.get("real")).setScale(scale, 4)) + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"yuan") + ", ");
        sb.append(FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"deprValueSum") + ":" + format.format(((BigDecimal)sumValue.get("depr")).setScale(scale, 4)) + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"yuan"));
        return sb.toString();
    }

    public static String getFormatPattern(int scale) {
        String pattern = null;
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        return pattern;
    }

    public static MutexParameter setMutexParameter(Uuid uuid, String actionName, CompanyOrgUnitInfo currentCompanyInfo, Context ctx) {
        MutexParameter param = new MutexParameter();
        param.setRequestId(uuid);
        param.setMutexName(FA_MUTEX_LOCK);
        param.setActionName(actionName);
        param.setUserID(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        param.setOrgUnitID(currentCompanyInfo.getId());
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        param.setDcName(ContextUtil.getDbType((Context)ctx));
        return param;
    }

    public static void releaseMutex(Uuid id, Context ctx) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexService.releaseMutex(id);
    }

    public static int getCurrencyScale(BOSUuid currencyID, Context ctx) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("precision"));
        ObjectUuidPK pk = new ObjectUuidPK(currencyID);
        CurrencyInfo currencyInfo = ctx == null ? CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)pk, sic) : CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)pk, sic);
        return currencyInfo == null ? 2 : currencyInfo.getPrecision();
    }

    public Map<String, Object> unCheckout(String companyIDs) throws EASBizException, BOSException {
        List comIdList = this.buildComIDListByRquestComIdStr(companyIDs);
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> uncheckResultMsMap = this.unCheckWithReturn(comIdList);
        this.buildResultInfo(uncheckResultMsMap, result, comIdList);
        return result;
    }

    private void buildResultInfo(Map<String, Object> uncheckResultMsMap, Map<String, Object> result, List comIdList) throws EASBizException, BOSException {
        List dataList = new ArrayList();
        dataList = this.getFacade().getInitData();
        ArrayList<Map<String, Object>> loadData = new ArrayList<Map<String, Object>>();
        if (dataList != null && dataList.size() > 0) {
            for (int j = 0; j < dataList.size(); ++j) {
                Map recordMap = (Map)dataList.get(j);
                if (!comIdList.contains(recordMap.get("id"))) continue;
                HashMap row = new HashMap();
                row.put("id", recordMap.get("id"));
                row.put("companyId", recordMap.get("id"));
                row.put("orgName", recordMap.get("name"));
                row.put("curPeriod", recordMap.get("curPeriod"));
                row.put("handleResult", "");
                row.put("isPassPeriodCloseOrgInfo", "true");
                if (uncheckResultMsMap.containsKey(recordMap.get("id"))) {
                    row.put("hasPassPeriodCloseCheck", "false");
                    loadData.add(row);
                    this.addPrompInfo(uncheckResultMsMap, loadData, recordMap);
                    continue;
                }
                row.put("hasPassPeriodCloseCheck", "true");
                loadData.add(row);
            }
            result.put("onloadData", loadData);
        }
    }

    private void addPrompInfo(Map<String, Object> uncheckResultMsMap, List<Map<String, Object>> loadData, Map recordMap) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("id", recordMap.get("id") + "1");
        row.put("orgName", uncheckResultMsMap.get(recordMap.get("id")));
        row.put("curPeriod", "");
        row.put("url", "");
        row.put("isPassPeriodCloseOrgInfo", "false");
        row.put("handleResult", "checkDetailContent");
        loadData.add(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> unCheckWithReturn(List comIdList) throws EASBizException, BOSException {
        HashMap<String, Object> uncheckResultMsMap = new HashMap<String, Object>();
        for (int i = 0; i < comIdList.size(); ++i) {
            String companyID = (String)comIdList.get(i);
            String msg = "";
            Uuid mutexUuid = Uuid.create();
            try {
                String mutexActionName = "checkout";
                CompanyOrgUnitInfo currCompany = null;
                ICompanyOrgUnit comOrg = null;
                comOrg = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
                currCompany = comOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
                MutexParameter mutexParam = FaFinalCheckOutServiceImpl.setMutexParameter(mutexUuid, mutexActionName, currCompany, this.ctx);
                if (FaFinalCheckOutServiceImpl.requestMutex(mutexParam, this.ctx)) {
                    IFaPeriodCloseFacade periodClose = FaPeriodCloseFacadeFactory.getLocalInstance((Context)this.ctx);
                    PeriodInfo period = periodClose.carrayBack(companyID);
                    msg = msg + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"backSuccess") + "\n";
                    msg = msg + FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"currentPeriod") + MessageFormat.format(FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"displayPeriod"), Integer.toString(period.getPeriodYear()), Integer.toString(period.getPeriodNumber()));
                    continue;
                }
                msg = FaLocalUtils.getResource((Context)this.ctx, (String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"Fa_Mutex_Is_InProcess");
                uncheckResultMsMap.put(companyID, msg);
                continue;
            }
            catch (Exception exception) {
                msg = exception.getMessage();
                uncheckResultMsMap.put(companyID, msg.substring(msg.indexOf(":") + 1, msg.length()));
                continue;
            }
            finally {
                FaFinalCheckOutServiceImpl.releaseMutex(mutexUuid, this.ctx);
            }
        }
        return uncheckResultMsMap;
    }
}

