/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.abs.AbstractPeriodCloseValidateBase;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.vo.PeriodCloseValidateCheckParam;
import com.kingdee.eas.fi.fa.manage.FaChangeBillCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaChangeBill;
import com.kingdee.eas.fi.fa.manage.IFaChangeBillEntry;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.periodclose.FaChangeBillCheckBeforePeriodClose;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class FaChangeBillPeriodCloseValidateImpl
extends AbstractPeriodCloseValidateBase {
    private StringBuffer url = new StringBuffer();

    @Override
    protected String setNoteUrl() {
        return this.url.toString();
    }

    private String getUIPK() {
        return "com.kingdee.eas.fi.fa.FaChangeBillListUI";
    }

    @Override
    protected void validateHandle(Context ctx, PeriodCloseValidateCheckParam periodCloseValidateCheckParam) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = periodCloseValidateCheckParam.getCompany();
        PeriodInfo period = periodCloseValidateCheckParam.getPeriod();
        HashMap<String, Boolean> hmParam = periodCloseValidateCheckParam.getHmPara();
        boolean isCheckVoucher = hmParam.get("isCheckVoucher");
        this.hasChangeCard(ctx, company, period, isCheckVoucher);
    }

    private void hasChangeCard(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, boolean notGenVoucher) throws BOSException, EASBizException {
        FaChangeBillCollection c;
        IFaChangeBill ichange = FaChangeBillFactory.getLocalInstance((Context)ctx);
        Date beginDate = DateTimeUtils.truncateDate((Date)period.getBeginDate());
        Date endDate = DateTimeUtils.truncateDate((Date)period.getEndDate());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        calendar.add(5, 1);
        endDate = calendar.getTime();
        PeriodInfo adjPeriod = PeriodUtils.getAdjPeriodInfo((Context)ctx, (PeriodInfo)period);
        boolean hasNotAudit = FaChangeBillCheckBeforePeriodClose.hasFaChangeBillNotAudit((Context)ctx, (CompanyOrgUnitInfo)company, (PeriodInfo)period, (PeriodInfo)adjPeriod, (Date)beginDate, (Date)endDate);
        if (hasNotAudit) {
            this.setWebLinkUrl(company.getId().toString(), period.getId().toString(), "noAudit");
            throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_HasChange_NoAudit")));
        }
        if (notGenVoucher && (c = ichange.getFaChangeBillCollection(FaChangeBillCheckBeforePeriodClose.getNeedVoucherView((Context)ctx, (CompanyOrgUnitInfo)company, (PeriodInfo)period, (PeriodInfo)adjPeriod, (Date)beginDate, (Date)endDate))).size() > 0) {
            HashSet<String> changeId = new HashSet<String>();
            for (int i = 0; i < c.size(); ++i) {
                FaChangeBillInfo changeInfo = c.get(i);
                changeId.add(changeInfo.getId().toString());
            }
            FilterInfo filter = new FilterInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("originChg", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("accuDeprChg", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("decValueChg", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("changeBill", changeId, CompareType.INCLUDE));
            String mask = "(#0 or #1 or #2) and #3";
            filter.setMaskString(mask);
            IFaChangeBillEntry changeEntry = FaChangeBillEntryFactory.getLocalInstance((Context)ctx);
            boolean hasVoucher = changeEntry.exists(filter);
            if (hasVoucher) {
                this.setWebLinkUrl(company.getId().toString(), period.getId().toString(), "noVoucher");
                throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_HasChange_NoVoucher")));
            }
            this.hasDepartChangeNeedVoucher(ctx, company, period, changeId);
        }
    }

    private void hasDepartChangeNeedVoucher(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, Set changeId) throws BOSException, EASBizException {
        IFaChangeBill ichange = FaChangeBillFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hasDepartmentChanged", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)changeId, CompareType.INCLUDE));
        boolean hasDepartChangeNeedVoucher = ichange.exists(filter);
        HashMap map = FaManageUtils.getFAParameter((Context)ctx, (String[])new String[]{"FA_039"}, (String)company.getId().toString());
        boolean departChangeNeedVoucher = false;
        if (map != null && map.get("FA_039") != null && map.get("FA_039").toString().equals("true")) {
            departChangeNeedVoucher = true;
        }
        if (hasDepartChangeNeedVoucher && departChangeNeedVoucher) {
            this.setWebLinkUrl(company.getId().toString(), period.getId().toString(), "noVoucher");
            throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"96_FaPeriodCloseFacadeControllerBean", (Locale)ctx.getOriginLocale())));
        }
    }

    private void setWebLinkUrl(String companyId, String periodId, String validateResult) {
        this.url = new StringBuffer();
        this.url.append("&uipk=").append(this.getUIPK());
        if ("noAudit".equals(validateResult)) {
            this.url.append("&companyId=").append(companyId).append("&periodId=").append(periodId).append("&checkedStatus=1");
        } else if ("noVoucher".equals(validateResult)) {
            this.url.append("&companyId=").append(companyId).append("&periodId=").append(periodId).append("&noVoucher=true");
        }
    }
}

