/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.abs.AbstractPeriodCloseValidateBase;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.vo.PeriodCloseValidateCheckParam;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaClearBillEntry;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.HashMap;

public class FaClearbillPeriodCloseValidateImpl
extends AbstractPeriodCloseValidateBase {
    private StringBuffer url = new StringBuffer();

    @Override
    protected String setNoteUrl() {
        return this.url.toString();
    }

    private String getUIPK() {
        return "com.kingdee.eas.fi.fa.FaClearBillListUI";
    }

    @Override
    protected void validateHandle(Context ctx, PeriodCloseValidateCheckParam periodCloseValidateCheckParam) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = periodCloseValidateCheckParam.getCompany();
        PeriodInfo period = periodCloseValidateCheckParam.getPeriod();
        HashMap<String, Boolean> hmParam = periodCloseValidateCheckParam.getHmPara();
        boolean isCheckVoucher = hmParam.get("isCheckVoucher");
        this.hasCleanCard(ctx, company, period, isCheckVoucher);
    }

    private void hasCleanCard(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, boolean notGenVoucher) throws BOSException, EASBizException {
        IFaClearBillEntry iclean = FaClearBillEntryFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entry.period.id", (Object)period.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("entry.company.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("entry.checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        boolean hasNotAudit = iclean.exists(filter);
        if (hasNotAudit) {
            this.setWebLinkUrl(company.getId().toString(), period.getId().toString(), "noAudit");
            throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_HasClean_NoAudit")));
        }
        if (notGenVoucher) {
            String mask;
            filter.getFilterItems().add(new FilterItemInfo("entry.fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("curCard.assetValue", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            HashMap hmParam = FaManageUtils.getFAParameter((BOSUuid)company.getId(), (Context)ctx);
            boolean isSplitOrCombineNoVourcher = "true".equals(hmParam.get("FA_048").toString());
            if (isSplitOrCombineNoVourcher) {
                filter.getFilterItems().add(new FilterItemInfo("entry.billtype", (Object)"1000", CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("entry.billtype", (Object)"2000", CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("entry.billtype", null, CompareType.EQUALS));
                mask = "#0 and #1 and (#2 or #3) and #4 and ((#5 and #6) or #7)";
                filter.setMaskString(mask);
            } else {
                mask = "#0 and #1 and (#2 or #3) and #4";
                filter.setMaskString(mask);
            }
            boolean hasVoucher = iclean.exists(filter);
            if (hasVoucher) {
                this.setWebLinkUrl(company.getId().toString(), period.getId().toString(), "noVoucher");
                throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_HasClean_NoVoucher")));
            }
        }
    }

    private void setWebLinkUrl(String companyId, String periodId, String validateResult) {
        this.url = new StringBuffer();
        this.url.append("&uipk=").append(this.getUIPK());
        if ("noAudit".equals(validateResult)) {
            this.url.append("&companyId=").append(companyId).append("&periodId=").append(periodId).append("&checkedStatus=1");
        } else if ("noVoucher".equals(validateResult)) {
            this.url.append("&companyId=").append(companyId).append("&periodId=").append(periodId).append("&noVoucher=true");
        }
    }
}

