/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.abs.AbstractPeriodCloseValidateBase;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.vo.PeriodCloseValidateCheckParam;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;

public class FaCurCardPeriodCloseValidateImpl
extends AbstractPeriodCloseValidateBase {
    private StringBuffer url = new StringBuffer();

    @Override
    protected String setNoteUrl() {
        return this.url.toString();
    }

    private String getUIPK() {
        return "com.kingdee.eas.fi.fa.FaCurCardListUI";
    }

    @Override
    protected void validateHandle(Context ctx, PeriodCloseValidateCheckParam periodCloseValidateCheckParam) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = periodCloseValidateCheckParam.getCompany();
        PeriodInfo period = periodCloseValidateCheckParam.getPeriod();
        HashMap<String, Boolean> hmParam = periodCloseValidateCheckParam.getHmPara();
        boolean isCheckVoucher = hmParam.get("isCheckVoucher");
        boolean allowPassPeriodAudit = hmParam.get("allowPassPeriodAudit");
        if (company == null || period == null) {
            throw new BOSException("company is null or period is null");
        }
        this.hasNewCard(ctx, company, period, isCheckVoucher, allowPassPeriodAudit);
        if (this.hasNeedAuditPassPeriodCard(ctx, company, period, allowPassPeriodAudit)) {
            this.setWebLinkUrl(company.getId().toString(), period.getId().toString(), "noAuditPassPeriod");
            throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_HasPassPeriodNeedAuditCard")));
        }
    }

    private void setWebLinkUrl(String companyId, String periodId, String validateResult) {
        this.url = new StringBuffer();
        this.url.append("&uipk=").append(this.getUIPK());
        if ("noAudit".equals(validateResult)) {
            this.url.append("&companyId=").append(companyId).append("&periodId=").append(periodId).append("&checkedStatus=1");
        } else if ("noVoucher".equals(validateResult)) {
            this.url.append("&companyId=").append(companyId).append("&periodId=").append(periodId).append("&noVoucher=true");
        } else if ("noAuditPassPeriod".equals(validateResult)) {
            this.url.append("&companyId=").append(companyId).append("&periodId!=").append(periodId).append("&checkedStatus=1");
        }
    }

    private void hasNewCard(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, boolean notGenVoucher, boolean allowPassPeriodAudit) throws BOSException, EASBizException {
        boolean hasNotAudit;
        IFaCurCard icard = FaCurCardFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        if (allowPassPeriodAudit) {
            filter.getFilterItems().add(new FilterItemInfo("fiAccountDate", null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId(), CompareType.EQUALS));
        }
        if (hasNotAudit = icard.exists(filter)) {
            this.setWebLinkUrl(company.getId().toString(), period.getId().toString(), "noAudit");
            throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_HasNewCard_NoAudit")));
        }
        if (notGenVoucher) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2)));
            filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("originFlag", (Object)new Integer(0), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("originFlag", (Object)new Integer(6), CompareType.NOTEQUALS));
            HashMap hmParam = FaManageUtils.getFAParameter((Context)ctx, (String[])new String[]{"FA_048"}, (String)company.getId().toString());
            boolean isSplitOrCombineNoVourcher = "true".equals(hmParam.get("FA_048").toString());
            if (isSplitOrCombineNoVourcher) {
                filter.getFilterItems().add(new FilterItemInfo("originFlag", (Object)new Integer(2), CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("originFlag", (Object)new Integer(3), CompareType.NOTEQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("assetValue", (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
            boolean hasVoucher = icard.exists(filter);
            if (hasVoucher) {
                this.setWebLinkUrl(company.getId().toString(), period.getId().toString(), "noVoucher");
                throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_HasNewCard_NoVoucher")));
            }
        }
    }

    private boolean hasNeedAuditPassPeriodCard(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, boolean allowPassPeriodAudit) throws BOSException, EASBizException {
        IFaCurCard icard = FaCurCardFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId().toString(), CompareType.NOTEQUALS));
        HashSet laterPeriods = FaLocalUtils.getLaterPeriodIdSet((Context)ctx, (String)period.getId().toString());
        if (laterPeriods.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)laterPeriods, CompareType.NOTINCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId(), CompareType.EQUALS));
        if (allowPassPeriodAudit) {
            filter.getFilterItems().add(new FilterItemInfo("fiAccountDate", null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)period.getId(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        return icard.exists(filter);
    }
}

