/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.abs.AbstractPeriodCloseValidateBase;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.vo.PeriodCloseValidateCheckParam;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepCalcForCoalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.IFaDepCalFacade;
import com.kingdee.eas.fi.fa.manage.IFaDepCalcForCoalFacade;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepORMapping;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.periodclose.FaDepreciationCheckBeforePeriodClose;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;

public class FaDepreciationPeriodCloseValidateImpl
extends AbstractPeriodCloseValidateBase {
    private StringBuffer url = new StringBuffer();
    private String companyId = "";
    private String periodId = "";

    @Override
    protected String setNoteUrl() {
        this.url = new StringBuffer();
        this.url.append("&uipk=").append(this.getUIPK()).append("&companyId=").append(this.companyId).append("&periodId=").append(this.periodId);
        return this.url.toString();
    }

    private String getUIPK() {
        return "com.kingdee.eas.fi.fa.FaDepCalUIView";
    }

    @Override
    protected void validateHandle(Context ctx, PeriodCloseValidateCheckParam periodCloseValidateCheckParam) throws BOSException, EASBizException {
        boolean needReDep;
        FaCurCardCollection card;
        CompanyOrgUnitInfo company = periodCloseValidateCheckParam.getCompany();
        this.companyId = company.getId().toString();
        PeriodInfo period = periodCloseValidateCheckParam.getPeriod();
        this.periodId = period.getId().toString();
        HashMap<String, Boolean> hmParam = periodCloseValidateCheckParam.getHmPara();
        boolean isCheckDep = hmParam.get("isCheckDep");
        boolean isCheckVoucher = hmParam.get("isCheckVoucher");
        IFaDepCalFacade depCal = FaDepCalFacadeFactory.getLocalInstance((Context)ctx);
        boolean hasDep = false;
        if (isCheckDep && !(hasDep = FaDepLocalUtils.ifAlreadyCal((Context)ctx, (PeriodInfo)period, (String)company.getId().toString())) && (card = depCal.getDepCardCollection(company)).size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_NoDep")));
        }
        if (FaDepreciationCheckBeforePeriodClose.hasCleanNDepre((Context)ctx, (CompanyOrgUnitInfo)company, (PeriodInfo)period)) {
            throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_HasCleanNDepre")));
        }
        if (isCheckDep && hasDep && (needReDep = FaDepreciationCheckBeforePeriodClose.hasNeedRedoDep((Context)ctx, (CompanyOrgUnitInfo)company, (PeriodInfo)period))) {
            throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_NeedReDep")));
        }
        boolean hasNoAudit = FaDepORMapping.hasNoAudit((Context)ctx, (int)period.getPeriodYear(), (int)period.getPeriodNumber(), (String)company.getId().toString());
        if (hasNoAudit) {
            throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_NoAudit") + "," + FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepCal_DoAction")));
        }
        if (isCheckVoucher) {
            boolean depGenFv;
            IFaDepCalcForCoalFacade depForCoalFacade = FaDepCalcForCoalFacadeFactory.getLocalInstance((Context)ctx);
            boolean hasDep_Coal = depForCoalFacade.checkBeforePeriodForward(company.getId().toString());
            if ((hasDep || hasDep_Coal) && !(depGenFv = FaDepLocalUtils.ifDepGenFV((Context)ctx, (PeriodInfo)period, (String)company.getId().toString()))) {
                throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_DepNotGenFV")));
            }
        }
    }
}

