/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.abs.AbstractPeriodCloseValidateBase;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.vo.PeriodCloseValidateCheckParam;
import com.kingdee.eas.fi.fa.manage.FaLeaseBalanceEntryFactory;
import com.kingdee.eas.fi.fa.manage.IFaLeaseBalanceEntry;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;

public class FaLeaseBalancePeriodCloseValidateImpl
extends AbstractPeriodCloseValidateBase {
    private StringBuffer url = new StringBuffer();

    @Override
    protected String setNoteUrl() {
        return this.url.toString();
    }

    protected String getUIPK() {
        return "com.kingdee.eas.fi.fa.FaLeaseBalanceListUI";
    }

    @Override
    protected void validateHandle(Context ctx, PeriodCloseValidateCheckParam periodCloseValidateCheckParam) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = periodCloseValidateCheckParam.getCompany();
        PeriodInfo period = periodCloseValidateCheckParam.getPeriod();
        HashMap<String, Boolean> hmParam = periodCloseValidateCheckParam.getHmPara();
        boolean isCheckVoucher = hmParam.get("isCheckVoucher");
        this.verifyLeaseBalance(ctx, isCheckVoucher, period.getId().toString(), company.getId().toString());
    }

    private void verifyLeaseBalance(Context ctx, boolean notGenVoucher, String periodID, String companyID) throws EASBizException, BOSException {
        IFaLeaseBalanceEntry iLeaseBal = FaLeaseBalanceEntryFactory.getLocalInstance((Context)ctx);
        String billName = FaLocalUtils.getEntityAlias((Context)ctx, (BOSObjectType)iLeaseBal.getType());
        FilterInfo auditFilter = new FilterInfo();
        auditFilter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodID, CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("bill.company.id", (Object)companyID, CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        boolean hasNotAudit = FaLeaseBalanceEntryFactory.getLocalInstance((Context)ctx).exists(auditFilter);
        if (hasNotAudit) {
            this.setWebLinkUrl(companyID, periodID, "noAudit");
            throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_HasNewBiz_NoAudit")), (Object[])new String[]{billName});
        }
        if (notGenVoucher) {
            FilterInfo voucherFilter = new FilterInfo();
            voucherFilter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodID, CompareType.EQUALS));
            voucherFilter.getFilterItems().add(new FilterItemInfo("bill.company.id", (Object)companyID, CompareType.EQUALS));
            voucherFilter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            voucherFilter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)"1", CompareType.NOTEQUALS));
            voucherFilter.setMaskString("#0 and #1 and (#2 or #3)");
            boolean hasVoucher = FaLeaseBalanceEntryFactory.getLocalInstance((Context)ctx).exists(voucherFilter);
            if (!hasNotAudit && hasVoucher) {
                this.setWebLinkUrl(companyID, periodID, "noVoucher");
                throw new EASBizException(new NumericExceptionSubItem("1", FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.manage.FaPeriodClose", (String)"forward_HasNewBiz_NoVoucher")), (Object[])new String[]{billName});
            }
        }
    }

    protected void setWebLinkUrl(String companyId, String periodId, String validateResult) {
        this.url = new StringBuffer();
        this.url.append("&uipk=").append(this.getUIPK());
        if ("noAudit".equals(validateResult)) {
            this.url.append("&companyId=").append(companyId).append("&periodId=").append(periodId).append("&checkedStatus=1");
        } else if ("noVoucher".equals(validateResult)) {
            this.url.append("&companyId=").append(companyId).append("&periodId=").append(periodId).append("&noVoucher=true");
        }
    }
}

