/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.periodclose.validate.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.abs.AbstractPeriodCloseValidateBase;
import com.kingdee.eas.fi.fa.facade.app.periodclose.validate.vo.PeriodCloseValidateCheckParam;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Date;

public class MonthEnd
extends AbstractPeriodCloseValidateBase {
    @Override
    protected void validateHandle(Context ctx, PeriodCloseValidateCheckParam periodCloseValidateCheckParam) throws BOSException, EASBizException {
        String strInfo;
        CompanyOrgUnitInfo currCompany = periodCloseValidateCheckParam.getCompany();
        try {
            strInfo = this.checkMonthEnd(ctx, currCompany);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (!StringUtils.isEmpty((String)strInfo)) {
            throw new EASBizException(new NumericExceptionSubItem("1", strInfo));
        }
    }

    @Override
    protected String setNoteUrl() {
        return null;
    }

    private String checkMonthEnd(Context ctx, CompanyOrgUnitInfo currCompany) throws Exception {
        String checkResult = "";
        if (currCompany != null) {
            if (currCompany.getInvalidDate() != null && DateTimeUtils.dayBefore((Date)currCompany.getInvalidDate(), (Date)new Date())) {
                checkResult = FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Company_Disabled");
                return checkResult;
            }
            if (!currCompany.isIsBizUnit()) {
                checkResult = FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"vitualComNotAllowUseThisFun");
                return checkResult;
            }
        } else {
            checkResult = FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Company_Null");
            return checkResult;
        }
        PeriodInfo aPeriodInfo = null;
        try {
            aPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)(currCompany == null ? currCompany : currCompany));
        }
        catch (Exception e) {
            checkResult = e.toString();
            return checkResult;
        }
        if (aPeriodInfo == null) {
            checkResult = FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"notConfigStartPeriod");
            return checkResult;
        }
        if (currCompany.getAccountTable() == null) {
            checkResult = FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"CurrentCompanyHasNoStartAccountTable");
            return checkResult;
        }
        return checkResult;
    }
}

