/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.rpt.IFARptRowSet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class FARptRowSet
implements IFARptRowSet,
Serializable {
    private static final long serialVersionUID = -3517682193727931934L;
    protected String[] columKey;
    protected Object[][] data;
    private int[] rowIndexs;
    protected transient int currRowIndex = 0;

    public FARptRowSet(String[] columKey, int rowCount) {
        this.columKey = columKey;
        this.data = new Object[rowCount + 1][columKey.length];
        this.rowIndexs = new int[rowCount];
    }

    public int getRowIndex() {
        return this.rowIndexs[this.getCurrRowIndex()];
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndexs[this.getCurrRowIndex()] = rowIndex;
    }

    public void insertRow(int rowIndex) throws BOSException {
        if (++rowIndex < 1 && rowIndex >= this.data.length) {
            throw new BOSException("The rowIndex must between 0 and data's length!");
        }
        this.currRowIndex = rowIndex;
    }

    public void insertRow() throws BOSException {
        if (this.currRowIndex + 1 >= this.data.length) {
            throw new BOSException("The data's length is full, can't insert row!");
        }
        this.data[++this.currRowIndex] = new Object[this.columKey.length];
    }

    public Object[] getCurrentRow() throws BOSException {
        this.checkRowIndex(this.currRowIndex);
        return this.data[this.currRowIndex];
    }

    private void checkRowIndex(int rowIndex) throws BOSException {
        if (rowIndex < 0 || rowIndex >= this.data.length) {
            throw new BOSException("error rowIndex!");
        }
    }

    @Override
    public boolean next() {
        if (this.currRowIndex + 1 >= this.data.length) {
            return false;
        }
        ++this.currRowIndex;
        return true;
    }

    @Override
    public boolean previous() throws BOSException {
        if (this.currRowIndex - 1 <= 0) {
            return false;
        }
        --this.currRowIndex;
        return true;
    }

    @Override
    public void beforeFirst() {
        this.currRowIndex = 0;
    }

    @Override
    public String getString(String columnName) throws BOSException {
        return this.getString(this.getCurrRowIndex(), columnName);
    }

    public String getString(int rowIndex, String columnName) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        return (String)this.data[++rowIndex][colIndex];
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws BOSException {
        return this.getBigDecimal(this.getCurrRowIndex(), columnName);
    }

    public BigDecimal getBigDecimal(int rowIndex, String columnName) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        if (this.data[++rowIndex][colIndex] instanceof BigDecimal) {
            return (BigDecimal)this.data[rowIndex][colIndex];
        }
        return null;
    }

    @Override
    public int getInt(String columnName) throws BOSException {
        return this.getInt(this.getCurrRowIndex(), columnName);
    }

    public int getInt(int rowIndex, String columnName) throws BOSException {
        Object value;
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        if (colIndex < 0) {
            return -1;
        }
        if ((value = this.data[++rowIndex][colIndex]) == null) {
            return -1;
        }
        return Integer.parseInt(value.toString());
    }

    @Override
    public short getShort(String columnName) throws BOSException {
        return this.getShort(this.getCurrRowIndex(), columnName);
    }

    public short getShort(int rowIndex, String columnName) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        Object value = this.data[++rowIndex][colIndex];
        if (value == null) {
            return -1;
        }
        return (Short)value;
    }

    @Override
    public boolean getBoolean(String columnName) throws BOSException {
        return this.getBoolean(this.getCurrRowIndex(), columnName);
    }

    public boolean getBoolean(int rowIndex, String columnName) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        Object value = this.data[++rowIndex][colIndex];
        if (value == null) {
            return false;
        }
        return (Boolean)value;
    }

    @Override
    public byte getByte(String columnName) throws BOSException {
        return this.getByte(this.getCurrRowIndex(), columnName);
    }

    public byte getByte(int rowIndex, String columnName) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        Object value = this.data[++rowIndex][colIndex];
        if (value == null) {
            return -1;
        }
        return (Byte)value;
    }

    @Override
    public byte[] getBytes(String columnName) throws BOSException {
        return this.getBytes(this.getCurrRowIndex(), columnName);
    }

    public byte[] getBytes(int rowIndex, String columnName) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        return (byte[])this.data[++rowIndex][colIndex];
    }

    @Override
    public Date getDate(String columnName) throws BOSException {
        return this.getDate(this.getCurrRowIndex(), columnName);
    }

    public Date getDate(int rowIndex, String columnName) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        return (Date)this.data[++rowIndex][colIndex];
    }

    @Override
    public Time getTime(String columnName) throws BOSException {
        return this.getTime(this.getCurrRowIndex(), columnName);
    }

    public Time getTime(int rowIndex, String columnName) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        return (Time)this.data[++rowIndex][colIndex];
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws BOSException {
        return this.getTimestamp(this.getCurrRowIndex(), columnName);
    }

    public Timestamp getTimestamp(int rowIndex, String columnName) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        return (Timestamp)this.data[++rowIndex][colIndex];
    }

    @Override
    public Object getObject(String columnName) throws BOSException {
        return this.getObject(this.getCurrRowIndex(), columnName);
    }

    @Override
    public Object getObject(int rowIndex, String columnName) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        if (colIndex == -1) {
            return null;
        }
        return this.data[++rowIndex][colIndex];
    }

    @Override
    public void updateString(String columnName, String x) throws BOSException {
        this.updateString(this.getCurrRowIndex(), columnName, x);
    }

    public void updateString(int rowIndex, String columnName, String x) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        this.data[++rowIndex][colIndex] = x;
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws BOSException {
        this.updateBigDecimal(this.getCurrRowIndex(), columnName, x);
    }

    public void updateBigDecimal(int rowIndex, String columnName, BigDecimal x) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        this.data[++rowIndex][colIndex] = x;
    }

    @Override
    public void updateInt(String columnName, int x) throws BOSException {
        this.updateInt(this.getCurrRowIndex(), columnName, x);
    }

    public void updateInt(int rowIndex, String columnName, int x) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        this.data[++rowIndex][colIndex] = new Integer(x);
    }

    @Override
    public void updateShort(String columnName, short x) throws BOSException {
        this.updateShort(this.getCurrRowIndex(), columnName, x);
    }

    public void updateShort(int rowIndex, String columnName, short x) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        this.data[++rowIndex][colIndex] = new Short(x);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws BOSException {
        this.updateBoolean(this.getCurrRowIndex(), columnName, x);
    }

    public void updateBoolean(int rowIndex, String columnName, boolean x) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        this.data[++rowIndex][colIndex] = x;
    }

    @Override
    public void updateByte(String columnName, byte x) throws BOSException {
        this.updateByte(this.getCurrRowIndex(), columnName, x);
    }

    public void updateByte(int rowIndex, String columnName, byte x) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        this.data[++rowIndex][colIndex] = new Byte(x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws BOSException {
        this.updateBytes(this.getCurrRowIndex(), columnName, x);
    }

    public void updateBytes(int rowIndex, String columnName, byte[] x) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        this.data[++rowIndex][colIndex] = x;
    }

    @Override
    public void updateDate(String columnName, Date x) throws BOSException {
        this.updateDate(this.getCurrRowIndex(), columnName, x);
    }

    public void updateDate(int rowIndex, String columnName, Date x) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        this.data[++rowIndex][colIndex] = x;
    }

    @Override
    public void updateTime(String columnName, Time x) throws BOSException {
        this.updateTime(this.getCurrRowIndex(), columnName, x);
    }

    public void updateTime(int rowIndex, String columnName, Time x) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        this.data[++rowIndex][colIndex] = x;
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws BOSException {
        this.updateTimestamp(this.getCurrRowIndex(), columnName, x);
    }

    public void updateTimestamp(int rowIndex, String columnName, Timestamp x) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        this.data[++rowIndex][colIndex] = x;
    }

    @Override
    public void updateObject(String columnName, Object x) throws BOSException {
        this.updateObject(this.getCurrRowIndex(), columnName, x);
    }

    @Override
    public void updateObject(int rowIndex, String columnName, Object x) throws BOSException {
        this.checkRowIndex(rowIndex);
        int colIndex = this.indexOf(columnName);
        if (colIndex < 0) {
            return;
        }
        this.data[++rowIndex][colIndex] = x;
    }

    public int indexOf(String columnName) throws BOSException {
        for (int i = 0; i < this.columKey.length; ++i) {
            if (!this.columKey[i].equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public void addRowSets(FARptRowSet rs) {
        Object[][] tempData = new Object[this.data.length + rs.size()][this.columKey.length];
        System.arraycopy(this.data, 0, tempData, 0, this.data.length);
        System.arraycopy(rs.data, 1, tempData, this.data.length, rs.size());
        this.data = tempData;
        int[] indexData = new int[this.rowIndexs.length + rs.size()];
        System.arraycopy(this.rowIndexs, 0, indexData, 0, this.rowIndexs.length);
        System.arraycopy(rs.rowIndexs, 0, indexData, this.rowIndexs.length, rs.size());
        this.rowIndexs = indexData;
    }

    public FARptRowSet getRow(int i) {
        FARptRowSet rs = new FARptRowSet(this.columKey, 1);
        rs.rowIndexs[0] = this.rowIndexs[i];
        rs.data[1] = this.data[++i];
        return rs;
    }

    public boolean moveToRow(int rowIndex) throws BOSException {
        for (int i = 0; i < this.rowIndexs.length; ++i) {
            if (rowIndex != this.rowIndexs[i]) continue;
            this.absolute(i);
            return true;
        }
        return false;
    }

    public boolean exist(int rowIndex) {
        for (int i = 0; i < this.rowIndexs.length; ++i) {
            if (rowIndex != this.rowIndexs[i]) continue;
            return true;
        }
        return false;
    }

    public void extendSize(int extendSize) {
        Object[][] tempData = new Object[this.data.length + extendSize][this.columKey.length];
        System.arraycopy(this.data, 0, tempData, 0, this.data.length);
        this.data = tempData;
        int[] indexData = new int[this.rowIndexs.length + extendSize];
        System.arraycopy(this.rowIndexs, 0, indexData, 0, this.rowIndexs.length);
        this.rowIndexs = indexData;
    }

    @Override
    public void absolute(int row) throws BOSException {
        if (row > this.size() - 1 || row < 0) {
            throw new BOSException("The row is not exist!");
        }
        this.currRowIndex = row + 1;
    }

    @Override
    public boolean first() throws BOSException {
        if (this.size() > 0) {
            this.currRowIndex = 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws BOSException {
        if (this.size() > 0) {
            this.currRowIndex = this.data.length - 1;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.data.length - 1;
    }

    @Override
    public String[] getColumKeys() {
        return this.columKey;
    }

    public int getCurrRowIndex() {
        return this.currRowIndex - 1;
    }

    @Override
    public void close() throws BOSException, EASBizException {
        this.data = null;
        this.columKey = null;
        this.currRowIndex = 0;
    }
}

