/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.app.rpt.FaRptField;
import com.kingdee.eas.fi.fa.facade.app.rpt.FaRptSelector;
import com.kingdee.eas.fi.fa.facade.app.rpt.FaRptTableHeadInfo;
import com.kingdee.eas.fi.fa.facade.app.rpt.IFaRptHelper;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.LevelSumOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FaRptListHelper
implements IFaRptHelper {
    Context context;
    protected boolean isVirCompany = false;
    private FaRptSelector selector;

    public FaRptListHelper(Context context) {
        this.context = context;
    }

    @Override
    public FaRptTableHeadInfo getTableHeadInfo() throws BOSException, EASBizException {
        FaRptTableHeadInfo headInfo = new FaRptTableHeadInfo();
        if (this.selector == null) {
            return headInfo;
        }
        Iterator it = this.selector.iterator();
        while (it.hasNext()) {
            FaRptField field = (FaRptField)it.next();
            this.addTableHeadColumn(headInfo, field);
        }
        headInfo.setHeadTitle(this.getHeadTitles());
        return headInfo;
    }

    protected String[][] getHeadTitles() throws EASBizException, BOSException {
        String[][] titles = null;
        titles = new String[][]{this.getTitleRow1()};
        return titles;
    }

    protected String[] getTitleRow1() throws EASBizException, BOSException {
        Iterator it = this.selector.iterator();
        ArrayList colTitles = new ArrayList();
        while (it.hasNext()) {
            FaRptField field = (FaRptField)it.next();
            if (field.getName() == null) continue;
            this.setRow1Title(colTitles, field);
        }
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    protected void setRow1Title(List colTitles, FaRptField field) {
        colTitles.add(field.getTitle() == null ? "" : field.getTitle());
    }

    protected void setRow2Title(List colTitles, FaRptField field) throws EASBizException, BOSException {
        colTitles.add(field.getTitle());
    }

    protected String[] getTitleRow2() throws EASBizException, BOSException {
        ArrayList colTitles = new ArrayList();
        Iterator it = this.selector.iterator();
        while (it.hasNext()) {
            FaRptField field = (FaRptField)it.next();
            if (field.getName() == null) continue;
            this.setRow2Title(colTitles, field);
        }
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    protected void addTableHeadColumn(FaRptTableHeadInfo headInfo, FaRptField field) throws EASBizException, BOSException {
        if (field.getName() == null) {
            return;
        }
        FaRptTableHeadInfo.FaRptTableColumnInfo colInfo = headInfo.addColumnInfo();
        colInfo.setColName(field.getName());
        colInfo.setWidth(field.getLength());
        colInfo.setAlign(1);
        if ("orgArchitecture".equals(field.getName())) {
            colInfo.setTreeNode(true);
        }
        if (field.getLength() == -1) {
            colInfo.setHide(true);
        }
        if (colInfo != null && this.getFreezeField() == field) {
            colInfo.setFreeze(true);
        }
        if (field.getType() == "NUMERIC(29,10)") {
            colInfo.setNumeral(true);
            this.setAmountColScale(field, colInfo);
            colInfo.setAlign(3);
        } else if (field.getType() == "NUMERIC(27,10)") {
            colInfo.setNumeral(true);
            colInfo.setScale(6);
            colInfo.setAlign(3);
        }
    }

    private void setAmountColScale(FaRptField field, FaRptTableHeadInfo.FaRptTableColumnInfo colInfo) throws EASBizException, BOSException {
        CurrencyInfo currency = FaLocalUtils.getBaseCurrency((Context)this.context);
        if (currency != null && currency.getPrecision() > 0) {
            colInfo.setScale(currency.getPrecision());
        }
    }

    protected FaRptField getFreezeField() {
        return null;
    }

    @Override
    public FaRptSelector initSelector(LevelSumOption sumOption) throws EASBizException, BOSException {
        this.selector = new FaRptSelector();
        CompanyOrgUnitInfo currCompany = sumOption.getCurrCompany();
        boolean bl = this.isVirCompany = !currCompany.isIsBizUnit();
        if (this.isVirCompany && this.isAllowVirtualOrg()) {
            this.selector.add(FaRptField.orgArchitecture);
        }
        this.selector.add(FaRptField.assetNumber);
        this.selector.add(FaRptField.olderNumber);
        this.selector.add(FaRptField.groupNumber);
        this.selector.add(FaRptField.barCode);
        this.selector.add(FaRptField.assetName);
        this.selector.add(FaRptField.cardNum);
        this.selector.add(FaRptField.assetAmt);
        this.selector.add(FaRptField.measureUnitName);
        this.selector.add(FaRptField.accountDate);
        this.selector.add(FaRptField.fiAccountDate);
        this.selector.add(FaRptField.originMethodName);
        this.selector.add(FaRptField.useStatusName);
        this.selector.add(FaRptField.economicPurpName);
        this.selector.add(FaRptField.storeCityName);
        this.selector.add(FaRptField.useDepartment);
        this.selector.add(FaRptField.usePerson);
        this.selector.add(FaRptField.costCenter);
        this.selector.add(FaRptField.specs);
        this.selector.add(FaRptField.pArea);
        this.selector.add(FaRptField.mfr);
        this.selector.add(FaRptField.levfrDate);
        this.selector.add(FaRptField.paperNo);
        this.selector.add(FaRptField.isOverAged);
        this.selector.add(FaRptField.deprMethodName);
        this.selector.add(FaRptField.measureUnitWLName);
        this.selector.add(FaRptField.currencyName);
        this.selector.add(FaRptField.exRate);
        this.selector.add(FaRptField.originAmt);
        this.selector.add(FaRptField.inputTax);
        this.selector.add(FaRptField.addonFare);
        this.selector.add(FaRptField.addOns);
        this.selector.add(FaRptField.treatmentIncome);
        this.selector.add(FaRptField.assetValue);
        this.selector.add(FaRptField.fairValue);
        this.selector.add(FaRptField.initEvalValue);
        this.selector.add(FaRptField.evalMinusAssetValue);
        this.selector.add(FaRptField.buyValue);
        this.selector.add(FaRptField.buyAccuDepr);
        this.selector.add(FaRptField.deliverDate);
        this.selector.add(FaRptField.startUseDate);
        this.selector.add(FaRptField.useYears);
        this.selector.add(FaRptField.useTermCount);
        this.selector.add(FaRptField.deprTermCount);
        this.selector.add(FaRptField.leftTermCount);
        this.selector.add(FaRptField.evalLeftPeriod);
        this.selector.add(FaRptField.monthDepreRate);
        this.selector.add(FaRptField.deprTTerm);
        this.selector.add(FaRptField.accuDepr);
        this.selector.add(FaRptField.accuDeprTYear);
        this.selector.add(FaRptField.neatRemValue);
        this.selector.add(FaRptField.neatLeftRate);
        this.selector.add(FaRptField.neatValue);
        this.selector.add(FaRptField.decValue);
        this.selector.add(FaRptField.neatAmt);
        this.selector.add(FaRptField.actAssetName);
        this.selector.add(FaRptField.actAccDeprName);
        this.selector.add(FaRptField.actDecval);
        this.selector.add(FaRptField.companyName);
        this.selector.add(FaRptField.deptName);
        this.selector.add(FaRptField.keeperName);
        this.selector.add(FaRptField.reMark);
        this.selector.add(FaRptField.wrtyPeriod);
        this.selector.add(FaRptField.wrtyNumber);
        return this.selector;
    }

    @Override
    public boolean isAllowVirtualOrg() {
        return true;
    }
}

