/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.fa.facade.app.rpt.IDNode;
import com.kingdee.eas.fi.fa.rpt.FaDaoSqlObject;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.IFaList;
import com.kingdee.eas.fi.fa.rpt.TreeIDNode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TreeIdsList {
    List list = new ArrayList();
    private int currIndex = 0;
    private int topLevel;
    public int index = 0;

    public TreeIdsList(int topLevel) {
        this.topLevel = topLevel;
    }

    private synchronized void initPreNode(List preIdSet) throws SQLException {
        int size = preIdSet.size();
        for (int i = 0; i < size; ++i) {
            IDNode idNode = new IDNode();
            TreeIDNode node = (TreeIDNode)preIdSet.get(i);
            idNode.setFID(node.getID());
            idNode.setLevel(node.getLevel());
            this.list.add(idNode);
        }
    }

    public synchronized void initNode(Context ctx, FaDaoSqlObject resultSql, int specLevel) throws SQLException, BOSException {
        TreeIDNode node;
        IFaList manager = FaListFactory.getLocalInstance((Context)ctx);
        resultSql.setWhere("SumLevel > " + (this.topLevel - 1));
        List allIds = manager.getTreeIdList(resultSql);
        resultSql.setWhere("SumLevel < " + (this.topLevel + 1));
        List preIds = manager.getTreeIdList(resultSql);
        resultSql.setWhere("");
        this.initPreNode(preIds);
        IDNode lastNode = new IDNode();
        if (allIds.size() > 0) {
            IDNode idNode = new IDNode();
            node = (TreeIDNode)allIds.get(0);
            idNode.setFID(node.getID());
            int level = node.isSum() ? node.getLevel() : node.getLevel() + 1;
            idNode.setLevel(level);
            lastNode = idNode;
            int size = this.list.size();
            for (int i = 0; i < size; ++i) {
                if (!idNode.equals(this.list.get(i))) continue;
                this.list.remove(i);
                this.list.add(i, idNode);
                break;
            }
        }
        int size = allIds.size();
        for (int i = 1; i < size; ++i) {
            IDNode father;
            IDNode idNode = new IDNode();
            node = (TreeIDNode)allIds.get(i);
            idNode.setFID(node.getID());
            int level = node.isSum() ? node.getLevel() : node.getLevel() + 1;
            idNode.setLevel(level);
            if (level == this.topLevel) {
                int length = this.list.size();
                for (int j = 0; j < length; ++j) {
                    if (!idNode.equals(this.list.get(j))) continue;
                    this.list.remove(j);
                    this.list.add(j, idNode);
                    break;
                }
            }
            if (idNode.getLevel() == lastNode.getLevel()) {
                father = lastNode.getFather();
            } else if (idNode.getLevel() < lastNode.getLevel()) {
                for (father = lastNode; father != null && idNode.getLevel() <= father.getLevel(); father = father.getFather()) {
                }
            }
            if (father != null) {
                father.addSonIDNode(idNode);
            }
            idNode.setFather(father);
            lastNode = idNode;
        }
        if (specLevel != -1) {
            this.openSpecLevel(specLevel);
        }
    }

    public synchronized void setOneNodeHide(int index, boolean hide) {
        IDNode node = (IDNode)this.list.get(index);
        if (node == null || node.isLeaf()) {
            return;
        }
        if (node.isOpen() && hide) {
            this.closeNode(node);
        } else if (!node.isOpen() && !hide) {
            this.currIndex = index;
            this.openNode(node);
        }
        node.setOpen(!hide);
    }

    private void closeNode(IDNode node) {
        List sonNodes = node.getSonIDNodes();
        int size = sonNodes.size();
        for (int i = 0; i < size; ++i) {
            IDNode sonNode = (IDNode)sonNodes.get(i);
            if (sonNode.isOpen()) {
                this.closeNode(sonNode);
            }
            this.list.remove(sonNode);
        }
    }

    private void openNode(IDNode node) {
        List sonNodes = node.getSonIDNodes();
        if (sonNodes == null) {
            return;
        }
        int size = sonNodes.size();
        for (int i = 0; i < size; ++i) {
            IDNode sonNode = (IDNode)sonNodes.get(i);
            this.list.add(this.currIndex + 1, sonNode);
            ++this.currIndex;
            if (!sonNode.isOpen()) continue;
            this.openNode(sonNode);
        }
    }

    public synchronized void openSpecLevel(int level) {
        if (this.list == null || this.list.size() == 0) {
            return;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            this.openSpecLevelNodes((IDNode)this.list.get(i), level);
        }
    }

    private void openSpecLevelNodes(IDNode node, int level) {
        if (level < 0 || node.isLeaf() || node.getLevel() > level + this.topLevel - 1 || node.isOpen()) {
            return;
        }
        node.setOpen(true);
        List sonNodes = node.getSonIDNodes();
        if (sonNodes == null) {
            return;
        }
        boolean notFind = true;
        int size = sonNodes.size();
        for (int i = 0; i < size; ++i) {
            IDNode sonNode = (IDNode)sonNodes.get(i);
            for (int j = 0; j < this.list.size() && notFind; ++j) {
                if (node.getFID() != ((IDNode)this.list.get(j)).getFID()) continue;
                this.index = j;
                notFind = false;
            }
            this.list.add(++this.index, sonNode);
            this.openSpecLevelNodes(sonNode, level);
        }
    }

    public synchronized List getIdList(int start, int length) {
        if (start + 1 > this.list.size()) {
            return null;
        }
        if (start + length > this.list.size()) {
            length = this.list.size() - start;
        }
        List nodeList = this.list.subList(start, start + length);
        ArrayList<String> ids = new ArrayList<String>();
        int size = nodeList.size();
        for (int i = 0; i < size; ++i) {
            ids.add(((IDNode)nodeList.get(i)).getFID());
        }
        return ids;
    }

    public synchronized List getIdList() {
        ArrayList<String> ids = new ArrayList<String>();
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            ids.add(((IDNode)this.list.get(i)).getFID());
        }
        return ids;
    }

    public synchronized boolean[] getHasSubLevel(int start, int length) {
        if (start + 1 > this.list.size()) {
            return null;
        }
        if (start + length > this.list.size()) {
            length = this.list.size() - start;
        }
        List nodeList = this.list.subList(start, start + length);
        boolean[] isLevels = new boolean[length];
        int size = nodeList.size();
        for (int i = 0; i < size; ++i) {
            isLevels[i] = ((IDNode)nodeList.get(i)).isLeaf();
        }
        return isLevels;
    }

    public int expandRow(int index) {
        IDNode node = this.getIDNode(index);
        this.openNode(index, node);
        node.setOpen(true);
        return this.getViewRowCount();
    }

    private int openNode(int index, IDNode node) {
        if (node == null || node.isLeaf()) {
            return index;
        }
        List sonNodes = node.getSonIDNodes();
        if (sonNodes == null) {
            return index;
        }
        int size = sonNodes.size();
        for (int i = 0; i < size; ++i) {
            IDNode sonNode = (IDNode)sonNodes.get(i);
            this.list.add(++index, sonNode);
            if (!sonNode.isOpen()) continue;
            index = this.openNode(index, sonNode);
        }
        return index;
    }

    private int openAllNode(int index, IDNode node) {
        if (node == null || node.isLeaf()) {
            return index;
        }
        List sonNodes = node.getSonIDNodes();
        if (sonNodes == null) {
            return index;
        }
        int size = sonNodes.size();
        for (int i = 0; i < size; ++i) {
            IDNode sonNode = (IDNode)sonNodes.get(i);
            this.list.add(++index, sonNode);
            index = this.openAllNode(index, sonNode);
        }
        node.setOpen(true);
        return index;
    }

    public int shrinkRow(int index) {
        IDNode node = this.getIDNode(index);
        this.closeNode(node);
        node.setOpen(false);
        return this.getViewRowCount();
    }

    public synchronized int getViewRowCount() {
        return this.list.size();
    }

    public synchronized IDNode getIDNode(int rowIndex) {
        if (rowIndex >= this.list.size()) {
            return null;
        }
        return (IDNode)this.list.get(rowIndex);
    }
}

