/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.rpt.impl;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ArrayUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.DataObject;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.def.FaDefPropertyCollection;
import com.kingdee.eas.fi.fa.def.FaDefPropertyInfo;
import com.kingdee.eas.fi.fa.facade.app.rpt.DynShowColumnList;
import com.kingdee.eas.fi.fa.facade.app.rpt.FARptRowSet;
import com.kingdee.eas.fi.fa.facade.app.rpt.IDNode;
import com.kingdee.eas.fi.fa.facade.app.rpt.TreeColumn;
import com.kingdee.eas.fi.fa.facade.app.rpt.TreeIdsList;
import com.kingdee.eas.fi.fa.facade.app.rpt.impl.FaRptBaseConditionBuilder;
import com.kingdee.eas.fi.fa.facade.app.rpt.impl.FaRptCache;
import com.kingdee.eas.fi.fa.facade.app.rpt.impl.IFaRptBaseService;
import com.kingdee.eas.fi.fa.facade.app.util.FaServerUtil;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaDaoSqlObject;
import com.kingdee.eas.fi.fa.rpt.FaListFactory;
import com.kingdee.eas.fi.fa.rpt.FaRptException;
import com.kingdee.eas.fi.fa.rpt.IFaList;
import com.kingdee.eas.fi.fa.rpt.SumGroupInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.RptException;
import com.kingdee.eas.framework.report.RptFilterUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaRptBaseServiceImpl
implements IFaRptBaseService {
    private static Logger logger = Logger.getLogger(FaRptBaseServiceImpl.class);
    protected final Context ctx;
    protected static final String ID = "FID";
    protected static final String RES_PATH = "com.kingdee.eas.fi.fa.rpt.FaRptResource";
    protected static final String DAOPATH = "com.kingdee.eas.fi.fa.rpt.app.dao.";
    private static final String NAME = "Name";
    private static final String RESULTSQL = "resultSql";
    private static final String TEMPTABLENAME = "tempTableName";
    protected static final String QUERYID = "queryId";
    protected static final String CARDID = "CARDID";
    protected static final String SUBTOTAL = "subTotal";
    protected static final String TOTAL2 = "total2";
    protected static final String ISTOTAL = "ISTOTAL";
    protected FaRptBaseConditionBuilder faBaseConBuilder;
    protected DynShowColumnList dynShowColumnList;
    protected FaDaoSqlObject resultSql;
    private String sub_total;
    private String total;
    Map<String, String> paramMap = new HashMap<String, String>();
    protected List hideSumColList = null;
    protected List columnNameListForSum = null;
    protected List<String> allUserDefineShowList = null;
    protected List sumStyShowColList = null;
    protected List<String> sumColList = null;

    public FaRptBaseServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    public Map getQueryInitData(boolean isSupportUnion) throws BOSException, EASBizException {
        HashMap<String, Object> initData = new HashMap<String, Object>();
        initData.put("accountTables", this.getAccountTableCollection(this.ctx, isSupportUnion));
        initData.put("periodTypes", this.getPeriodTypeCollection(this.ctx));
        return initData;
    }

    public Map getPeriodRange(Set companyIdSet, String periodTypeId) throws BOSException, EASBizException {
        return FaServerUtil.getPeriodRange(this.ctx, companyIdSet, periodTypeId);
    }

    public CompanyOrgUnitInfo getCompanyInfo(String companyID, String selector) throws EASBizException, BOSException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        if (selector != null) {
            String[] properties;
            for (String property : properties = selector.split(",")) {
                SelectorItemInfo selectorItemInfo = new SelectorItemInfo(property);
                selectorItemCollection.add(selectorItemInfo);
            }
        }
        return CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), selectorItemCollection);
    }

    public CompanyOrgUnitCollection getCompanys(Set companyIdSet, String selector) throws EASBizException, BOSException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        if (selector != null) {
            String[] properties;
            for (String property : properties = selector.split(",")) {
                SelectorItemInfo selectorItemInfo = new SelectorItemInfo(property);
                selectorItemCollection.add(selectorItemInfo);
            }
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIdSet, CompareType.INCLUDE));
        return CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)selectorItemCollection, null));
    }

    public int getAccountMaxLevel(Set companyIdSet, String accountTableId) throws BOSException, EASBizException {
        return 5;
    }

    public Map saveQuerySolution(String uipk, String filterUIPK, String queryPK, String solutionName, Map customFilter, List queryFilter, List queryOrder, boolean isdefault) throws BOSException, EASBizException {
        QuerySolutionInfo solutionInfo = this.getSameNameSolution(solutionName, filterUIPK, uipk);
        HashMap<String, String> results = new HashMap<String, String>();
        String viewId = "";
        if (solutionInfo != null) {
            viewId = solutionInfo.getId().toString();
            this.editSolution(viewId, solutionName, queryPK, filterUIPK, customFilter, queryFilter, queryOrder, isdefault);
            results.put("oprSta", "update");
        } else {
            viewId = this.addSolution(solutionName, queryPK, filterUIPK, uipk, customFilter, queryFilter, queryOrder, isdefault);
            results.put("oprSta", "addnew");
        }
        results.put("viewId", viewId);
        return results;
    }

    private QuerySolutionInfo getSameNameSolution(String solutionName, String queryPK, String parentPageName) {
        MetaDataPK queryObjectPK = new MetaDataPK(queryPK);
        QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getQuery((IMetaDataPK)queryObjectPK);
        String orgID = FaRptBaseServiceImpl.getOrgIDString(this.ctx, queryInfo);
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)this.ctx);
            return iQuerySolution.getOwnerSolutionByName(orgID, queryPK, parentPageName, ShareTypeEnum.USER_LEVEL, solutionName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getOrgIDString(Context ctx, QueryInfo queryInfo) {
        try {
            BOSUuid id = FaRptBaseServiceImpl.getOrgID(ctx, queryInfo);
            if (id != null) {
                return id.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static BOSUuid getOrgID(Context ctx, QueryInfo queryInfo) {
        BOSUuid orgID = null;
        try {
            String orgType = null;
            if (FaRptBaseServiceImpl.getOrgType(queryInfo) != null) {
                orgType = FaRptBaseServiceImpl.getOrgType(queryInfo).getName();
            }
            if (orgType != null) {
                if ("Admin".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentAdminUnit((Context)ctx).getId();
                } else if ("Company".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentFIUnit((Context)ctx).getId();
                } else if ("Sale".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentSaleUnit((Context)ctx).getId();
                } else if ("Purchase".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentPurchaseUnit((Context)ctx).getId();
                } else if ("Storage".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentStorageUnit((Context)ctx).getId();
                } else if ("CostCenter".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentCostUnit((Context)ctx).getId();
                } else if ("ProfitCenter".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentProfitUnit((Context)ctx).getId();
                } else if ("ControlUnit".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
                } else if ("HRO".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentHRUnit((Context)ctx).getId();
                } else if ("NONE".equalsIgnoreCase(orgType)) {
                    orgID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
                }
            } else {
                orgID = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            orgID = null;
        }
        return orgID;
    }

    public static OrgType getOrgType(QueryInfo queryInfo) {
        OrgType orgType = null;
        try {
            EntityObjectInfo eo;
            String orgTypeStr;
            SubObjectInfo main = queryInfo.getMainObject();
            if (main instanceof SubQueryInfo) {
                main = ((SubQueryInfo)main).getQueryRef().getMainObject();
            }
            if ((orgTypeStr = (eo = ((SubEntityInfo)main).getEntityRef()).getExtendedProperty("OrgType")) != null) {
                if ("Admin".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Admin;
                } else if ("Company".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Company;
                } else if ("Sale".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Sale;
                } else if ("Purchase".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Purchase;
                } else if ("Storage".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Storage;
                } else if ("CostCenter".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.CostCenter;
                } else if ("ProfitCenter".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.ProfitCenter;
                } else if ("ControlUnit".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.ControlUnit;
                } else if ("HRO".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.HRO;
                } else if ("Transport".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Transport;
                } else if ("NONE".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.NONE;
                }
            } else {
                orgType = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            orgType = null;
        }
        return orgType;
    }

    private boolean editSolution(String solutionID, String solutionName, String queryPK, String filterUIPK, Map customDataMap, List filterDataList, List orderDataList, boolean isdefault) {
        try {
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)this.ctx);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)solutionID));
            QuerySolutionInfo solutionInfo = iSolution.getQuerySolutionInfo((IObjectPK)pk);
            solutionInfo.setEntityViewInfo(this.getEntityViewInfo(queryPK, filterDataList).toString());
            solutionInfo.setShareType(ShareTypeEnum.USER_LEVEL);
            solutionInfo.setIsUserDefaultSolu(isdefault);
            QueryPanelCollection queryPanelCol = new QueryPanelCollection();
            queryPanelCol.add(this.getCustomFilterQueryPanel(filterUIPK, customDataMap));
            queryPanelCol.add(this.getFilterQueryPanel(queryPK, filterDataList));
            queryPanelCol.add(this.getOrderQueryPanel(queryPK, orderDataList));
            solutionInfo.getQueryPanelInfo().clear();
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            iSolution.update((IObjectPK)pk, (CoreBaseInfo)solutionInfo);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String addSolution(String solutionName, String queryPK, String filterUIPK, String parentPageName, Map customDataMap, List filterDataList, List orderDataList, boolean isdefault) {
        MetaDataPK queryObjectPK = new MetaDataPK(queryPK);
        QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getQuery((IMetaDataPK)queryObjectPK);
        try {
            QuerySolutionInfo solutionInfo = new QuerySolutionInfo();
            solutionInfo.setName(solutionName);
            solutionInfo.setName(solutionName, new Locale("l1"));
            solutionInfo.setName(solutionName, new Locale("l3"));
            solutionInfo.setOwner(ContextUtil.getCurrentUserInfo((Context)this.ctx).getId());
            solutionInfo.setOrgID(FaRptBaseServiceImpl.getOrgID(this.ctx, queryInfo));
            solutionInfo.setQueryObjectName(queryPK);
            solutionInfo.setEntityViewInfo(this.getEntityViewInfo(queryPK, filterDataList).toString());
            solutionInfo.setShareType(ShareTypeEnum.USER_LEVEL);
            solutionInfo.setSolutionType(SolutionTypeEnum.CUSTOMER_SOLUTION);
            solutionInfo.setParentUIName(parentPageName);
            solutionInfo.setIsUserDefaultSolu(isdefault);
            QueryPanelCollection queryPanelCol = new QueryPanelCollection();
            queryPanelCol.add(this.getCustomFilterQueryPanel(filterUIPK, customDataMap));
            queryPanelCol.add(this.getFilterQueryPanel(queryPK, filterDataList));
            queryPanelCol.add(this.getOrderQueryPanel(queryPK, orderDataList));
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)this.ctx);
            IObjectPK pk = iSolution.addnew((CoreBaseInfo)solutionInfo);
            solutionInfo.setId(BOSUuid.read((String)pk.toString()));
            return solutionInfo.getId().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private EntityViewInfo getEntityViewInfo(String queryPK, List filterDataList) {
        EntityViewInfo resultEntityViewInfo = new EntityViewInfo();
        if (resultEntityViewInfo.getFilter() != null) {
            resultEntityViewInfo.getFilter().setMaskString("");
            resultEntityViewInfo.getFilter().getFilterItems().clear();
        }
        resultEntityViewInfo.setFilter(this.getCommFilter(queryPK, filterDataList));
        return resultEntityViewInfo;
    }

    private QueryPanelInfo getCustomFilterQueryPanel(String filterUIPK, Map customDataMap) throws Exception {
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        queryPanelInfo.setPanelClassName(filterUIPK);
        CustomerParams cp = new CustomerParams();
        if (cp != null) {
            cp.addCustomerParam("RPTPARAMS_KEY_AT_CUSTOMERPARAMS", Base64Encoder.byteArrayToBase64((byte[])FaRptBaseServiceImpl.getBytes(RptFilterUtils.toRptFilterMapFromObject((Object)customDataMap))));
        }
        String customerParams = null;
        if (cp != null) {
            Collection keys = cp.getKeys();
            Collection values = cp.getValues();
            if (keys.size() > 0) {
                customerParams = XMLBean.CreateXMLStrRecursion((Collection)keys, (Collection)values);
            }
        }
        queryPanelInfo.setCustomerParams(customerParams);
        queryPanelInfo.setSorterInfo(null);
        queryPanelInfo.setParam(null);
        queryPanelInfo.setPanelName(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.facade.FACADEAutoGenerateResource", (String)"2_FaRptBaseServiceImpl", (Locale)this.ctx.getLocale()));
        queryPanelInfo.setQueryPanelType(QueryPanelTypeEnum.CUSTOMER_PANEL);
        return queryPanelInfo;
    }

    private QueryPanelInfo getFilterQueryPanel(String queryPK, List filterDataList) throws Exception {
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        queryPanelInfo.setPanelClassName("com.kingdee.eas.base.commonquery.client.CommonFilterPanel");
        FilterInfo filter = this.getCommFilter(queryPK, filterDataList);
        queryPanelInfo.setFilterInfo(filter.toString());
        queryPanelInfo.setSorterInfo(null);
        queryPanelInfo.setParam(null);
        queryPanelInfo.setPanelName(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.facade.FACADEAutoGenerateResource", (String)"3_FaRptBaseServiceImpl", (Locale)this.ctx.getLocale()));
        queryPanelInfo.setQueryPanelType(QueryPanelTypeEnum.FILTER_PANEL);
        return queryPanelInfo;
    }

    private QueryPanelInfo getOrderQueryPanel(String queryPK, List orderDataList) throws Exception {
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        queryPanelInfo.setPanelName(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.facade.FACADEAutoGenerateResource", (String)"4_FaRptBaseServiceImpl", (Locale)this.ctx.getLocale()));
        queryPanelInfo.setPanelClassName("com.kingdee.eas.base.commonquery.client.CommonSorterPanel");
        String orderString = this.getCommOrder(queryPK, orderDataList);
        queryPanelInfo.setFilterInfo(null);
        queryPanelInfo.setSorterInfo(orderString);
        queryPanelInfo.setParam(null);
        queryPanelInfo.setQueryPanelType(QueryPanelTypeEnum.SORTER_PANEL);
        return queryPanelInfo;
    }

    private FilterInfo getCommFilter(String queryPK, List filterDataList) {
        MetaDataPK queryObjectPK = new MetaDataPK(queryPK);
        QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getQuery((IMetaDataPK)queryObjectPK);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItem = null;
        int rowCount = filterDataList.size();
        for (int i = 0; i < rowCount; ++i) {
            String filterField;
            Object compareValue = null;
            LinkedTreeMap hsFilter = (LinkedTreeMap)filterDataList.get(i);
            String realField = filterField = (String)hsFilter.get((Object)"prop_field");
            if (filterField.indexOf("aqdef.") >= 0) {
                realField = filterField.substring(6);
            }
            String compareOp = (String)hsFilter.get((Object)"prop_op");
            Object fValue = hsFilter.get((Object)"prop_value");
            if (fValue instanceof String) {
                compareValue = this.processDateType(realField, (String)fValue, compareOp, queryInfo);
            }
            if (this.isUsingF7(realField, queryInfo) && fValue instanceof LinkedTreeMap) {
                compareValue = this.processF7Type(realField, (LinkedTreeMap)fValue);
            }
            if (compareValue == null) {
                compareValue = fValue;
            }
            if (compareValue != null && ("like".equals(compareOp) || "not like".equals(compareOp))) {
                String value = compareValue.toString();
                if (value.charAt(0) != '%') {
                    value = "%" + value;
                }
                if (!value.endsWith("%")) {
                    value = value + "%";
                }
                compareValue = value;
            } else if ("is".equals(compareOp) || "is not".equals(compareOp)) {
                compareValue = null;
            } else if (compareOp.startsWith("tod=")) {
                compareValue = "today";
                compareOp = "=";
            } else if (compareOp.startsWith("yes=")) {
                compareValue = "yesterday";
                compareOp = "=";
            } else if (compareOp.startsWith("tom=")) {
                compareValue = "tomorrow";
                compareOp = "=";
            }
            filterItem = new FilterItemInfo(filterField, compareValue, CompareType.getEnum((String)compareOp));
            filterInfo.getFilterItems().add(filterItem);
        }
        return filterInfo;
    }

    private String getCommOrder(String queryPK, List orderDataList) {
        StringBuffer orderString = new StringBuffer();
        int rowCount = orderDataList.size();
        if (rowCount > 0) {
            orderString.append("ORDER BY");
        }
        for (int i = 0; i < rowCount; ++i) {
            Object compareValue = null;
            LinkedTreeMap hsFilter = (LinkedTreeMap)orderDataList.get(i);
            String filterField = (String)hsFilter.get((Object)"prop_field");
            String compareOp = (String)hsFilter.get((Object)"prop_op");
            orderString.append(" ").append(filterField).append(" ").append(compareOp);
            if (i >= rowCount - 1) continue;
            orderString.append(",");
        }
        return orderString.toString();
    }

    private Object processDateType(String filterField, String filterValue, String compareOp, QueryInfo queryInfo) {
        if (StringUtils.isEmpty((String)filterValue)) {
            return null;
        }
        if (this.isUsingDate(filterField, queryInfo)) {
            if (filterValue.startsWith("d") || filterValue.startsWith("w") || filterValue.startsWith("m")) {
                return null;
            }
            return filterValue;
        }
        return null;
    }

    private boolean isUsingDate(String queryFieldName, QueryInfo queryInfo) {
        String type;
        DataObject dataObject = QueryUtils.getRefMetaData(null, (QueryInfo)queryInfo, (String)queryFieldName);
        return dataObject != null && ((type = dataObject.getName()).equalsIgnoreCase(DataType.DATE.getName()) || type.equalsIgnoreCase(DataType.TIMESTAMP.getName()) || type.equalsIgnoreCase(DataType.TIME.getName()));
    }

    private Object processF7Type(String filterField, LinkedTreeMap filterValue) {
        if (filterValue == null) {
            return null;
        }
        return filterValue.get((Object)"id");
    }

    private boolean isUsingF7(String queryFieldName, QueryInfo queryInfo) {
        String type;
        DataObject dataObject = QueryUtils.getRefMetaData(null, (QueryInfo)queryInfo, (String)queryFieldName);
        return dataObject != null && (type = dataObject.getName()).equalsIgnoreCase("F7");
    }

    public static byte[] getBytes(Object object) {
        byte[] bytes = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            bytes = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return bytes;
    }

    public static Object getObject(byte[] bytes) {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return object;
    }

    private Object getFromCustomerParams(CustomerParams cp, String key) throws EASBizException {
        if (cp != null) {
            String s = cp.getCustomerParam(key);
            if (s != null) {
                byte[] bytes = Base64Encoder.base64ToByteArray((String)s);
                Object object = null;
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    object = objectInputStream.readObject();
                    return object;
                }
                catch (Exception e) {
                    throw new RptException(RptException.IOSERIALIZABLE_ERROR);
                }
            }
            throw new RptException(RptException.IOSERIALIZABLE_ERROR);
        }
        return null;
    }

    private IObjectValue getF7ValueInfo(String id) {
        ObjectUuidPK objpk = new ObjectUuidPK(id);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        try {
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)this.ctx);
            IObjectValue billInfo = iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, sic);
            return billInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getResourceName() {
        return RES_PATH;
    }

    protected synchronized List getIdList(int start, int length, List list) {
        if (start + 1 > list.size()) {
            return null;
        }
        if (start + length > list.size()) {
            length = list.size() - start;
        }
        List subList = list.subList(start, start + length);
        return subList;
    }

    protected Map getCustomCond(Map condition) throws EASBizException, BOSException {
        return null;
    }

    protected String getDaoClassName() {
        return null;
    }

    public boolean isContainsKey(String[] columns, String str) {
        boolean bool = false;
        for (int i = 0; i < columns.length; ++i) {
            if (!str.equals(columns[i])) continue;
            bool = true;
        }
        return bool;
    }

    protected FaRptBaseConditionBuilder getConditionBuilder(Context ctx, Map condition) {
        return null;
    }

    protected TreeColumn getTreeColumn() {
        String treeTitle = FaLocalUtils.getResource((Context)this.ctx, (String)RES_PATH, (String)"orgArchitecture");
        TreeColumn treeColumn = new TreeColumn(0, "orgArchitecture", treeTitle);
        return treeColumn;
    }

    @Override
    public int expandRow(String queryId, int rowIndex) throws BOSException, EASBizException {
        return this.getTreeIdsList(this.ctx, queryId).expandRow(rowIndex);
    }

    public int expandAllRow(String queryId, int rowIndex) throws BOSException, EASBizException {
        return this.getTreeIdsList(this.ctx, queryId).expandRow(rowIndex);
    }

    @Override
    public int shrinkRow(String queryId, int rowIndex) throws BOSException, EASBizException {
        return this.getTreeIdsList(this.ctx, queryId).shrinkRow(rowIndex);
    }

    protected TreeIdsList getTreeIdsList(Context ctx, String queryId) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        return cache.getTreeIdsList();
    }

    protected List getAllIdsList(Context ctx, String queryId) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        return cache.getAllIdsList();
    }

    protected FaDaoSqlObject getFaDaoSqlObject(Context ctx, String queryId) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        return cache.getFaDaoSqlObject();
    }

    protected List getSumColList(Context ctx, String queryId) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        return cache.getDynShowColumnList().getSumColList();
    }

    protected Map getSumColObjMap(Context ctx, String queryId) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        return cache.getDynShowColumnList().getColumnObjMap();
    }

    protected List getHideSumColList(Context ctx, String queryId) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        return cache.getDynShowColumnList().getHideSumColList();
    }

    protected List getColumnNameListForSum(Context ctx, String queryId) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        return cache.getDynShowColumnList().getColumnNameListForSum();
    }

    protected List getAllUserDefineShowColList(Context ctx, String queryId) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        return cache.getDynShowColumnList().getAllUserDefineShowColList();
    }

    protected List getAllColumnList(Context ctx, String queryId) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        return cache.getDynShowColumnList().getAllColumnList();
    }

    protected Map getFilterKeyMap(Context ctx, String queryId) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        return cache.getFilterKeyMap();
    }

    protected boolean isFirst(Context ctx, String queryId) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        return cache.isFirst();
    }

    protected boolean isSumStyle(Context ctx, String queryId) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        return cache.isSumStyle();
    }

    protected void setFirstToCache(Context ctx, String queryId, boolean isFirst) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        cache.setFirst(isFirst);
    }

    protected void setFilterKeyMapToCache(Context ctx, String queryId, Map filterKeyMap) throws FaRptException {
        FaRptCache cache = FaRptCache.getFaRptCache(ctx, queryId);
        if (cache == null) {
            throw new FaRptException(FaRptException.SESSION_INVALID);
        }
        cache.setFilterKeyMap(filterKeyMap);
    }

    protected int indexof(List idList, IRowSet rs) throws SQLException {
        if (idList == null) {
            return -1;
        }
        String FID = rs.getString(ID);
        for (int i = 0; i < idList.size(); ++i) {
            if (!idList.get(i).equals(FID)) continue;
            return i;
        }
        return -1;
    }

    protected boolean isCommonUse(String panelType) {
        return panelType.indexOf("_commonuse_") != -1;
    }

    protected FaDaoSqlObject cloneFaDaoSqlObject(FaDaoSqlObject faDaoSqlObject) {
        FaDaoSqlObject newResultSql = new FaDaoSqlObject();
        newResultSql.setSelect(faDaoSqlObject.getSelect());
        newResultSql.setFrom(faDaoSqlObject.getFrom());
        newResultSql.setWhere(faDaoSqlObject.getWhere());
        newResultSql.setOrder(faDaoSqlObject.getOrder());
        newResultSql.setGroup(faDaoSqlObject.getGroup());
        newResultSql.setHaving(faDaoSqlObject.getHaving());
        newResultSql.setSecondTable(faDaoSqlObject.getSecondTable());
        return newResultSql;
    }

    protected void updateField(FARptRowSet rowData, String colName, Object value) throws BOSException, EASBizException, SQLException {
        rowData.updateObject(colName, value);
    }

    @Override
    public void releaseDataSource(String queryId) throws BOSException {
        if (queryId != null) {
            this.getBizCtrl().dropTempTable(queryId);
            FaRptCache.clearFaRptCache(this.ctx, queryId);
        }
    }

    public IFaList getBizCtrl() throws BOSException {
        return FaListFactory.getLocalInstance((Context)this.ctx);
    }

    @Override
    public Map exportData(Map condition) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Map queryResultMap = this.query(condition);
        String queryId = (String)queryResultMap.get(QUERYID);
        List allIdsList = this.getAllIdsList(this.ctx, queryId);
        if (allIdsList == null) {
            allIdsList = this.getTreeIdsList(this.ctx, queryId).getIdList();
        }
        FaDaoSqlObject newResultSql = this.cloneFaDaoSqlObject(this.resultSql);
        IRowSet rowSet = this.getBizCtrl().getDataForIdListFromWeb(newResultSql, allIdsList);
        List hideColumnList = this.dynShowColumnList.getHideSumColList();
        List sumColumnList = this.dynShowColumnList.getSumColList();
        Map columnObjMap = this.dynShowColumnList.getColumnObjMap();
        try {
            FARptRowSet rptRowSet = this.getRowSetDataForExportData(queryId, -1, allIdsList, 0, rowSet);
            if (hideColumnList != null && hideColumnList.size() > 0 || sumColumnList != null && sumColumnList.size() > 0) {
                String[] columnKeys;
                ArrayList<String> newKeysList = new ArrayList<String>();
                ArrayList<String> defProList = new ArrayList<String>();
                int indexOfStr = 0;
                for (String key : columnKeys = rptRowSet.getColumKeys()) {
                    if (hideColumnList.indexOf(key) != -1) continue;
                    indexOfStr = key.indexOf("_");
                    if (indexOfStr > -1 && !key.startsWith("DEF_") && !key.startsWith("PV_")) {
                        boolean flag = false;
                        for (int i = 0; i < sumColumnList.size(); ++i) {
                            if (!((String)sumColumnList.get(i)).startsWith(key.substring(0, indexOfStr))) continue;
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        newKeysList.add(key);
                        continue;
                    }
                    if (key.startsWith("DEF_")) {
                        String subStr1 = key.substring(key.indexOf("DEF_") + "DEF_".length());
                        defProList.add(subStr1);
                        newKeysList.add(key);
                        continue;
                    }
                    if (key.startsWith("PV_")) {
                        this.doDefPropertyColumn(key, defProList, newKeysList);
                        continue;
                    }
                    if ("scrollTh".equals(key)) continue;
                    newKeysList.add(key);
                }
                String[] columnArr = null;
                Object[] objArr = newKeysList.toArray();
                columnArr = new String[objArr.length];
                ArrayList stringColList = ArrayUtil.objects2ArrayList((Object[])objArr);
                stringColList.toArray(columnArr);
                FARptRowSet rowSetNew = new FARptRowSet(columnArr, rptRowSet.size());
                rptRowSet.beforeFirst();
                columnKeys = rowSetNew.getColumKeys();
                while (rptRowSet.next()) {
                    for (String key : columnKeys) {
                        int rowIndex = rptRowSet.getRowIndex();
                        rowSetNew.insertRow(rowIndex);
                        rowSetNew.setRowIndex(rowIndex);
                        this.updateField(rowSetNew, key, rptRowSet.getObject(key));
                    }
                }
                resultMap.put("rowSet", rowSetNew);
            } else {
                resultMap.put("rowSet", rptRowSet);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        this.releaseDataSource(queryId);
        HashMap data = new HashMap();
        data.put("currencyPrecision", queryResultMap.get("currencyPrecision"));
        data.put("deprRate", queryResultMap.get("deprRate"));
        data.put("quantity", queryResultMap.get("quantity"));
        resultMap.put("precMap", data);
        resultMap.put("sumColObjMap", columnObjMap);
        return resultMap;
    }

    protected void doDefPropertyColumn(String key, List<String> sumDefProList, List keyList) {
    }

    @Override
    public Map query(Map condition) throws BOSException, EASBizException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.faBaseConBuilder = this.getConditionBuilder(this.ctx, condition);
        EntityViewInfo ev = this.faBaseConBuilder.getView();
        Map queryResult = this.getBizCtrl().buildData(ev, DAOPATH + this.getDaoClassName());
        this.resultSql = (FaDaoSqlObject)queryResult.get(RESULTSQL);
        String queryId = queryResult.get(TEMPTABLENAME).toString();
        FaRptCache cache = FaRptCache.createFaRptCache(this.ctx, queryId);
        cache.setFaDaoSqlObject(this.resultSql);
        List<String> columnNameListForSum = this.faBaseConBuilder.getColumnNameListForSum();
        Map dynamicShowColumnMap = this.getDynamicShowColumnMap(queryResult, columnNameListForSum);
        FaDaoSqlObject newResultSql = this.cloneFaDaoSqlObject(this.resultSql);
        boolean isVirtual = this.faBaseConBuilder.isVirtualCompany();
        Integer defCompanyLevel = this.faBaseConBuilder.getDefCompanyLevel();
        ArrayList<String> allIdsList = new ArrayList<String>();
        try {
            if (isVirtual && defCompanyLevel != null) {
                TreeIdsList treeIdsList = new TreeIdsList(this.getTreeColumn().getTopLevel());
                treeIdsList.initNode(this.ctx, newResultSql, defCompanyLevel - 1);
                cache.setTreeIdsList(treeIdsList);
            } else {
                IRowSet rowSet = this.getBizCtrl().getIdList(newResultSql);
                while (rowSet.next()) {
                    String fid = rowSet.getString(ID);
                    allIdsList.add(fid);
                }
                cache.setAllIdsList(allIdsList);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        data.put(QUERYID, queryId);
        data.put("records", isVirtual ? this.getTreeIdsList(this.ctx, queryId).getViewRowCount() : allIdsList.size());
        this.dynShowColumnList = new DynShowColumnList();
        List sumColunmNameList = (List)dynamicShowColumnMap.get("sumColumnNameList");
        List hideSumNameColList = (List)dynamicShowColumnMap.get("hideSumColList");
        Map columnObjMap = (Map)dynamicShowColumnMap.get("columnObjMap");
        ArrayList<String> allUserDefineShowColList = new ArrayList<String>();
        List allColumnList = (List)dynamicShowColumnMap.get("allSumColList");
        allUserDefineShowColList.addAll(sumColunmNameList);
        boolean isSumStyle = this.faBaseConBuilder.isSumStyle();
        cache.setSumStyle(isSumStyle);
        if (this.faBaseConBuilder.getCustomDefQueryList().size() > 0 || this.faBaseConBuilder.getCustomDefQueryForSumStyle().size() > 0) {
            List<String> customDefQueryList = null;
            customDefQueryList = isSumStyle ? this.faBaseConBuilder.getCustomDefQueryForSumStyle() : this.faBaseConBuilder.getCustomDefQueryList();
            allUserDefineShowColList.addAll(allUserDefineShowColList.size(), customDefQueryList);
            allColumnList.addAll(allColumnList.size(), customDefQueryList);
        }
        List defColumnNameList = (List)dynamicShowColumnMap.get("defColumnNameList");
        if (!isSumStyle) {
            allUserDefineShowColList.addAll(allUserDefineShowColList.size(), defColumnNameList);
            allColumnList.addAll(allColumnList.size(), defColumnNameList);
        }
        this.dynShowColumnList.setAllUserDefineShowColList(allUserDefineShowColList);
        this.dynShowColumnList.setAllColumnList(allColumnList);
        this.dynShowColumnList.setColumnNameListForSum(columnNameListForSum);
        this.dynShowColumnList.setSumColList(sumColunmNameList);
        this.dynShowColumnList.setColumnObjMap(columnObjMap);
        this.dynShowColumnList.setHideSumColList(hideSumNameColList);
        cache.setDynShowColumnList(this.dynShowColumnList);
        HashMap<String, Object> dynShowMap = new HashMap<String, Object>();
        dynShowMap.put("sumColumnNameList", sumColunmNameList);
        dynShowMap.put("defColumnNameList", defColumnNameList);
        dynShowMap.put("columnObjMap", columnObjMap);
        data.put("dynamicShowColumnMap", dynShowMap);
        String companyId = this.faBaseConBuilder.getCompanyId();
        CompanyOrgUnitInfo compayInfo = this.getCompanyInfo(companyId, "id,name,baseCurrency.id,baseCurrency.name,baseCurrency.precision");
        ObjectUuidPK pk = new ObjectUuidPK(companyId);
        this.paramMap = FaManageUtils.getFAParameter((BOSUuid)BOSUuid.read((String)companyId), (Context)this.ctx);
        data.put("isUseGroupNumber", this.paramMap.get("FA_030"));
        data.put("currencyPrecision", compayInfo.getBaseCurrency().getPrecision());
        data.put("deprRate", this.paramMap.get("FA_007"));
        data.put("quantity", this.paramMap.get("FA_008"));
        return data;
    }

    private Map getDynamicShowColumnMap(Map queryResult, List<String> columnNameListForSum) {
        FaDaoSqlObject resultSql = (FaDaoSqlObject)queryResult.get(RESULTSQL);
        List sumColumnName = (List)queryResult.get("sumColumnName");
        HashMap<String, Cloneable> map = new HashMap<String, Cloneable>();
        SumGroupInfo sumGroupInfo = null;
        String subName = null;
        HashMap<String, String> columnObjMapForWebShow = new HashMap<String, String>();
        ArrayList<String> columnNameListForWebShow = new ArrayList<String>();
        ArrayList<String> hideSumColList = new ArrayList<String>();
        ArrayList<String> allSumColList = new ArrayList<String>();
        for (int h = 0; h < columnNameListForSum.size(); ++h) {
            for (int i = 0; i < sumColumnName.size(); ++i) {
                sumGroupInfo = (SumGroupInfo)sumColumnName.get(i);
                subName = columnNameListForSum.get(h);
                if ("asstActItem".equals(subName)) {
                    if (!sumGroupInfo.getNumber().startsWith("asstAct")) continue;
                    if (sumGroupInfo.isVisualable()) {
                        columnNameListForWebShow.add(columnNameListForWebShow.size(), sumGroupInfo.getNumber().toUpperCase());
                        columnObjMapForWebShow.put(sumGroupInfo.getNumber().toUpperCase(), sumGroupInfo.getName());
                    } else {
                        hideSumColList.add(sumGroupInfo.getNumber().toUpperCase());
                    }
                    allSumColList.add(sumGroupInfo.getNumber().toUpperCase());
                    continue;
                }
                if ((!"storeCity".equalsIgnoreCase(subName) || !sumGroupInfo.getNumber().equalsIgnoreCase("STORECITYName")) && !sumGroupInfo.getNumber().startsWith(subName)) continue;
                if (sumGroupInfo.isVisualable()) {
                    columnNameListForWebShow.add(columnNameListForWebShow.size(), sumGroupInfo.getNumber().toUpperCase());
                    columnObjMapForWebShow.put(sumGroupInfo.getNumber().toUpperCase(), sumGroupInfo.getName());
                } else {
                    hideSumColList.add(sumGroupInfo.getNumber().toUpperCase());
                }
                allSumColList.add(sumGroupInfo.getNumber().toUpperCase());
            }
        }
        FaDefPropertyCollection pc = (FaDefPropertyCollection)queryResult.get("pc");
        String[] showColumnArr = resultSql.getSelect().split(",");
        String treeName = this.getTreeColumn().getColumnName();
        String treeTitle = this.getTreeColumn().getColumnTitle();
        ArrayList<String> defColumnNameList = new ArrayList<String>();
        boolean first = true;
        for (int i = 0; i < showColumnArr.length; ++i) {
            if (showColumnArr[i].indexOf(treeName) != -1 && first) {
                columnNameListForWebShow.add(treeName.toUpperCase());
                allSumColList.add(treeName.toUpperCase());
                columnObjMapForWebShow.put(treeName.toUpperCase(), treeTitle);
                first = false;
                continue;
            }
            if (!showColumnArr[i].startsWith("PV_")) continue;
            defColumnNameList.add(showColumnArr[i].trim().toUpperCase());
        }
        FaDefPropertyInfo pi = null;
        for (int i = 0; i < pc.size(); ++i) {
            pi = pc.get(i);
            if (!defColumnNameList.contains("PV_" + pi.getNumber().toUpperCase())) continue;
            columnObjMapForWebShow.put("PV_" + pi.getNumber().toUpperCase(), pi.getName());
        }
        map.put("sumColumnNameList", columnNameListForWebShow);
        map.put("defColumnNameList", defColumnNameList);
        map.put("columnObjMap", columnObjMapForWebShow);
        map.put("hideSumColList", hideSumColList);
        map.put("allSumColList", allSumColList);
        return map;
    }

    @Override
    public Map getData(String queryId, String page, String records, String rows, String currentIndex) throws BOSException, EASBizException {
        int from;
        HashMap<String, Object> data = new HashMap<String, Object>();
        FaDaoSqlObject resultSql = this.getFaDaoSqlObject(this.ctx, queryId);
        int intCurrentIndex = -1;
        if (currentIndex != null && currentIndex.trim().length() > 0) {
            intCurrentIndex = Integer.parseInt(currentIndex.trim());
            ++intCurrentIndex;
        }
        if (page == null) {
            page = "1";
        }
        if (rows == null) {
            rows = "100";
        }
        int intPage = Integer.parseInt(page);
        int intRows = Integer.parseInt(rows);
        int intRecords = Integer.parseInt(records);
        int total = intRecords / intRows;
        if (total * intRows < intRecords) {
            ++total;
        }
        if ((from = (intPage - 1) * intRows) >= intRecords) {
            intPage = 1;
            from = 0;
        }
        List allIdsList = this.getAllIdsList(this.ctx, queryId);
        List idList = null;
        idList = allIdsList == null ? this.getTreeIdsList(this.ctx, queryId).getIdList(from, intRows) : this.getIdList(from, intRows, allIdsList);
        FaDaoSqlObject newResultSql = this.cloneFaDaoSqlObject(resultSql);
        IRowSet rowSet = this.getBizCtrl().getDataForIdListFromWeb(newResultSql, idList);
        ArrayList datas = null;
        try {
            FARptRowSet faRptRowSet = this.getRowSetData(queryId, intCurrentIndex, idList, from, rowSet);
            String[] keys = faRptRowSet.getColumKeys();
            datas = new ArrayList(faRptRowSet.size());
            faRptRowSet.beforeFirst();
            while (faRptRowSet.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                int rowIndex = faRptRowSet.getRowIndex();
                if (rowIndex < intCurrentIndex) continue;
                row.put("id", rowIndex);
                if (intCurrentIndex > 0) {
                    row.put("crn", rowIndex + 1);
                }
                boolean firstBool = true;
                for (String key : keys) {
                    Object value = faRptRowSet.getObject(key);
                    if (key.startsWith(this.getTreeColumn().getColumnName().toUpperCase(Locale.ENGLISH))) {
                        if (value instanceof IDNode) {
                            IDNode treeNode = (IDNode)value;
                            row.put(this.getTreeColumn().getColumnName().toUpperCase(Locale.ENGLISH), treeNode.getName());
                            row.put("level", treeNode.getLevel());
                            row.put("parent", "todo");
                            row.put("expanded", treeNode.isOpen());
                            row.put("isLeaf", treeNode.isLeaf());
                            firstBool = false;
                            continue;
                        }
                        if (!firstBool) continue;
                        row.put(this.getTreeColumn().getColumnName().toUpperCase(), "");
                        continue;
                    }
                    if (value != null && ResourceBase.getString((String)"com.kingdee.eas.fi.fa.facade.FACADEAutoGenerateResource", (String)"5_FaRptBaseServiceImpl", (Locale)this.ctx.getLocale()).equals(value.toString())) {
                        row.put(key, ResourceBase.getString((String)"com.kingdee.eas.fi.fa.facade.FACADEAutoGenerateResource", (String)"5_FaRptBaseServiceImpl", (Locale)this.ctx.getLocale()));
                        continue;
                    }
                    row.put(key, value);
                }
                datas.add(row);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        data.put("page", page);
        data.put("total", total);
        data.put("records", allIdsList == null ? this.getTreeIdsList(this.ctx, queryId).getViewRowCount() : allIdsList.size());
        data.put("rows", datas);
        data.put(QUERYID, queryId);
        return data;
    }

    public FARptRowSet getRowSetDataForExportData(String queryId, int intCurrentIndex, List allIdsList, int start, IRowSet rs) throws BOSException, EASBizException, SQLException {
        List columnList = this.dynShowColumnList.getAllColumnList();
        columnList.add(ISTOTAL);
        String[] columnArr = null;
        Object[] objArr = columnList.toArray();
        columnArr = new String[objArr.length];
        ArrayList stringColList = ArrayUtil.objects2ArrayList((Object[])objArr);
        stringColList.toArray(columnArr);
        FARptRowSet rowSet = new FARptRowSet(columnArr, rs.size());
        try {
            while (rs.next()) {
                int rowIndex = this.indexof(allIdsList, rs);
                rowSet.insertRow(rowIndex);
                rowSet.setRowIndex(rowIndex + start);
                this.toFARptRowData(queryId, rowIndex + start, intCurrentIndex, rs, rowSet);
                this.doFARptRowData(queryId, rowSet);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return rowSet;
    }

    protected void doFARptRowData(String queryId, FARptRowSet rowSet) throws EASBizException, BOSException, SQLException {
        String[] keys;
        if (this.hideSumColList == null) {
            this.hideSumColList = this.getHideSumColList(this.ctx, queryId);
        }
        if (this.columnNameListForSum == null) {
            this.columnNameListForSum = this.getColumnNameListForSum(this.ctx, queryId);
        }
        if (this.allUserDefineShowList == null) {
            this.allUserDefineShowList = this.getAllUserDefineShowColList(this.ctx, queryId);
        }
        List sumStyShowColList = this.getSumStyleShowColumnList();
        for (String colName : keys = rowSet.getColumKeys()) {
            Object value = rowSet.getObject(colName);
            if (this.hideSumColList == null || this.hideSumColList.indexOf(colName) == -1 || !this.sub_total.equals(value)) continue;
            Iterator it = this.columnNameListForSum.iterator();
            while (it.hasNext()) {
                String name = it.next().toString().toUpperCase();
                if (colName.indexOf(name) == -1) continue;
                String subStr = colName.substring(colName.indexOf(name) + name.length());
                Integer num = Integer.valueOf(subStr.substring(0, subStr.indexOf(NAME.toUpperCase())));
                String newColName = this.allUserDefineShowList.get(this.allUserDefineShowList.indexOf(name + (num - 1) + NAME.toUpperCase()) + 1);
                if (newColName.equals(this.getTreeColumn().getColumnName().toUpperCase(Locale.ENGLISH))) {
                    IDNode node = new IDNode();
                    node.setName(this.sub_total);
                    node.setLeaf(true);
                    node.setLevel(-1);
                    node.setOpen(false);
                    this.updateField(rowSet, newColName, node);
                    continue;
                }
                if (sumStyShowColList.indexOf(newColName) != -1) continue;
                this.updateField(rowSet, newColName, this.sub_total);
            }
        }
    }

    protected void toFARptRowData(String queryId, int index, int intCurrentIndex, IRowSet rs, FARptRowSet rowData) throws BOSException, EASBizException, SQLException {
        if (this.sub_total == null) {
            this.sub_total = FaLocalUtils.getResource((Context)this.ctx, (String)RES_PATH, (String)SUBTOTAL);
        }
        if (this.total == null) {
            this.total = FaLocalUtils.getResource((Context)this.ctx, (String)RES_PATH, (String)TOTAL2);
        }
        if (this.sumColList == null) {
            this.sumColList = this.getSumColList(this.ctx, queryId);
        }
        int topLevel = this.getTreeColumn().getTopLevel();
        String topNode = this.getTreeColumn().getType() + topLevel + NAME;
        Map filterKeyMap = this.getFilterKeyMap(this.ctx, queryId);
        boolean isCurrentFirst = true;
        ResultSetMetaData md = rs.getMetaData();
        int count = md.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String compareStr;
            String colName = md.getColumnName(i).toUpperCase(Locale.ENGLISH);
            Object value = null;
            if (md.getColumnType(i) == 91 || md.getColumnType(i) == 93) {
                Date date = rs.getDate(i);
                if (date != null) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    value = df.format(date);
                }
                this.updateField(rowData, colName, value);
                continue;
            }
            if (index < intCurrentIndex && isCurrentFirst) {
                isCurrentFirst = false;
                if (!this.isFirst(this.ctx, queryId)) {
                    if (index == intCurrentIndex - 1) {
                        for (int j = 1; j <= rs.getMetaData().getColumnCount(); ++j) {
                            String columnName = rs.getMetaData().getColumnName(j).toUpperCase(Locale.ENGLISH);
                            Object columnValue = rs.getObject(j);
                            if (this.sumColList == null || this.sumColList.indexOf(this.getTreeColumn().getColumnName().toUpperCase(Locale.ENGLISH)) == -1 || this.sumColList.indexOf(columnName) == -1) continue;
                            filterKeyMap.put(columnName, columnValue == null || columnValue.equals(this.sub_total) ? "" : columnValue);
                        }
                    }
                } else {
                    this.setFirstToCache(this.ctx, queryId, false);
                }
            }
            value = rs.getObject(i);
            boolean isVim = false;
            int length = this.getTreeColumn().getColumnName().toUpperCase(Locale.ENGLISH).length();
            if (colName != null && colName.length() >= length && (compareStr = colName.substring(0, length)).equalsIgnoreCase(this.getTreeColumn().getColumnName().toUpperCase(Locale.ENGLISH))) {
                isVim = true;
            }
            if (isVim) {
                IDNode currentNode = this.getTreeIdsList(this.ctx, queryId).getIDNode(index);
                int level = currentNode.getLevel();
                String treeName = this.getTreeColumn().getType() + level + NAME;
                if (colName.equalsIgnoreCase(treeName)) {
                    String nodeName = rs.getString(this.getTreeColumn().getType() + level + NAME);
                    if (level > topLevel - 1 && !currentNode.isLeaf()) {
                        if (this.sub_total != null && !"".equals(this.sub_total) && this.sub_total.equals(rs.getString(topNode))) {
                            currentNode.setName(this.sub_total);
                            currentNode.setLevel(topLevel);
                            this.updateField(rowData, this.getTreeColumn().getColumnName().toUpperCase(Locale.ENGLISH), this.sub_total);
                        } else {
                            currentNode.setName(nodeName);
                            this.updateField(rowData, this.getTreeColumn().getColumnName().toUpperCase(Locale.ENGLISH), currentNode);
                        }
                    } else if (level > topLevel - 1 && currentNode.isLeaf() && this.isSumStyle(this.ctx, queryId)) {
                        currentNode.setName(nodeName);
                        this.updateField(rowData, this.getTreeColumn().getColumnName().toUpperCase(Locale.ENGLISH), currentNode);
                    }
                }
            } else {
                if (colName.equals(ID)) continue;
                this.updateField(rowData, colName, value);
            }
            if (!this.total.equals(value) && !this.sub_total.equals(value) || colName.startsWith(this.getTreeColumn().getColumnName().toUpperCase(Locale.ENGLISH))) continue;
            this.updateField(rowData, ISTOTAL, true);
        }
        this.setFilterKeyMapToCache(this.ctx, queryId, filterKeyMap);
    }

    protected void doFARptRowDataDetail(String queryId, FARptRowSet rowSet) throws EASBizException, BOSException, SQLException {
    }

    public FARptRowSet getRowSetData(String queryId, int intCurrentIndex, List allIdsList, int start, IRowSet rs) throws BOSException, EASBizException, SQLException {
        IRowSetMetaData rowSetMetaData = rs.getRowSetMetaData();
        String[] columnArr = null;
        ArrayList<String> columnList = new ArrayList<String>();
        boolean first = true;
        String treeName = this.getTreeColumn().getColumnName().toUpperCase(Locale.ENGLISH);
        for (int i = 1; i <= rowSetMetaData.getColumnCount(); ++i) {
            String colName = rowSetMetaData.getColumnName(i).toUpperCase(Locale.ENGLISH);
            if (colName.startsWith(treeName)) {
                if (!first) continue;
                columnList.add(treeName);
                first = false;
                continue;
            }
            columnList.add(colName);
        }
        columnList.add(ISTOTAL);
        Object[] objArr = columnList.toArray();
        columnArr = new String[objArr.length];
        ArrayList stringColList = ArrayUtil.objects2ArrayList((Object[])objArr);
        stringColList.toArray(columnArr);
        FARptRowSet rowSet = new FARptRowSet(columnArr, rs.size());
        try {
            while (rs.next()) {
                int rowIndex = this.indexof(allIdsList, rs);
                rowSet.insertRow(rowIndex);
                rowSet.setRowIndex(rowIndex + start);
                this.toFARptRowData(queryId, rowIndex + start, intCurrentIndex, rs, rowSet);
                this.doFARptRowData(queryId, rowSet);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return rowSet;
    }

    protected List getSumStyleShowColumnList() {
        return new ArrayList();
    }

    public CompanyOrgUnitInfo[] getValidCompanys(Set companyIDs, String accountTableId, String periodTypeId, String periodNumber) throws BOSException, EASBizException {
        if (companyIDs == null || companyIDs.size() == 0) {
            return null;
        }
        StringBuffer filterSql = new StringBuffer();
        filterSql.append(" select com.fid from t_org_company com ");
        filterSql.append(" inner join t_bd_acct_contorl ac on ac.fdestcompanyid = com.fid ");
        filterSql.append(" inner join t_bd_accounttable ab on ab.fid = ac.faccounttableid ");
        filterSql.append(" inner join t_bd_systemstatusctrol ssc on ssc.fcompanyid = com.fid");
        filterSql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(14);
        filterSql.append(" inner join t_bd_period pe on pe.fid = ssc.fstartperiodid ");
        filterSql.append(" where ac.FIsDefaultForRefer = 0 ");
        if (accountTableId != null) {
            filterSql.append(" and ab.fid = '").append(accountTableId).append("'");
        }
        filterSql.append(" and com.fid in ").append(FaRptBaseServiceImpl.getIdStr(companyIDs));
        filterSql.append(" and pe.fnumber <= ").append(periodNumber);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        if (periodTypeId != null) {
            fic.add(new FilterItemInfo("accountPeriodType.id", (Object)periodTypeId));
        }
        fic.add(new FilterItemInfo("id", (Object)filterSql.toString(), CompareType.INNER));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longnumber"));
        view.setFilter(filter);
        view.setSelector(GlUtils.getCompanySic());
        view.setSorter(sorter);
        CompanyOrgUnitCollection companyCollection = null;
        try {
            companyCollection = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (companyCollection == null) {
            return null;
        }
        CompanyOrgUnitInfo[] checkedCompanys = new CompanyOrgUnitInfo[companyCollection.size()];
        for (int i = 0; i < companyCollection.size(); ++i) {
            checkedCompanys[i] = companyCollection.get(i);
        }
        return checkedCompanys;
    }

    public static String getIdStr(Set idSet) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer ids = new StringBuffer();
        Iterator it = idSet.iterator();
        ids.append("('").append(it.next()).append("'");
        while (it.hasNext()) {
            ids.append(",'").append(it.next()).append("'");
        }
        ids.append(")");
        return ids.toString();
    }

    public String getAllParentCompanyID(Set companyIdSet) throws BOSException {
        StringBuffer parents = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("select pcp.fid from t_org_company pcp inner join t_org_company cp on (charindex(pcp.flongnumber||'!', cp.flongnumber) = 1 or pcp.fid = cp.fid) where cp.fid in(");
        Iterator it = companyIdSet.iterator();
        sql.append("'").append(it.next()).append("'");
        while (it.hasNext()) {
            sql.append(",'").append(it.next()).append("'");
        }
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                parents.append("'").append(rs.getString("fid")).append("'");
            }
            while (rs.next()) {
                parents.append(",'").append(rs.getString("fid")).append("'");
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql error!", (Throwable)e);
        }
        return parents.toString();
    }

    private AccountTableCollection getAccountTableCollection(Context ctx, boolean isSupportUnion) throws ReportBizException, BOSException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (!company.isIsBizUnit() && isSupportUnion) {
            return AccountTools.getAllAccountTableByCompany((Context)ctx, (CompanyOrgUnitInfo)company);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableCollection(view);
    }

    private PeriodTypeCollection getPeriodTypeCollection(Context ctx) throws ReportBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return PeriodTypeFactory.getLocalInstance((Context)ctx).getPeriodTypeCollection(view);
    }

    @Override
    public Map<String, Object> exportDataByNumber(Map condition, String queryId, String page, String records, String rows, String currentIndex, String where) throws BOSException, EASBizException {
        return null;
    }
}

