/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.smartaccounting;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.NBgControlCallerUtil;
import com.kingdee.eas.fi.fa.manage.FaCardValidatorImpl;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.vc.app.AbstractSmartAccountingProcess;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FaCurCardSubmitSmartAccounting
extends AbstractSmartAccountingProcess {
    private HashMap faParameter;

    public Map process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String billID = paramMap.get("billID").toString();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("error", "");
        try {
            IFaCurCard iFaCurCard = FaCurCardFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("assetCat.*"));
            sic.add(new SelectorItemInfo("currency.name"));
            sic.add(new SelectorItemInfo("currency.number"));
            sic.add(new SelectorItemInfo("currency.precision"));
            sic.add(new SelectorItemInfo("assetCat.isLeaf"));
            sic.add(new SelectorItemInfo("assetCat.isDeductInputTax"));
            sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
            sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.*"));
            sic.add(new SelectorItemInfo("originMethod.isLeaf"));
            sic.add(new SelectorItemInfo("originMethod.number"));
            sic.add(new SelectorItemInfo("useStatus.isLeaf"));
            sic.add(new SelectorItemInfo("useStatus.isDepreciation"));
            sic.add(new SelectorItemInfo("economicPurp.isLeaf"));
            sic.add(new SelectorItemInfo("dept.isLeaf"));
            sic.add(new SelectorItemInfo("accountAsset.isLeaf"));
            sic.add(new SelectorItemInfo("accountAccuDepr.isLeaf"));
            sic.add(new SelectorItemInfo("accountDecValue.isLeaf"));
            sic.add(new SelectorItemInfo("faCurFacility.*"));
            sic.add(new SelectorItemInfo("faCurDepartment.*"));
            sic.add(new SelectorItemInfo("faCurCostCenter.*"));
            sic.add(new SelectorItemInfo("faCurCostCenter.asstActType.*"));
            sic.add(new SelectorItemInfo("faCurCostCenter.asstActItem.*"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.isLeaf"));
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.longName"));
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
            sic.add(new SelectorItemInfo("accountAsset.longName"));
            sic.add(new SelectorItemInfo("accountAccuDepr.longName"));
            sic.add(new SelectorItemInfo("accountDecValue.longName"));
            sic.add(new SelectorItemInfo("deprMethod.*"));
            sic.add(new SelectorItemInfo("period.beginDate"));
            sic.add(new SelectorItemInfo("period.endDate"));
            sic.add(new SelectorItemInfo("period.periodYear"));
            sic.add(new SelectorItemInfo("period.periodNumber"));
            sic.add(new SelectorItemInfo("evalDeprMode.*"));
            sic.add(new SelectorItemInfo("assetCat.id"));
            sic.add(new SelectorItemInfo("assetCat.numberRule"));
            sic.add(new SelectorItemInfo("assetCat.number"));
            sic.add(new SelectorItemInfo("dept.id"));
            sic.add(new SelectorItemInfo("dept.name"));
            sic.add(new SelectorItemInfo("dept.number"));
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("CU.name"));
            sic.add(new SelectorItemInfo("CU.number"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("effectedStatus"));
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.baseCurrency.id"));
            sic.add(new SelectorItemInfo("company.baseCurrency.name"));
            sic.add(new SelectorItemInfo("company.baseCurrency.number"));
            HashSet<String> idset = new HashSet<String>();
            idset.add(billID);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
            view.put("selector", (Object)sic);
            FaCurCardCollection cards = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardCollection(view);
            FaCurCardInfo model = cards.get(0);
            FaCardValidatorImpl validator = new FaCardValidatorImpl((BillBaseInfo)new FaCurCardInfo(), null, false);
            model.put("oldCatID", model.getAssetCat() == null ? null : model.getAssetCat().getId());
            model.put("oldDeptID", model.getDept() == null ? null : model.getDept().getId());
            validator.setBillInfo((BillBaseInfo)model);
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fromBillUI", Boolean.FALSE);
            validator.setParam(params);
            HashMap hmResult = this.faParameter;
            if (hmResult != null && hmResult.size() != 0 && hmResult.get("FA_029") != null && !"false".equals(hmResult.get("FA_029"))) {
                NBgControlCallerUtil.checkBudget(null, (IObjectValue)model);
            }
            if (!validator.validate4smartAccounting()) {
                throw new Exception(validator.getInvalidMsg());
            }
            iFaCurCard.submit((CoreBaseInfo)model);
        }
        catch (Exception e) {
            result.put("error", e.getMessage());
        }
        return result;
    }

    public List getSourceBillList(Context ctx, String schemaID1, String businessEntryID1, String companyID, String filterSql, String queryPK, PeriodInfo periodInfo) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("FA_007", pk);
        paramKeyMap.put("FA_030", pk);
        paramKeyMap.put("FA_043", pk);
        paramKeyMap.put("FA_040", pk);
        paramKeyMap.put("FA_008", pk);
        paramKeyMap.put("FA_048", pk);
        paramKeyMap.put("FA_029", pk);
        paramKeyMap.put("FA_998", pk);
        paramKeyMap.put("FA_018", pk);
        paramKeyMap.put("FA_102", pk);
        paramKeyMap.put("FA_025", pk);
        paramKeyMap.put("G012", pk);
        this.faParameter = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
        List ids = new ArrayList();
        String filter = "";
        if (filterSql != null) {
            String oql = "select id where " + filterSql;
            IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
            IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, oql);
            String sql = iexec.getSQL();
            int distinctIndex = sql.indexOf("DISTINCT");
            int fromIndex = sql.indexOf("FROM");
            if (distinctIndex < 0 || distinctIndex > fromIndex) {
                sql = sql.replaceFirst("SELECT", "SELECT DISTINCT");
            }
            filter = sql;
        }
        StringBuffer sql = new StringBuffer("select t.fid, t.fnumber from t_fa_facurcard t where 1 = 1 ");
        if (periodInfo == null) {
            periodInfo = FaLocalUtils.getCurrentPeriod((Context)ctx, (String)companyID);
        }
        if (filter != null && filter.length() > 0) {
            sql.append(" and t.fid in ( ").append(filter).append(" ) ");
        }
        sql.append(" and t.FCompanyID = '").append(companyID).append("' ");
        sql.append(" and t.FPeriodID = '").append(periodInfo.getId().toString()).append("' ");
        sql.append(" and t.FEffectedStatus = '").append(1).append("' ");
        sql.append(" order by t.fnumber ");
        ids = this.getSourceBillRowSetNumber(ctx, sql.toString());
        return ids;
    }
}

