/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.smartaccounting;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.vc.SmartAccountEntryBusinessInfo;
import com.kingdee.eas.fi.vc.SmartAccountEntryCompanyInfo;
import com.kingdee.eas.fi.vc.SmartAccountingDetailRPTFactory;
import com.kingdee.eas.fi.vc.SmartAccountingDetailRPTInfo;
import com.kingdee.eas.fi.vc.SmartAccountingDetailStateEnum;
import com.kingdee.eas.fi.vc.SmartAccountingReportFactory;
import com.kingdee.eas.fi.vc.SmartAccountingReportInfo;
import com.kingdee.eas.fi.vc.SmartAccountingSchemaInfo;
import com.kingdee.eas.fi.vc.app.AbstractSmartAccountingProcess;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaDepCalSmartAccounting
extends AbstractSmartAccountingProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.facade.app.smartaccounting.FaDepCalSmartAccounting");

    public Map process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String companyID = paramMap.get("companyID").toString();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("error", "");
        try {
            HashMap<String, Comparable<Boolean>> hmPara = new HashMap<String, Comparable<Boolean>>();
            hmPara.put("all", Boolean.TRUE);
            hmPara.put("useSQL", Boolean.TRUE);
            hmPara.put("isNeedAudit", Boolean.FALSE);
            hmPara.put("threadCount", new Integer(2));
            boolean bo = FaDepCalFacadeFactory.getLocalInstance((Context)ctx).checkBeforeCal();
            HashMap hm = FaDepCalFacadeFactory.getLocalInstance((Context)ctx).calDep(hmPara, companyID);
            if (hm.get("msg") != null && !"".equals(hm.get("msg"))) {
                String msg = hm.get("msg").toString();
                logger.error((Object)msg);
                throw new Exception(msg);
            }
            result.put("state", 0);
            result.put("success", hm.get("DepCount") == null ? new Integer(0) : (Integer)hm.get("DepCount"));
            result.put("failure", 0);
            this.recordLog(ctx, paramMap, true, "");
        }
        catch (Exception e) {
            result.put("state", 1);
            result.put("success", 0);
            result.put("failure", 1);
            String resultLog = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.facade.FACADEAutoGenerateResource", (String)"71_FaDepCalSmartAccounting", (Locale)ctx.getLocale()) + e.getMessage();
            result.put("error", resultLog);
            logger.error((Object)resultLog);
            this.recordLog(ctx, paramMap, false, resultLog);
        }
        return result;
    }

    public List getSourceBillList(Context ctx, String schemaID1, String businessEntryID1, String companyID, String filterSql, String queryPK, PeriodInfo periodInfo) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", "depCalId");
        list.add(map);
        return list;
    }

    public void recordLog(Context ctx, Map paramMap, boolean success, String resultLog) throws BOSException, EASBizException {
        SmartAccountingDetailRPTInfo vrii = new SmartAccountingDetailRPTInfo();
        String billID = paramMap.get("billID").toString();
        String reportID = paramMap.get("reportID").toString();
        SmartAccountingReportInfo reportInfo = SmartAccountingReportFactory.getLocalInstance((Context)ctx).getSmartAccountingReportInfo((IObjectPK)new ObjectUuidPK(reportID), SmartAccountingReportInfo.getDefaultSelector());
        SmartAccountingSchemaInfo schemaInfo = reportInfo.getSmartAccounting();
        SmartAccountEntryBusinessInfo businessInfo = reportInfo.getBusinessEntry();
        SmartAccountEntryCompanyInfo comInfo = reportInfo.getCompanyEntry();
        try {
            vrii.setCompany(comInfo.getCompany());
            vrii.setSubSystem(businessInfo.getSubSystem());
            vrii.setBusinessType(businessInfo.getBusinessType().getId().toString());
            vrii.setBusinessNumber(businessInfo.getBusinessNumber());
            vrii.setOperatorNumber(businessInfo.getOperatorNumber());
            vrii.setBillID(billID);
            vrii.setBizDate((Date)GlUtils.getTime());
            vrii.setBillNumber(schemaInfo.getNumber());
            if (success) {
                vrii.setResultState(SmartAccountingDetailStateEnum.SUCCESS);
            } else {
                vrii.setResultState(SmartAccountingDetailStateEnum.FAIL);
            }
            vrii.setFailureCause(resultLog);
            vrii.setSmartAccounting(schemaInfo);
            vrii.setUser(schemaInfo.getBackSchedule().getCreator());
            vrii.setSmartAccountEntryBusiness(businessInfo);
            vrii.setSmartAccountEntryCompany(comInfo);
            vrii.put("report", (Object)reportID);
            SmartAccountingDetailRPTFactory.getLocalInstance((Context)ctx).submitReportDetailNew(vrii);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

