/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.participant.PerformerType;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class FasBosUtils {
    public static EntityViewBuilder entityViewBuilder() {
        return new EntityViewBuilder();
    }

    public static SelectorsBuilder selectorsBuilder() {
        return new SelectorsBuilder();
    }

    public static void appendSelectors(SelectorItemCollection selectors, String ... properties) {
        for (String p : properties) {
            selectors.add(new SelectorItemInfo(p));
        }
    }

    public static SelectorItemCollection buildSelectors(String ... properties) {
        SelectorItemCollection selectors = new SelectorItemCollection();
        FasBosUtils.appendSelectors(selectors, properties);
        return selectors;
    }

    public static List convertCollection(AbstractBaseObjectCollection collection) {
        ArrayList result = new ArrayList();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static boolean existsProcessDef(String packageName, String functionName, String operationName) throws BOSException {
        IEnactmentService wfService = EnactmentServiceFactory.createRemoteEnactService();
        ProcessDefInfo[] defInfo = wfService.getProcessDefInfos(packageName, functionName, operationName, PerformerType.ALL.getValue());
        return defInfo != null && defInfo.length > 0;
    }

    public static Set set(Object ... objects) {
        HashSet<Object> result = new HashSet<Object>();
        for (Object obj : objects) {
            result.add(obj);
        }
        return result;
    }

    public static CoreBaseInfo getOne(ICoreBase coreBase, EntityViewInfo view) throws BOSException {
        CoreBaseInfo coreBaseInfo = null;
        CoreBaseCollection c = coreBase.getCollection(view);
        if (!c.isEmpty()) {
            coreBaseInfo = c.get(0);
        }
        return coreBaseInfo;
    }

    public static class EntityViewBuilder {
        List<SelectorItemInfo> selectProperties = new ArrayList<SelectorItemInfo>();
        List<FilterItemInfo> filterItems = new ArrayList<FilterItemInfo>();
        List<SorterItemInfo> sorterItems = new ArrayList<SorterItemInfo>();
        private String oql;

        private EntityViewBuilder() {
        }

        public EntityViewBuilder select(String ... properties) {
            for (String pro : properties) {
                this.selectProperties.add(new SelectorItemInfo(pro));
            }
            return this;
        }

        public EntityViewBuilder filter(String compareExpress, Object compareValue, CompareType compareType) {
            this.filterItems.add(new FilterItemInfo(compareExpress, compareValue, compareType));
            return this;
        }

        public EntityViewBuilder filter(String compareExpress, Object compareValue) {
            this.filterItems.add(new FilterItemInfo(compareExpress, compareValue, CompareType.EQUALS));
            return this;
        }

        public EntityViewBuilder filter(String oql) {
            this.oql = oql;
            return this;
        }

        public EntityViewBuilder sort(String property, SortType sortType) {
            SorterItemInfo item = new SorterItemInfo(property);
            item.setSortType(sortType);
            this.sorterItems.add(item);
            return this;
        }

        public EntityViewInfo build() {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.setSelector(new SelectorItemCollection());
            view.setSorter(new SorterItemCollection());
            for (SelectorItemInfo selectorItemInfo : this.selectProperties) {
                view.getSelector().add(selectorItemInfo);
            }
            for (FilterItemInfo filterItemInfo : this.filterItems) {
                view.getFilter().getFilterItems().add(filterItemInfo);
            }
            for (SorterItemInfo sorterItemInfo : this.sorterItems) {
                view.getSorter().add(sorterItemInfo);
            }
            if (StringUtils.isNotEmpty((String)this.oql)) {
                view.getFilter().getFilterItems().add(new FilterItemInfo(this.oql));
            }
            return view;
        }
    }

    public static class SelectorsBuilder {
        private List<String> selectors = new ArrayList<String>();

        private SelectorsBuilder() {
        }

        public SelectorsBuilder select(String ... properties) {
            for (String s : properties) {
                this.selectors.add(s);
            }
            return this;
        }

        public SelectorItemCollection build() {
            SelectorItemCollection result = new SelectorItemCollection();
            for (String s : this.selectors) {
                result.add(s);
            }
            return result;
        }
    }
}

