/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.IFaDepCalStrategy;
import java.math.BigDecimal;
import java.util.HashMap;

public abstract class AbstractFaDepCalStrategy
implements IFaDepCalStrategy {
    private int deprRatePrecision = 6;
    private Integer baseScale = null;
    private int periodCount = 12;
    private Object userObject = null;
    public static final BigDecimal zero = new BigDecimal("0");

    protected int getValidPeriodCountofYear(Context ctx, PeriodInfo periodInfo) throws BOSException {
        return this.getPeriodCount();
    }

    protected int getBaseCurrencyPrecision(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        if (this.baseScale != null) {
            return this.baseScale;
        }
        if (companyInfo.getBaseCurrency() != null) {
            this.baseScale = new Integer(companyInfo.getBaseCurrency().getPrecision());
        } else {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id='" + companyInfo.getId() + "'");
            this.baseScale = new Integer(company.getBaseCurrency().getPrecision());
        }
        return this.baseScale;
    }

    @Override
    public int getDeprRatePrecision() {
        return this.deprRatePrecision;
    }

    @Override
    public abstract HashMap calcuatePeriodDepreResultDynamic(Context var1, FaCurCardInfo var2, PeriodInfo var3) throws BOSException, EASBizException;

    @Override
    public abstract HashMap calcuatePeriodDepreResultStatic(Context var1, FaCurCardInfo var2, PeriodInfo var3) throws BOSException, EASBizException;

    @Override
    public abstract HashMap getCalParameter(Context var1, FaDepreciationModeInfo var2) throws BOSException, EASBizException;

    @Override
    public boolean haveAmountForDep(FaCurCardInfo faCardInfo, Context ctx) throws BOSException {
        return this.getLeftAmount(faCardInfo).compareTo(new BigDecimal("0")) > 0;
    }

    @Override
    public boolean haveLifeForDep(FaCurCardInfo faCardInfo, Context ctx) throws BOSException {
        return this.getLeftLife(faCardInfo).compareTo(new BigDecimal("0")) > 0;
    }

    @Override
    public void setDeprRatePrecision(int deprRatePrecision) {
        this.deprRatePrecision = deprRatePrecision;
    }

    protected Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    protected BigDecimal getLeftLife(FaCurCardInfo faCardInfo) {
        BigDecimal useTermCount;
        BigDecimal bigDecimal = useTermCount = faCardInfo.getUseTermCount() == null ? new BigDecimal("0") : faCardInfo.getUseTermCount();
        if (useTermCount.compareTo(new BigDecimal("0")) <= 0) {
            return new BigDecimal("0");
        }
        BigDecimal deprTermCount = faCardInfo.getDeprTermCount() == null ? new BigDecimal("0") : faCardInfo.getDeprTermCount();
        BigDecimal result = useTermCount.subtract(deprTermCount);
        if (result.compareTo(new BigDecimal("0")) < 0) {
            return new BigDecimal("0");
        }
        return result;
    }

    protected BigDecimal getLeftAmount(FaCurCardInfo faCardInfo) {
        BigDecimal assetValue = faCardInfo.getAssetValue();
        if (assetValue == null || assetValue.compareTo(new BigDecimal("0")) <= 0) {
            return new BigDecimal("0");
        }
        BigDecimal accuDepr = faCardInfo.getAccuDepr() == null ? new BigDecimal("0") : faCardInfo.getAccuDepr();
        BigDecimal decValue = faCardInfo.getDecValue() == null ? new BigDecimal("0") : faCardInfo.getDecValue();
        BigDecimal neatRemValue = faCardInfo.getNeatRemValue() == null ? new BigDecimal("0") : faCardInfo.getNeatRemValue();
        BigDecimal result = assetValue.subtract(accuDepr).subtract(decValue).subtract(neatRemValue);
        if (result.compareTo(new BigDecimal("0")) > 0) {
            return result;
        }
        return new BigDecimal("0");
    }

    protected boolean isFinalyDepCal(FaCurCardInfo card) {
        BigDecimal left = this.getLeftLife(card);
        return left.compareTo(new BigDecimal(1)) == 0;
    }

    protected boolean isFinalyDepAllLeft(FaCurCardInfo card) throws BOSException {
        return FaDepLocalUtils.isLastPeriodAll(card);
    }

    protected boolean isYearDep(FaCurCardInfo card) throws BOSException {
        return FaDepLocalUtils.isYearDepCal(card);
    }

    protected BigDecimal dealPeriodAmount(FaCurCardInfo faCardInfo, BigDecimal oldAmount) throws BOSException {
        BigDecimal leftAmount = this.getLeftAmount(faCardInfo);
        if (oldAmount.compareTo(leftAmount) > 0 || this.isFinalyDepCal(faCardInfo) && this.isFinalyDepAllLeft(faCardInfo)) {
            oldAmount = leftAmount;
        }
        return oldAmount;
    }

    public int getPeriodCount() {
        return this.periodCount;
    }

    @Override
    public void setPeriodCount(int periodCount) {
        this.periodCount = periodCount;
    }
}

