/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaEconomicPurpInfo;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusInfo;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardCollection;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaTransCardToBookException;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaMonCard;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaAddStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.gl.InitException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CardForMulBook {
    private static final Logger logger = Logger.getLogger(CardForMulBook.class);
    private static String FABookResource = "com.kingdee.eas.fi.fa.manage.FaBookResource";
    Map mapValues = null;
    private static final long serialVersionUID = 6695827054925773062L;

    public static SelectorItemCollection getCompanySic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("isGrouping"));
        sic.add(new SelectorItemInfo("isGroup"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.id"));
        sic.add(new SelectorItemInfo("mainOrg.name"));
        sic.add(new SelectorItemInfo("mainOrg.number"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.name"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.number"));
        sic.add(new SelectorItemInfo("accountScheme.id"));
        sic.add(new SelectorItemInfo("accountScheme.name"));
        sic.add(new SelectorItemInfo("accountScheme.number"));
        return sic;
    }

    public static boolean checkFaInit(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
    }

    public static boolean isMasterBook(Context ctx) {
        return BooksUtil.isMasterBook((Context)ctx);
    }

    public static boolean isSynCard(Context ctx) {
        return BooksUtil.getCurrentBook((Context)ctx).isIsSyncCard();
    }

    public static boolean canCreateBook(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("G012", null);
        IParamControl pc = null;
        pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        boolean canCreateBook = false;
        if (hmAllParam.get("G012") != null) {
            canCreateBook = Boolean.valueOf(hmAllParam.get("G012").toString());
        }
        return canCreateBook;
    }

    public static String _changePeriod(Context ctx, FaCardInfo cardInfo, CompanyOrgUnitInfo mainOrg, CompanyOrgUnitInfo transferOrg) throws BOSException, EASBizException {
        if (mainOrg.getAccountPeriodType() == null) {
            mainOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrg.getId().toString()));
        }
        if (transferOrg.getAccountPeriodType() == null) {
            transferOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(transferOrg.getId().toString()));
        }
        if (mainOrg.getAccountPeriodType() == null || transferOrg.getAccountPeriodType() == null) {
            return ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"90_CardForMulBook", (Locale)ctx.getOriginLocale());
        }
        if (mainOrg.getAccountPeriodType().getId().toString().equals(transferOrg.getAccountPeriodType().getId().toString())) {
            PeriodInfo mainCurrentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(mainOrg.getId().toString()));
            PeriodInfo bookCurrentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(transferOrg.getId().toString()));
            if (bookCurrentPeriod == null) {
                return null;
            }
            if (!mainCurrentPeriod.getId().equals((Object)bookCurrentPeriod.getId())) {
                return ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"91_CardForMulBook", (Locale)ctx.getOriginLocale());
            }
        } else {
            PeriodInfo bookCurrentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(transferOrg.getId().toString()));
            Date date = cardInfo.getAccountDate();
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)date, (CompanyOrgUnitInfo)transferOrg, (SystemEnum)SystemEnum.GENERALLEDGER);
            if (periodInfo == null) {
                return ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"92_CardForMulBook", (Locale)ctx.getOriginLocale());
            }
            if (bookCurrentPeriod == null) {
                return null;
            }
            if (!bookCurrentPeriod.getId().equals((Object)periodInfo.getId())) {
                return ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"91_CardForMulBook", (Locale)ctx.getOriginLocale());
            }
        }
        return null;
    }

    public static Map _getBookList(Context ctx, String companyid) throws EASBizException, BOSException {
        HashMap<String, String> bookList = new HashMap<String, String>();
        String sql = "select b.fid,b.faccountschemeid from \tt_Org_Company  b\t  inner join T_BKS_AcountScheme c on c.fid=b.faccountschemeid \twhere b.fmainorgid=? and b.FisSealUp=0  and c.FisSyncCard=1";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyid});
        try {
            while (set != null && set.next()) {
                bookList.put(set.getString(1), set.getString(2));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return bookList;
    }

    public static void _createBotRelation(Context ctx, String srcCardId, String destId, BOSObjectType type) throws BOSException {
        BOTRelationInfo bot = null;
        bot = new BOTRelationInfo();
        bot.setSrcEntityID(type.toString());
        bot.setDestEntityID(type.toString());
        bot.setSrcObjectID(srcCardId);
        bot.setOperatorID(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        bot.setDestObjectID(destId);
        BOTRelationFactory.getLocalInstance((Context)ctx).addnew(bot);
    }

    public static void _removeBotRelation(Context ctx, String srcVchId, String destId, BOSObjectType type) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcVchId));
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destId));
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)type.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)type.toString()));
        BOTRelationCollection col = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (col != null) {
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                BOTRelationInfo bot = col.get(i);
                BOTRelationFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(bot.getId().toString()));
            }
        }
    }

    public static void _removeBotRelation(Context ctx, String destId, BOSObjectType type) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destId));
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)type.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)type.toString()));
        BOTRelationCollection col = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (col != null) {
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                BOTRelationInfo bot = col.get(i);
                BOTRelationFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(bot.getId().toString()));
            }
        }
    }

    public static boolean _existBotRelation(Context ctx, String srcVchId, BOSObjectType type) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcVchId));
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)type.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)type.toString()));
        BOTRelationCollection col = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        return col != null && col.size() > 0;
    }

    public static BOTRelationCollection _getBotRelation(Context ctx, String destVchId, BOSObjectType type) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)destVchId));
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)type.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)type.toString()));
        BOTRelationCollection col = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        return col;
    }

    public static boolean _existBotRelationBybookCardId(Context ctx, String destVchId, BOSObjectType type) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destVchId));
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)type.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)type.toString()));
        BOTRelationCollection col = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        return col != null && col.size() > 0;
    }

    public static IObjectPK _transferCard(Context ctx, FaCardInfo model) throws EASBizException, BOSException {
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        String srcCardId = model.getId().toString();
        IFaCurCard card = FaCurCardFactory.getLocalInstance(ctx);
        Map bookList = CardForMulBook._getBookList(ctx, ((FaCurCardInfo)model).getCompany().getId().toString());
        Set keys = bookList.keySet();
        for (String transferOrg : keys) {
            String bookid = (String)bookList.get(transferOrg);
            AcountSchemeInfo book = (AcountSchemeInfo)AcountSchemeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(bookid));
            CompanyOrgUnitInfo transferOrgInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(transferOrg), CardForMulBook.getCompanySic());
            if (!book.isIsSyncCard() || !CardForMulBook.checkFaInit(ctx, transferOrgInfo) || !CardForMulBook._checkPeriodValid(ctx, srcCardId.toString(), bookid)) continue;
            CardForMulBook.checkCardNumberDup(ctx, model, transferOrgInfo, 1);
            String msg = CardForMulBook._changePeriod(ctx, model, model.getCompany(), transferOrgInfo);
            if (msg != null) continue;
            if (CardForMulBook.prepareForTargetCard(ctx, srcCardId) == null) {
                return null;
            }
            FaCurCardInfo curCardInfo = CardForMulBook.prepareForTargetCard(ctx, srcCardId);
            curCardInfo.getFaCurCardSum().clear();
            CardForMulBook._checkBaseDataForCard(ctx, curCardInfo, transferOrgInfo, "t_fa_facurcard", false);
            CardForMulBook._checkAccountDataForCard(ctx, curCardInfo, transferOrgInfo, "t_fa_facurcard", false);
            curCardInfo.setCompany(transferOrgInfo);
            IObjectPK cardPK = CardForMulBook.submitBill(ctx, (IObjectValue)curCardInfo);
            curCardInfo.setId(BOSUuid.read((String)cardPK.toString()));
            SelectorItemCollection sic = PrcFaCoreManager.getCurCardSelectors();
            sic.addObjectCollection((IObjectCollection)FaManageUtils.getDepCardSelector());
            model = (FaCurCardInfo)card.getValue(cardPK, sic);
            PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaAddStrategy());
            prcFaCoreManager.getFaManageStrategy().checkForAudit(ctx, cardPK);
            prcFaCoreManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)curCardInfo);
            CardForMulBook._dealWithAttachment(ctx, curCardInfo, srcCardId);
            CardForMulBook._createBotRelation(ctx, srcCardId, cardPK.toString(), curCardInfo.getBOSType());
        }
        return null;
    }

    public static String _transferCardBatch(Context ctx, FaCardInfo model, String bookId) throws EASBizException, BOSException {
        String msg = null;
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        String srcCardId = model.getId().toString();
        IFaCurCard card = FaCurCardFactory.getLocalInstance(ctx);
        CompanyOrgUnitInfo transferOrgInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(bookId), CardForMulBook.getCompanySic());
        FaDepreciationEntryCollection depre = FaDepreciationEntryFactory.getLocalInstance(ctx).getFaDepreciationEntryCollection("select fid where faCurCard.id='" + srcCardId + "'");
        if (depre != null && depre.size() > 0) {
            return EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.HasDepreciation");
        }
        if (!"0099".equals(model.getBizStatus().getValue())) {
            return EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.HasBiZ");
        }
        try {
            if (!CardForMulBook._checkPeriodValid(ctx, srcCardId.toString(), bookId)) {
                return EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaBookResource.FAPeriodValid");
            }
            CardForMulBook.checkCardNumberDup(ctx, model, transferOrgInfo, 1);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        msg = CardForMulBook._changePeriod(ctx, model, model.getCompany(), transferOrgInfo);
        if (msg != null) {
            return msg;
        }
        if (CardForMulBook.prepareForTargetCard(ctx, srcCardId) == null) {
            return "false";
        }
        FaCurCardInfo curCardInfo = CardForMulBook.prepareForTargetCard(ctx, srcCardId);
        curCardInfo.getFaCurCardSum().clear();
        msg = CardForMulBook._checkBaseDataForCard(ctx, curCardInfo, transferOrgInfo, "t_fa_facurcard", false);
        if (msg != null) {
            return msg;
        }
        msg = CardForMulBook._checkAccountDataForCard(ctx, curCardInfo, transferOrgInfo, "t_fa_facurcard", false);
        if (msg != null) {
            return msg;
        }
        curCardInfo.setCompany(transferOrgInfo);
        try {
            IObjectPK cardPK = CardForMulBook.submitBill(ctx, (IObjectValue)curCardInfo);
            curCardInfo.setId(BOSUuid.read((String)cardPK.toString()));
            SelectorItemCollection sic = PrcFaCoreManager.getCurCardSelectors();
            sic.addObjectCollection((IObjectCollection)FaManageUtils.getDepCardSelector());
            model = (FaCurCardInfo)card.getValue(cardPK, sic);
            PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaAddStrategy());
            prcFaCoreManager.getFaManageStrategy().checkForAudit(ctx, cardPK);
            prcFaCoreManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)curCardInfo);
            CardForMulBook._dealWithAttachment(ctx, curCardInfo, srcCardId);
            CardForMulBook._createBotRelation(ctx, srcCardId, cardPK.toString(), curCardInfo.getBOSType());
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public static FaCurCardInfo prepareForTargetCard(Context ctx, String srcCardID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("faCurFacility.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        sic.add(new SelectorItemInfo("faCurDepartment.*"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)srcCardID));
        FaCurCardCollection cardCollection = FaCurCardFactory.getLocalInstance(ctx).getFaCurCardCollection(view);
        if (cardCollection == null || cardCollection.size() <= 0) {
            return null;
        }
        FaCurCardInfo model = cardCollection.get(0);
        FaCurCardInfo curCardInfo = new FaCurCardInfo();
        try {
            FaManageUtils.copyValueBetweenCard(model, curCardInfo, false);
        }
        catch (Exception e) {
            return null;
        }
        return curCardInfo;
    }

    public static boolean _checkPeriodValid(Context ctx, String cardid, String bookid) throws EASBizException, BOSException {
        String sql = "select s.fnumber from t_bd_systemstatus a \t\t\tinner join t_bd_systemstatusctrol b on a.fid=b.fsystemstatusid\t\t\t\t\tinner join t_bd_period  s on s.fid=b.fstartperiodid\t\t\t\t\tinner join t_org_company c on c.fid=b.fcompanyid where c.faccountschemeid=?\t";
        int startPeriod = 0;
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bookid});
        try {
            if (set == null || !set.next()) {
                return false;
            }
            startPeriod = set.getInt("fnumber");
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        sql = "select e.fnumber from  t_fa_facurcard d  inner join t_bd_period e on e.fid=d.fperiodid  where d.fid=? ";
        set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{cardid});
        try {
            int fnumber;
            if (set != null && set.next() && startPeriod > (fnumber = set.getInt("fnumber"))) {
                return false;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    protected static IObjectPK submitBill(Context ctx, IObjectValue bill) throws EASBizException, BOSException {
        if (bill == null) {
            throw new IllegalArgumentException();
        }
        FaCurCardInfo curCard = (FaCurCardInfo)bill;
        curCard.setEffectedStatus(EffectedStatusEnum.EFFECTED);
        curCard.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        curCard.setDeletedStatus(DeletedStatusEnum.NORMAL);
        curCard.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        curCard.setBizStatus(FaBizStatusEnum.ADDING);
        curCard.setFiVouchered(false);
        return FaCurCardFactory.getLocalInstance(ctx).submitSelf((CoreBaseInfo)curCard);
    }

    protected static PeriodInfo getCurrentPeriod(Context ctx, BillBaseInfo bill) throws EASBizException, BOSException {
        PeriodInfo bookPeriod = null;
        if (bill != null && bill.getCompany() != null && bill.getCompany().getId() != null) {
            String strCompanyOrgUnitInfoID = bill.getCompany().getId().toString();
            ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("systemStatus.name", (Object)new Integer(SystemEnum.FIXEDASSETS.getValue())));
            fic.add(new FilterItemInfo("company.id", (Object)strCompanyOrgUnitInfoID));
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("currentPeriod.periodYear"));
            sic.add(new SelectorItemInfo("currentPeriod.periodNumber"));
            sic.add(new SelectorItemInfo("currentPeriod.beginDate"));
            sic.add(new SelectorItemInfo("currentPeriod.endDate"));
            sic.add(new SelectorItemInfo("currentPeriod.periodType.*"));
            SystemStatusCtrolCollection col = ictrol.getSystemStatusCtrolCollection(view);
            if (col.size() > 0) {
                bookPeriod = col.get(0).getCurrentPeriod();
            }
        }
        return bookPeriod == null ? new PeriodInfo() : bookPeriod;
    }

    public static void _deleteCard(Context ctx, FaCardInfo model) throws EASBizException, BOSException {
        BOTRelationCollection relationCol = CardForMulBook._getBotRelation(ctx, model.getId().toString(), model.getBOSType());
        IFaCurCard faCard = FaCurCardFactory.getLocalInstance(ctx);
        if (relationCol != null) {
            int n = relationCol.size();
            for (int i = 0; i < n; ++i) {
                BOTRelationInfo bot = relationCol.get(i);
                String destCardID = bot.getDestObjectID();
                SelectorItemCollection sic = PrcFaCoreManager.getCurCardSelectors();
                sic.addObjectCollection((IObjectCollection)FaManageUtils.getDepCardSelector());
                FaCurCardInfo cardInfo = faCard.getFaCurCardInfo((IObjectPK)new ObjectUuidPK(destCardID), sic);
                ObjectUuidPK pk = new ObjectUuidPK(destCardID);
                PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaAddStrategy());
                if (pk != null && !faCard.exists((IObjectPK)pk)) {
                    pk = null;
                    return;
                }
                prcFaCoreManager.getFaManageStrategy().checkForUnAudit(ctx, (IObjectPK)pk);
                prcFaCoreManager.getFaManageStrategy().unAuditBill(ctx, (IObjectValue)cardInfo);
                faCard.delete((IObjectPK)new ObjectUuidPK(destCardID));
                CardForMulBook._removerAttachment(ctx, cardInfo);
                CardForMulBook._removeBotRelation(ctx, model.getId().toString(), destCardID, model.getBOSType());
            }
        }
    }

    public static void _transMondCardToBook(Context ctx, FaMonCardInfo cardInfo) throws EASBizException, BOSException {
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        String srcCardId = cardInfo.getId().toString();
        IFaMonCard monCard = FaMonCardFactory.getLocalInstance(ctx);
        Map bookList = CardForMulBook._getBookList(ctx, cardInfo.getCompany().getId().toString());
        Set keys = bookList.keySet();
        for (String transferOrg : keys) {
            String bookid = (String)bookList.get(transferOrg);
            AcountSchemeInfo book = (AcountSchemeInfo)AcountSchemeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(bookid));
            CompanyOrgUnitInfo transferOrgInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(transferOrg), CardForMulBook.getCompanySic());
            if (!book.isIsSyncCard() || CardForMulBook.checkFaInit(ctx, transferOrgInfo)) continue;
            if (CardForMulBook._checkHasTransfered(ctx, cardInfo, transferOrgInfo)) {
                CardForMulBook._deleteInit(ctx, cardInfo, transferOrgInfo);
            }
            if (!CardForMulBook._checkPeriodValid(ctx, srcCardId.toString(), bookid)) continue;
            CardForMulBook.checkCardNumberDup(ctx, cardInfo, transferOrgInfo, 2);
            String msg = CardForMulBook._changePeriod(ctx, cardInfo, cardInfo.getCompany(), transferOrgInfo);
            if (msg != null) continue;
            cardInfo = CardForMulBook.prepareForTargetMonCard(ctx, srcCardId);
            CardForMulBook._checkBaseDataForCard(ctx, cardInfo, transferOrgInfo, "t_fa_famoncard", false);
            CardForMulBook._checkAccountDataForCard(ctx, cardInfo, transferOrgInfo, "t_fa_famoncard", false);
            cardInfo.setCompany(transferOrgInfo);
            cardInfo.setFaPeriod(null);
            IObjectPK cardPK = monCard.submitForBook(cardInfo);
            cardInfo.setId(BOSUuid.read((String)cardPK.toString()));
            CardForMulBook._dealWithAttachment(ctx, cardInfo, srcCardId);
            CardForMulBook._createBotRelation(ctx, srcCardId, cardPK.toString(), cardInfo.getBOSType());
        }
    }

    public static boolean _checkHasTransfered(Context ctx, FaCardInfo cardInfo, CompanyOrgUnitInfo destOrgInfo) throws BOSException {
        BOTRelationCollection relationCol = CardForMulBook._getBotRelation(ctx, cardInfo.getId().toString(), cardInfo.getBOSType());
        Set idSet = CardForMulBook.getAllTargetCardID(relationCol);
        if (idSet == null || idSet.size() <= 0) {
            return false;
        }
        EntityViewInfo viewInfo = CardForMulBook.getHasTransResultView(idSet);
        FilterInfo f2 = new FilterInfo();
        f2.getFilterItems().add(new FilterItemInfo("company.id", (Object)destOrgInfo.getId().toString(), CompareType.EQUALS));
        f2.setMaskString("#0");
        viewInfo.getFilter().mergeFilter(f2, "AND");
        FaMonCardCollection collection = FaMonCardFactory.getLocalInstance(ctx).getFaMonCardCollection(viewInfo);
        return collection != null && collection.size() > 0;
    }

    public static Set getAllTargetCardID(BOTRelationCollection relationCollection) {
        HashSet<String> targetCardIDS = new HashSet<String>();
        if (relationCollection != null) {
            BOTRelationInfo bot = null;
            for (int i = 0; i < relationCollection.size(); ++i) {
                bot = relationCollection.get(i);
                targetCardIDS.add(bot.getDestObjectID());
            }
        }
        return targetCardIDS;
    }

    private static EntityViewInfo getHasTransResultView(Set ids) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.put("selector", (Object)sic);
        return view;
    }

    public static void _deleteInit(Context ctx, FaCardInfo model, CompanyOrgUnitInfo destOrgInfo) throws EASBizException, BOSException {
        BOTRelationCollection relationCol = CardForMulBook._getBotRelation(ctx, model.getId().toString(), model.getBOSType());
        String fcompanyID = destOrgInfo.getId().toString();
        if (fcompanyID == null) {
            return;
        }
        IFaMonCard faCard = FaMonCardFactory.getLocalInstance(ctx);
        if (relationCol != null) {
            BOTRelationInfo bot = null;
            int n = relationCol.size();
            for (int i = 0; i < n; ++i) {
                bot = relationCol.get(i);
                String destCardID = bot.getDestObjectID();
                FaMonCardInfo cardInfo = faCard.getFaMonCardInfo((IObjectPK)new ObjectUuidPK(destCardID));
                if (cardInfo.getCompany() == null || !cardInfo.getCompany().getId().toString().equals(fcompanyID)) continue;
                faCard.deleteInit((IObjectPK)new ObjectUuidPK(destCardID));
                CardForMulBook._removerAttachment(ctx, cardInfo);
                CardForMulBook._removeBotRelation(ctx, model.getId().toString(), destCardID, model.getBOSType());
            }
        }
    }

    public Map getSelectedValues() {
        return this.mapValues;
    }

    public void setSelectedValues(Map mapValues) {
        this.mapValues = mapValues;
    }

    public EntityViewInfo getCurCardQueryView(Context ctx, PeriodInfo periodInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("faCurFacility.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.asstActItem.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.isLeaf"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.longName"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("faCurDepartment.*"));
        sic.addObjectCollection((IObjectCollection)FaManageUtils.getDepCardSelector());
        view.setFilter(this.getFilterForTranser());
        FilterInfo f2 = new FilterInfo();
        f2.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodInfo.getId().toString(), CompareType.EQUALS));
        f2.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        f2.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)"2", CompareType.EQUALS));
        f2.getFilterItems().add(new FilterItemInfo("hasNew", (Object)"1", CompareType.EQUALS));
        f2.getFilterItems().add(new FilterItemInfo("originFlag", (Object)"1", CompareType.EQUALS));
        view.getFilter().mergeFilter(f2, "AND");
        view.getSorter().add(new SorterItemInfo("number"));
        return view;
    }

    public EntityViewInfo getQueryView(Context ctx, PeriodInfo periodInfo, int type) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        if (type == 1) {
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("faMonFacility.*"));
            sic.add(new SelectorItemInfo("faMonCostCenter.*"));
            sic.add(new SelectorItemInfo("faMonCostCenter.faMonAsstActComposit.*"));
            sic.add(new SelectorItemInfo("faMonCostCenter.faMonAsstActComposit.asstActType.*"));
            sic.add(new SelectorItemInfo("faMonCostCenter.faMonAsstActComposit.asstActItem.*"));
            sic.add(new SelectorItemInfo("faMonCostCenter.asstActType.*"));
            sic.add(new SelectorItemInfo("faMonCostCenter.accountView.isLeaf"));
            sic.add(new SelectorItemInfo("faMonCostCenter.accountView.longName"));
            sic.add(new SelectorItemInfo("faMonDepartment.*"));
            sic.add(new SelectorItemInfo("faMonInitData.*"));
        } else if (type == 2) {
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("faCurFacility.*"));
            sic.add(new SelectorItemInfo("faCurCostCenter.*"));
            sic.add(new SelectorItemInfo("faCurCostCenter.asstActItem.*"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.*"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.isLeaf"));
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.longName"));
            sic.add(new SelectorItemInfo("faCurDepartment.*"));
        }
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("assetCat.isLeaf"));
        sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.id"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.DeprRule"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.initOldAsset"));
        sic.add(new SelectorItemInfo("originMethod.isLeaf"));
        sic.add(new SelectorItemInfo("originMethod.number"));
        sic.add(new SelectorItemInfo("useStatus.isLeaf"));
        sic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        sic.add(new SelectorItemInfo("economicPurp.isLeaf"));
        sic.add(new SelectorItemInfo("dept.isLeaf"));
        sic.add(new SelectorItemInfo("accountAsset.isLeaf"));
        sic.add(new SelectorItemInfo("accountAccuDepr.isLeaf"));
        sic.add(new SelectorItemInfo("accountDecValue.isLeaf"));
        sic.add(new SelectorItemInfo("accountAsset.longName"));
        sic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        sic.add(new SelectorItemInfo("accountDecValue.longName"));
        sic.add(new SelectorItemInfo("deprMethod.*"));
        sic.add(new SelectorItemInfo("period.beginDate"));
        sic.add(new SelectorItemInfo("period.endDate"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("evalDeprMode.*"));
        view.setFilter(this.getFilterForTranser());
        FilterInfo f2 = new FilterInfo();
        if (type == 1) {
            PeriodInfo aPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
            if (aPeriodInfo.getId().equals((Object)periodInfo.getId())) {
                f2.getFilterItems().add(new FilterItemInfo("faPeriod.id", null, CompareType.EQUALS));
                f2.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
                f2.setMaskString("#0 and #1");
                view.getFilter().mergeFilter(f2, "AND");
            } else {
                f2.getFilterItems().add(new FilterItemInfo("faPeriod.id", (Object)periodInfo.getId().toString(), CompareType.EQUALS));
                f2.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
                f2.setMaskString("#0 and #1");
                view.getFilter().mergeFilter(f2, "AND");
            }
        }
        view.getSorter().add(new SorterItemInfo("number"));
        return view;
    }

    private FilterInfo getFilterForTranser() {
        AdminOrgUnitInfo orgUnitInfo;
        FaEconomicPurpInfo economicPurpInfo;
        FaUseStatusInfo useStatusInfo;
        AddressInfo addressInfo;
        FaCatInfo catInfo;
        String textNumberTo;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        Map valueMap = this.getSelectedValues();
        String textNumberFrom = (String)valueMap.get("textNumberFrom");
        if (textNumberFrom != null && textNumberFrom.length() > 0) {
            fic.add(new FilterItemInfo("number", (Object)textNumberFrom, CompareType.GREATER_EQUALS));
        }
        if ((textNumberTo = (String)valueMap.get("textNumberTo")) != null && textNumberTo.length() > 0) {
            fic.add(new FilterItemInfo("number", (Object)textNumberTo, CompareType.LESS_EQUALS));
        }
        if ((catInfo = (FaCatInfo)valueMap.get("prompFaCatFrom")) != null) {
            fic.add(new FilterItemInfo("assetCat.number", (Object)catInfo.getNumber(), CompareType.GREATER_EQUALS));
        }
        if ((catInfo = (FaCatInfo)valueMap.get("prompFaCatTo")) != null) {
            fic.add(new FilterItemInfo("assetCat.number", (Object)catInfo.getNumber(), CompareType.LESS_EQUALS));
        }
        if ((addressInfo = (AddressInfo)valueMap.get("promptFaLocationFrom")) != null) {
            fic.add(new FilterItemInfo("storeCity.number", (Object)addressInfo.getNumber(), CompareType.GREATER_EQUALS));
        }
        if ((addressInfo = (AddressInfo)valueMap.get("promptFaLocationTo")) != null) {
            fic.add(new FilterItemInfo("storeCity.number", (Object)addressInfo.getNumber(), CompareType.LESS_EQUALS));
        }
        if ((useStatusInfo = (FaUseStatusInfo)valueMap.get("promptFaUseStatuFrom")) != null) {
            fic.add(new FilterItemInfo("useStatus.number", (Object)useStatusInfo.getNumber(), CompareType.GREATER_EQUALS));
        }
        if ((useStatusInfo = (FaUseStatusInfo)valueMap.get("promptFaUseStatuTo")) != null) {
            fic.add(new FilterItemInfo("useStatus.number", (Object)useStatusInfo.getNumber(), CompareType.LESS_EQUALS));
        }
        if ((economicPurpInfo = (FaEconomicPurpInfo)valueMap.get("promptEconomicFrom")) != null) {
            fic.add(new FilterItemInfo("economicPurp.number", (Object)economicPurpInfo.getNumber(), CompareType.GREATER_EQUALS));
        }
        if ((economicPurpInfo = (FaEconomicPurpInfo)valueMap.get("promptEconomicTo")) != null) {
            fic.add(new FilterItemInfo("economicPurp.number", (Object)economicPurpInfo.getNumber(), CompareType.LESS_EQUALS));
        }
        if ((orgUnitInfo = (AdminOrgUnitInfo)valueMap.get("promptUseDepartmentFrom")) != null) {
            fic.add(new FilterItemInfo("faCurDepartment.useDepartment.number", (Object)orgUnitInfo.getNumber(), CompareType.GREATER_EQUALS));
        }
        if ((orgUnitInfo = (AdminOrgUnitInfo)valueMap.get("promptUseDepartmentTo")) != null) {
            fic.add(new FilterItemInfo("faCurDepartment.useDepartment.number", (Object)orgUnitInfo.getNumber(), CompareType.LESS_EQUALS));
        }
        if ((orgUnitInfo = (AdminOrgUnitInfo)valueMap.get("promptManageDepartmentFrom")) != null) {
            fic.add(new FilterItemInfo("dept.number", (Object)orgUnitInfo.getNumber(), CompareType.GREATER_EQUALS));
        }
        if ((orgUnitInfo = (AdminOrgUnitInfo)valueMap.get("promptManageDepartmentTo")) != null) {
            fic.add(new FilterItemInfo("dept.number", (Object)orgUnitInfo.getNumber(), CompareType.LESS_EQUALS));
        }
        return filter;
    }

    public static void checkBooksPeriod(Context ctx, String orgUnitId, String curPeriodID, boolean unClose) throws BOSException, EASBizException {
        String masterOrg;
        PeriodInfo startPeriod;
        if (unClose && CardForMulBook.isMasterBook(ctx)) {
            Map bookList = CardForMulBook._getBookList(ctx, orgUnitId);
            Set keys = bookList.keySet();
            for (String transferOrg : keys) {
                PeriodInfo startPeriod2 = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(transferOrg));
                if (startPeriod2 == null || !startPeriod2.getId().toString().equals(curPeriodID)) continue;
                String bookid = (String)bookList.get(transferOrg);
                AcountSchemeInfo book = (AcountSchemeInfo)AcountSchemeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(bookid));
                throw new InitException(InitException.OTHERBOOKSPERIOD, new Object[]{book.getName()});
            }
        }
        if (!unClose && !CardForMulBook.isMasterBook(ctx) && (startPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)new ObjectUuidPK(masterOrg = BooksUtil.getCurrentMasterCompanyID((Context)ctx)))) != null && startPeriod.getId().toString().equals(curPeriodID)) {
            throw new InitException(InitException.MASTERNOTCLOSEPERIOD);
        }
    }

    public static void _checkBeforeMoncardDelete(Context ctx, FaMonCardInfo aFaMonCardInfo) throws BOSException, FaTransCardToBookException {
        if (!CardForMulBook.isMasterBook(ctx) && CardForMulBook._existBotRelationBybookCardId(ctx, aFaMonCardInfo.getId().toString(), aFaMonCardInfo.getBOSType())) {
            throw new FaTransCardToBookException(FaTransCardToBookException.FORDESTBOOKMONCARD);
        }
    }

    public static SelectorItemCollection getMonCardSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("faMonFacility.*"));
        sic.add(new SelectorItemInfo("faMonCostCenter.*"));
        sic.add(new SelectorItemInfo("faMonCostCenter.faMonAsstActComposit.*"));
        sic.add(new SelectorItemInfo("faMonCostCenter.faMonAsstActComposit.asstActType.*"));
        sic.add(new SelectorItemInfo("faMonCostCenter.faMonAsstActComposit.asstActItem.*"));
        sic.add(new SelectorItemInfo("faMonDepartment.*"));
        return sic;
    }

    public static FaMonCardInfo prepareForTargetMonCard(Context ctx, String srcCardID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().addObjectCollection((IObjectCollection)CardForMulBook.getMonCardSelectors());
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)srcCardID));
        FaMonCardCollection monCardCollection = FaMonCardFactory.getLocalInstance(ctx).getFaMonCardCollection(view);
        if (monCardCollection == null || monCardCollection.size() <= 0) {
            return null;
        }
        FaMonCardInfo model = monCardCollection.get(0);
        FaMonCardInfo monCardInfo = new FaMonCardInfo();
        try {
            FaManageUtils.copyValueBetweenCard(model, monCardInfo, false);
        }
        catch (Exception e) {
            return null;
        }
        return monCardInfo;
    }

    public static void checkCardNumberDup(Context ctx, FaCardInfo cardInfo, CompanyOrgUnitInfo companyOrgUnitInfo, int type) throws BOSException, EASBizException {
        IRowSet set;
        String sql;
        if (type == 1) {
            sql = "select fnumber from t_fa_facurcard where fnumber='" + cardInfo.getNumber() + "' and fcompanyid='" + companyOrgUnitInfo.getId().toString() + "'";
            set = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (set != null && set.next()) {
                    throw new FaTransCardToBookException(FaTransCardToBookException.EXISTTHISNUMBER, new Object[]{companyOrgUnitInfo.getName()});
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (type == 2) {
            sql = "select fnumber from t_fa_famoncard where fnumber='" + cardInfo.getNumber() + "' and fcompanyid='" + companyOrgUnitInfo.getId().toString() + "'";
            set = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (set != null && set.next()) {
                    throw new FaTransCardToBookException(FaTransCardToBookException.EXISTTHISNUMBER, new Object[]{companyOrgUnitInfo.getName()});
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    public static void _dealWithAttachment(Context ctx, FaCardInfo cardInfo, String srcCardID) throws BOSException, EASBizException {
        String cardId = cardInfo.getId().toString();
        if (cardId == null) {
            return;
        }
        String sql = "select * from T_BAS_BoAttchAsso where FBoID ='" + srcCardID + "'";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)FaLocalUtils.transformLocal(ctx, sql));
        BoAttchAssoInfo attchAssoInfo = null;
        AttachmentInfo attachmentInfo = null;
        IBoAttchAsso boAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        try {
            while (set != null && set.next()) {
                attchAssoInfo = new BoAttchAssoInfo();
                attachmentInfo = new AttachmentInfo();
                attchAssoInfo.setBoID(cardId);
                attchAssoInfo.setAssoType(set.getString("FAssoType_" + (ctx.getLocale() != null ? ctx.getLocale().toString() : "L2")));
                attachmentInfo.setId(BOSUuid.read((String)set.getString("FAttachmentID")));
                attchAssoInfo.setAttachment(attachmentInfo);
                attchAssoInfo.setAssoBusObjType(set.getString("FAssoBusObjType"));
                boAttchAsso.addnew(attchAssoInfo);
                attchAssoInfo = null;
                attachmentInfo = null;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void _removerAttachment(Context ctx, FaCardInfo cardInfo) throws BOSException {
        String cardId = cardInfo.getId().toString();
        if (cardId == null) {
            return;
        }
        String sql = "delete from T_BAS_BoAttchAsso where FBoID ='" + cardId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static String _checkBaseDataForCard(Context ctx, FaCardInfo info, CompanyOrgUnitInfo companyOrgUnitInfo, String table, boolean isMultiTrans) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select ccat.fid from t_fa_cat ccat inner join t_fa_cat  pcat on ccat.flongnumber= pcat.flongnumber \n");
        sql.append(" and ccat.fcontrolunitid= pcat.fcontrolunitid \n");
        sql.append(" inner join " + table + " card on pcat.fid= card.FAssetCatID \n");
        sql.append(" and pcat.fcompanyid= card.fcompanyid  \n");
        sql.append(" where card.fnumber='" + info.getNumber() + "' \n");
        sql.append(" and card.fcompanyid='" + info.getCompany().getId().toString() + "' \n");
        sql.append(" and ccat.fcompanyid ='" + companyOrgUnitInfo.getId().toString() + "'   \n");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (set == null || !set.next()) {
                if (table.equalsIgnoreCase("t_fa_famoncard") && isMultiTrans) {
                    return ResourceBase.getString((String)FABookResource, (String)"NotAdjustAssetCat", (Locale)ctx.getOriginLocale());
                }
                throw new FaTransCardToBookException(FaTransCardToBookException.NOTADJUSTASSETCAT, new Object[]{companyOrgUnitInfo.getName()});
            }
            FaCatInfo catInfo = new FaCatInfo();
            catInfo.setId(BOSUuid.read((String)set.getString(1)));
            info.setAssetCat(catInfo);
            sql = null;
            sql = new StringBuffer();
            sql.append("select ccat.fid from T_FA_FaEconomicPurp ccat inner join T_FA_FaEconomicPurp  pcat on ccat.flongnumber= pcat.flongnumber \n");
            sql.append(" and ccat.fcontrolunitid= pcat.fcontrolunitid \n");
            sql.append(" inner join " + table + " card on pcat.fid= card.FEconomicPurpID \n");
            sql.append(" and pcat.fcompanyid= card.fcompanyid  \n");
            sql.append(" where card.fnumber='" + info.getNumber() + "' \n");
            sql.append(" and card.fcompanyid='" + info.getCompany().getId().toString() + "' \n");
            sql.append(" and ccat.fcompanyid ='" + companyOrgUnitInfo.getId().toString() + "' \n");
            set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (set == null || !set.next()) {
                if (table.equalsIgnoreCase("t_fa_famoncard") && isMultiTrans) {
                    return ResourceBase.getString((String)FABookResource, (String)"NotAdjustFaEcomno", (Locale)ctx.getOriginLocale());
                }
                throw new FaTransCardToBookException(FaTransCardToBookException.NOTADJUSTFAECOMNO, new Object[]{companyOrgUnitInfo.getName()});
            }
            FaEconomicPurpInfo economicPurpInfo = new FaEconomicPurpInfo();
            economicPurpInfo.setId(BOSUuid.read((String)set.getString(1)));
            info.setEconomicPurp(economicPurpInfo);
            sql = null;
            sql = new StringBuffer();
            sql.append("select ccat.fid from T_FA_UseStatus ccat inner join T_FA_UseStatus  pcat on ccat.flongnumber= pcat.flongnumber \n");
            sql.append(" and ccat.fcontrolunitid= pcat.fcontrolunitid \n");
            sql.append(" inner join " + table + " card on pcat.fid= card.FUseStatusID \n");
            sql.append(" and pcat.fcompanyid= card.fcompanyid  \n");
            sql.append(" where card.fnumber='" + info.getNumber() + "' \n");
            sql.append(" and card.fcompanyid='" + info.getCompany().getId().toString() + "' \n");
            sql.append(" and ccat.fcompanyid ='" + companyOrgUnitInfo.getId().toString() + "'  \n");
            set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (set == null || !set.next()) {
                if (table.equalsIgnoreCase("t_fa_famoncard") && isMultiTrans) {
                    return ResourceBase.getString((String)FABookResource, (String)"NotAdjustFaUseStatus", (Locale)ctx.getOriginLocale());
                }
                throw new FaTransCardToBookException(FaTransCardToBookException.NOTADJUSTFAUSESTATUS, new Object[]{companyOrgUnitInfo.getName()});
            }
            FaUseStatusInfo useStatusInfo = new FaUseStatusInfo();
            useStatusInfo.setId(BOSUuid.read((String)set.getString(1)));
            info.setUseStatus(useStatusInfo);
        }
        catch (UuidException e) {
            throw new UuidException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static String _checkAccountDataForCard(Context ctx, FaCardInfo info, CompanyOrgUnitInfo orgUnitInfo, String table, boolean isMultiTrans) throws EASBizException, BOSException {
        block15: {
            CompanyOrgUnitInfo mainInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            if (orgUnitInfo.getAccountTable() != null && mainInfo.getAccountTable() != null && !mainInfo.getAccountTable().getId().equals((Object)orgUnitInfo.getAccountTable().getId())) {
                if (table.equalsIgnoreCase("t_fa_famoncard") && isMultiTrans) {
                    return ResourceBase.getString((String)FABookResource, (String)"AccountTableNotConsistent", (Locale)ctx.getOriginLocale());
                }
                throw new FaTransCardToBookException(FaTransCardToBookException.ACCOUNTTABLENOTCONSISTENT, new Object[]{orgUnitInfo.getName()});
            }
            try {
                AccountViewInfo viewInfo;
                StringBuffer sql = new StringBuffer();
                IRowSet set = null;
                if (info.getAccountAsset() != null) {
                    sql.append(" select ccat.fid from T_BD_AccountView ccat inner join T_BD_AccountView  pcat on ccat.flongnumber= pcat.flongnumber \n");
                    sql.append(" and ccat.fcontrolunitid= pcat.fcontrolunitid \n");
                    sql.append(" inner join " + table + " card on pcat.fid= card.FAccountAssetID \n");
                    sql.append(" and pcat.FCompanyID= card.fcompanyid  \n");
                    sql.append(" where card.fnumber='" + info.getNumber() + "' \n");
                    sql.append(" and card.fcompanyid='" + info.getCompany().getId().toString() + "' \n");
                    sql.append(" and ccat.fcompanyid ='" + orgUnitInfo.getId().toString() + "'  \n");
                    set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    if (set != null && set.next()) {
                        viewInfo = new AccountViewInfo();
                        viewInfo.setId(BOSUuid.read((String)set.getString(1)));
                        info.setAccountAsset(viewInfo);
                    } else {
                        if (table.equalsIgnoreCase("t_fa_famoncard") && isMultiTrans) {
                            return ResourceBase.getString((String)FABookResource, (String)"NotAdjustFAccountAsset", (Locale)ctx.getOriginLocale());
                        }
                        throw new FaTransCardToBookException(FaTransCardToBookException.NOTADJUSTFACCOUNTASSET, new Object[]{orgUnitInfo.getName()});
                    }
                }
                sql = null;
                sql = new StringBuffer();
                if (info.getAccountAccuDepr() != null) {
                    sql.append(" select ccat.fid from T_BD_AccountView ccat inner join T_BD_AccountView  pcat on ccat.flongnumber= pcat.flongnumber \n");
                    sql.append(" and ccat.fcontrolunitid= pcat.fcontrolunitid \n");
                    sql.append(" inner join " + table + " card on pcat.fid= card.FAccountAccuDeprID \n");
                    sql.append(" and pcat.FCompanyID= card.fcompanyid  \n");
                    sql.append(" where card.fnumber='" + info.getNumber() + "' \n");
                    sql.append(" and card.fcompanyid='" + info.getCompany().getId().toString() + "' \n");
                    sql.append(" and ccat.fcompanyid ='" + orgUnitInfo.getId().toString() + "'  \n");
                    set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    if (set != null && set.next()) {
                        viewInfo = new AccountViewInfo();
                        viewInfo.setId(BOSUuid.read((String)set.getString(1)));
                        info.setAccountAccuDepr(viewInfo);
                    } else {
                        if (table.equalsIgnoreCase("t_fa_famoncard") && isMultiTrans) {
                            return ResourceBase.getString((String)FABookResource, (String)"NotAdjustAccountAccuDepr", (Locale)ctx.getOriginLocale());
                        }
                        throw new FaTransCardToBookException(FaTransCardToBookException.NOTADJUSTACCOUNTACCUDEPR, new Object[]{orgUnitInfo.getName()});
                    }
                }
                sql = null;
                sql = new StringBuffer();
                if (info.getAccountDecValue() == null) break block15;
                sql.append(" select ccat.fid from T_BD_AccountView ccat inner join T_BD_AccountView  pcat on ccat.flongnumber= pcat.flongnumber \n");
                sql.append(" and ccat.fcontrolunitid= pcat.fcontrolunitid \n");
                sql.append(" inner join " + table + " card on pcat.fid= card.FAccountDecValueID \n");
                sql.append(" and pcat.FCompanyID= card.fcompanyid  \n");
                sql.append(" where card.fnumber='" + info.getNumber() + "' \n");
                sql.append(" and card.fcompanyid='" + info.getCompany().getId().toString() + "' \n");
                sql.append(" and ccat.fcompanyid ='" + orgUnitInfo.getId().toString() + "'   \n");
                set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (set != null && set.next()) {
                    viewInfo = new AccountViewInfo();
                    viewInfo.setId(BOSUuid.read((String)set.getString(1)));
                    info.setAccountDecValue(viewInfo);
                    break block15;
                }
                if (table.equalsIgnoreCase("t_fa_famoncard") && isMultiTrans) {
                    return ResourceBase.getString((String)FABookResource, (String)"NotAdjustFAccountDecValue", (Locale)ctx.getOriginLocale());
                }
                throw new FaTransCardToBookException(FaTransCardToBookException.NOTADJUSTFACCOUNTDECVALUE, new Object[]{orgUnitInfo.getName()});
            }
            catch (UuidException e) {
                throw new UuidException((Throwable)e);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }
}

