/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceCollection;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.FaBalanceUpdException;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaBalanceUpdStrategy;
import com.kingdee.eas.framework.BillBaseInfo;
import java.math.BigDecimal;

public class FaBalanceAddUpdStrategy
extends AbstractFaBalanceUpdStrategy {
    @Override
    public FaAccountBalanceCollection proc4UpdateFaBalance(Context ctx, BillBaseInfo billBaseInfo, PeriodInfo periodInfo) throws BOSException, EASBizException {
        FaCurCardInfo billInfo = (FaCurCardInfo)billBaseInfo;
        FaAccountBalanceInfo faActBalanceInfo = new FaAccountBalanceInfo();
        faActBalanceInfo.setPeriod(periodInfo);
        faActBalanceInfo.setRealBeginBalanceFor(new BigDecimal("0"));
        faActBalanceInfo.setRealDebitFor(billInfo.getAssetValue());
        faActBalanceInfo.setRealCreditFor(new BigDecimal("0"));
        faActBalanceInfo.setRealEndBalanceFor(this.calcRealEndBalanceFor(faActBalanceInfo));
        faActBalanceInfo.setDepreBeginBalanceFor(new BigDecimal("0"));
        faActBalanceInfo.setDepreDebitFor(new BigDecimal("0"));
        faActBalanceInfo.setDepreCreditFor(billInfo.getAccuDepr());
        faActBalanceInfo.setDepreEndBalanceFor(this.calcDepreEndBalanceFor(faActBalanceInfo));
        faActBalanceInfo.setAddUpYearDepre(billInfo.getAccuDeprTYear());
        faActBalanceInfo.setDecValueBeginBalanceFor(new BigDecimal("0"));
        faActBalanceInfo.setDecValueDebitFor(new BigDecimal("0"));
        faActBalanceInfo.setDecValueCreditFor(billInfo.getDecValue());
        faActBalanceInfo.setDecValueEndBalanceFor(this.calcDecValueEndBalanceFor(faActBalanceInfo));
        faActBalanceInfo.setEvalueBeginBalanceFor(new BigDecimal("0"));
        faActBalanceInfo.setEvalueDebitFor(billInfo.getInitEvalValue() != null ? billInfo.getInitEvalValue() : billInfo.getAssetValue());
        faActBalanceInfo.setEvalueCreditFor(new BigDecimal("0"));
        faActBalanceInfo.setEvalueEndBalanceFor(this.calcEvalueEndBalanceFor(faActBalanceInfo));
        FaAccountBalanceCollection faActBalanceCol = new FaAccountBalanceCollection();
        faActBalanceCol.add(faActBalanceInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        ObjectUuidPK pk = new ObjectUuidPK(billInfo.getCompany().getId().toString());
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk, sic);
        CurrencyInfo desCyInfo = companyInfo.getBaseCurrency();
        faActBalanceInfo.setCurrency(desCyInfo);
        faActBalanceInfo.setCompanyOrgUnit(companyInfo);
        faActBalanceInfo.setFaCurCard(billInfo);
        return faActBalanceCol;
    }

    @Override
    public FaAccountBalanceCollection proc4RollbackFaBalance(Context ctx, BillBaseInfo billInfo, PeriodInfo periodInfo) throws BOSException, EASBizException {
        FaCurCardInfo faCurCardInfo = (FaCurCardInfo)billInfo;
        String companyID = this.getCompanyID(faCurCardInfo);
        String faCardID = this.getFaCardID(faCurCardInfo);
        FaAccountBalanceInfo faActBalanceInfo = this.getFaAcctBalanceByCurCard(ctx, faCardID, companyID, periodInfo);
        FaAccountBalanceCollection faActBalanceCol = new FaAccountBalanceCollection();
        if (faActBalanceInfo == null) {
            throw new FaBalanceUpdException(FaBalanceUpdException.FA_BALANCE_CANNOTFOUND);
        }
        faActBalanceCol.add(faActBalanceInfo);
        return faActBalanceCol;
    }
}

