/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceCollection;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBalanceUpdException;
import com.kingdee.eas.fi.fa.manage.FaClearBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaClearBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaBalanceUpdStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaStocktakingReportBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.PrcFaSplitStrategy;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FaBalanceClrUpdStrategy
extends AbstractFaBalanceUpdStrategy {
    @Override
    public FaAccountBalanceCollection proc4UpdateFaBalance(Context ctx, BillBaseInfo billBaseInfo, PeriodInfo periodInfo) throws BOSException, EASBizException {
        FaClearBillInfo clearBillInfo = (FaClearBillInfo)billBaseInfo;
        FaAccountBalanceCollection faActBalanceCol = new FaAccountBalanceCollection();
        String companyID = clearBillInfo.getCompany().getId().toString();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id = '" + companyID + "'");
        int baseCurPrecision = company.getBaseCurrency() == null ? 2 : company.getBaseCurrency().getPrecision();
        String isFromStock = clearBillInfo.getString(FaStocktakingReportBillControllerBean.IS_FROM_STOCK_TAKING_REPORT_BILL);
        String isFromSplit = clearBillInfo.getString(PrcFaSplitStrategy.IS_FROM_Split_BILL);
        if ("true".equals(isFromStock) || "true".equals(isFromSplit)) {
            for (int i = 0; i < clearBillInfo.getClearBillEntry().size(); ++i) {
                FaCurCardInfo billInfo = clearBillInfo.getClearBillEntry().get(i).getCurCard();
                String faCardID = this.getFaCardID(billInfo);
                FaAccountBalanceInfo faActBalanceInfo = this.getFaAcctBalanceByCurCard(ctx, faCardID, companyID, periodInfo);
                if (faActBalanceInfo == null) {
                    throw new FaBalanceUpdException(FaBalanceUpdException.FA_BALANCE_CANNOTFOUND);
                }
                faActBalanceInfo.setRealCreditFor(faActBalanceInfo.getRealCreditFor().add(clearBillInfo.getClearBillEntry().get(i).getClrOriginal()));
                faActBalanceInfo.setRealEndBalanceFor(this.calcRealEndBalanceFor(faActBalanceInfo));
                faActBalanceInfo.setDepreDebitFor(faActBalanceInfo.getDepreDebitFor().add(clearBillInfo.getClearBillEntry().get(i).getClrAddupDep()));
                faActBalanceInfo.setDepreEndBalanceFor(this.calcDepreEndBalanceFor(faActBalanceInfo));
                faActBalanceInfo.setAddUpYearDepre(faActBalanceInfo.getAddUpYearDepre().subtract(clearBillInfo.getClearBillEntry().get(i).getClrAddupDep()));
                faActBalanceInfo.setDecValueDebitFor(faActBalanceInfo.getDecValueDebitFor().add(clearBillInfo.getClearBillEntry().get(i).getClrDecPrep()));
                faActBalanceInfo.setDecValueEndBalanceFor(this.calcDecValueEndBalanceFor(faActBalanceInfo));
                FaBakCardInfo bakcard = clearBillInfo.getClearBillEntry().get(i).getBizCard().getFaBakCard();
                bakcard = FaBakCardFactory.getLocalInstance(ctx).getFaBakCardInfo((IObjectPK)new ObjectUuidPK(bakcard.getId().toString()));
                BigDecimal clearRadio = clearBillInfo.getClearBillEntry().get(i).getClrQty().divide(bakcard.getAssetAmt(), 4, 4);
                BigDecimal lastEvaValue = (bakcard.getInitEvalValue() == null ? zeroValue : bakcard.getInitEvalValue()).multiply(clearRadio).setScale(baseCurPrecision, 4);
                faActBalanceInfo.setEvalueCreditFor(faActBalanceInfo.getEvalueCreditFor().add(lastEvaValue));
                faActBalanceInfo.setEvalueEndBalanceFor(this.calcEvalueEndBalanceFor(faActBalanceInfo));
                faActBalanceCol.add(faActBalanceInfo);
            }
        } else {
            try {
                int i;
                String sql = "select threadCount threadCount from t_fa_faThreadSize";
                IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
                int threadCount = 12;
                while (set.next()) {
                    threadCount = set.getInt("threadCount");
                }
                ExecutorService executor = Executors.newFixedThreadPool(threadCount);
                ArrayList<Future<String>> futureList = new ArrayList<Future<String>>();
                Future<String> future = null;
                for (i = 0; i < clearBillInfo.getClearBillEntry().size(); ++i) {
                    FaClearBillEntryInfo entryInfo = clearBillInfo.getClearBillEntry().get(i);
                    InitCallable callable = new InitCallable(entryInfo, faActBalanceCol, ctx, companyID, periodInfo, baseCurPrecision);
                    future = executor.submit(callable);
                    futureList.add(future);
                }
                for (i = 0; i < futureList.size(); ++i) {
                    ((Future)futureList.get(i)).get();
                }
                executor.shutdown();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return faActBalanceCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEntry(FaClearBillEntryInfo entryInfo, FaAccountBalanceCollection faActBalanceCol, Context ctx, String companyID, PeriodInfo periodInfo, int baseCurPrecision) throws EASBizException, BOSException {
        FaCurCardInfo billInfo = entryInfo.getCurCard();
        String faCardID = this.getFaCardID(billInfo);
        FaAccountBalanceInfo faActBalanceInfo = this.getFaAcctBalanceByCurCard(ctx, faCardID, companyID, periodInfo);
        if (faActBalanceInfo != null) {
            faActBalanceInfo.setRealCreditFor(faActBalanceInfo.getRealCreditFor().add(entryInfo.getClrOriginal()));
            faActBalanceInfo.setRealEndBalanceFor(this.calcRealEndBalanceFor(faActBalanceInfo));
            faActBalanceInfo.setDepreDebitFor(faActBalanceInfo.getDepreDebitFor().add(entryInfo.getClrAddupDep()));
            faActBalanceInfo.setDepreEndBalanceFor(this.calcDepreEndBalanceFor(faActBalanceInfo));
            faActBalanceInfo.setAddUpYearDepre(faActBalanceInfo.getAddUpYearDepre().subtract(entryInfo.getClrAddupDep()));
            faActBalanceInfo.setDecValueDebitFor(faActBalanceInfo.getDecValueDebitFor().add(entryInfo.getClrDecPrep()));
            faActBalanceInfo.setDecValueEndBalanceFor(this.calcDecValueEndBalanceFor(faActBalanceInfo));
            FaBakCardInfo bakcard = entryInfo.getBizCard().getFaBakCard();
            bakcard = FaBakCardFactory.getLocalInstance(ctx).getFaBakCardInfo((IObjectPK)new ObjectUuidPK(bakcard.getId().toString()));
            BigDecimal clearRadio = entryInfo.getClrQty().divide(bakcard.getAssetAmt(), 4, 4);
            BigDecimal lastEvaValue = (bakcard.getInitEvalValue() == null ? zeroValue : bakcard.getInitEvalValue()).multiply(clearRadio).setScale(baseCurPrecision, 4);
            faActBalanceInfo.setEvalueCreditFor(faActBalanceInfo.getEvalueCreditFor().add(lastEvaValue));
            faActBalanceInfo.setEvalueEndBalanceFor(this.calcEvalueEndBalanceFor(faActBalanceInfo));
            FaAccountBalanceCollection faAccountBalanceCollection = faActBalanceCol;
            synchronized (faAccountBalanceCollection) {
                faActBalanceCol.add(faActBalanceInfo);
            }
        } else {
            throw new FaBalanceUpdException(FaBalanceUpdException.FA_BALANCE_CANNOTFOUND);
        }
    }

    @Override
    public FaAccountBalanceCollection proc4RollbackFaBalance(Context ctx, BillBaseInfo billBaseInfo, PeriodInfo periodInfo) throws BOSException, EASBizException {
        FaClearBillInfo clearBillInfo = (FaClearBillInfo)billBaseInfo;
        FaAccountBalanceCollection faActBalanceCol = new FaAccountBalanceCollection();
        String companyID = clearBillInfo.getCompany().getId().toString();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id = '" + companyID + "'");
        int baseCurPrecision = company.getBaseCurrency() == null ? 2 : company.getBaseCurrency().getPrecision();
        for (int i = 0; i < clearBillInfo.getClearBillEntry().size(); ++i) {
            FaCurCardInfo billInfo = clearBillInfo.getClearBillEntry().get(i).getCurCard();
            String faCardID = this.getFaCardID(billInfo);
            FaAccountBalanceInfo faActBalanceInfo = this.getFaAcctBalanceByCurCard(ctx, faCardID, companyID, periodInfo);
            if (faActBalanceInfo == null) {
                throw new FaBalanceUpdException(FaBalanceUpdException.FA_BALANCE_CANNOTFOUND);
            }
            faActBalanceInfo.setRealCreditFor(faActBalanceInfo.getRealCreditFor().subtract(clearBillInfo.getClearBillEntry().get(i).getClrOriginal()));
            faActBalanceInfo.setRealEndBalanceFor(this.calcRealEndBalanceFor(faActBalanceInfo));
            faActBalanceInfo.setDepreDebitFor(faActBalanceInfo.getDepreDebitFor().subtract(clearBillInfo.getClearBillEntry().get(i).getClrAddupDep()));
            faActBalanceInfo.setDepreEndBalanceFor(this.calcDepreEndBalanceFor(faActBalanceInfo));
            faActBalanceInfo.setAddUpYearDepre(faActBalanceInfo.getAddUpYearDepre().add(clearBillInfo.getClearBillEntry().get(i).getClrAddupDep()));
            faActBalanceInfo.setDecValueDebitFor(faActBalanceInfo.getDecValueDebitFor().subtract(clearBillInfo.getClearBillEntry().get(i).getClrDecPrep()));
            faActBalanceInfo.setDecValueEndBalanceFor(this.calcDecValueEndBalanceFor(faActBalanceInfo));
            FaBakCardInfo bakcard = clearBillInfo.getClearBillEntry().get(i).getBizCard().getFaBakCard();
            BigDecimal clearRadio = clearBillInfo.getClearBillEntry().get(i).getClrQty().divide(bakcard.getAssetAmt(), 4, 4);
            BigDecimal lastEvaValue = (bakcard.getInitEvalValue() == null ? zeroValue : bakcard.getInitEvalValue()).multiply(clearRadio).setScale(baseCurPrecision, 4);
            faActBalanceInfo.setEvalueCreditFor(faActBalanceInfo.getEvalueCreditFor().subtract(lastEvaValue));
            faActBalanceInfo.setEvalueEndBalanceFor(this.calcEvalueEndBalanceFor(faActBalanceInfo));
            faActBalanceCol.add(faActBalanceInfo);
        }
        return faActBalanceCol;
    }

    class InitCallable
    implements Callable<String> {
        private FaClearBillEntryInfo entryInfo;
        private FaAccountBalanceCollection faActBalanceCol;
        private Context ctx;
        private String companyID;
        private PeriodInfo periodInfo;
        private int baseCurPrecision;

        public InitCallable(FaClearBillEntryInfo entryInfo, FaAccountBalanceCollection faActBalanceCol, Context ctx, String companyID, PeriodInfo periodInfo, int baseCurPrecision) {
            this.entryInfo = entryInfo;
            this.faActBalanceCol = faActBalanceCol;
            this.ctx = ctx;
            this.companyID = companyID;
            this.periodInfo = periodInfo;
            this.baseCurPrecision = baseCurPrecision;
        }

        @Override
        public String call() throws Exception {
            FaBalanceClrUpdStrategy.this.handleEntry(this.entryInfo, this.faActBalanceCol, this.ctx, this.companyID, this.periodInfo, this.baseCurPrecision);
            return "success";
        }
    }
}

