/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceCollection;
import com.kingdee.eas.fi.fa.manage.FaAccountBalanceFactory;
import com.kingdee.eas.fi.fa.manage.FaBalanceUpdException;
import com.kingdee.eas.fi.fa.manage.IFaAccountBalance;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaBalanceUpdStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaBalanceAddUpdStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaStocktakingReportBillControllerBean;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;

public class FaBalanceFacade {
    private AbstractFaBalanceUpdStrategy faBalanceUpdStrategy;
    private FaAccountBalanceCollection faAcctBalanceCol;

    public void updateFaAccountBalance(Context ctx, BillBaseCollection billCol, PeriodInfo periodInfo) throws BOSException, EASBizException {
        for (int i = 0; i < billCol.size(); ++i) {
            this.updateFaAccountBalance(ctx, billCol.get(i), periodInfo);
        }
    }

    public void updateFaAccountBalance(Context ctx, BillBaseInfo billInfo, PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (periodInfo == null) {
            throw new FaBalanceUpdException(FaBalanceUpdException.FA_PREIOD_ISNULL);
        }
        this.faAcctBalanceCol = this.faBalanceUpdStrategy.proc4UpdateFaBalance(ctx, billInfo, periodInfo);
        String isFromStock = billInfo.getString(FaStocktakingReportBillControllerBean.IS_FROM_STOCK_TAKING_REPORT_BILL);
        if ("true".equals(isFromStock)) {
            ctx.put((Object)FaStocktakingReportBillControllerBean.IS_FROM_STOCK_TAKING_REPORT_BILL, (Object)"true");
        }
        this.saveFaAcctBalance(ctx, this.faAcctBalanceCol);
    }

    public void rollbackFaAccountBalance(Context ctx, BillBaseCollection billCol, PeriodInfo periodInfo) throws BOSException, EASBizException {
        for (int i = 0; i < billCol.size(); ++i) {
            this.rollbackFaAccountBalance(ctx, billCol.get(i), periodInfo);
        }
    }

    public void rollbackFaAccountBalance(Context ctx, BillBaseInfo bill, PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (periodInfo == null) {
            throw new FaBalanceUpdException(FaBalanceUpdException.FA_PREIOD_ISNULL);
        }
        this.faAcctBalanceCol = this.faBalanceUpdStrategy.proc4RollbackFaBalance(ctx, bill, periodInfo);
        if (this.faBalanceUpdStrategy instanceof FaBalanceAddUpdStrategy) {
            this.deleteFaAcctBalance(ctx, this.faAcctBalanceCol);
        } else {
            this.saveFaAcctBalance(ctx, this.faAcctBalanceCol);
        }
    }

    public void setFaBalanceUpdStrategy(AbstractFaBalanceUpdStrategy concreteFaBlcUpdStrategy) {
        this.faBalanceUpdStrategy = concreteFaBlcUpdStrategy;
    }

    private void saveFaAcctBalance(Context ctx, FaAccountBalanceCollection faAcctBalanceCol) throws BOSException, EASBizException {
        IFaAccountBalance faAccountBalance = null;
        faAccountBalance = FaAccountBalanceFactory.getLocalInstance(ctx);
        for (int i = 0; i < faAcctBalanceCol.size(); ++i) {
            faAccountBalance.submit((CoreBaseInfo)faAcctBalanceCol.get(i));
        }
    }

    private void deleteFaAcctBalance(Context ctx, FaAccountBalanceCollection faAcctBalanceCol) throws BOSException, EASBizException {
        IFaAccountBalance faAccountBalance = null;
        faAccountBalance = FaAccountBalanceFactory.getLocalInstance(ctx);
        for (int i = 0; i < faAcctBalanceCol.size(); ++i) {
            faAccountBalance.delete((IObjectPK)new ObjectUuidPK(faAcctBalanceCol.get(i).getId()));
        }
    }
}

