/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeFactory;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaEconomicPurpInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.FaUseStatusInfo;
import com.kingdee.eas.fi.fa.basedata.IFaAlterMode;
import com.kingdee.eas.fi.fa.facade.app.util.FasBosUtils;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardWebValidatorImpl;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaClearStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaCurAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaCurAsstActCompositInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityCollection;
import com.kingdee.eas.fi.fa.manage.FaCurFacilityInfo;
import com.kingdee.eas.fi.fa.manage.FaDispatchBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaFromUnitCatEnum;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaWebException;
import com.kingdee.eas.fi.fa.manage.IFaChangeBill;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaChangeBillWebFacadeControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaChangeBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaDepCalWebExecutor;
import com.kingdee.eas.fi.fa.manage.app.PrcFaChangeStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.common.BatchBillProcessResult;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaChangeBillWebFacadeControllerBean
extends AbstractFaChangeBillWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaChangeBillWebFacadeControllerBean");
    private String RESOURCE_PATH = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private static final String FA_WE_RESOUSE = "com.kingdee.eas.fi.fa.manage.FaWebResource";
    private static final BigDecimal ZERO = new BigDecimal("0");
    private int amountScale = 10;
    private int originScale = 10;
    private int quantityScale = 0;
    private int rateScale = 3;

    @Override
    protected Map _delete(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchBillProcessResult resultList = new BatchBillProcessResult();
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        String permissionName = "fa_cardchange_delete";
        HashMap permissionMap = new HashMap();
        int success = 0;
        IFaChangeBill billBase = FaChangeBillFactory.getLocalInstance(ctx);
        for (int i = 0; i < pks.length; ++i) {
            String pk = pks[i];
            try {
                boolean isPermission;
                if (!billBase.exists((IObjectPK)new ObjectUuidPK(pk))) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                FaChangeBillInfo outBillInfo = (FaChangeBillInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(pk), this.getSelector());
                if (permissionMap.get(outBillInfo.getCompany().getId().toString()) != null) {
                    HashMap map = (HashMap)permissionMap.get(outBillInfo.getCompany().getId().toString());
                    isPermission = (Boolean)map.get("isPermission");
                    if (!isPermission) {
                        String companyName = (String)map.get("companyName");
                        String number = (String)map.get("number");
                        String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NOPASSAUDIT_THISBILL", (Locale)ctx.getOriginLocale()), companyName);
                        throw new EASBizException(new NumericExceptionSubItem("NOPASSAUDIT_THISBILL", msg));
                    }
                } else {
                    HashMap<String, Object> companyMap = new HashMap<String, Object>();
                    isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(outBillInfo.getCompany().getId().toString()), permissionName);
                    companyMap.put("companyName", outBillInfo.getCompany().getName());
                    companyMap.put("isPermission", isPermission);
                    companyMap.put("number", outBillInfo.getNumber());
                    permissionMap.put(outBillInfo.getCompany().getId().toString(), companyMap);
                    if (!isPermission) {
                        String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NODELETE_THISBILL", (Locale)ctx.getOriginLocale()), outBillInfo.getCompany().getName());
                        throw new EASBizException(new NumericExceptionSubItem("NODELETE_THISBILL", msg));
                    }
                }
                FaChangeBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(pk));
                ++success;
                continue;
            }
            catch (Exception e) {
                BatchBillProcessResult result = new BatchBillProcessResult();
                logger.equals(e.getMessage());
                e.printStackTrace();
                result.setIconType("error");
                result.setInfo(e.getMessage());
                resultList.getDetailMsgList().add(result);
            }
        }
        if (success == pks.length) {
            resultList.setSummaryMsg(EASResource.getString((String)FA_WE_RESOUSE, (String)"DELETEALL_SUCCESS", (Locale)ctx.getOriginLocale()));
        } else {
            String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"DELETE_SUCCESSFUL_FAILURE", (Locale)ctx.getOriginLocale()), String.valueOf(success), String.valueOf(pks.length - success));
            resultList.setSummaryMsg(msg);
        }
        return resultList;
    }

    @Override
    protected Map _passAudit(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchBillProcessResult resultList = new BatchBillProcessResult();
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        String permissionName = "fa_cardchange_audit";
        HashMap permissionMap = new HashMap();
        int success = 0;
        IFaChangeBill billBase = FaChangeBillFactory.getLocalInstance(ctx);
        for (int i = 0; i < pks.length; ++i) {
            String pk = pks[i];
            try {
                boolean isPermission;
                if (!billBase.exists((IObjectPK)new ObjectUuidPK(pk))) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                FaChangeBillInfo outBillInfo = (FaChangeBillInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(pk), this.getSelector());
                if (permissionMap.get(outBillInfo.getCompany().getId().toString()) != null) {
                    HashMap map = (HashMap)permissionMap.get(outBillInfo.getCompany().getId().toString());
                    isPermission = (Boolean)map.get("isPermission");
                    if (!isPermission) {
                        String companyName = (String)map.get("companyName");
                        String number = (String)map.get("number");
                        String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NOPASSAUDIT_THISBILL", (Locale)ctx.getOriginLocale()), companyName);
                        throw new EASBizException(new NumericExceptionSubItem("NOPASSAUDIT_THISBILL", msg));
                    }
                } else {
                    HashMap<String, Object> companyMap = new HashMap<String, Object>();
                    isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(outBillInfo.getCompany().getId().toString()), permissionName);
                    companyMap.put("companyName", outBillInfo.getCompany().getName());
                    companyMap.put("isPermission", isPermission);
                    companyMap.put("number", outBillInfo.getNumber());
                    permissionMap.put(outBillInfo.getCompany().getId().toString(), companyMap);
                    if (!isPermission) {
                        String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NOPASSAUDIT_THISBILL", (Locale)ctx.getOriginLocale()), outBillInfo.getCompany().getName());
                        throw new EASBizException(new NumericExceptionSubItem("NOPASSAUDIT_THISBILL", msg));
                    }
                }
                FaBillBizProcessor.lockTable(ctx, pk.toString());
                prcFaCoreManager.getFaManageStrategy().checkForAudit(ctx, (IObjectPK)new ObjectUuidPK(pk));
                BillBaseInfo billInfo = prcFaCoreManager.getFaManageStrategy().perpareBillInfo(ctx, (IObjectPK)new ObjectUuidPK(pk));
                if (this.isCurrencyDisable(ctx, (FaChangeBillInfo)billInfo)) {
                    StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"THISBILL", (Locale)ctx.getOriginLocale()));
                    sbAll.append(" ");
                    sbAll.append(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
                    throw new FaCardException(FaCardException.UN_SUCCESS, new String[]{sbAll.toString()});
                }
                FaChangeBillInfo bill = new FaChangeBillInfo();
                bill.setId(BOSUuid.read((String)pk.toString()));
                prcFaCoreManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)bill);
                ++success;
                continue;
            }
            catch (Exception e) {
                BatchBillProcessResult result = new BatchBillProcessResult();
                logger.equals(e.getMessage());
                e.printStackTrace();
                result.setIconType("error");
                result.setInfo(e.getMessage());
                resultList.getDetailMsgList().add(result);
            }
        }
        if (success == pks.length) {
            String msg = EASResource.getString((String)FA_WE_RESOUSE, (String)"ALL_PASSAUDIT_SUCCESS", (Locale)ctx.getOriginLocale());
            resultList.setSummaryMsg(msg);
        } else {
            String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"AUDIT_SUCCESSFUL_FAILURE", (Locale)ctx.getOriginLocale()), String.valueOf(success), String.valueOf(pks.length - success));
            resultList.setSummaryMsg(msg);
        }
        return resultList;
    }

    @Override
    protected Map _unpassAudit(Context ctx, String[] pks) throws BOSException, EASBizException {
        BatchBillProcessResult resultList = new BatchBillProcessResult();
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(new PrcFaChangeStrategy());
        String permissionName = "fa_cardchange_unaudit";
        HashMap permissionMap = new HashMap();
        int success = 0;
        IFaChangeBill billBase = FaChangeBillFactory.getLocalInstance(ctx);
        for (int i = 0; i < pks.length; ++i) {
            String pk = pks[i];
            try {
                boolean isPermission;
                if (!billBase.exists((IObjectPK)new ObjectUuidPK(pk))) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                FaChangeBillInfo outBillInfo = (FaChangeBillInfo)billBase.getValue((IObjectPK)new ObjectUuidPK(pk), this.getSelector());
                if (permissionMap.get(outBillInfo.getCompany().getId().toString()) != null) {
                    HashMap map = (HashMap)permissionMap.get(outBillInfo.getCompany().getId().toString());
                    isPermission = (Boolean)map.get("isPermission");
                    if (!isPermission) {
                        String companyName = (String)map.get("companyName");
                        String number = (String)map.get("number");
                        String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NOUNPASSAUDI_THISBILL", (Locale)ctx.getOriginLocale()), companyName);
                        throw new EASBizException(new NumericExceptionSubItem("NOUNPASSAUDI_THISBILL", msg));
                    }
                } else {
                    HashMap<String, Object> companyMap = new HashMap<String, Object>();
                    isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(outBillInfo.getCompany().getId().toString()), permissionName);
                    companyMap.put("companyName", outBillInfo.getCompany().getName());
                    companyMap.put("isPermission", isPermission);
                    companyMap.put("number", outBillInfo.getNumber());
                    permissionMap.put(outBillInfo.getCompany().getId().toString(), companyMap);
                    if (!isPermission) {
                        String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"NOUNPASSAUDI_THISBILL", (Locale)ctx.getOriginLocale()), outBillInfo.getCompany().getName());
                        throw new EASBizException(new NumericExceptionSubItem("NOUNPASSAUDI_THISBILL", msg));
                    }
                }
                FaChangeBillInfo billInfo = (FaChangeBillInfo)prcFaCoreManager.getFaManageStrategy().perpareBillInfo(ctx, (IObjectPK)new ObjectUuidPK(pk));
                PeriodInfo period = this.getCurrentPeriod(ctx);
                IFaAlterMode iAlterMode = FaAlterModeFactory.getLocalInstance((Context)ctx);
                if (iAlterMode.exists("where id='" + billInfo.getChangeMode().getId() + "' and number='000'")) {
                    boolean isInCurPeriod;
                    boolean bl = isInCurPeriod = billInfo.getChangeDate().after(period.getBeginDate()) && billInfo.getChangeDate().before(period.getEndDate());
                    if (billInfo.getChangeDate().equals(period.getBeginDate()) || billInfo.getChangeDate().equals(period.getEndDate())) {
                        isInCurPeriod = true;
                    }
                    if (isInCurPeriod) {
                        DbUtil.execute((Context)ctx, (String)("update T_fa_fachangebill set fperiodId = '" + period.getId().toString() + "' where fid = '" + pk.toString() + "'"));
                        billInfo.setPeriod(period);
                    }
                }
                FaBillBizProcessor.lockTable(ctx, pk.toString());
                prcFaCoreManager.getFaManageStrategy().checkForUnAudit(ctx, (IObjectPK)new ObjectUuidPK(pk));
                FaChangeBillInfo model = billInfo;
                prcFaCoreManager.getFaManageStrategy().unAuditBill(ctx, (IObjectValue)model);
                ++success;
                continue;
            }
            catch (Exception e) {
                BatchBillProcessResult result = new BatchBillProcessResult();
                logger.equals(e.getMessage());
                e.printStackTrace();
                result.setIconType("error");
                result.setInfo(e.getMessage());
                resultList.getDetailMsgList().add(result);
            }
        }
        if (success == pks.length) {
            String msg = EASResource.getString((String)FA_WE_RESOUSE, (String)"ALL_UNPASSAUDIT_SUCCESS", (Locale)ctx.getOriginLocale());
            resultList.setSummaryMsg(msg);
        } else {
            String msg = MessageFormat.format(EASResource.getString((String)FA_WE_RESOUSE, (String)"UNAUDIT_SUCCESSFUL_FAILURE", (Locale)ctx.getOriginLocale()), String.valueOf(success), String.valueOf(pks.length - success));
            resultList.setSummaryMsg(msg);
        }
        return resultList;
    }

    private boolean isCurrencyDisable(Context ctx, FaChangeBillInfo changeBillInfo) throws EASBizException, BOSException {
        FaBizCardInfo bizCardInfo;
        boolean isDisable = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.number"));
        if (changeBillInfo != null && changeBillInfo.getChangeBillEntry() != null && changeBillInfo.getChangeBillEntry().get(0) != null && changeBillInfo.getChangeBillEntry().get(0).getBizCard() != null && (bizCardInfo = changeBillInfo.getChangeBillEntry().get(0).getBizCard()) != null && bizCardInfo.getId() != null) {
            bizCardInfo = FaBizCardFactory.getLocalInstance(ctx).getFaBizCardInfo((IObjectPK)new ObjectUuidPK(bizCardInfo.getId()), sic);
            CurrencyInfo currencyInfo = bizCardInfo.getCurrency();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)currencyInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)"2", CompareType.EQUALS));
            isDisable = CurrencyFactory.getLocalInstance((Context)ctx).exists(filter);
        }
        return isDisable;
    }

    protected PeriodInfo getCurrentPeriod(Context ctx) throws EASBizException, BOSException {
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo")));
        return curPeriod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String _getOrgDataFilter(Context ctx, boolean share) throws BOSException, EASBizException {
        String permItem = "fa_cardchange_list";
        StringBuffer orgDataFilter = new StringBuffer("id in ( ");
        CompanyOrgUnitCollection companyOrgUnitCollection = new CompanyOrgUnitCollection();
        if (!share) {
            CompanyOrgUnitInfo current = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
            if (!current.isIsBizUnit()) throw new FaWebException(FaWebException.CUORGVIRTUAL);
            boolean isPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(current.getId().toString()), permItem);
            if (!isPermission) {
                throw new FaWebException(FaWebException.NO_VIEW_PERMISSION);
            }
            if (current.isIsSealUp()) {
                throw new FaWebException(FaWebException.CUORGSEALED);
            }
            if (current.getInvalidDate() != null && DateTimeUtils.dayBefore((Date)current.getInvalidDate(), (Date)new Date())) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"Company_Disabled", (Locale)ctx.getOriginLocale());
                throw new EASBizException(new NumericExceptionSubItem("Company_Disabled", strMsg));
            }
            ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)current.getId().toString()));
            PeriodInfo currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)orgPk);
            if (currenctPeriod == null) {
                String strMsg = EASCommonResource.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notConfigStartPeriod", (Locale)ctx.getOriginLocale());
                throw new CasWebException(new NumericExceptionSubItem("1", strMsg));
            }
            boolean isInitEnd = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)current);
            if (!isInitEnd) {
                String strMsg = EASCommonResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.FaCurCardEditUI_FANotEndInit", (Locale)ctx.getOriginLocale());
                throw new EASBizException(new NumericExceptionSubItem("FaCurCardEditUI_FANotEndInit", strMsg));
            }
            FaCardFactory.getRemoteInstance().checkAccountSwap(current);
            companyOrgUnitCollection.add(current);
        } else {
            companyOrgUnitCollection = this.getOrgsByPermission(ctx, permItem);
        }
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            CompanyOrgUnitInfo orgInfo = companyOrgUnitCollection.get(i);
            orgDataFilter.append("'" + orgInfo.getId().toString() + "',");
        }
        if (orgDataFilter.toString().equals("id in ( ")) {
            orgDataFilter = new StringBuffer("id in ('NE')");
            return orgDataFilter.toString();
        } else {
            orgDataFilter.deleteCharAt(orgDataFilter.length() - 1);
            orgDataFilter.append(") ");
        }
        return orgDataFilter.toString();
    }

    public CompanyOrgUnitCollection getOrgsByPermission(Context ctx, String permItem) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitCollection collection = new CompanyOrgUnitCollection();
        CompanyOrgUnitCollection permCollection = new CompanyOrgUnitCollection();
        collection = this.getAuthrizedCompanyOrg(ctx, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), permItem, false);
        Iterator iterator = collection.iterator();
        boolean i = false;
        while (iterator.hasNext()) {
            CompanyOrgUnitInfo orgInfo = (CompanyOrgUnitInfo)iterator.next();
            if (!orgInfo.isIsBizUnit() || orgInfo.isIsSealUp()) continue;
            permCollection.add(orgInfo);
        }
        if (permCollection == null || permCollection.size() <= 0) {
            throw new FaWebException(FaWebException.NO_VIEW_PERMISSION_ALL);
        }
        CompanyOrgUnitCollection isInitEndCollection = new CompanyOrgUnitCollection();
        for (int j = 0; j < permCollection.size(); ++j) {
            CompanyOrgUnitInfo orgInfo = permCollection.get(j);
            boolean isInitEnd = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)orgInfo);
            if (!isInitEnd) continue;
            isInitEndCollection.add(orgInfo);
        }
        if (isInitEndCollection == null || isInitEndCollection.size() == 0) {
            String strMsg = EASCommonResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.FaCurCardEditUI_FANotEndInit", (Locale)ctx.getOriginLocale());
            throw new EASBizException(new NumericExceptionSubItem("FaCurCardEditUI_FANotEndInit", strMsg));
        }
        CompanyOrgUnitCollection accountSwapCollection = new CompanyOrgUnitCollection();
        for (int j = 0; j < isInitEndCollection.size(); ++j) {
            CompanyOrgUnitInfo orgInfo = isInitEndCollection.get(j);
            try {
                CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId()));
                FaCardFactory.getRemoteInstance().checkAccountSwap(companyOrgUnitInfo);
                accountSwapCollection.add(orgInfo);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (accountSwapCollection == null || accountSwapCollection.size() == 0) {
            throw new FaCardException(FaCardException.ACCOUNTSWAP);
        }
        return accountSwapCollection;
    }

    protected CompanyOrgUnitCollection getAuthrizedCompanyOrg(Context ctx, String userID, String permItemName, boolean includeVirtual) throws BOSException, EASBizException {
        FullOrgUnitCollection collection;
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        String orgTreeId = OrgCommonUtils.getOrgTreeId((OrgType)OrgType.Company);
        ObjectUuidPK orgTreePK = null;
        if (orgTreeId != null) {
            orgTreePK = new ObjectUuidPK(orgTreeId);
        }
        if ((collection = iPermission.getAuthorizedOrg(ctx.getCaller(), OrgType.Company, (IObjectPK)orgTreePK, permItemName)).size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            idSet.add(collection.get(i).getId().toString());
        }
        FasBosUtils.EntityViewBuilder viewBuilder = FasBosUtils.entityViewBuilder();
        viewBuilder.select(new String[]{"id", "number", "name", "longNumber", "level", "isBizUnit", "isIsSealUp"}).sort("longNumber", SortType.ASCEND).sort("number", SortType.ASCEND).filter("id", idSet, CompareType.INCLUDE);
        if (!includeVirtual) {
            viewBuilder.filter("isBizUnit", (Object)true, CompareType.EQUALS);
        }
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(viewBuilder.build());
        return coll;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    @Override
    protected Map _save(Context ctx, IObjectValue dataObject) throws BOSException, EASBizException {
        HashMap<String, String> resultList = new HashMap<String, String>();
        IObjectPK objectPK = null;
        FaCurCardInfo card = (FaCurCardInfo)dataObject;
        try {
            CoreBaseInfo model;
            if (dataObject.get("cardInfoID") != null) {
                String cardInfoID = (String)dataObject.get("cardInfoID");
                dataObject.put("id", (Object)BOSUuid.read((String)cardInfoID));
            }
            if ((model = (CoreBaseInfo)dataObject).get("changeMode") instanceof String) {
                Object faAlterModeInfo = null;
                model.put("changeMode", faAlterModeInfo);
            } else if (model.get("changeMode") instanceof Map) {
                String changeModeJson = JSONUtils.convertObjectToJson((Context)ctx, (Object)model.get("changeMode"));
                FaAlterModeInfo faAlterModeInfo = (FaAlterModeInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)changeModeJson, FaAlterModeInfo.class);
                model.put("changeMode", (Object)faAlterModeInfo);
            }
            if (model.get("changeBill") != null && model.get("changeBill") instanceof Map) {
                String changeBillJson = JSONUtils.convertObjectToJson((Context)ctx, (Object)model.get("changeBill"));
                FaChangeBillInfo faChangeBillInfo = (FaChangeBillInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)changeBillJson, FaChangeBillInfo.class);
                FaBizCardInfo FaBizCardInfo2 = faChangeBillInfo.getChangeBillEntry().get(0).getBizCard();
                FaBakCardInfo faBakCardInfo = FaBizCardInfo2.getFaBakCard();
                FaBizCardInfo2.setFaBakCard(faBakCardInfo);
                model.put("changeBill", (Object)faChangeBillInfo);
                model.put("faBakCard", (Object)faBakCardInfo);
            }
            if (model.get("CHANGE_INFO_FOR_VERFY") != null && model.get("CHANGE_INFO_FOR_VERFY") instanceof Map) {
                String FaCurCardInfoJson = JSONUtils.convertObjectToJson((Context)ctx, (Object)model.get("CHANGE_INFO_FOR_VERFY"));
                FaCurCardInfo FaCurCardInfo2 = (FaCurCardInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)FaCurCardInfoJson, FaCurCardInfo.class);
                model.put("CHANGE_INFO_FOR_VERFY", (Object)FaCurCardInfo2);
            }
            FaCurCostCenterCollection faCurCostCenterCollection = card.getFaCurCostCenter();
            int rowCount = faCurCostCenterCollection.size();
            for (int i = 0; i < rowCount; ++i) {
                FaCurCostCenterInfo faCurCostCenterInfo = faCurCostCenterCollection.get(i);
                BOSUuid id = BOSUuid.create((BOSObjectType)faCurCostCenterInfo.getBOSType());
                faCurCostCenterInfo.setId(id);
                faCurCostCenterInfo.setSeq(i + 1);
                FaCurAsstActCompositCollection faCurAsstActCompositCollection = faCurCostCenterInfo.getFaCurAsstActComposit();
                for (int j = 0; j < faCurAsstActCompositCollection.size(); ++j) {
                    FaCurAsstActCompositInfo faCurAsstActCompositInfo = faCurAsstActCompositCollection.get(i);
                    BOSUuid assId = BOSUuid.create((BOSObjectType)faCurAsstActCompositInfo.getBOSType());
                    faCurAsstActCompositInfo.setId(assId);
                }
            }
            String changeDateStr = (String)model.get("changeDate");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd ");
            Date changeDate = sdf.parse(changeDateStr);
            model.put("changeDate", (Object)changeDate);
            String lastupdatetimes = (String)model.get("lastupdatetimes");
            long lastupdatetime = Long.parseLong(lastupdatetimes);
            Date date = new Date(lastupdatetime);
            model.put("lastupdatetime", (Object)date);
            StringBuffer errorMsg = new StringBuffer();
            if (model instanceof FaCurCardInfo) {
                StringBuffer stringBuffer1 = this.checkBeforeSubmit(ctx, (FaCardInfo)model, false);
                StringBuffer stringBuffer2 = this.verifyInput((IObjectValue)model, false);
                errorMsg.append(stringBuffer1);
                errorMsg.append(stringBuffer2);
            }
            if (errorMsg.length() > 0) {
                throw new Exception(errorMsg.toString());
            }
            IFaChangeBill iFaChangeBill = FaChangeBillFactory.getLocalInstance(ctx);
            objectPK = this.getSavePk(ctx, iFaChangeBill, model);
            resultList.put("pkId", objectPK.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            resultList.put("summaryMsg", e.getMessage());
            resultList.put("detailMsg", e.toString());
        }
        return resultList;
    }

    private IObjectPK getSavePk(Context ctx, IFaChangeBill iFaChangeBill, CoreBaseInfo info) throws Exception {
        IObjectPK objectPK = null;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection btpRelationCollection = FaChangeBillWebFacadeControllerBean.getBOTRelationColFromExtendProperty(ctx, (IObjectValue)info);
        if (info.get("id") != null) {
            if (btpRelationCollection == null || btpRelationCollection.size() == 0) {
                btpRelationCollection = iBTPManager.getRelationCollection(info.get("id").toString());
            }
            objectPK = btpRelationCollection != null && btpRelationCollection.size() > 0 ? iBTPManager.saveRelations((CoreBillBaseInfo)info, btpRelationCollection) : iFaChangeBill.save(info);
        } else {
            objectPK = iFaChangeBill.save(info);
        }
        return objectPK;
    }

    public static BOTRelationCollection getBOTRelationColFromExtendProperty(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        BOTRelationCollection botCol = new BOTRelationCollection();
        if (model.getExtendedProperty("botrelation") != null) {
            Object o;
            String botrelationStr = model.getExtendedProperty("botrelation");
            ArrayList list = (ArrayList)JSONUtils.convertJsonToObject((Context)ctx, (String)botrelationStr, ArrayList.class);
            for (int i = 0; i < list.size(); ++i) {
                LinkedTreeMap map = (LinkedTreeMap)list.get(i);
                Iterator iterator = map.keySet().iterator();
                BOTRelationInfo info = new BOTRelationInfo();
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    if (map.get((Object)key) == null || "date".equals(key)) continue;
                    if ("isEffected".equals(key)) {
                        info.setIsEffected(false);
                        continue;
                    }
                    if ("relationEntries".equals(key)) {
                        info.put(key, (Object)FaChangeBillWebFacadeControllerBean.getBOTEntryRelation((ArrayList)map.get((Object)key), info));
                        continue;
                    }
                    info.put(key, map.get((Object)key));
                }
                botCol.add(info);
            }
            if (model.containsKey("relationColl") && !EmptyUtil.isEmpty((Object)(o = model.get("relationColl"))) && o instanceof String) {
                model.put("relationColl", (Object)botCol);
            }
            return botCol;
        }
        return null;
    }

    private static BOTRelationEntryCollection getBOTEntryRelation(ArrayList list, BOTRelationInfo relationinfo) {
        if (list == null || list.size() == 0) {
            return null;
        }
        BOTRelationEntryCollection botCol = new BOTRelationEntryCollection();
        for (int i = 0; i < list.size(); ++i) {
            LinkedTreeMap map = (LinkedTreeMap)list.get(i);
            Iterator iterator = map.keySet().iterator();
            BOTRelationEntryInfo info = new BOTRelationEntryInfo();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                if (map.get((Object)key) == null) continue;
                info.put(key, map.get((Object)key));
            }
            info.put("relation", (Object)relationinfo);
            botCol.add(info);
        }
        return botCol;
    }

    @Override
    protected Map _submit(Context ctx, IObjectValue dataObject) throws BOSException, EASBizException {
        HashMap<String, String> resultList = new HashMap<String, String>();
        IObjectPK objectPK = null;
        try {
            CoreBaseInfo model;
            if (dataObject.get("cardInfoID") != null) {
                String cardInfoID = (String)dataObject.get("cardInfoID");
                dataObject.put("id", (Object)BOSUuid.read((String)cardInfoID));
            }
            if ((model = (CoreBaseInfo)dataObject).get("changeMode") instanceof String) {
                Object faAlterModeInfo = null;
                model.put("changeMode", faAlterModeInfo);
            } else if (model.get("changeMode") instanceof Map) {
                String changeModeJson = JSONUtils.convertObjectToJson((Context)ctx, (Object)model.get("changeMode"));
                FaAlterModeInfo faAlterModeInfo = (FaAlterModeInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)changeModeJson, FaAlterModeInfo.class);
                model.put("changeMode", (Object)faAlterModeInfo);
            }
            if (model.get("changeBill") != null && model.get("changeBill") instanceof Map) {
                String changeBillJson = JSONUtils.convertObjectToJson((Context)ctx, (Object)model.get("changeBill"));
                FaChangeBillInfo faChangeBillInfo = (FaChangeBillInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)changeBillJson, FaChangeBillInfo.class);
                FaBizCardInfo FaBizCardInfo2 = faChangeBillInfo.getChangeBillEntry().get(0).getBizCard();
                FaBakCardInfo faBakCardInfo = FaBizCardInfo2.getFaBakCard();
                FaBizCardInfo2.setFaBakCard(faBakCardInfo);
                model.put("changeBill", (Object)faChangeBillInfo);
                model.put("faBakCard", (Object)faBakCardInfo);
            }
            if (model.get("CHANGE_INFO_FOR_VERFY") != null && model.get("CHANGE_INFO_FOR_VERFY") instanceof Map) {
                String FaCurCardInfoJson = JSONUtils.convertObjectToJson((Context)ctx, (Object)model.get("CHANGE_INFO_FOR_VERFY"));
                FaCurCardInfo FaCurCardInfo2 = (FaCurCardInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)FaCurCardInfoJson, FaCurCardInfo.class);
                model.put("CHANGE_INFO_FOR_VERFY", (Object)FaCurCardInfo2);
            }
            FaCurCardInfo card = (FaCurCardInfo)dataObject;
            FaCurCostCenterCollection faCurCostCenterCollection = card.getFaCurCostCenter();
            int rowCount = faCurCostCenterCollection.size();
            for (int i = 0; i < rowCount; ++i) {
                FaCurCostCenterInfo faCurCostCenterInfo = faCurCostCenterCollection.get(i);
                BOSUuid id = BOSUuid.create((BOSObjectType)faCurCostCenterInfo.getBOSType());
                faCurCostCenterInfo.setId(id);
                faCurCostCenterInfo.setSeq(i + 1);
                FaCurAsstActCompositCollection faCurAsstActCompositCollection = faCurCostCenterInfo.getFaCurAsstActComposit();
                for (int j = 0; j < faCurAsstActCompositCollection.size(); ++j) {
                    FaCurAsstActCompositInfo faCurAsstActCompositInfo = faCurAsstActCompositCollection.get(i);
                    if (faCurAsstActCompositInfo == null) continue;
                    BOSUuid assId = BOSUuid.create((BOSObjectType)faCurAsstActCompositInfo.getBOSType());
                    faCurAsstActCompositInfo.setId(assId);
                }
            }
            String changeDateStr = (String)model.get("changeDate");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd ");
            Date changeDate = sdf.parse(changeDateStr);
            model.put("changeDate", (Object)changeDate);
            String lastupdatetimes = (String)model.get("lastupdatetimes");
            long lastupdatetime = Long.parseLong(lastupdatetimes);
            Date date = new Date(lastupdatetime);
            model.put("lastupdatetime", (Object)date);
            StringBuffer errorMsg = new StringBuffer();
            if (model instanceof FaCurCardInfo) {
                StringBuffer stringBuffer1 = this.checkBeforeSubmit(ctx, (FaCardInfo)model, true);
                StringBuffer stringBuffer2 = this.verifyInput((IObjectValue)model, true);
                errorMsg.append(stringBuffer1);
                errorMsg.append(stringBuffer2);
            }
            if (errorMsg.length() > 0) {
                throw new Exception(errorMsg.toString());
            }
            IFaChangeBill iFaChangeBill = FaChangeBillFactory.getLocalInstance(ctx);
            objectPK = this.getSubmitPk(ctx, iFaChangeBill, model);
            resultList.put("pkId", objectPK.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            resultList.put("summaryMsg", e.getMessage());
            resultList.put("detailMsg", e.toString());
        }
        return resultList;
    }

    @Override
    protected Map _submitPrompt(Context ctx, IObjectValue dataObject) throws BOSException, EASBizException {
        HashMap<String, String> resultList = new HashMap<String, String>();
        Object objectPK = null;
        try {
            CoreBaseInfo model;
            if (dataObject.get("cardInfoID") != null) {
                String cardInfoID = (String)dataObject.get("cardInfoID");
                dataObject.put("id", (Object)BOSUuid.read((String)cardInfoID));
            }
            if ((model = (CoreBaseInfo)dataObject).get("changeMode") instanceof String) {
                Object faAlterModeInfo = null;
                model.put("changeMode", faAlterModeInfo);
            } else if (model.get("changeMode") instanceof Map) {
                String changeModeJson = JSONUtils.convertObjectToJson((Context)ctx, (Object)model.get("changeMode"));
                FaAlterModeInfo faAlterModeInfo = (FaAlterModeInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)changeModeJson, FaAlterModeInfo.class);
                model.put("changeMode", (Object)faAlterModeInfo);
            }
            if (model.get("changeBill") != null && model.get("changeBill") instanceof Map) {
                String changeBillJson = JSONUtils.convertObjectToJson((Context)ctx, (Object)model.get("changeBill"));
                FaChangeBillInfo faChangeBillInfo = (FaChangeBillInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)changeBillJson, FaChangeBillInfo.class);
                FaBizCardInfo FaBizCardInfo2 = faChangeBillInfo.getChangeBillEntry().get(0).getBizCard();
                FaBakCardInfo faBakCardInfo = FaBizCardInfo2.getFaBakCard();
                FaBizCardInfo2.setFaBakCard(faBakCardInfo);
                model.put("changeBill", (Object)faChangeBillInfo);
                model.put("faBakCard", (Object)faBakCardInfo);
            }
            if (model.get("CHANGE_INFO_FOR_VERFY") != null && model.get("CHANGE_INFO_FOR_VERFY") instanceof Map) {
                String FaCurCardInfoJson = JSONUtils.convertObjectToJson((Context)ctx, (Object)model.get("CHANGE_INFO_FOR_VERFY"));
                FaCurCardInfo FaCurCardInfo2 = (FaCurCardInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)FaCurCardInfoJson, FaCurCardInfo.class);
                model.put("CHANGE_INFO_FOR_VERFY", (Object)FaCurCardInfo2);
            }
            FaCurCardInfo card = (FaCurCardInfo)dataObject;
            FaCurCostCenterCollection faCurCostCenterCollection = card.getFaCurCostCenter();
            int rowCount = faCurCostCenterCollection.size();
            for (int i = 0; i < rowCount; ++i) {
                FaCurCostCenterInfo faCurCostCenterInfo = faCurCostCenterCollection.get(i);
                BOSUuid id = BOSUuid.create((BOSObjectType)faCurCostCenterInfo.getBOSType());
                faCurCostCenterInfo.setId(id);
                faCurCostCenterInfo.setSeq(i + 1);
                FaCurAsstActCompositCollection faCurAsstActCompositCollection = faCurCostCenterInfo.getFaCurAsstActComposit();
                for (int j = 0; j < faCurAsstActCompositCollection.size(); ++j) {
                    FaCurAsstActCompositInfo faCurAsstActCompositInfo = faCurAsstActCompositCollection.get(i);
                    BOSUuid assId = BOSUuid.create((BOSObjectType)faCurAsstActCompositInfo.getBOSType());
                    faCurAsstActCompositInfo.setId(assId);
                }
            }
            String changeDateStr = (String)model.get("changeDate");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd ");
            Date changeDate = sdf.parse(changeDateStr);
            model.put("changeDate", (Object)changeDate);
            String lastupdatetimes = (String)model.get("lastupdatetimes");
            long lastupdatetime = Long.parseLong(lastupdatetimes);
            Date date = new Date(lastupdatetime);
            model.put("lastupdatetime", (Object)date);
            StringBuffer promptMsg = new StringBuffer();
            if (model instanceof FaCurCardInfo) {
                StringBuffer stringBuffer2 = this.promptInput((IObjectValue)model, true);
                promptMsg.append(stringBuffer2);
            }
            if (promptMsg.length() > 0) {
                throw new Exception(promptMsg.toString());
            }
            resultList.put("pkId", objectPK.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            resultList.put("summaryMsg", e.getMessage());
            resultList.put("detailMsg", e.toString());
        }
        return resultList;
    }

    private IObjectPK getSubmitPk(Context ctx, IFaChangeBill iFaChangeBil, CoreBaseInfo info) throws Exception {
        IObjectPK objectPK = null;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection btpRelationCollection = FaChangeBillWebFacadeControllerBean.getBOTRelationColFromExtendProperty(ctx, (IObjectValue)info);
        if (info.get("id") != null) {
            if (btpRelationCollection == null || btpRelationCollection.size() == 0) {
                btpRelationCollection = iBTPManager.getRelationCollection(info.get("id").toString());
            }
            objectPK = btpRelationCollection != null && btpRelationCollection.size() > 0 ? iBTPManager.submitRelations((CoreBillBaseInfo)info, btpRelationCollection) : iFaChangeBil.submit(info);
        } else {
            objectPK = iFaChangeBil.submit(info);
        }
        return objectPK;
    }

    public StringBuffer checkBeforeSubmit(Context ctx, FaCardInfo faCardInfo, boolean isSubmit) throws BOSException, EASBizException {
        String dependMsg = this.checkDepend((FaCurCardInfo)faCardInfo);
        if (dependMsg != null && dependMsg.length() > 0) {
            throw new BOSException(dependMsg);
        }
        StringBuffer errorMsg = new StringBuffer();
        String departMsg = this.checkDepartment(ctx, (FaCurCardInfo)faCardInfo);
        if (departMsg != null && departMsg.length() > 0) {
            errorMsg.append(departMsg);
        }
        FaCardWebValidatorImpl validator = new FaCardWebValidatorImpl(ctx, faCardInfo, false);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("verifySubmit", isSubmit);
        params.put("Company", faCardInfo.getCompany());
        params.put("fromBillUI", "FaChangeBillEditUI");
        validator.setParam(params);
        FaCurCardInfo verifyBill = (FaCurCardInfo)faCardInfo;
        if (faCardInfo instanceof FaMonCardInfo) {
            verifyBill = FaManageUtils.MonCard2CurCard((FaMonCardInfo)faCardInfo);
            verifyBill.setId(faCardInfo.getId());
        }
        validator.setBillInfo(verifyBill);
        if (!validator.validate()) {
            errorMsg.append(validator.getInvalidMsg());
        }
        return errorMsg;
    }

    private String checkDepartment(Context ctx, FaCurCardInfo cardInfo) {
        int count = cardInfo.getFaCurDepartment().size();
        String chongfu = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"chongfu", (Locale)ctx.getLocale());
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String msg;
            FaCurDepartmentInfo curDepartmentInfo = cardInfo.getFaCurDepartment().get(i);
            AdminOrgUnitInfo dept = curDepartmentInfo.getUseDepartment();
            PersonInfo user = curDepartmentInfo.getUsePerson();
            if (dept == null) {
                PersonInfo person = user;
                if (person == null || !map.containsKey(person.getId().toString())) continue;
                msg = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"exitUser", (Locale)ctx.getLocale());
                return msg + "\"" + person.getName() + "\"" + chongfu;
            }
            AdminOrgUnitInfo deptInfo = dept;
            if (list.contains(deptInfo.getId().toString())) {
                msg = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"exitDepartmennt", (Locale)ctx.getLocale());
                return msg + "\"" + dept.getName() + "\"" + chongfu;
            }
            if (user == null) {
                if (list.contains(deptInfo.getId().toString())) {
                    msg = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"exitDepartmennt", (Locale)ctx.getLocale());
                    msg = msg + "\"" + dept.getName() + "\"" + chongfu;
                    return msg;
                }
                list.add(deptInfo.getId().toString());
                if (!map.containsValue(deptInfo.getId().toString())) continue;
                msg = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"exitDepartmennt", (Locale)ctx.getLocale());
                return msg + "\"" + dept.getName() + "\"" + chongfu;
            }
            PersonInfo person = user;
            if (map.containsKey(person.getId().toString())) {
                String msg2 = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"exitUser", (Locale)ctx.getLocale());
                return msg2 + "\"" + person.getName() + "\"" + chongfu;
            }
            map.put(person.getId().toString(), deptInfo.getId().toString());
        }
        return null;
    }

    protected StringBuffer verifyInput(IObjectValue dataObject, boolean isSubmit) throws Exception {
        FaChangeBillInfo changeBillInfo;
        FaCurCardInfo oriCardInfo;
        String curCardID;
        FaCurCardInfo faCurCardInfo = (FaCurCardInfo)dataObject;
        HashMap hResult = this.gethmParam(faCurCardInfo.getCompany().getId());
        BigDecimal ZERO = new BigDecimal("0.00");
        StringBuffer errorMsg = new StringBuffer();
        Object isUseGroupNumber = hResult.get("FA_030");
        if (Boolean.valueOf(isUseGroupNumber.toString()).booleanValue()) {
            FilterInfo f = new FilterInfo();
            f.getFilterItems().add(new FilterItemInfo("company.id", (Object)faCurCardInfo.getCompany().getId().toString()));
            if (faCurCardInfo.getId() != null && new FaCurCardInfo().getBOSType().equals((Object)faCurCardInfo.getId().getType())) {
                f.getFilterItems().add(new FilterItemInfo("id", (Object)dataObject.get("id").toString(), CompareType.NOTEQUALS));
            } else if (faCurCardInfo.get("changeBill") != null) {
                FaChangeBillInfo bill = (FaChangeBillInfo)faCurCardInfo.get("changeBill");
                curCardID = bill.getChangeBillEntry().get(0).getCurCard().getId().toString();
                f.getFilterItems().add(new FilterItemInfo("id", (Object)curCardID, CompareType.NOTEQUALS));
            }
            f.getFilterItems().add(new FilterItemInfo("groupNumber", (Object)faCurCardInfo.getGroupNumber()));
            boolean flag = FaCurCardFactory.getRemoteInstance().exists(f);
            if (flag) {
                errorMsg.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"44_FaChangeBillEditUI"), faCurCardInfo.getGroupNumber()) + ";");
            }
        }
        if (hResult.get("FA_043") != null && "true".equals(hResult.get("FA_043").toString())) {
            FilterInfo f1 = new FilterInfo();
            f1.getFilterItems().add(new FilterItemInfo("company.id", (Object)faCurCardInfo.getCompany().getId().toString()));
            if (faCurCardInfo.getId() != null && new FaCurCardInfo().getBOSType().equals((Object)faCurCardInfo.getId().getType())) {
                f1.getFilterItems().add(new FilterItemInfo("id", (Object)faCurCardInfo.getId().toString(), CompareType.NOTEQUALS));
            } else if (faCurCardInfo.get("changeBill") != null) {
                FaChangeBillInfo bill = (FaChangeBillInfo)faCurCardInfo.get("changeBill");
                curCardID = bill.getChangeBillEntry().get(0).getCurCard().getId().toString();
                f1.getFilterItems().add(new FilterItemInfo("id", (Object)curCardID, CompareType.NOTEQUALS));
            }
            f1.getFilterItems().add(new FilterItemInfo("barCode", (Object)faCurCardInfo.getBarCode()));
            boolean flag1 = FaCurCardFactory.getRemoteInstance().exists(f1);
            if (flag1) {
                errorMsg.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"47_FaChangeBillEditUI"), faCurCardInfo.getBarCode()) + ";");
            }
        }
        FaCurCardInfo faCurCardInfo2 = oriCardInfo = (changeBillInfo = (FaChangeBillInfo)faCurCardInfo.get("changeBill")) == null ? (FaCurCardInfo)faCurCardInfo.get("CHANGE_INFO_FOR_VERFY") : changeBillInfo.getChangeBillEntry().get(0).getCurCard();
        if (isSubmit) {
            boolean deprCountShoudLessThanUseCount;
            BigDecimal accuDepr = faCurCardInfo.getAccuDepr();
            BigDecimal assetValue = faCurCardInfo.getAssetValue();
            BigDecimal decValue = faCurCardInfo.getDecValue();
            if (assetValue.compareTo(oriCardInfo.getAssetValue()) != 0 && !this.isAccountEqual(faCurCardInfo.getAccountAsset(), oriCardInfo.getAccountAsset())) {
                errorMsg.append(EASResource.getString((String)this.RESOURCE_PATH, (String)"CantSynModifyAssetAcct") + ";");
            }
            if (accuDepr.compareTo(oriCardInfo.getAccuDepr()) != 0 && !this.isAccountEqual(faCurCardInfo.getAccountAccuDepr(), oriCardInfo.getAccountAccuDepr())) {
                errorMsg.append(EASResource.getString((String)this.RESOURCE_PATH, (String)"CantSynModifyAccuAcct") + ";");
            }
            if (decValue.compareTo(oriCardInfo.getDecValue()) != 0 && !this.isAccountEqual(faCurCardInfo.getAccountDecValue(), oriCardInfo.getAccountDecValue())) {
                errorMsg.append(EASResource.getString((String)this.RESOURCE_PATH, (String)"CantSynModifyDecAcct") + ";");
            }
            BigDecimal addUPDep = faCurCardInfo.getAccuDepr();
            BigDecimal useTermCount = faCurCardInfo.getUseTermCount();
            BigDecimal deprCount = faCurCardInfo.getDeprTermCount();
            if (addUPDep.compareTo(ZERO) == 0 && deprCount.compareTo(ZERO) != 0) {
                errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"39_FaChangeBillEditUI") + ";");
            }
            if (addUPDep.compareTo(ZERO) != 0 && deprCount.compareTo(ZERO) == 0) {
                errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"40_FaChangeBillEditUI") + ";");
            }
            boolean isStraightMethod = FaChangeBillWebFacadeControllerBean.isStraightAccountMethod(faCurCardInfo.getDeprMethod());
            boolean isAverageYearMethod = FaChangeBillWebFacadeControllerBean.isAveUsingOriginAgeMethod(faCurCardInfo.getDeprMethod());
            boolean FA_051On = false;
            if (hResult.get("FA_051") != null) {
                FA_051On = "true".equals(hResult.get("FA_051").toString());
            }
            boolean bl = deprCountShoudLessThanUseCount = !isStraightMethod && (!isAverageYearMethod || !FA_051On);
            if (deprCount.compareTo(useTermCount) == 1 && deprCountShoudLessThanUseCount) {
                errorMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"48_FaChangeBillEditUI") + ";");
            }
        }
        return errorMsg;
    }

    protected StringBuffer promptInput(IObjectValue dataObject, boolean isSubmit) throws Exception {
        FaCurCardInfo oriCardInfo;
        FaCurCardInfo faCurCardInfo = (FaCurCardInfo)dataObject;
        StringBuffer promptMsg = new StringBuffer();
        FaChangeBillInfo changeBillInfo = (FaChangeBillInfo)faCurCardInfo.get("changeBill");
        FaCurCardInfo faCurCardInfo2 = oriCardInfo = changeBillInfo == null ? (FaCurCardInfo)faCurCardInfo.get("CHANGE_INFO_FOR_VERFY") : changeBillInfo.getChangeBillEntry().get(0).getCurCard();
        if (isSubmit) {
            FaCurCardInfo curCard;
            FaCurCardInfo __curCard;
            BigDecimal accuDepr = faCurCardInfo.getAccuDepr();
            BigDecimal accuDeprTYear = faCurCardInfo.getAccuDeprTYear();
            if (accuDepr.compareTo(oriCardInfo.getAccuDepr()) == 0 && accuDeprTYear.compareTo(oriCardInfo.getAccuDeprTYear()) != 0) {
                promptMsg.append(EASResource.getString((String)this.RESOURCE_PATH, (String)"SynAccuDeprFirst") + ";");
            }
            if (accuDepr.compareTo(oriCardInfo.getAccuDepr()) != 0 && accuDeprTYear.compareTo(oriCardInfo.getAccuDeprTYear()) == 0) {
                promptMsg.append(EASResource.getString((String)this.RESOURCE_PATH, (String)"SynAccuDeprTYearFirst") + ";");
            }
            FaCurCardInfo changedCard = faCurCardInfo;
            FaCurCardInfo faCurCardInfo3 = __curCard = changeBillInfo == null ? (FaCurCardInfo)faCurCardInfo.get("CHANGE_INFO_FOR_VERFY") : changeBillInfo.getChangeBillEntry().get(0).getCurCard();
            if (FaChangeBillWebFacadeControllerBean.isAveUsingOriginAgeMethod(changedCard.getDeprMethod()) && FaChangeBillWebFacadeControllerBean.isAveUsingOriginAgeMethod(__curCard.getDeprMethod()) && this.isDeprElemChg(curCard = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo("select id,deprMethod.id,deprMethod.number,assetValue,accuDepr,decValue,neatRemValue,useTermCount,useStatus.id,faCurCostCenter.*,faCurCostCenter.faCurAsstActComposit.* where id='" + __curCard.getId() + "'"), changedCard)) {
                promptMsg.append(EASResource.getString((String)this.RESOURCE_PATH, (String)"FaChangeBillEditUI_ChgDeprMethod") + ";");
            }
            if (FaChangeBillWebFacadeControllerBean.isDoubleSubtractStaMethod(changedCard.getDeprMethod()) && this.isDeprElemChg(curCard = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo("select id,deprMethod.id,deprMethod.number,assetValue,accuDepr,decValue,neatRemValue,useTermCount,useStatus.id,faCurCostCenter.*,faCurCostCenter.faCurAsstActComposit.* where id='" + __curCard.getId() + "'"), changedCard)) {
                promptMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"49_FaChangeBillEditUI") + ";");
            }
            if (FaChangeBillWebFacadeControllerBean.isTotalYearStaitcMethod(changedCard.getDeprMethod()) && this.isDeprElemChg(curCard = FaCurCardFactory.getRemoteInstance().getFaCurCardInfo("select id,deprMethod.id,deprMethod.number,assetValue,accuDepr,decValue,neatRemValue,useTermCount,useStatus.id,faCurCostCenter.*,faCurCostCenter.faCurAsstActComposit.* where id='" + __curCard.getId() + "'"), changedCard)) {
                promptMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"49_FaChangeBillEditUI") + ";");
            }
        }
        return promptMsg;
    }

    public static boolean isTotalYearStaitcMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals("103");
    }

    public static boolean isDoubleSubtractStaMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals("101");
    }

    public static boolean isStraightAccountMethod(FaDepreciationModeInfo method) {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals("007");
    }

    public static boolean isAveUsingOriginAgeMethod(FaDepreciationModeInfo method) throws BOSException {
        if (method == null || method.getId() == null || method.getNumber() == null) {
            return false;
        }
        return method.getNumber().trim().equals("010");
    }

    private boolean isDeprElemChg(FaCurCardInfo bakCardInfo, FaCurCardInfo bizCardInfo) {
        if (bakCardInfo.getAssetValue().compareTo(bizCardInfo.getAssetValue()) != 0) {
            return true;
        }
        if (bakCardInfo.getAccuDepr().compareTo(bizCardInfo.getAccuDepr()) != 0) {
            return true;
        }
        if (bakCardInfo.getDecValue().compareTo(bizCardInfo.getDecValue()) != 0) {
            return true;
        }
        if (bakCardInfo.getNeatRemValue().compareTo(bizCardInfo.getNeatRemValue()) != 0) {
            return true;
        }
        if (bakCardInfo.getUseTermCount().compareTo(bizCardInfo.getUseTermCount()) != 0) {
            return true;
        }
        if (!(bakCardInfo.getDeprMethod() != null ? bakCardInfo.getDeprMethod().getId().toString() : "").equals(bizCardInfo.getDeprMethod() != null ? bizCardInfo.getDeprMethod().getId().toString() : "")) {
            return true;
        }
        if (!bakCardInfo.getUseStatus().getId().toString().equals(bizCardInfo.getUseStatus().getId().toString())) {
            return true;
        }
        FaCurCostCenterCollection bakCostCenter = bakCardInfo.getFaCurCostCenter();
        FaCurCostCenterCollection bizCostCenter = bizCardInfo.getFaCurCostCenter();
        if (bakCostCenter.size() != bizCostCenter.size()) {
            return true;
        }
        for (int i = 0; i < bakCostCenter.size(); ++i) {
            FaCurCostCenterInfo bizCostInfo;
            FaCurCostCenterInfo bakCostInfo = bakCostCenter.get(i);
            if (!this.isAsstActChange(bakCostInfo, bizCostInfo = bizCostCenter.get(i))) continue;
            return true;
        }
        return false;
    }

    protected HashMap gethmParam(BOSUuid id) {
        HashMap hmParam = new HashMap();
        try {
            hmParam = FaManageUtils.getFAParameter(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hmParam;
    }

    private boolean isAccountEqual(AccountViewInfo src, AccountViewInfo target) {
        if (src == null && target != null || src != null && target == null) {
            return false;
        }
        if (src == null && target == null) {
            return true;
        }
        return src.getNumber().equals(target.getNumber());
    }

    private String checkDepend(FaCurCardInfo cardInfo) throws BOSException, EASBizException {
        return null;
    }

    public boolean isAsstActChange(FaCurCostCenterInfo bakCostInfo, FaCurCostCenterInfo bizCostInfo) {
        if (bakCostInfo == null || bizCostInfo == null) {
            return false;
        }
        FaCurAsstActCompositCollection bakAsstActCollection = bakCostInfo.getFaCurAsstActComposit();
        FaCurAsstActCompositCollection bizAsstActCollection = bizCostInfo.getFaCurAsstActComposit();
        if (bakAsstActCollection == null || bakAsstActCollection.size() < 1 || bizAsstActCollection == null || bizAsstActCollection.size() < 1) {
            return false;
        }
        if (bakAsstActCollection.size() != bizAsstActCollection.size()) {
            return true;
        }
        if (bakAsstActCollection != null && bakAsstActCollection.size() > 0) {
            for (int j = 0; j < bakAsstActCollection.size(); ++j) {
                if (!bakAsstActCollection.get(j).getAsstActType().getId().toString().equals(bizAsstActCollection.get(j).getAsstActType().getId().toString())) {
                    return true;
                }
                if (bakAsstActCollection.get(j).getAsstActItem().getId().toString().equals(bizAsstActCollection.get(j).getAsstActItem().getId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected ArrayList _emuCalDep(Context ctx, int startYear, int startNumber, IObjectValue curCardInfo, CompanyOrgUnitInfo companyOrgUnitInfo) throws BOSException, EASBizException {
        FaDepCalWebExecutor executor = new FaDepCalWebExecutor();
        return executor._emuCalDep(ctx, startYear, startNumber, curCardInfo, companyOrgUnitInfo);
    }

    @Override
    protected Map _addNewCardToEditUiGrid(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap mapResult = new HashMap();
        ArrayList<Map<String, Object>> loadData = new ArrayList<Map<String, Object>>();
        FaDispatchBillEntryCollection currentGridBillCollection = new FaDispatchBillEntryCollection();
        String newSelectedIdSetString = paramMap.get("newSelectedIdSetString").toString();
        String curcardIDsInCurrentDispatchBillEdit = paramMap.get("curcardIDsInCurrentDispatchBillEdit").toString();
        String companyId = paramMap.get("companyId").toString();
        if (companyId != null) {
            companyId = companyId.split(",")[0];
        }
        String[] cardIdAfterMerge = new String[]{};
        cardIdAfterMerge = this.getStringIntersection(newSelectedIdSetString, curcardIDsInCurrentDispatchBillEdit);
        HashMap hmParam = this.gethmParam(BOSUuid.read((String)companyId));
        HashSet<String> cardset = new HashSet<String>(Arrays.asList(cardIdAfterMerge));
        FaCurCardCollection cards = this.getCurCards(cardset);
        for (int i = 0; i < cards.size(); ++i) {
            FaCurCardInfo cardInfo = cards.get(i);
            Map<String, Object> row = this.convtDisEntryBillToRow(hmParam, cardInfo);
            loadData.add(row);
        }
        mapResult.put("loadData", loadData);
        return mapResult;
    }

    private String[] getStringIntersection(String newSelectedIdSetString, String curcardIDsInCurrentDispatchBillEdit) {
        String[] cardIdAfterMerge;
        if (!curcardIDsInCurrentDispatchBillEdit.equals("")) {
            String notRepeatIdStrInNewSelectedCard = "";
            String[] newSelectedIdSetStringArray = newSelectedIdSetString.split(",");
            String[] curcardIDsInCurrentDispatchBillEditArray = curcardIDsInCurrentDispatchBillEdit.split(",");
            for (String newSelectedId : newSelectedIdSetStringArray) {
                boolean isSame = false;
                for (String curcardIDInCurrentDispatchBill : curcardIDsInCurrentDispatchBillEditArray) {
                    if (!newSelectedId.equals(curcardIDInCurrentDispatchBill)) continue;
                    isSame = true;
                }
                if (isSame) continue;
                notRepeatIdStrInNewSelectedCard = notRepeatIdStrInNewSelectedCard + newSelectedId + ",";
            }
            cardIdAfterMerge = (notRepeatIdStrInNewSelectedCard + curcardIDsInCurrentDispatchBillEdit).split(",");
        } else {
            cardIdAfterMerge = newSelectedIdSetString.split(",");
        }
        return cardIdAfterMerge;
    }

    private FaCurCardCollection getCurCards(HashSet cardset) throws BOSException {
        if (cardset == null || cardset.size() == 0) {
            return new FaCurCardCollection();
        }
        FaCurCardCollection cards = new FaCurCardCollection();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("assetCat.DepreciationPolicy.*"));
        selectors.add(new SelectorItemInfo("assetCat.name"));
        selectors.add(new SelectorItemInfo("assetCat.isLeaf"));
        selectors.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        selectors.add(new SelectorItemInfo("assetCat.isDeductInputTax"));
        selectors.add(new SelectorItemInfo("measureUnit.name"));
        selectors.add(new SelectorItemInfo("originMethod.name"));
        selectors.add(new SelectorItemInfo("originMethod.number"));
        selectors.add(new SelectorItemInfo("originMethod.isLeaf"));
        selectors.add(new SelectorItemInfo("deprMethod.number"));
        selectors.add(new SelectorItemInfo("deprMethod.name"));
        selectors.add(new SelectorItemInfo("deprMethod.isCustom"));
        selectors.add(new SelectorItemInfo("deprMethod.isWorkload"));
        selectors.add(new SelectorItemInfo("evalDeprMode.number"));
        selectors.add(new SelectorItemInfo("evalDeprMode.name"));
        selectors.add(new SelectorItemInfo("evalDeprMode.isCustom"));
        selectors.add(new SelectorItemInfo("evalDeprMode.isWorkload"));
        selectors.add(new SelectorItemInfo("useStatus.name"));
        selectors.add(new SelectorItemInfo("useStatus.isLeaf"));
        selectors.add(new SelectorItemInfo("economicPurp.name"));
        selectors.add(new SelectorItemInfo("storeCity.name"));
        selectors.add(new SelectorItemInfo("dept.name"));
        selectors.add(new SelectorItemInfo("keeper.name"));
        selectors.add(new SelectorItemInfo("currency.*"));
        selectors.add(new SelectorItemInfo("faCurFacility.*"));
        selectors.add(new SelectorItemInfo("faCurCostCenter.*"));
        selectors.add(new SelectorItemInfo("faCurCostCenter.accountView.isLeaf"));
        selectors.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.*"));
        selectors.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        selectors.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        selectors.add(new SelectorItemInfo("faCurDepartment.*"));
        selectors.add(new SelectorItemInfo("accountAsset.isLeaf"));
        selectors.add(new SelectorItemInfo("accountAccuDepr.isLeaf"));
        selectors.add(new SelectorItemInfo("accountDecValue.isLeaf"));
        selectors.add(new SelectorItemInfo("propertyValue.*"));
        EntityViewInfo v = new EntityViewInfo();
        v.getSelector().addObjectCollection((IObjectCollection)selectors);
        FilterInfo f = new FilterInfo();
        v.setFilter(f);
        f.getFilterItems().add(new FilterItemInfo("id", (Object)cardset, CompareType.INCLUDE));
        v.getSorter().add(new SorterItemInfo("number"));
        cards = FaCurCardFactory.getRemoteInstance().getFaCurCardCollection(v);
        return cards;
    }

    private Map<String, Object> convtDisEntryBillToRow(HashMap hmParam, FaCurCardInfo cardInfo) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("cardId", cardInfo.getId().toString());
        row.put("assetCat", cardInfo.getAssetCat() == null ? "" : cardInfo.getAssetCat().getName());
        row.put("number", cardInfo.getNumber() == null ? "" : cardInfo.getNumber());
        row.put("specs", cardInfo.getSpecs() == null ? "" : cardInfo.getSpecs());
        row.put("assetName", cardInfo.getAssetName() == null ? "" : cardInfo.getAssetName());
        row.put("measureUnit", cardInfo.getMeasureUnit() == null ? "" : cardInfo.getMeasureUnit().getName());
        row.put("alterMode", cardInfo.getOriginMethod() == null ? "" : cardInfo.getOriginMethod().getName());
        row.put("useStatus", cardInfo.getUseStatus() == null ? "" : cardInfo.getUseStatus().getName());
        row.put("useStatus", cardInfo.getUseStatus() == null ? "" : cardInfo.getUseStatus().getName());
        if (cardInfo.getEconomicPurp() != null) {
            row.put("economicPurp", cardInfo.getEconomicPurp() == null ? "" : cardInfo.getEconomicPurp().getName());
        }
        row.put("address", cardInfo.getStoreCity() == null ? "" : cardInfo.getStoreCity().getName());
        row.put("adminOrg", cardInfo.getDept() == null ? "" : cardInfo.getDept().getName());
        String isUseBarcode = (String)hmParam.get("FA_043");
        if (isUseBarcode != null && !"".equals(isUseBarcode) && new Boolean(isUseBarcode).booleanValue()) {
            row.put("barCode", cardInfo.getBarCode() == null ? "" : cardInfo.getBarCode());
        }
        if (cardInfo.getKeeper() != null) {
            row.put("keeper", cardInfo.getKeeper() == null ? "" : cardInfo.getKeeper().getName());
        }
        return row;
    }

    @Override
    protected Map _batchSubmit(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        IObjectValue infoObj = (IObjectValue)paramMap.get("infoObj");
        String billId = (String)paramMap.get("billId");
        String[] billIds = billId.split(",");
        try {
            String info;
            if (billIds.length <= 0) {
                throw new EASBizException(FaWebException.NO_CHANGE_CARD);
            }
            HashSet<String> cardset = new HashSet<String>(Arrays.asList(billIds));
            EntityViewInfo v = new EntityViewInfo();
            v.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
            FilterInfo f = new FilterInfo();
            v.setFilter(f);
            f.getFilterItems().add(new FilterItemInfo("id", cardset, CompareType.INCLUDE));
            v.getSorter().add(new SorterItemInfo("number"));
            FaCurCardCollection cards = FaCurCardFactory.getRemoteInstance().getFaCurCardCollection(v);
            if (infoObj.get("changeMode") instanceof String) {
                Object faAlterModeInfo = null;
                infoObj.put("changeMode", faAlterModeInfo);
            } else if (infoObj.get("changeMode") instanceof Map) {
                String changeModeJson = JSONUtils.convertObjectToJson((Context)ctx, (Object)infoObj.get("changeMode"));
                FaAlterModeInfo faAlterModeInfo = (FaAlterModeInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)changeModeJson, FaAlterModeInfo.class);
                infoObj.put("changeMode", (Object)faAlterModeInfo);
            }
            String changeDateStr = (String)infoObj.get("changeDate");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd ");
            try {
                Date changeDate = sdf.parse(changeDateStr);
                infoObj.put("changeDate", (Object)changeDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            ArrayList changeCardList = new ArrayList();
            String info1 = this.verifyNotAbort(infoObj, cards, changeCardList);
            FaCurCardInfo[] cardInfos = new FaCurCardInfo[changeCardList.size()];
            for (int i = 0; i < cardInfos.length; ++i) {
                cardInfos[i] = (FaCurCardInfo)((FaCurCardInfo)changeCardList.get(i)).clone();
            }
            this.storeFields(cardInfos, infoObj, ctx);
            Map result = FaChangeBillFactory.getRemoteInstance().buildChangeBills(cardInfos);
            String info2 = (String)result.get("info");
            List changebillList = (List)result.get("changebills");
            String string = info1 != null && info2 != null ? info1 + "\uff1b" + info2 : (info = info1 == null ? info2 : info1);
            if (info != null) {
                resultMap.put("showConfirm", info + "\u3002" + EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaChangeResource", (String)"isContinue"));
                resultMap.put("changebills", changebillList);
            } else {
                FaChangeBillInfo[] changebills = new FaChangeBillInfo[changebillList.size()];
                changebillList.toArray(changebills);
                FaChangeBillFactory.getRemoteInstance().batchSubmit(changebills);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            resultMap.put("summaryMsg", e.getMessage());
            resultMap.put("detailMsg", e.toString());
        }
        return resultMap;
    }

    private void storeFields(FaCurCardInfo[] cardInfos, IObjectValue infoObj, Context ctx) throws EASBizException {
        FaCurCardInfo faCardInfo = (FaCurCardInfo)infoObj;
        Object changeMode = faCardInfo.get("changeMode");
        Object changeDate = faCardInfo.get("changeDate");
        String description = (String)faCardInfo.get("description");
        FaCatInfo asstCat = faCardInfo.getAssetCat();
        String assetName = faCardInfo.getAssetName();
        MeasureUnitInfo measureUnit = faCardInfo.getMeasureUnit();
        BigDecimal assetAmount = faCardInfo.getAssetAmt();
        FaAlterModeInfo alterMode = faCardInfo.getOriginMethod();
        FaUseStatusInfo useStatus = faCardInfo.getUseStatus();
        FaEconomicPurpInfo ecomomicPurp = faCardInfo.getEconomicPurp();
        String specs = faCardInfo.getSpecs();
        AddressInfo storeCity = faCardInfo.getStoreCity();
        String area = faCardInfo.getPArea();
        String manufacturer = faCardInfo.getMfr();
        Date leaveFactoryDate = faCardInfo.getLevFrDate();
        String paperNo = faCardInfo.getPaperNo();
        AdminOrgUnitInfo manageDepartment = faCardInfo.getDept();
        PersonInfo keeper = faCardInfo.getKeeper();
        FaFromUnitCatEnum fromUnitCat = faCardInfo.getOriginType();
        String fromUnit = faCardInfo.getOriginUnit();
        String remark = faCardInfo.getRemark();
        CurrencyInfo currency = faCardInfo.getCurrency();
        BigDecimal originalAmount = faCardInfo.getOriginAmt();
        BigDecimal additiveAmount = faCardInfo.getAddons();
        BigDecimal exchangeRate = faCardInfo.getExRate();
        BigDecimal buyOriginalValue = faCardInfo.getBuyValue();
        Date deliverDate = faCardInfo.getDeliverDate();
        BigDecimal expUseYears = faCardInfo.getUseYears();
        BigDecimal buyAddUpDep = faCardInfo.getBuyAccuDepr();
        BigDecimal addUPDep = faCardInfo.getAccuDepr();
        BigDecimal expNeatLeftValue = faCardInfo.getNeatRemValue();
        BigDecimal expUsePeriod = faCardInfo.getUseTermCount();
        BigDecimal addUPDepThisYear = faCardInfo.getAccuDeprTYear();
        BigDecimal treatmentIncome = faCardInfo.getTreatmentIncome();
        BigDecimal fairValue = faCardInfo.getFairValue();
        BigDecimal accuDeprAll = faCardInfo.getAccuDeprAll();
        BigDecimal neatLeftRate = faCardInfo.getNeatLeftRate();
        FaDepreciationModeInfo depreciationMode = faCardInfo.getDeprMethod();
        MeasureUnitInfo loadMeasureUnit = faCardInfo.getMeasureUnitWL();
        AccountViewInfo accountFixedAssets = faCardInfo.getAccountAsset();
        AccountViewInfo accountDepreciation = faCardInfo.getAccountAccuDepr();
        AccountViewInfo accountDecPrepare = faCardInfo.getAccountDecValue();
        int facilityRowCount = faCardInfo.getFaCurFacility().size();
        int departRowCount = faCardInfo.getFaCurDepartment().size();
        int costRowCount = faCardInfo.getFaCurCostCenter().size();
        for (int i = 0; i < cardInfos.length; ++i) {
            FaCurCardInfo oldCardInfo = (FaCurCardInfo)cardInfos[i].clone();
            cardInfos[i].put("oldCard", oldCardInfo);
            cardInfos[i].put("changeMode", changeMode);
            cardInfos[i].put("changeDate", changeDate);
            cardInfos[i].put("description", description);
            if (asstCat != null) {
                cardInfos[i].setAssetCat(asstCat);
            }
            if (assetName != null && assetName.trim().length() > 0) {
                cardInfos[i].setAssetName(assetName);
            }
            if (measureUnit != null) {
                cardInfos[i].setMeasureUnit(measureUnit);
            }
            if (assetAmount != null) {
                cardInfos[i].setAssetAmt(assetAmount);
            }
            if (alterMode != null) {
                cardInfos[i].setOriginMethod(alterMode);
            }
            if (useStatus != null) {
                cardInfos[i].setUseStatus(useStatus);
            }
            if (ecomomicPurp != null) {
                cardInfos[i].setEconomicPurp(ecomomicPurp);
            }
            if (specs != null && specs.trim().length() > 0) {
                cardInfos[i].setSpecs(specs);
            }
            if (storeCity != null) {
                cardInfos[i].setStoreCity(storeCity);
            }
            if (area != null && area.trim().length() > 0) {
                cardInfos[i].setPArea(area);
            }
            if (manufacturer != null && manufacturer.trim().length() > 0) {
                cardInfos[i].setMfr(manufacturer);
            }
            if (leaveFactoryDate != null) {
                cardInfos[i].setLevFrDate(leaveFactoryDate);
            }
            if (paperNo != null && paperNo.trim().length() > 0) {
                cardInfos[i].setPaperNo(paperNo);
            }
            if (manageDepartment != null) {
                cardInfos[i].setDept(manageDepartment);
            }
            if (keeper != null) {
                cardInfos[i].setKeeper(keeper);
            }
            if (fromUnitCat != null && FaFromUnitCatEnum.NULL != fromUnitCat) {
                cardInfos[i].setOriginType(fromUnitCat);
            }
            if (fromUnit != null) {
                cardInfos[i].setOriginUnit(((ObjectBaseInfo)fromUnit).getBOSUuid("id").toString());
            }
            if (remark != null && remark.trim().length() > 0) {
                cardInfos[i].setRemark(remark);
            }
            if (currency != null) {
                cardInfos[i].setCurrency(currency);
            }
            if (originalAmount != null) {
                cardInfos[i].setOriginAmt(originalAmount);
            }
            if (additiveAmount != null) {
                cardInfos[i].setAddons(additiveAmount);
            }
            if (exchangeRate != null) {
                cardInfos[i].setExRate(exchangeRate);
            }
            if (buyOriginalValue != null) {
                cardInfos[i].setBuyValue(buyOriginalValue);
            }
            if (deliverDate != null) {
                cardInfos[i].setDeliverDate(deliverDate);
            }
            if (expUseYears != null) {
                cardInfos[i].setUseYears(expUseYears);
            }
            if (buyAddUpDep != null) {
                cardInfos[i].setBuyAccuDepr(buyAddUpDep);
            }
            if (addUPDep != null) {
                cardInfos[i].setAccuDepr(addUPDep);
            }
            if (expUsePeriod != null) {
                cardInfos[i].setUseTermCount(expUsePeriod);
            }
            if (addUPDepThisYear != null) {
                cardInfos[i].setAccuDeprTYear(addUPDepThisYear);
            }
            if (treatmentIncome != null) {
                cardInfos[i].setTreatmentIncome(treatmentIncome);
            }
            if (fairValue != null) {
                cardInfos[i].setFairValue(fairValue);
            }
            if (accuDeprAll != null) {
                cardInfos[i].setAccuDeprAll(accuDeprAll);
            }
            if (depreciationMode != null) {
                cardInfos[i].setDeprMethod(depreciationMode);
            }
            if (loadMeasureUnit != null) {
                cardInfos[i].setMeasureUnitWL(loadMeasureUnit);
            }
            if (accountFixedAssets != null) {
                cardInfos[i].setAccountAsset(accountFixedAssets);
            }
            if (accountDepreciation != null) {
                cardInfos[i].setAccountAccuDepr(accountDepreciation);
            }
            if (accountDecPrepare != null) {
                cardInfos[i].setAccountDecValue(accountDecPrepare);
            }
            if (originalAmount != null || exchangeRate != null || additiveAmount != null) {
                this.calLocalAmount(cardInfos[i]);
            }
            if (expNeatLeftValue == null && neatLeftRate != null) {
                cardInfos[i].setNeatRemValue(neatLeftRate.multiply(cardInfos[i].getAssetValue()).divide(new BigDecimal(100), 10, 4));
            }
            if (neatLeftRate != null) {
                cardInfos[i].setNeatLeftRate(neatLeftRate);
            }
            if (expNeatLeftValue != null) {
                cardInfos[i].setNeatRemValue(expNeatLeftValue);
            }
            if (originalAmount != null || addUPDep != null) {
                this.calNeat(cardInfos[i]);
            }
            FaCurFacilityCollection facilityColl = cardInfos[i].getFaCurFacility();
            if (facilityRowCount > 0) {
                facilityColl.clear();
            }
            FaCurFacilityCollection faCurFacilityCollection = faCardInfo.getFaCurFacility();
            for (int j = 0; j < faCurFacilityCollection.size(); ++j) {
                FaCurFacilityInfo faCurFacilityInfo = faCurFacilityCollection.get(j);
                FaCurFacilityInfo aFaCurFacilityInfo = new FaCurFacilityInfo();
                BOSUuid id = BOSUuid.create((BOSObjectType)aFaCurFacilityInfo.getBOSType());
                aFaCurFacilityInfo.setId(id);
                aFaCurFacilityInfo.setSeq(j + 1);
                aFaCurFacilityInfo.setFacilityNumber(faCurFacilityInfo.getFacilityNumber());
                aFaCurFacilityInfo.setFacilityName(faCurFacilityInfo.getFacilityName());
                aFaCurFacilityInfo.setFacilityModel(faCurFacilityInfo.getFacilityModel());
                aFaCurFacilityInfo.setRegisterDate(faCurFacilityInfo.getRegisterDate());
                aFaCurFacilityInfo.setStorePlace(faCurFacilityInfo.getStorePlace());
                aFaCurFacilityInfo.setMeasureUnit(faCurFacilityInfo.getMeasureUnit());
                BigDecimal quantity = faCurFacilityInfo.getQuantity() == null ? ZERO : faCurFacilityInfo.getQuantity();
                aFaCurFacilityInfo.setQuantity(this.formatBigDecmal(quantity, 2));
                BigDecimal amount = faCurFacilityInfo.getAmount() == null ? ZERO : faCurFacilityInfo.getAmount();
                aFaCurFacilityInfo.setAmount(this.formatBigDecmal(amount, this.amountScale));
                aFaCurFacilityInfo.setKeeper(faCurFacilityInfo.getKeeper());
                aFaCurFacilityInfo.setRemark(faCurFacilityInfo.getRemark());
                facilityColl.add(aFaCurFacilityInfo);
            }
            FaCurDepartmentCollection departmentColl = cardInfos[i].getFaCurDepartment();
            if (departRowCount > 0) {
                departmentColl.clear();
            }
            FaCurDepartmentCollection faCurDepartmentCollection = faCardInfo.getFaCurDepartment();
            for (int j = 0; j < faCurDepartmentCollection.size(); ++j) {
                FaCurDepartmentInfo faCurDepartmentInfo = faCurDepartmentCollection.get(j);
                FaCurDepartmentInfo aFaCurDepartmentInfo = new FaCurDepartmentInfo();
                BOSUuid id = BOSUuid.create((BOSObjectType)aFaCurDepartmentInfo.getBOSType());
                aFaCurDepartmentInfo.setId(id);
                aFaCurDepartmentInfo.setSeq(j + 1);
                aFaCurDepartmentInfo.setUseDepartment(faCurDepartmentInfo.getUseDepartment());
                aFaCurDepartmentInfo.setUsePerson(faCurDepartmentInfo.getUsePerson());
                aFaCurDepartmentInfo.setUsage(faCurDepartmentInfo.getUsage());
                aFaCurDepartmentInfo.setRemark(faCurDepartmentInfo.getRemark());
                departmentColl.add(aFaCurDepartmentInfo);
            }
            this.storeMultiAsstActFields(cardInfos[i], faCardInfo);
            this.verifyData(cardInfos[i], i, ctx);
        }
    }

    private void storeMultiAsstActFields(FaCurCardInfo cardInfo, FaCurCardInfo faCardInfo) {
        FaCurCostCenterCollection faCurCostCenterCollection = faCardInfo.getFaCurCostCenter();
        int rowCount = faCurCostCenterCollection.size();
        if (rowCount < 1) {
            return;
        }
        FaCurCostCenterCollection costCenterColl = cardInfo.getFaCurCostCenter();
        costCenterColl.clear();
        for (int i = 0; i < rowCount; ++i) {
            FaCurCostCenterInfo faCurCostCenterInfo = faCurCostCenterCollection.get(i);
            FaCurCostCenterInfo aFaCurCostCenterInfo = new FaCurCostCenterInfo();
            BOSUuid id = BOSUuid.create((BOSObjectType)aFaCurCostCenterInfo.getBOSType());
            aFaCurCostCenterInfo.setId(id);
            aFaCurCostCenterInfo.setSeq(i + 1);
            AccountViewInfo accountViewInfo = faCurCostCenterInfo.getAccountView();
            aFaCurCostCenterInfo.setAccountView(accountViewInfo);
            if (faCurCostCenterInfo.getApportionScale() != null) {
                BigDecimal tempB = faCurCostCenterInfo.getApportionScale();
                tempB = this.formatBigDecmal(tempB, 2);
                aFaCurCostCenterInfo.setApportionScale(tempB);
            } else {
                aFaCurCostCenterInfo.setApportionScale(ZERO);
            }
            FaCurAsstActCompositCollection asstActCollection = aFaCurCostCenterInfo.getFaCurAsstActComposit();
            asstActCollection.clear();
            FaCurAsstActCompositCollection curAsstActCollection = faCurCostCenterInfo.getFaCurAsstActComposit();
            if (curAsstActCollection != null && curAsstActCollection.size() > 0) {
                for (int j = 0; j < curAsstActCollection.size(); ++j) {
                    asstActCollection.add(curAsstActCollection.get(j));
                }
            }
            aFaCurCostCenterInfo.setRemark(faCurCostCenterInfo.getRemark());
            if (aFaCurCostCenterInfo.getAccountView() == null && (aFaCurCostCenterInfo.getApportionScale() == null || aFaCurCostCenterInfo.getApportionScale().equals(ZERO)) && aFaCurCostCenterInfo.getRemark() == null) continue;
            costCenterColl.add(aFaCurCostCenterInfo);
        }
    }

    private BigDecimal formatBigDecmal(BigDecimal data) {
        if (data == null) {
            data = ZERO;
        }
        return data.setScale(this.amountScale, 4);
    }

    private BigDecimal formatBigDecmal(BigDecimal data, int scale) {
        if (data == null || data.compareTo(ZERO) == 0) {
            data = ZERO;
        }
        return data.setScale(scale, 4);
    }

    protected void calNeat(FaCurCardInfo cardInfo) {
        FaCatInfo aFaCatInfo = cardInfo.getAssetCat();
        BigDecimal amount = aFaCatInfo != null && aFaCatInfo.isCalcuByEvaluate() ? cardInfo.getInitEvalValue() : cardInfo.getAssetValue();
        BigDecimal addUPDep = cardInfo.getAccuDepr();
        BigDecimal decPrepare = cardInfo.getDecValue();
        cardInfo.setNeatValue(this.formatBigDecmal(amount.subtract(addUPDep)));
        cardInfo.setNeatAmt(this.formatBigDecmal(amount.subtract(addUPDep).subtract(decPrepare)));
    }

    protected void calLocalAmount(FaCurCardInfo cardInfo) {
        BigDecimal originalAmount = cardInfo.getOriginAmt();
        BigDecimal exchangeRate = cardInfo.getExRate();
        BigDecimal addonFare = cardInfo.getAddonFare() == null ? new BigDecimal("0") : cardInfo.getAddonFare();
        BigDecimal addAmount = cardInfo.getAddons() == null ? new BigDecimal("0") : cardInfo.getAddons();
        BigDecimal calAmount = originalAmount.multiply(exchangeRate).add(addonFare).add(addAmount);
        cardInfo.setAssetValue(this.formatBigDecmal(calAmount));
    }

    private void verifyData(FaCurCardInfo cardInfo, int i, Context ctx) throws EASBizException {
        FaCardWebValidatorImpl validator = new FaCardWebValidatorImpl(ctx, cardInfo, false);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("OprtState", "ADDNEW");
        params.put("verifySubmit", Boolean.TRUE);
        params.put("fromBillUI", "FaBatchChangeBillUI");
        validator.setParam(params);
        if (!validator.validate()) {
            String strCard = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaChangeResource", (String)"card");
            String cantChange = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaChangeResource", (String)"cantChange");
            String info = strCard + cardInfo.getNumber() + "(" + cardInfo.getAssetName() + ")" + validator.getInvalidMsg() + "\uff0c" + cantChange;
            throw new EASBizException(new NumericExceptionSubItem("NOPASSAUDIT_THISBILL", info));
        }
    }

    private String verifyNotAbort(IObjectValue infoObj, FaCurCardCollection cards, ArrayList changeCardList) throws BOSException, EASBizException {
        FaCardInfo faCardInfo = (FaCardInfo)infoObj;
        StringBuffer info = new StringBuffer();
        String strCard = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaChangeResource", (String)"card");
        String strChangeDateBeforeAccount = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaChangeResource", (String)"changeDateBeforeAccountDate");
        String strCanNotChangeCat = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"FaChangeBillEditUI_CanNotChangeCat");
        String strCanNotChange = FaResUtil.getRes((String)"canNotChange");
        Date changeDate = (Date)faCardInfo.get("changeDate");
        FaDepreciationModeInfo deprModeObj = faCardInfo.getDeprMethod();
        ArrayList<FaCurCardInfo> tmpList = new ArrayList<FaCurCardInfo>();
        for (int i = 0; i < cards.size(); ++i) {
            FaCurCardInfo cardInfo = cards.get(i);
            Date accountDate = cardInfo.getAccountDate();
            if (DateTimeUtils.dayBefore((Date)changeDate, (Date)accountDate)) {
                info.append("\uff1b").append(strCard).append(cardInfo.getNumber());
                info.append("(").append(cardInfo.getAssetName()).append(")");
                info.append(strChangeDateBeforeAccount);
                continue;
            }
            FaCatInfo afterChangeCatInfo = faCardInfo.getAssetCat();
            if (afterChangeCatInfo != null && !afterChangeCatInfo.getDepreciationPolicy().getId().equals((Object)cardInfo.getAssetCat().getDepreciationPolicy().getId()) && cardInfo.getHasCleared() != FaClearStatusEnum.HasNotCleared) {
                info.append("\uff1b");
                info.append(strCard).append(cardInfo.getNumber());
                info.append("(").append(cardInfo.getAssetName()).append(")");
                info.append(strCanNotChangeCat);
                continue;
            }
            if (deprModeObj != null && cardInfo.getDeprMethod() != null) {
                FaDepreciationModeInfo afterChange = deprModeObj;
                FaDepreciationModeInfo beforeChange = cardInfo.getDeprMethod();
                if (afterChange != null && beforeChange != null) {
                    boolean isWellOnlyMethodAfter = FaClientUtils.isWellOnlyMethod((FaDepreciationModeInfo)afterChange);
                    boolean isWellOnlyMethodBefore = FaClientUtils.isWellOnlyMethod((FaDepreciationModeInfo)beforeChange);
                    if (isWellOnlyMethodAfter && !isWellOnlyMethodBefore || !isWellOnlyMethodAfter && isWellOnlyMethodBefore) {
                        info.append("\uff1b");
                        info.append(strCard).append(cardInfo.getNumber());
                        info.append("(").append(cardInfo.getAssetName()).append(")");
                        info.append(strCanNotChange);
                        continue;
                    }
                    boolean isWorkLoadMethodAfter = FaClientUtils.isWorkLoadMethod((FaDepreciationModeInfo)afterChange);
                    boolean isWorkLoadMethodBefore = FaClientUtils.isWorkLoadMethod((FaDepreciationModeInfo)beforeChange);
                    if (isWorkLoadMethodAfter && !isWorkLoadMethodBefore || !isWorkLoadMethodAfter && isWorkLoadMethodBefore) {
                        if (!cardInfo.getAssetCat().getDepreciationPolicy().isDeprMethodChange()) {
                            if (cardInfo.getTempDeprMethod() == null || cardInfo.getTempDeprMethod().length() == 0) {
                                cardInfo.setTempDeprMethod(cardInfo.getDeprMethod().getId().toString());
                                cardInfo.setTempDeprTermCount(cardInfo.getDeprTermCount());
                                cardInfo.setTempUseTermCount(cardInfo.getUseTermCount());
                            } else {
                                cardInfo.setTempDeprMethod("");
                                cardInfo.setTempDeprTermCount(ZERO);
                                cardInfo.setTempUseTermCount(ZERO);
                            }
                        }
                    } else if (cardInfo.getTempDeprMethod() == null || cardInfo.getTempDeprMethod().length() == 0) {
                        cardInfo.setTempDeprMethod("");
                        cardInfo.setTempDeprTermCount(ZERO);
                        cardInfo.setTempUseTermCount(ZERO);
                    }
                }
            }
            tmpList.add(cardInfo);
        }
        changeCardList.addAll(tmpList);
        if (info.length() > 0) {
            return info.substring(1);
        }
        return null;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = this._getSelectors();
        SelectorItemCollection depSic = FaManageUtils.getDepCardSelector();
        sic.add(new SelectorItemInfo("*"));
        for (int i = 0; i < depSic.size(); ++i) {
            if (sic.contains(depSic.get(i))) continue;
            sic.add(depSic.get(i));
        }
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("company.baseCurrency.*"));
        sic.add(new SelectorItemInfo("deprMethod.isCustom"));
        sic.add(new SelectorItemInfo("deprMethod.isWorkload"));
        return sic;
    }

    protected SelectorItemCollection _getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = "true";
        sic.add(new SelectorItemInfo("assetAmt"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("measureUnit.*"));
        } else {
            sic.add(new SelectorItemInfo("measureUnit.id"));
            sic.add(new SelectorItemInfo("measureUnit.number"));
            sic.add(new SelectorItemInfo("measureUnit.name"));
        }
        sic.add(new SelectorItemInfo("accountDate"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("storeCity.*"));
        } else {
            sic.add(new SelectorItemInfo("storeCity.id"));
            sic.add(new SelectorItemInfo("storeCity.number"));
            sic.add(new SelectorItemInfo("storeCity.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("economicPurp.*"));
        } else {
            sic.add(new SelectorItemInfo("economicPurp.id"));
            sic.add(new SelectorItemInfo("economicPurp.number"));
            sic.add(new SelectorItemInfo("economicPurp.name"));
        }
        sic.add(new SelectorItemInfo("specs"));
        sic.add(new SelectorItemInfo("pArea"));
        sic.add(new SelectorItemInfo("mfr"));
        sic.add(new SelectorItemInfo("levFrDate"));
        sic.add(new SelectorItemInfo("paperNo"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("company.*"));
        } else {
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("dept.*"));
        } else {
            sic.add(new SelectorItemInfo("dept.id"));
            sic.add(new SelectorItemInfo("dept.number"));
            sic.add(new SelectorItemInfo("dept.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("keeper.*"));
        } else {
            sic.add(new SelectorItemInfo("keeper.id"));
            sic.add(new SelectorItemInfo("keeper.number"));
            sic.add(new SelectorItemInfo("keeper.name"));
        }
        sic.add(new SelectorItemInfo("originType"));
        sic.add(new SelectorItemInfo("originUnit"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("originMethod.*"));
        } else {
            sic.add(new SelectorItemInfo("originMethod.id"));
            sic.add(new SelectorItemInfo("originMethod.number"));
            sic.add(new SelectorItemInfo("originMethod.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("useStatus.*"));
        } else {
            sic.add(new SelectorItemInfo("useStatus.id"));
            sic.add(new SelectorItemInfo("useStatus.number"));
            sic.add(new SelectorItemInfo("useStatus.name"));
        }
        sic.add(new SelectorItemInfo("fiAccountDate"));
        sic.add(new SelectorItemInfo("wrtyPeriod"));
        sic.add(new SelectorItemInfo("wrtyNumber"));
        sic.add(new SelectorItemInfo("tempUseTermCount"));
        sic.add(new SelectorItemInfo("tempDeprTermCount"));
        sic.add(new SelectorItemInfo("tempDeprMethod"));
        sic.add(new SelectorItemInfo("isOveraged"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("originAmt"));
        sic.add(new SelectorItemInfo("addons"));
        sic.add(new SelectorItemInfo("exRate"));
        sic.add(new SelectorItemInfo("assetValue"));
        sic.add(new SelectorItemInfo("initEvalValue"));
        sic.add(new SelectorItemInfo("buyValue"));
        sic.add(new SelectorItemInfo("buyAccuDepr"));
        sic.add(new SelectorItemInfo("evalLeftPeriod"));
        sic.add(new SelectorItemInfo("useYears"));
        sic.add(new SelectorItemInfo("deliverDate"));
        sic.add(new SelectorItemInfo("startUseDate"));
        sic.add(new SelectorItemInfo("useTermCount"));
        sic.add(new SelectorItemInfo("deprTermCount"));
        sic.add(new SelectorItemInfo("accuDepr"));
        sic.add(new SelectorItemInfo("neatRemValue"));
        sic.add(new SelectorItemInfo("accuDeprTYear"));
        sic.add(new SelectorItemInfo("decValue"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("deprMethod.*"));
        } else {
            sic.add(new SelectorItemInfo("deprMethod.id"));
            sic.add(new SelectorItemInfo("deprMethod.number"));
            sic.add(new SelectorItemInfo("deprMethod.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("measureUnitWL.*"));
        } else {
            sic.add(new SelectorItemInfo("measureUnitWL.id"));
            sic.add(new SelectorItemInfo("measureUnitWL.number"));
            sic.add(new SelectorItemInfo("measureUnitWL.name"));
        }
        sic.add(new SelectorItemInfo("neatValue"));
        sic.add(new SelectorItemInfo("neatAmt"));
        sic.add(new SelectorItemInfo("accuDeprAll"));
        sic.add(new SelectorItemInfo("monthDepreRate"));
        sic.add(new SelectorItemInfo("treatmentIncome"));
        sic.add(new SelectorItemInfo("fairValue"));
        sic.add(new SelectorItemInfo("neatLeftRate"));
        sic.add(new SelectorItemInfo("addonFare"));
        sic.add(new SelectorItemInfo("inputTax"));
        sic.add(new SelectorItemInfo("evalAssetValue"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("evalDeprMode.*"));
        } else {
            sic.add(new SelectorItemInfo("evalDeprMode.id"));
            sic.add(new SelectorItemInfo("evalDeprMode.number"));
            sic.add(new SelectorItemInfo("evalDeprMode.name"));
        }
        sic.add(new SelectorItemInfo("evalMonthRate"));
        sic.add(new SelectorItemInfo("evalNeatLeftRate"));
        sic.add(new SelectorItemInfo("evalRemValue"));
        sic.add(new SelectorItemInfo("evalDecValue"));
        sic.add(new SelectorItemInfo("evalNeatValue"));
        sic.add(new SelectorItemInfo("evalNeatAmt"));
        sic.add(new SelectorItemInfo("evalDeprTTerm"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.*"));
        } else {
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.id"));
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.number"));
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.name"));
        }
        sic.add(new SelectorItemInfo("evalYearDepr"));
        sic.add(new SelectorItemInfo("evalAddDepr"));
        sic.add(new SelectorItemInfo("evalTaxLeftPeriod"));
        sic.add(new SelectorItemInfo("evalDeprPeriodNum"));
        sic.add(new SelectorItemInfo("evalUseTermCount"));
        sic.add(new SelectorItemInfo("evalReInAccountDate"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("accountAsset.*"));
        } else {
            sic.add(new SelectorItemInfo("accountAsset.id"));
            sic.add(new SelectorItemInfo("accountAsset.number"));
            sic.add(new SelectorItemInfo("accountAsset.name"));
            sic.add(new SelectorItemInfo("accountAsset.longName"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("accountAccuDepr.*"));
        } else {
            sic.add(new SelectorItemInfo("accountAccuDepr.id"));
            sic.add(new SelectorItemInfo("accountAccuDepr.number"));
            sic.add(new SelectorItemInfo("accountAccuDepr.name"));
            sic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("accountDecValue.*"));
        } else {
            sic.add(new SelectorItemInfo("accountDecValue.id"));
            sic.add(new SelectorItemInfo("accountDecValue.number"));
            sic.add(new SelectorItemInfo("accountDecValue.name"));
            sic.add(new SelectorItemInfo("accountDecValue.longName"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.id"));
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.number"));
        }
        sic.add(new SelectorItemInfo("faCurCostCenter.remark"));
        sic.add(new SelectorItemInfo("faCurCostCenter.apportionScale"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.id"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.name"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.id"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.name"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.id"));
        }
        sic.add(new SelectorItemInfo("faCurFacility.facilityNumber"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityName"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityModel"));
        sic.add(new SelectorItemInfo("faCurFacility.registerDate"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.id"));
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.name"));
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.id"));
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.name"));
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.number"));
        }
        sic.add(new SelectorItemInfo("faCurFacility.quantity"));
        sic.add(new SelectorItemInfo("faCurFacility.amount"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurFacility.keeper.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurFacility.keeper.id"));
            sic.add(new SelectorItemInfo("faCurFacility.keeper.name"));
            sic.add(new SelectorItemInfo("faCurFacility.keeper.number"));
        }
        sic.add(new SelectorItemInfo("faCurFacility.remark"));
        sic.add(new SelectorItemInfo("faCurFacility.id"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.id"));
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.name"));
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.id"));
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.name"));
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.number"));
        }
        sic.add(new SelectorItemInfo("faCurDepartment.usage"));
        sic.add(new SelectorItemInfo("faCurDepartment.remark"));
        sic.add(new SelectorItemInfo("faCurDepartment.id"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("assetCat.*"));
        } else {
            sic.add(new SelectorItemInfo("assetCat.id"));
            sic.add(new SelectorItemInfo("assetCat.number"));
            sic.add(new SelectorItemInfo("assetCat.name"));
            sic.add(new SelectorItemInfo("assetCat.displayName"));
        }
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("assetName"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("creator.*"));
        } else {
            sic.add(new SelectorItemInfo("creator.id"));
            sic.add(new SelectorItemInfo("creator.number"));
            sic.add(new SelectorItemInfo("creator.name"));
        }
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("oldNumber"));
        sic.add(new SelectorItemInfo("groupNumber"));
        sic.add(new SelectorItemInfo("barCode"));
        SelectorItemCollection newSic = new SelectorItemCollection();
        for (int i = 0; i < sic.size(); ++i) {
            SelectorItemInfo selector = sic.get(i);
            if (selector.getPropertyName().endsWith(".*") && !selector.getPropertyName().equalsIgnoreCase("originUnit.*")) {
                String propName = selector.get("propertyName").toString();
                String prefix = propName.substring(0, propName.length() - 1);
                newSic.add(new SelectorItemInfo(prefix + "id"));
                newSic.add(new SelectorItemInfo(prefix + "name"));
                newSic.add(new SelectorItemInfo(prefix + "number"));
                continue;
            }
            newSic.add(selector);
        }
        newSic.add(new SelectorItemInfo("*"));
        newSic.add(new SelectorItemInfo("currency.id"));
        newSic.add(new SelectorItemInfo("currency.number"));
        newSic.add(new SelectorItemInfo("currency.name"));
        newSic.add(new SelectorItemInfo("currency.isoCode"));
        newSic.add(new SelectorItemInfo("currency.sign"));
        newSic.add(new SelectorItemInfo("currency.baseUnit"));
        newSic.add(new SelectorItemInfo("currency.precision"));
        newSic.add(new SelectorItemInfo("assetCat.isDeductInputTax"));
        newSic.add(new SelectorItemInfo("assetCat.isLeaf"));
        newSic.add(new SelectorItemInfo("assetCat.displayName"));
        newSic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        newSic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.*"));
        newSic.add(new SelectorItemInfo("assetCat.measureUnit.name"));
        newSic.add(new SelectorItemInfo("assetCat.measureUnit.number"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.number"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.name"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.isCustom"));
        newSic.add(new SelectorItemInfo("assetCat.depreMode.isWorkload"));
        newSic.add(new SelectorItemInfo("assetCat.classfication.*"));
        newSic.add(new SelectorItemInfo("assetCat.classfication.detailCollection.*"));
        newSic.add(new SelectorItemInfo("assetCat.classfication.number"));
        newSic.add(new SelectorItemInfo("assetCat.company.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.creator.name"));
        newSic.add(new SelectorItemInfo("assetCat.id"));
        newSic.add(new SelectorItemInfo("assetCat.numberRule"));
        newSic.add(new SelectorItemInfo("assetCat.number"));
        newSic.add(new SelectorItemInfo("assetCat.gcUseLimitAndPureRate"));
        newSic.add(new SelectorItemInfo("dept.id"));
        newSic.add(new SelectorItemInfo("dept.name"));
        newSic.add(new SelectorItemInfo("dept.number"));
        newSic.add(new SelectorItemInfo("CU.id"));
        newSic.add(new SelectorItemInfo("CU.name"));
        newSic.add(new SelectorItemInfo("CU.number"));
        newSic.add(new SelectorItemInfo("number"));
        newSic.add(new SelectorItemInfo("effectedStatus"));
        newSic.add(new SelectorItemInfo("checkedStatus"));
        newSic.add(new SelectorItemInfo("originMethod.isLeaf"));
        newSic.add(new SelectorItemInfo("useStatus.isLeaf"));
        newSic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        newSic.add(new SelectorItemInfo("economicPurp.isLeaf"));
        newSic.add(new SelectorItemInfo("dept.isLeaf"));
        newSic.add(new SelectorItemInfo("accountAsset.isLeaf"));
        newSic.add(new SelectorItemInfo("accountAccuDepr.isLeaf"));
        newSic.add(new SelectorItemInfo("accountDecValue.isLeaf"));
        newSic.add(new SelectorItemInfo("faCurFacility.seq"));
        newSic.add(new SelectorItemInfo("faCurDepartment.seq"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.seq"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.*"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.accountView.isLeaf"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.accountView.longName"));
        newSic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
        newSic.add(new SelectorItemInfo("accountAsset.longName"));
        newSic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        newSic.add(new SelectorItemInfo("accountDecValue.longName"));
        newSic.add(new SelectorItemInfo("company.*"));
        newSic.add(new SelectorItemInfo("company.id"));
        newSic.add(new SelectorItemInfo("company.number"));
        newSic.add(new SelectorItemInfo("company.name"));
        newSic.add(new SelectorItemInfo("deprMethod.isCustom"));
        newSic.add(new SelectorItemInfo("deprMethod.isWorkload"));
        newSic.add(new SelectorItemInfo("period.beginDate"));
        newSic.add(new SelectorItemInfo("period.endDate"));
        newSic.add(new SelectorItemInfo("period.periodYear"));
        newSic.add(new SelectorItemInfo("period.periodNumber"));
        newSic.add(new SelectorItemInfo("faCurDepartment.useDepartment.displayName"));
        newSic.add(new SelectorItemInfo("evalDeprMode.isCustom"));
        newSic.add(new SelectorItemInfo("evalDeprMode.isWorkload"));
        return newSic;
    }

    @Override
    protected Map _submit(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            List changebills;
            List changebillList = changebills = (List)paramMap.get("changebills");
            FaChangeBillInfo[] faChangeBillInfos = new FaChangeBillInfo[changebills.size()];
            changebillList.toArray(faChangeBillInfos);
            FaChangeBillFactory.getRemoteInstance().batchSubmit(faChangeBillInfos);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            resultMap.put("summaryMsg", e.getMessage());
            resultMap.put("detailMsg", e.toString());
        }
        return resultMap;
    }

    @Override
    protected Map _getPermissionsByCompany(Context ctx, Map argJsonMap) throws BOSException, EASBizException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        String companyId = (String)argJsonMap.get("companyId");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("companyId", companyId);
        boolean addPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "fa_cardchange_addnew");
        if (addPermission) {
            result.put("addPermission", true);
        } else {
            result.put("addPermission", false);
        }
        boolean updatePermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "fa_cardchange_update");
        if (updatePermission) {
            result.put("updatePermission", true);
        } else {
            result.put("updatePermission", false);
        }
        boolean deletePermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "fa_cardchange_delete");
        if (deletePermission) {
            result.put("deletePermission", true);
        } else {
            result.put("deletePermission", false);
        }
        boolean auditPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "fa_cardchange_audit");
        if (auditPermission) {
            result.put("auditPermission", true);
        } else {
            result.put("auditPermission", false);
        }
        boolean unAuditPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "fa_cardchange_unaudit");
        if (unAuditPermission) {
            result.put("unAuditPermission", true);
        } else {
            result.put("unAuditPermission", false);
        }
        boolean printPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "fa_cardchange_print");
        if (printPermission) {
            result.put("printPermission", true);
        } else {
            result.put("printPermission", false);
        }
        return result;
    }

    private void checkForUseWorkFlow(Context ctx, FaChangeBillInfo billInfo) throws FaCardException, EASBizException, BOSException {
        if (FaManageUtils.isUseWorkflow(ctx, billInfo.getCompany().getId().toString(), new FaChangeBillControllerBean().getClass())) {
            String msg = ResourceBase.getString((String)this.RESOURCE_PATH, (String)"WORKFLOW_ENABLE", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{billInfo.getCompany().getName() + "\uff08" + billInfo.getCompany().getNumber() + "\uff09", billInfo.getNumber()});
            throw new EASBizException(new NumericExceptionSubItem("01", msg));
        }
    }

    private void checkAuditWithWorkFlow(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        FaChangeBillInfo faChangeBillInfo;
        if (model == null) {
            model = FaChangeBillFactory.getLocalInstance(ctx).getFaChangeBillInfo(pk, new SelectorItemCollection());
        }
        if ((faChangeBillInfo = (FaChangeBillInfo)model) == null) {
            throw new IllegalArgumentException();
        }
        SelectorItemCollection sicOfChangeBill = new SelectorItemCollection();
        sicOfChangeBill.add(new SelectorItemInfo("number"));
        sicOfChangeBill.add(new SelectorItemInfo("company.id"));
        sicOfChangeBill.add(new SelectorItemInfo("company.name"));
        sicOfChangeBill.add(new SelectorItemInfo("company.number"));
        faChangeBillInfo = FaChangeBillFactory.getLocalInstance(ctx).getFaChangeBillInfo((IObjectPK)new ObjectUuidPK(faChangeBillInfo.getId()), sicOfChangeBill);
        this.checkForUseWorkFlow(ctx, faChangeBillInfo);
    }
}

