/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaAppLogForBusinessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBillBaseInfo;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCombinBillEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaCombinBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaCombinBillFactory;
import com.kingdee.eas.fi.fa.manage.FaCombinBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaCombinBillControllerBean;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCombinStrategy;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaMethodCalcOrderEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodMappingUtils;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public class FaCombinBillControllerBean
extends AbstractFaCombinBillControllerBean {
    @Override
    protected AbstractPrcFaManageStrategy getBillStrategy() {
        return new PrcFaCombinStrategy();
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, ((FaCombinBillInfo)model).getCompany().getId().toString(), pk.toString(), 4);
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, FaBillBaseInfo model) throws BOSException, EASBizException {
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, ((FaCombinBillInfo)model).getCompany().getId().toString(), pk.toString(), 5);
    }

    @Override
    public String getMasterTable() {
        return "T_FA_FaCombinBill";
    }

    @Override
    protected SelectorItemCollection getSelfSelctor() {
        SelectorItemCollection sic = super.getSelfSelctor();
        sic.add(new SelectorItemInfo("faCombinBillEntry.id"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.faBakCard.assetAmt"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.faBakCard.lastEvalValue"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.id"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.accuDepr"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.accuDeprTYear"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faBizCard.deprTTerm"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.*"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.company.id"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.deprMethod.number"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.deprMethod.isWorkload"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.faCurCostCenter.id"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.faCurCostCenter.apportionScale"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.faCurCostCenter.accountView.id"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.faCurCostCenter.accountView.name"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.faCurCostCenter.accountView.number"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.faCurCostCenter.accountView.name"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.faCurCostCenter.asstActType.*"));
        sic.add(new SelectorItemInfo("faCombinBillEntry.faCurCard.faCurCostCenter.asstActItem"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.bizStatus"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.lastBillID"));
        sic.add(new SelectorItemInfo("faBizCard.faBakCard.hasCleared"));
        sic.add(new SelectorItemInfo("faBizCard.id"));
        sic.add(new SelectorItemInfo("faBizCard.accuDepr"));
        sic.add(new SelectorItemInfo("faBizCard.accuDeprTYear"));
        sic.add(new SelectorItemInfo("faBizCard.deprTermCount"));
        sic.add(new SelectorItemInfo("faCurCard.*"));
        sic.add(new SelectorItemInfo("faCurCard.company.id"));
        sic.add(new SelectorItemInfo("faCurCard.company.id"));
        sic.add(new SelectorItemInfo("faCurCard.deprMethod.number"));
        sic.add(new SelectorItemInfo("faCurCard.deprMethod.isWorkload"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("clearMode.id"));
        sic.add(new SelectorItemInfo("faClearBill.id"));
        sic.add(new SelectorItemInfo("faClearBill.number"));
        sic.add(new SelectorItemInfo("faClearBill.fiVouchered"));
        sic.add(new SelectorItemInfo("combinDate"));
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    @Override
    protected void checkBeforeSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaCombinBillInfo combinBill = (FaCombinBillInfo)model;
        FaCombinBillEntryCollection entryColl = combinBill.getFaCombinBillEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCombinBillEntryInfo entry = entryColl.get(i);
            FaCurCardInfo card = entry.getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaCombinBillInfo combinBill = (FaCombinBillInfo)model;
        FaCombinBillEntryCollection entryColl = combinBill.getFaCombinBillEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCombinBillEntryInfo entry = entryColl.get(i);
            FaCurCardInfo card = entry.getFaCurCard();
            if (card == null || card.getId() == null || card.getLastUpdateTime() == null) continue;
            FaBillBizProcessor.lockFaCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), card.getLastUpdateTime());
        }
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FaCombinBillInfo faCombinBillInfo = FaCombinBillFactory.getLocalInstance(ctx).getFaCombinBillInfo(pk);
        if (this.isCurrencyDisable(ctx, faCombinBillInfo)) {
            StringBuffer sbAll = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource", (String)"CurrencyDisable", (Locale)ctx.getOriginLocale()));
            throw new FaCardException(FaCardException.CURRENCYDISABLEFORCOMBIN_AUDIT, new String[]{sbAll.toString()});
        }
        super._passAudit(ctx, pk);
    }

    private boolean isCurrencyDisable(Context ctx, FaCombinBillInfo faCombinBillInfo) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo;
        FaBizCardInfo faBizCardInfo;
        boolean isDisable = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        if (faCombinBillInfo != null && faCombinBillInfo.getFaBizCard() != null && faCombinBillInfo.getFaBizCard().getId() != null && (faBizCardInfo = FaBizCardFactory.getLocalInstance(ctx).getFaBizCardInfo((IObjectPK)new ObjectUuidPK(faCombinBillInfo.getFaBizCard().getId()), sic)) != null && (currencyInfo = faBizCardInfo.getCurrency()) != null && currencyInfo.getId() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)currencyInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)"2", CompareType.EQUALS));
            isDisable = CurrencyFactory.getLocalInstance((Context)ctx).exists(filter);
        }
        return isDisable;
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_COMBIN, FaMethodCalcOrderEnum.BEFORE);
        super.invokeServiceBefore(svcCtx);
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_COMBIN, FaMethodCalcOrderEnum.AFTER);
        super.invokeServiceAfter(svcCtx);
    }
}

