/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.app.XmlTrans;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaChangeBillCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionCollection;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionFactory;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPeriodCloseFacadeFactory;
import com.kingdee.eas.fi.fa.manage.IFaContrastSolution;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaContrastCaclControllerBean;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportBatchCalculatorImpl;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaContrastCaclControllerBean
extends AbstractFaContrastCaclControllerBean {
    private static final long serialVersionUID = 8534534964948759690L;
    BigDecimal zeroValue = new BigDecimal("0");
    private static Logger logger = Logger.getLogger(FaContrastCaclControllerBean.class);
    private static String sumBegin = "sumBegin";
    private static String sumDebit = "sumDebit";
    private static String sumCredit = "sumCredit";
    private static String sumEnd = "sumEnd";
    private static String sumRealBeginBalance = "sumRealBeginBalance";
    private static String sumEvalueBeginBalance = "sumEvalueBeginBalance";
    private static String sumRealDebit = "sumRealDebit";
    private static String sumEvalueDebit = "sumEvalueDebit";
    private static String sumRealCredit = "sumRealCredit";
    private static String sumEvalueCredit = "sumEvalueCredit";
    private static String sumRealEndBalance = "sumRealEndBalance";
    private static String sumEvalueEndBalance = "sumEvalueEndBalance";
    private static String sumDepreBeginBalanceFor = sumBegin + "_DEPRE_ASSET";
    private static String sumDepreDebitFor = sumDebit + "_DEPRE_ASSET";
    private static String sumDepreCreditFor = sumCredit + "_DEPRE_ASSET";
    private static String sumDepreEndBalanceFor = sumEnd + "_DEPRE_ASSET";
    private static String sumDecValueBeginBalanceFor = sumBegin + "_DECVALUE_ASSET";
    private static String sumDecValueDebitFor = sumDebit + "_DECVALUE_ASSET";
    private static String sumDecValueCreditFor = sumCredit + "_DECVALUE_ASSET";
    private static String sumDecValueEndBalanceFor = sumEnd + "_DECVALUE_ASSET";
    private String resource = "com.kingdee.eas.fi.fa.manage.FaResource";
    private HashMap topAccountMap = null;
    private boolean isGetLastPeriodData = false;

    private boolean isAssetAccountDebit(Context ctx, HashMap accountMap) throws BOSException, EASBizException {
        Iterator items;
        HashMap assetAccount = (HashMap)accountMap.get("ASSET");
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        if (assetAccount != null && (items = assetAccount.values().iterator()).hasNext()) {
            AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()));
            return account.getDC().getValue() == 1;
        }
        return true;
    }

    private boolean isDecAccountCredit(Context ctx, HashMap accountMap) throws BOSException, EASBizException {
        Iterator items;
        HashMap decAccount = (HashMap)accountMap.get("DECVALUE");
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        if (decAccount != null && (items = decAccount.values().iterator()).hasNext()) {
            AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()));
            return account.getDC().getValue() == -1;
        }
        return true;
    }

    private boolean isDepreAccountCredit(Context ctx, HashMap accountMap) throws BOSException, EASBizException {
        Iterator items;
        HashMap depreAccount = (HashMap)accountMap.get("DEPRE");
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        if (depreAccount != null && (items = depreAccount.values().iterator()).hasNext()) {
            AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()));
            return account.getDC().getValue() == -1;
        }
        return true;
    }

    @Override
    protected HashMap _faAcct(Context ctx, String companyID, HashMap accountMap, HashMap catMap, boolean isIncludeUnposted, int periodYear, int periodNumber, boolean isUseEvaValue, boolean isUseCatNumber) throws BOSException, EASBizException {
        if (accountMap == null) {
            throw new IllegalArgumentException("accountMap is NULL");
        }
        if (isUseCatNumber && catMap == null) {
            throw new IllegalArgumentException("catMap is NULL");
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        CompanyOrgUnitInfo companyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
        CurrencyInfo currency = companyOrg.getBaseCurrency();
        HashMap result = isUseCatNumber ? this.faAcctUseCat(ctx, companyOrg, accountMap, catMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue, currency, null) : this.faAcctNotUseCat(ctx, companyOrg, accountMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue, currency);
        PeriodInfo startPeriodInfo = this.getPrePeriod(ctx, companyID);
        int startYear = startPeriodInfo.getPeriodYear();
        int startNumber = startPeriodInfo.getPeriodNumber();
        if (isUseCatNumber && (startYear != periodYear || startNumber != periodNumber)) {
            PeriodTypeInfo periodTypeInfo = startPeriodInfo.getPeriodType();
            IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
            PeriodInfo curPeriodInfo = iPeriod.getPeriodInfo(periodYear, periodNumber, periodTypeInfo);
            PeriodInfo lastPeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)curPeriodInfo);
            if (lastPeriodInfo != null) {
                int lastYear = lastPeriodInfo.getPeriodYear();
                int lastNumber = lastPeriodInfo.getPeriodNumber();
                this.isGetLastPeriodData = true;
                HashMap lastResult = this.faAcctUseCat(ctx, companyOrg, accountMap, catMap, isIncludeUnposted, lastYear, lastNumber, isUseEvaValue, currency, curPeriodInfo.getId().toString());
                result = this.replaceBegin(result, lastResult);
                boolean isFromFaAcct = true;
                this.calculateDebitAndCredit(ctx, curPeriodInfo, companyID, result, isFromFaAcct);
                this.isGetLastPeriodData = false;
            }
        }
        result.put("isUseCatNumber", isUseCatNumber);
        result.put("AccountMap", accountMap);
        result.put("CatMap", catMap);
        return result;
    }

    @Override
    protected boolean _isAcctEquals(Context ctx, String companyID, PeriodInfo periodInfo) throws BOSException, EASBizException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(companyID));
        if (startPeriod == null) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notConfigStartPeriod", (Locale)ctx.getOriginLocale());
            throw new EASBizException(new NumericExceptionSubItem("001", strMsg));
        }
        HashMap parameter = this.getDefaultContrastSolution(this.getContrastSolutions(ctx, companyID));
        if (parameter != null) {
            HashMap accountMap;
            boolean isIncludeUnposted = parameter.get("isIncludeUnposted") != null ? Boolean.valueOf((String)parameter.get("isIncludeUnposted")) : false;
            boolean isUseEvaValue = parameter.get("isUseEvaValue") != null ? Boolean.valueOf((String)parameter.get("isUseEvaValue")) : false;
            boolean isUseCat = parameter.get("isUseCatNumber") != null ? Boolean.valueOf((String)parameter.get("isUseCatNumber")) : false;
            boolean isUseCardAcct = parameter.get("isUseCardAcct") != null ? Boolean.valueOf((String)parameter.get("isUseCardAcct")) : false;
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(companyID));
            if (periodInfo != null && periodInfo.getNumber() > currentPeriodInfo.getNumber()) {
                String strMsg = EASResource.getString((String)this.resource, (String)"notAfterPeriodVC");
                throw new EASBizException(new NumericExceptionSubItem("001", strMsg));
            }
            PeriodInfo period = periodInfo == null ? currentPeriodInfo : periodInfo;
            HashMap hashMap = accountMap = parameter.get("AccountMap") != null ? (HashMap)parameter.get("AccountMap") : new HashMap();
            if (isUseCardAcct) {
                HashMap searcHashMap = this._faAcctDetail(ctx, companyID, accountMap, isIncludeUnposted, period.getPeriodYear(), period.getPeriodNumber(), isUseEvaValue);
                ArrayList accountArrayList = (ArrayList)searcHashMap.get("AccountMap");
                for (int i = 0; i < accountArrayList.size(); ++i) {
                    List accountList = (List)accountArrayList.get(i);
                    int size = accountList.size();
                    for (int j = 0; j < size; ++j) {
                        String PREFIX = i == 0 ? "ASSET_" : (i == 1 ? "DECVALUE_" : "DEPRE_");
                        AccountViewInfo accountInfo = (AccountViewInfo)accountList.get(j);
                        String[] colNamePrefix = new String[]{"sumEnd"};
                        int colSize = colNamePrefix.length;
                        for (int k = 0; k < colSize; ++k) {
                            BigDecimal valueAsset = (BigDecimal)searcHashMap.get(PREFIX + colNamePrefix[k] + "_ASSET_" + accountInfo.getNumber());
                            BigDecimal valueGl = (BigDecimal)searcHashMap.get(PREFIX + colNamePrefix[k] + "_GL_" + accountInfo.getNumber());
                            if (valueGl == null || valueAsset == null || valueGl.compareTo(valueAsset) == 0) continue;
                            return false;
                        }
                    }
                }
            } else {
                HashMap searchResult = this._faAcct(ctx, companyID, accountMap, (HashMap)parameter.get("CatMap"), isIncludeUnposted, period.getPeriodYear(), period.getPeriodNumber(), isUseEvaValue, isUseCat);
                if (!isUseCat) {
                    Set accountMapSet = accountMap.keySet();
                    String[] colNamePrefix = new String[]{sumEnd};
                    for (int setCount = accountMapSet.size() - 1; setCount >= 0; --setCount) {
                        int colSize = colNamePrefix.length;
                        for (int i = 0; i < colSize; ++i) {
                            BigDecimal valueGl = (BigDecimal)searchResult.get(colNamePrefix[i] + "_" + accountMapSet.toArray()[setCount] + "_ASSET");
                            BigDecimal valueAsset = (BigDecimal)searchResult.get(colNamePrefix[i] + "_" + accountMapSet.toArray()[setCount] + "_GL");
                            if (valueGl == null || valueAsset == null || valueGl.compareTo(valueAsset) == 0) continue;
                            return false;
                        }
                    }
                } else {
                    Set accountMapSet = accountMap.keySet();
                    IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
                    String[] colNamePrefix = new String[]{sumEnd};
                    for (int setCount = accountMapSet.size() - 1; setCount >= 0; --setCount) {
                        HashMap accountList = (HashMap)accountMap.get(accountMapSet.toArray()[setCount]);
                        Iterator items = accountList.values().iterator();
                        while (items.hasNext()) {
                            AccountViewInfo accountInfo = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()));
                            int colSize = colNamePrefix.length;
                            for (int i = 0; i < colSize; ++i) {
                                BigDecimal valueGl = (BigDecimal)searchResult.get(colNamePrefix[i] + "_" + accountMapSet.toArray()[setCount] + "_ASSET_" + accountInfo.getNumber());
                                BigDecimal valueAsset = (BigDecimal)searchResult.get(colNamePrefix[i] + "_GL_" + accountInfo.getNumber() + "_" + accountMapSet.toArray()[setCount]);
                                if (valueGl == null || valueAsset == null || valueGl.compareTo(valueAsset) == 0) continue;
                                return false;
                            }
                        }
                    }
                }
            }
        } else {
            throw new FaCardException(FaCardException.NO_DEFAULT_SOLUTION);
        }
        return true;
    }

    @Override
    protected HashMap _faAcct(Context ctx, String companyID, int periodYear, int periodNumber) throws BOSException, EASBizException {
        HashMap searchResult = null;
        HashMap parameter = this.getDefaultContrastSolution(this.getContrastSolutions(ctx, companyID));
        if (parameter != null) {
            boolean isIncludeUnposted = parameter.get("isIncludeUnposted") != null ? Boolean.valueOf((String)parameter.get("isIncludeUnposted")) : false;
            boolean isUseEvaValue = parameter.get("isUseEvaValue") != null ? Boolean.valueOf((String)parameter.get("isUseEvaValue")) : false;
            boolean isUseCat = parameter.get("isUseCatNumber") != null ? Boolean.valueOf((String)parameter.get("isUseCatNumber")) : false;
            boolean isUseCardAcct = parameter.get("isUseCardAcct") != null ? Boolean.valueOf((String)parameter.get("isUseCardAcct")) : false;
            searchResult = isUseCardAcct ? this._faAcctDetail(ctx, companyID, (HashMap)parameter.get("AccountMap"), isIncludeUnposted, periodYear, periodNumber, isUseEvaValue) : this._faAcct(ctx, companyID, (HashMap)parameter.get("AccountMap"), (HashMap)parameter.get("CatMap"), isIncludeUnposted, periodYear, periodNumber, isUseEvaValue, isUseCat);
            if (searchResult != null) {
                searchResult.put("isUseCardAcct", isUseCardAcct);
            }
        } else {
            throw new FaCardException(FaCardException.NO_DEFAULT_SOLUTION);
        }
        return searchResult == null ? new HashMap() : searchResult;
    }

    @Override
    protected HashMap _faAcct(Context ctx, String companyID) throws BOSException, EASBizException {
        HashMap searchResult = new HashMap();
        HashMap parameter = this.getDefaultContrastSolution(this.getContrastSolutions(ctx, companyID));
        if (parameter != null) {
            boolean isIncludeUnposted = parameter.get("isIncludeUnposted") != null ? Boolean.valueOf((String)parameter.get("isIncludeUnposted")) : false;
            boolean isUseEvaValue = parameter.get("isUseEvaValue") != null ? Boolean.valueOf((String)parameter.get("isUseEvaValue")) : false;
            boolean isUseCat = parameter.get("isUseCatNumber") != null ? Boolean.valueOf((String)parameter.get("isUseCatNumber")) : false;
            boolean isUseCardAcct = parameter.get("isUseCardAcct") != null ? Boolean.valueOf((String)parameter.get("isUseCardAcct")) : false;
            PeriodInfo period = this.getPrePeriod(ctx, companyID);
            HashMap hashMap = searchResult = isUseCardAcct ? this.faAcctDetail(ctx, companyID, (HashMap)parameter.get("AccountMap"), isIncludeUnposted, period.getPeriodYear(), period.getPeriodNumber(), isUseEvaValue) : this._faAcct(ctx, companyID, (HashMap)parameter.get("AccountMap"), (HashMap)parameter.get("CatMap"), isIncludeUnposted, period.getPeriodYear(), period.getPeriodNumber(), isUseEvaValue, isUseCat);
            if (!isUseCat) {
                Set resultKey = searchResult.keySet();
                for (int i = 0; i < resultKey.size(); ++i) {
                    String keyName = (String)resultKey.toArray()[i];
                    if (keyName.indexOf("_GL") == -1 && keyName.indexOf("_ASSET") == -1) continue;
                    BigDecimal valueGl = keyName.indexOf(sumDebit) != -1 || keyName.indexOf(sumCredit) != -1 ? this.zeroValue : (BigDecimal)searchResult.get(keyName);
                    searchResult.put(keyName, valueGl);
                    if (keyName.indexOf(sumBegin) == -1) continue;
                    searchResult.put(keyName.replaceAll(sumBegin, sumEnd), valueGl);
                }
            } else {
                HashMap accountMap = parameter.get("AccountMap") != null ? (HashMap)parameter.get("AccountMap") : new HashMap();
                Set accountMapSet = accountMap.keySet();
                IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
                String[] colNamePrefix = new String[]{sumBegin, sumCredit, sumDebit, sumEnd};
                for (int setCount = accountMapSet.size() - 1; setCount >= 0; --setCount) {
                    HashMap accountList = (HashMap)accountMap.get(accountMapSet.toArray()[setCount]);
                    Iterator items = accountList.values().iterator();
                    while (items.hasNext()) {
                        AccountViewInfo accountInfo = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()));
                        int colSize = colNamePrefix.length;
                        for (int i = 0; i < colSize; ++i) {
                            if (colNamePrefix[i].equals(sumCredit) || colNamePrefix[i].equals(sumDebit)) {
                                searchResult.put(colNamePrefix[i] + "_" + accountMapSet.toArray()[setCount] + "_ASSET_" + accountInfo.getNumber(), this.zeroValue);
                                searchResult.put(colNamePrefix[i] + "_GL_" + accountInfo.getNumber() + "_" + accountMapSet.toArray()[setCount], this.zeroValue);
                            }
                            if (!colNamePrefix[i].equals(sumEnd)) continue;
                            searchResult.put(colNamePrefix[i] + "_" + accountMapSet.toArray()[setCount] + "_ASSET_" + accountInfo.getNumber(), searchResult.get(sumBegin + "_" + accountMapSet.toArray()[setCount] + "_ASSET_" + accountInfo.getNumber()));
                            searchResult.put(colNamePrefix[i] + "_GL_" + accountInfo.getNumber() + "_" + accountMapSet.toArray()[setCount], searchResult.get(sumBegin + "_GL_" + accountInfo.getNumber() + "_" + accountMapSet.toArray()[setCount]));
                        }
                    }
                }
            }
            if (searchResult != null) {
                searchResult.put("isUseCatNumber", isUseCat);
                searchResult.put("CatMap", (HashMap)parameter.get("CatMap"));
                searchResult.put("isUseCardAcct", isUseCardAcct);
            }
        } else {
            throw new FaCardException(FaCardException.NO_DEFAULT_SOLUTION);
        }
        return searchResult == null ? new HashMap() : searchResult;
    }

    private PeriodInfo getPrePeriod(Context ctx, String companyID) throws BOSException, EASBizException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(companyID));
        return startPeriod == null ? new PeriodInfo() : startPeriod;
    }

    private QuerySolutionCollection getQuerySolutions(Context ctx, String companyID) throws BOSException, EASBizException {
        String queryName = "com.kingdee.eas.fi.fa.manage.FaChangeBillQuery";
        String parentUI = "com.kingdee.eas.fi.fa.manage.client.FaContrastUI";
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("queryObjectName", (Object)queryName));
        filterInfo.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentUI));
        filterInfo.getFilterItems().add(new FilterItemInfo("shareType", (Object)String.valueOf(2)));
        if (companyID != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)companyID));
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3");
        } else {
            filterInfo.setMaskString(" #0 AND #1 AND #2 ");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        return iQuerySolution.getQuerySolutionCollection(entityViewInfo);
    }

    private HashMap getDefaultSolution(QuerySolutionCollection collection) throws BOSException {
        if (collection == null) {
            return null;
        }
        for (int i = 0; i < collection.size(); ++i) {
            QuerySolutionInfo querySolutionInfo = collection.get(i);
            QueryPanelCollection queryPanelCollection = querySolutionInfo.getQueryPanelInfo();
            for (int j = 0; j < queryPanelCollection.size(); ++j) {
                QueryPanelInfo queryPanelInfo = queryPanelCollection.get(j);
                String params = queryPanelInfo.getCustomerParams();
                if (params == null) continue;
                try {
                    boolean isDefaultSolution;
                    HashMap loadInfo = XmlTrans.TransStrToCustParams((String)params);
                    boolean bl = isDefaultSolution = loadInfo == null ? false : Boolean.valueOf((String)loadInfo.get("IsDefaultSolution"));
                    if (!isDefaultSolution) continue;
                    return loadInfo;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return null;
    }

    private FaContrastSolutionCollection getContrastSolutions(Context ctx, String companyID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)companyID));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        IFaContrastSolution isolution = FaContrastSolutionFactory.getLocalInstance(ctx);
        return isolution.getFaContrastSolutionCollection(entityViewInfo);
    }

    private HashMap getDefaultContrastSolution(FaContrastSolutionCollection collection) throws BOSException {
        if (collection == null) {
            return null;
        }
        for (int i = 0; i < collection.size(); ++i) {
            FaContrastSolutionInfo solutionInfo = collection.get(i);
            String params = solutionInfo.getParams();
            if (params == null) continue;
            try {
                boolean isDefaultSolution;
                HashMap loadInfo = XmlTrans.TransStrToCustParams((String)params);
                boolean bl = isDefaultSolution = loadInfo == null ? false : Boolean.valueOf((String)loadInfo.get("IsDefaultSolution"));
                if (!isDefaultSolution) continue;
                return loadInfo;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    public static Object getObject(byte[] bytes) {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        return object;
    }

    protected String parseAccountString(String account) {
        return account + "";
    }

    protected HashMap searchGLBalance(Context ctx, CompanyOrgUnitInfo companyOrg, HashMap accountMap, int periodYear, int periodNumber, boolean isIncludeUnposted) throws BOSException, EASBizException {
        GlUtils.updateBalance((Context)ctx);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        BigDecimal c_value = this.zeroValue;
        BigDecimal y_value = this.zeroValue;
        BigDecimal jf_value = this.zeroValue;
        BigDecimal df_value = this.zeroValue;
        Set accountMapSet = accountMap.keySet();
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        for (int setCount = 0; setCount < accountMapSet.size(); ++setCount) {
            HashMap accountList = (HashMap)accountMap.get(accountMapSet.toArray()[setCount]);
            if (accountList == null) continue;
            c_value = this.zeroValue;
            y_value = this.zeroValue;
            jf_value = this.zeroValue;
            df_value = this.zeroValue;
            Iterator items = accountList.values().iterator();
            while (items.hasNext()) {
                AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()), sic);
                HashMap sum = this.searchGLBalance(ctx, companyOrg, account, periodYear, periodNumber, isIncludeUnposted);
                c_value = c_value.add(sum.get(sumBegin + "_GL_" + account.getNumber()) != null ? (BigDecimal)sum.get(sumBegin + "_GL_" + account.getNumber()) : this.zeroValue);
                y_value = y_value.add(sum.get(sumEnd + "_GL_" + account.getNumber()) != null ? (BigDecimal)sum.get(sumEnd + "_GL_" + account.getNumber()) : this.zeroValue);
                jf_value = jf_value.add(sum.get(sumDebit + "_GL_" + account.getNumber()) != null ? (BigDecimal)sum.get(sumDebit + "_GL_" + account.getNumber()) : this.zeroValue);
                df_value = df_value.add(sum.get(sumCredit + "_GL_" + account.getNumber()) != null ? (BigDecimal)sum.get(sumCredit + "_GL_" + account.getNumber()) : this.zeroValue);
            }
            result.put(sumBegin + "_" + accountMapSet.toArray()[setCount] + "_GL", c_value);
            result.put(sumDebit + "_" + accountMapSet.toArray()[setCount] + "_GL", jf_value);
            result.put(sumCredit + "_" + accountMapSet.toArray()[setCount] + "_GL", df_value);
            result.put(sumEnd + "_" + accountMapSet.toArray()[setCount] + "_GL", y_value);
        }
        return result;
    }

    protected HashMap searchGLSumEndBalance(Context ctx, String companyOrg, HashMap accountMap, int periodYear, int periodNumber, boolean isIncludeUnposted) throws BOSException, EASBizException {
        GlUtils.updateBalance((Context)ctx);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        BigDecimal y_value = this.zeroValue;
        Set accountMapSet = accountMap.keySet();
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        for (int setCount = 0; setCount < accountMapSet.size(); ++setCount) {
            HashMap accountList = (HashMap)accountMap.get(accountMapSet.toArray()[setCount]);
            if (accountList == null) continue;
            y_value = this.zeroValue;
            Iterator items = accountList.values().iterator();
            while (items.hasNext()) {
                AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()), sic);
                HashMap sum = this.searchGLSumEndBalance(ctx, companyOrg, account, periodYear, periodNumber, isIncludeUnposted);
                y_value = y_value.add(sum.get(sumEnd + "_GL_" + account.getNumber()) != null ? (BigDecimal)sum.get(sumEnd + "_GL_" + account.getNumber()) : this.zeroValue);
            }
            result.put(sumEnd + "_" + accountMapSet.toArray()[setCount] + "_GL", y_value);
        }
        return result;
    }

    private HashMap searchGLBalance(Context ctx, CompanyOrgUnitInfo companyOrg, AccountViewInfo account, int periodYear, int periodNumber, boolean isIncludeUnposted) throws BOSException, EASBizException {
        String foreignCurrencySU;
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        if (this.isGetLastPeriodData) {
            return result;
        }
        String currency = "GLC";
        HashMap hmResult = FaManageUtils.getFAParameter(ctx, new String[]{"GL_008"}, companyOrg.getId().toString());
        String string = foreignCurrencySU = hmResult != null && hmResult.get("GL_008") != null ? (String)hmResult.get("GL_008") : "false";
        if ("true".equalsIgnoreCase(foreignCurrencySU)) {
            CompanyOrgUnitInfo curCompanyInfo = FaManageUtils.getCurrentCompany(ctx, companyOrg.getId().toString());
            currency = curCompanyInfo.getBaseCurrency().getNumber();
        }
        result.put(sumBegin + "_GL_" + account.getNumber(), reportCacl.acct(companyOrg.getNumber(), this.parseAccountString(account.getNumber()), BalanceTypeEnum.C, periodYear, periodNumber, periodYear, periodNumber, currency, false, isIncludeUnposted, false));
        result.put(sumEnd + "_GL_" + account.getNumber(), reportCacl.acct(companyOrg.getNumber(), this.parseAccountString(account.getNumber()), BalanceTypeEnum.Y, periodYear, periodNumber, periodYear, periodNumber, currency, false, isIncludeUnposted, false));
        result.put(sumDebit + "_GL_" + account.getNumber(), reportCacl.acct(companyOrg.getNumber(), this.parseAccountString(account.getNumber()), BalanceTypeEnum.JF, periodYear, periodNumber, periodYear, periodNumber, currency, false, isIncludeUnposted, false));
        result.put(sumCredit + "_GL_" + account.getNumber(), reportCacl.acct(companyOrg.getNumber(), this.parseAccountString(account.getNumber()), BalanceTypeEnum.DF, periodYear, periodNumber, periodYear, periodNumber, currency, false, isIncludeUnposted, false));
        return result;
    }

    private HashMap searchGLSumEndBalance(Context ctx, String companyOrg, AccountViewInfo account, int periodYear, int periodNumber, boolean isIncludeUnposted) throws BOSException, EASBizException {
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        if (this.isGetLastPeriodData) {
            return result;
        }
        result.put(sumEnd + "_GL_" + account.getNumber(), reportCacl.acct(companyOrg, this.parseAccountString(account.getNumber()), BalanceTypeEnum.Y, periodYear, periodNumber, periodYear, periodNumber, "GLC", false, isIncludeUnposted, false));
        return result;
    }

    private HashMap searchGLBalance(Context ctx, CompanyOrgUnitInfo companyOrg, AccountViewCollection accounts, int periodYear, int periodNumber, boolean isIncludeUnposted) throws BOSException, EASBizException {
        String foreignCurrencySU;
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        SortedParameterArray acctParams = new SortedParameterArray();
        HashMap<String, Parameter> calcResult = new HashMap<String, Parameter>();
        String currency = "GLC";
        HashMap hmResult = FaManageUtils.getFAParameter(ctx, new String[]{"GL_008"}, companyOrg.getId().toString());
        String string = foreignCurrencySU = hmResult != null && hmResult.get("GL_008") != null ? (String)hmResult.get("GL_008") : "false";
        if ("true".equalsIgnoreCase(foreignCurrencySU)) {
            CompanyOrgUnitInfo curCompanyInfo = FaManageUtils.getCurrentCompany(ctx, companyOrg.getId().toString());
            currency = curCompanyInfo.getBaseCurrency().getNumber();
        }
        for (int i = 0; i < accounts.size(); ++i) {
            AccountViewInfo account = accounts.get(i);
            ArrayList<Variant> params = new ArrayList<Variant>();
            params.add(new Variant((Object)companyOrg.getNumber()));
            params.add(new Variant((Object)this.parseAccountString(account.getNumber())));
            params.add(new Variant((Object)BalanceTypeEnum.C));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant((Object)currency));
            Parameter parameter = new Parameter(params.toArray(), "sheet1", false);
            acctParams.insert((Object)parameter);
            calcResult.put(sumBegin + "_GL_" + account.getNumber(), parameter);
            params = new ArrayList();
            params.add(new Variant((Object)companyOrg.getNumber()));
            params.add(new Variant((Object)this.parseAccountString(account.getNumber())));
            params.add(new Variant((Object)BalanceTypeEnum.Y));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant((Object)currency));
            parameter = new Parameter(params.toArray(), "sheet1", false);
            acctParams.insert((Object)parameter);
            calcResult.put(sumEnd + "_GL_" + account.getNumber(), parameter);
            params = new ArrayList();
            params.add(new Variant((Object)companyOrg.getNumber()));
            params.add(new Variant((Object)this.parseAccountString(account.getNumber())));
            params.add(new Variant((Object)BalanceTypeEnum.JF));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant((Object)currency));
            parameter = new Parameter(params.toArray(), "sheet1", false);
            acctParams.insert((Object)parameter);
            calcResult.put(sumDebit + "_GL_" + account.getNumber(), parameter);
            params = new ArrayList();
            params.add(new Variant((Object)companyOrg.getNumber()));
            params.add(new Variant((Object)this.parseAccountString(account.getNumber())));
            params.add(new Variant((Object)BalanceTypeEnum.DF));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant((Object)currency));
            parameter = new Parameter(params.toArray(), "sheet1", false);
            acctParams.insert((Object)parameter);
            calcResult.put(sumCredit + "_GL_" + account.getNumber(), parameter);
        }
        ReportBatchCalculatorImpl calculater = new ReportBatchCalculatorImpl();
        ReportCalculateContext rptCalculater = new ReportCalculateContext(ctx);
        rptCalculater.setReportAdapter(new IReportPropertyAdapter(){
            private static final long serialVersionUID = 4036444267715695636L;

            public Object getReportProperty(String name) {
                if (name.equals("orgType")) {
                    return OrgType.Company;
                }
                return null;
            }

            public void initReportProperties(IObjectValue vo, Context ctx) {
            }
        });
        ReportVariables variables = new ReportVariables();
        if (isIncludeUnposted) {
            variables.add(VariablesHelper.createReservedEntry((String)"IncludePosted", (String)ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"75_FaContrastCaclControllerBean", (Locale)ctx.getOriginLocale()), (String)"sheet1", (String)"Y", (int)1));
        } else {
            variables.add(VariablesHelper.createReservedEntry((String)"IncludePosted", (String)ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"75_FaContrastCaclControllerBean", (Locale)ctx.getOriginLocale()), (String)"sheet1", (String)"N", (int)1));
        }
        rptCalculater.setReportVariables(variables);
        rptCalculater.setErrorProvider(new IErrorProvider(){

            public Variant getProperValue(Exception e) {
                return new Variant((Object)e);
            }
        });
        calculater.batchMethodQuery((ICalculateContextProvider)rptCalculater, "acct", acctParams);
        for (String key : calcResult.keySet()) {
            Parameter parameter = (Parameter)calcResult.get(key);
            Object val = parameter.getValue();
            if (val instanceof Exception) {
                throw new BOSException((Throwable)((Exception)val));
            }
            BigDecimal v = null;
            try {
                v = new BigDecimal(val.toString());
            }
            catch (Exception ex) {
                v = new BigDecimal(0.0);
            }
            result.put(key, v);
        }
        return result;
    }

    private HashMap faAcctNotUseCat(Context ctx, CompanyOrgUnitInfo companyOrg, HashMap accountMap, boolean isIncludeUnposted, int periodYear, int periodNumber, boolean isUseEvaValue, CurrencyInfo currency) throws BOSException, EASBizException {
        HashMap<Object, Number> result = new HashMap<Object, Number>();
        int currencyScale = currency == null ? 2 : currency.getPrecision();
        result.put("currencyScale", currencyScale);
        HashMap glValue = this.searchGLBalance(ctx, companyOrg, accountMap, periodYear, periodNumber, isIncludeUnposted);
        Set s = glValue.keySet();
        for (int number = 0; number < s.size(); ++number) {
            result.put(s.toArray()[number], ((BigDecimal)glValue.get(s.toArray()[number])).setScale(currencyScale, 4));
        }
        boolean isAssetDebit = this.isAssetAccountDebit(ctx, accountMap);
        boolean isDecCredit = this.isDecAccountCredit(ctx, accountMap);
        boolean isDepreCredit = this.isDepreAccountCredit(ctx, accountMap);
        PeriodInfo contrastPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)periodYear, (int)periodNumber, (CompanyOrgUnitInfo)companyOrg);
        String contrastPeriodId = contrastPeriodInfo.getId().toString();
        HashMap assetValue = this.searchAssetBalance(ctx, currency.getId().toString(), companyOrg.getId().toString(), contrastPeriodId, isUseEvaValue, null, null);
        s = assetValue.keySet();
        for (int number = 0; number < s.size(); ++number) {
            String key = (String)s.toArray()[number];
            if ((key.equalsIgnoreCase("sumBegin_ASSET_ASSET") || key.equalsIgnoreCase("sumEnd_ASSET_ASSET")) && !isAssetDebit || (key.equalsIgnoreCase("sumBegin_DEPRE_ASSET") || key.equalsIgnoreCase("sumEnd_DEPRE_ASSET")) && !isDepreCredit || (key.equalsIgnoreCase("sumBegin_DECVALUE_ASSET") || key.equalsIgnoreCase("sumEnd_DECVALUE_ASSET")) && !isDecCredit) {
                BigDecimal value = (BigDecimal)assetValue.get(key);
                result.put(key, value.negate().setScale(currencyScale, 4));
                continue;
            }
            result.put(key, ((BigDecimal)assetValue.get(key)).setScale(currencyScale, 4));
        }
        return result;
    }

    private HashMap faAcctUseCat(Context ctx, CompanyOrgUnitInfo companyOrg, HashMap accountMap, HashMap catMap, boolean isIncludeUnposted, int periodYear, int periodNumber, boolean isUseEvaValue, CurrencyInfo currency, String periodId) throws BOSException, EASBizException {
        GlUtils.updateBalance((Context)ctx);
        HashMap<String, Number> result = new HashMap<String, Number>();
        int currencyScale = currency == null ? 2 : currency.getPrecision();
        result.put("currencyScale", currencyScale);
        HashMap sumGL = new HashMap();
        HashMap sumFA = new HashMap();
        boolean isAssetDebit = this.isAssetAccountDebit(ctx, accountMap);
        boolean isDecCredit = this.isDecAccountCredit(ctx, accountMap);
        boolean isDepreCredit = this.isDepreAccountCredit(ctx, accountMap);
        PeriodInfo contrastPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)periodYear, (int)periodNumber, (CompanyOrgUnitInfo)companyOrg);
        String contrastPeriodId = contrastPeriodInfo.getId().toString();
        Set accountMapSet = accountMap.keySet();
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        for (int setCount = 0; setCount < accountMapSet.size(); ++setCount) {
            HashMap accountList = (HashMap)accountMap.get(accountMapSet.toArray()[setCount]);
            for (String id : accountList.values()) {
                int number;
                AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(id), sic);
                sumGL = this.searchGLBalance(ctx, companyOrg, account, periodYear, periodNumber, isIncludeUnposted);
                HashMap cats = (HashMap)catMap.get(accountMapSet.toArray()[setCount] + "_" + id);
                if (cats == null) {
                    cats = new HashMap();
                }
                Collection catListPerLine = cats.values();
                sumFA = this.searchAssetBalance(ctx, currency.getId().toString(), companyOrg.getId().toString(), contrastPeriodId, isUseEvaValue, catListPerLine, periodId);
                Set s = sumGL.keySet();
                for (number = 0; number < s.size(); ++number) {
                    result.put(s.toArray()[number] + "_" + accountMapSet.toArray()[setCount].toString(), ((BigDecimal)sumGL.get(s.toArray()[number])).setScale(currencyScale, 4));
                }
                s = sumFA.keySet();
                for (number = 0; number < s.size(); ++number) {
                    String key = (String)s.toArray()[number];
                    if ((key.equalsIgnoreCase("sumBegin_ASSET_ASSET") || key.equalsIgnoreCase("sumEnd_ASSET_ASSET")) && !isAssetDebit || (key.equalsIgnoreCase("sumBegin_DEPRE_ASSET") || key.equalsIgnoreCase("sumEnd_DEPRE_ASSET")) && !isDepreCredit || (key.equalsIgnoreCase("sumBegin_DECVALUE_ASSET") || key.equalsIgnoreCase("sumEnd_DECVALUE_ASSET")) && !isDecCredit) {
                        BigDecimal value = (BigDecimal)sumFA.get(s.toArray()[number]);
                        result.put(key + "_" + account.getNumber(), value.negate().setScale(currencyScale, 4));
                        continue;
                    }
                    result.put(key + "_" + account.getNumber(), ((BigDecimal)sumFA.get(s.toArray()[number])).setScale(currencyScale, 4));
                }
            }
        }
        return result;
    }

    protected HashMap searchAssetBalance(Context ctx, String currency, String companyOrg, String contrastPeriodId, boolean isUseEvaValue, Collection catIDList, String periodId) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        try {
            String parameter = this.genParameter(ctx, currency, companyOrg, contrastPeriodId, catIDList, periodId);
            boolean isCurrentPeriod = this.isCurrentPeriod(ctx, companyOrg, contrastPeriodId);
            ArrayList sqlList = this.getAllSql(ctx, isCurrentPeriod, companyOrg, periodId);
            for (int i = 0; i < sqlList.size(); ++i) {
                HashMap sqlMap = (HashMap)sqlList.get(i);
                String[] field = (String[])sqlMap.get("VALUE");
                StringBuffer sql = (StringBuffer)sqlMap.get("SQL");
                sql = sql.toString().indexOf("where") > -1 ? ((StringBuffer)sqlMap.get("SQL")).append(" and " + parameter) : ((StringBuffer)sqlMap.get("SQL")).append(" where " + parameter);
                ArrayList<String> para = new ArrayList<String>();
                para.add(contrastPeriodId);
                para.add(companyOrg);
                para.add(currency);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])para.toArray());
                logger.debug((Object)sql.toString());
                while (rowSet.next()) {
                    for (int j = 0; j < field.length; ++j) {
                        result.put(field[j], rowSet.getBigDecimal(field[j]) != null ? rowSet.getBigDecimal(field[j]) : this.zeroValue);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"error!");
            throw new BOSException((Throwable)e);
        }
        BigDecimal realBegin = !isUseEvaValue ? (BigDecimal)result.get(sumRealBeginBalance) : (BigDecimal)result.get(sumEvalueBeginBalance);
        result.put(sumBegin + "_ASSET_ASSET", realBegin);
        BigDecimal debit = !isUseEvaValue ? (BigDecimal)result.get(sumRealDebit) : (BigDecimal)result.get(sumEvalueDebit);
        result.put(sumDebit + "_ASSET_ASSET", debit);
        BigDecimal credit = !isUseEvaValue ? (BigDecimal)result.get(sumRealCredit) : (BigDecimal)result.get(sumEvalueCredit);
        result.put(sumCredit + "_ASSET_ASSET", credit);
        BigDecimal end = !isUseEvaValue ? (BigDecimal)result.get(sumRealEndBalance) : (BigDecimal)result.get(sumEvalueEndBalance);
        result.put(sumEnd + "_ASSET_ASSET", end);
        return result;
    }

    protected String getAssetTableName(boolean isCurrentPeriod) {
        if (isCurrentPeriod) {
            return "T_FA_FaAccountBalance Fa,T_FA_FaCurcard Card,T_FA_Cat Cat";
        }
        return "T_FA_FaAccountBalance Fa,T_FA_FaMoncard Card,T_FA_Cat Cat";
    }

    protected String getAssetTableNameForCat(Context ctx, boolean isCurrentPeriod, String companyOrg, String periodId) throws EASBizException, BOSException {
        if (isCurrentPeriod || this.isGetLastPeriodData && this.isCurrentPeriod(ctx, companyOrg, periodId)) {
            return "T_FA_FaAccountBalance Fa,T_FA_FaCurcard Card,T_FA_Cat Cat";
        }
        return "T_FA_FaAccountBalance Fa,T_FA_FaMoncard Card,T_FA_Cat Cat";
    }

    protected String genParameter(Context ctx, String currency, String companyOrg, String contrastPeriodId, Collection catIDList, String periodId) throws EASBizException, BOSException {
        String result = null;
        result = this.isCurrentPeriod(ctx, companyOrg, contrastPeriodId) || this.isGetLastPeriodData && this.isCurrentPeriod(ctx, companyOrg, periodId) ? " Fa.FPeriodID=? and Fa.FCompanyOrgUnitID=? and Fa.FCurrencyID=? and Fa.FFaCurCardID=Card.FID and Fa.FCompanyOrgUnitID=Card.FCompanyID and Card.FAssetCatID=Cat.FID and Cat.FCompanyID=Fa.FCompanyOrgUnitID " : (this.isGetLastPeriodData ? " Fa.FPeriodID=? and Fa.FCompanyOrgUnitID=? and Fa.FCurrencyID=? and Fa.FFaCurCardID=Card.FfaCurcardId and Fa.FCompanyOrgUnitID=Card.FCompanyID and Card.Ffaperiodid='" + periodId + "' and Card.FAssetCatID=Cat.FID and Cat.FCompanyID=Fa.FCompanyOrgUnitID " : " Fa.FPeriodID=? and Fa.FCompanyOrgUnitID=? and Fa.FCurrencyID=? and Fa.FFaCurCardID=Card.FfaCurcardId and Fa.FCompanyOrgUnitID=Card.FCompanyID and Card.Ffaperiodid=Fa.FPeriodID and Card.FAssetCatID=Cat.FID and Cat.FCompanyID=Fa.FCompanyOrgUnitID ");
        if (catIDList == null || catIDList.size() == 0) {
            return result;
        }
        String idInFilter = this.getFaCatIdFilter(ctx, companyOrg, catIDList);
        if (idInFilter.length() > 0) {
            result = result + " and Cat.FID in (" + idInFilter + ") ";
        }
        return result;
    }

    private String getFaCatIdFilter(Context ctx, String companyId, Collection catIDList) throws BOSException {
        StringBuffer result = new StringBuffer();
        ArrayList<String> para = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select t.fid from ( ");
        Iterator catIterator = catIDList.iterator();
        int i = 0;
        while (catIterator.hasNext()) {
            String catId = catIterator.next().toString();
            if (i > 0) {
                sql.append(" union \n");
            }
            ++i;
            sql.append(" ( select cat.fid fid, cat.FLONGNUMBER flongnumber from t_fa_cat cat where cat.fcompanyid = ? \n");
            sql.append(" and ( charindex(select Flongnumber || '!' from T_FA_Cat where fid = ? , cat.flongnumber) = 1  )  \n");
            sql.append(" union \n");
            sql.append(" SELECT cat.fid fid,  cat.FLONGNUMBER flongnumber  FROM  T_FA_Cat cat where cat.fid = ? ) \n");
            para.add(companyId);
            para.add(catId);
            para.add(catId);
        }
        sql.append(" ) t order by t.flongnumber asc ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])para.toArray());
        try {
            while (rs != null && rs.next()) {
                result.append("'").append(rs.getString("fid")).append("',");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result.length() == 0 ? "''" : result.substring(0, result.length() - 1);
    }

    protected ArrayList getAllSql(Context ctx, boolean isCurrentPeriod, String companyOrg, String periodId) throws EASBizException, BOSException {
        ArrayList result = new ArrayList();
        HashMap<String, Object> mapSum = new HashMap<String, Object>();
        mapSum.put("SQL", this.genSUMSQL(ctx, isCurrentPeriod, companyOrg, periodId));
        String[] fieldSum = new String[]{sumRealBeginBalance, sumEvalueBeginBalance, sumRealDebit, sumEvalueDebit, sumRealCredit, sumEvalueCredit, sumRealEndBalance, sumEvalueEndBalance, sumDepreBeginBalanceFor, sumDepreDebitFor, sumDepreCreditFor, sumDepreEndBalanceFor, sumDecValueBeginBalanceFor, sumDecValueDebitFor, sumDecValueCreditFor, sumDecValueEndBalanceFor};
        mapSum.put("VALUE", fieldSum);
        result.add(mapSum);
        return result;
    }

    protected StringBuffer genRealBeginBalanceSQL() {
        return new StringBuffer("select SUM(Fa.FRealBeginBalanceFor) " + sumRealBeginBalance + " from " + this.getAssetTableName(false));
    }

    protected StringBuffer genEvalueBeginBalanceSQL() {
        return new StringBuffer("select SUM(Fa.FEvalueBeginBalanceFor) " + sumEvalueBeginBalance + " from " + this.getAssetTableName(false));
    }

    protected StringBuffer genRealDebitSQL() {
        return new StringBuffer("select SUM(Fa.FRealDebitFor) " + sumRealDebit + " from " + this.getAssetTableName(false));
    }

    protected StringBuffer genEvalueDebitSQL() {
        return new StringBuffer("select SUM(Fa.FEvalueDebitFor) " + sumEvalueDebit + " from " + this.getAssetTableName(false));
    }

    protected StringBuffer genRealCreditSQL() {
        return new StringBuffer("select SUM(Fa.FRealCreditFor) " + sumRealCredit + " from " + this.getAssetTableName(false));
    }

    protected StringBuffer genEvalueCreditSQL() {
        return new StringBuffer("select SUM(Fa.FEvalueCreditFor) " + sumEvalueCredit + " from " + this.getAssetTableName(false));
    }

    protected StringBuffer genRealEndBalanceSQL() {
        return new StringBuffer("select SUM(Fa.FRealEndBalanceFor) " + sumRealEndBalance + " from " + this.getAssetTableName(false));
    }

    protected StringBuffer genEvalueEndBalanceSQL() {
        return new StringBuffer("select SUM(Fa.FEvalueEndBalanceFor) " + sumEvalueEndBalance + " from " + this.getAssetTableName(false));
    }

    protected StringBuffer genSUMSQL(Context ctx, boolean isCurrentPeriod, String companyOrg, String periodId) throws EASBizException, BOSException {
        return new StringBuffer("select SUM(Fa.FRealBeginBalanceFor) " + sumRealBeginBalance + ",SUM(Fa.FEvalueBeginBalanceFor) " + sumEvalueBeginBalance + ",SUM(Fa.FRealDebitFor) " + sumRealDebit + ",SUM(Fa.FEvalueDebitFor) " + sumEvalueDebit + ",SUM(Fa.FRealCreditFor) " + sumRealCredit + ",SUM(Fa.FEvalueCreditFor) " + sumEvalueCredit + ",SUM(Fa.FRealEndBalanceFor) " + sumRealEndBalance + ",SUM(Fa.FEvalueEndBalanceFor) " + sumEvalueEndBalance + ",SUM(Fa.FDepreBeginBalanceFor) " + sumDepreBeginBalanceFor + ",SUM(Fa.FDepreDebitFor) " + sumDepreDebitFor + ",SUM(Fa.FDepreCreditFor) " + sumDepreCreditFor + ",SUM(Fa.FDepreEndBalanceFor) " + sumDepreEndBalanceFor + ",SUM(Fa.FDecValueBeginBalanceFor) " + sumDecValueBeginBalanceFor + ",SUM(Fa.FDecValueDebitFor) " + sumDecValueDebitFor + ",SUM(Fa.FDecValueCreditFor) " + sumDecValueCreditFor + ",SUM(Fa.FDecValueEndBalanceFor) " + sumDecValueEndBalanceFor + " from " + this.getAssetTableNameForCat(ctx, isCurrentPeriod, companyOrg, periodId));
    }

    @Override
    protected HashMap _faAcctDetail(Context ctx, String companyId, HashMap accountMap, boolean isIncludeUnposted, int periodYear, int periodNumber, boolean isUseEvaValue) throws BOSException, EASBizException {
        if (this.topAccountMap == null) {
            this.topAccountMap = new HashMap(accountMap);
        }
        HashMap result = this.faAcctDetailData(ctx, companyId, accountMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue);
        PeriodInfo startPeriodInfo = this.getPrePeriod(ctx, companyId);
        int startYear = startPeriodInfo.getPeriodYear();
        int startNumber = startPeriodInfo.getPeriodNumber();
        PeriodTypeInfo periodTypeInfo = startPeriodInfo.getPeriodType();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo curPeriodInfo = iPeriod.getPeriodInfo(periodYear, periodNumber, periodTypeInfo);
        if (startYear != periodYear || startNumber != periodNumber) {
            PeriodInfo lastPeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)curPeriodInfo);
            if (lastPeriodInfo != null) {
                int lastYear = lastPeriodInfo.getPeriodYear();
                int lastNumber = lastPeriodInfo.getPeriodNumber();
                HashMap accountHashMap = new HashMap(this.topAccountMap);
                HashMap lastResult = this.faAcctDetailData(ctx, companyId, accountHashMap, isIncludeUnposted, lastYear, lastNumber, isUseEvaValue);
                result = this.replaceBegin(result, lastResult);
            }
        } else {
            this.calculateDebitAndCredit(ctx, curPeriodInfo, companyId, result, false);
        }
        return result;
    }

    private void calculateDebitAndCredit(Context ctx, PeriodInfo curPeriodInfo, String companyId, HashMap result, boolean isFromFaAcct) throws EASBizException, BOSException {
        int currencyScale = (Integer)result.get("currencyScale");
        FaChangeBillCollection collection = this.getChangeBillCollection(ctx, curPeriodInfo, companyId);
        HashMap<String, BigDecimal> assetDebitMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> assetCreditMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> deprDebitMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> deprCreditMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> decDebitMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> decCreditMap = new HashMap<String, BigDecimal>();
        HashMap<String, AccountViewInfo> accountMap = new HashMap<String, AccountViewInfo>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            FaChangeBillInfo info = (FaChangeBillInfo)iterator.next();
            FaChangeBillEntryInfo entry = info.getChangeBillEntry().get(0);
            FaBizCardInfo bizCard = entry.getBizCard();
            FaBakCardInfo bakCard = bizCard.getFaBakCard();
            AccountViewInfo assetAccountBiz = bizCard.getAccountAsset();
            AccountViewInfo assetAccountBak = bakCard.getAccountAsset();
            if (!assetAccountBiz.getId().toString().equals(assetAccountBak.getId().toString())) {
                BigDecimal assetValue = bakCard.getAssetValue().setScale(currencyScale, 4);
                this.putAmount4AllAccountViews(ctx, assetAccountBak, assetValue, assetCreditMap, accountMap);
                this.putAmount4AllAccountViews(ctx, assetAccountBiz, assetValue, assetDebitMap, accountMap);
            }
            AccountViewInfo deprAccountBiz = bizCard.getAccountAccuDepr();
            AccountViewInfo deprAccountBak = bakCard.getAccountAccuDepr();
            if (!deprAccountBiz.getId().toString().equals(deprAccountBak.getId().toString())) {
                BigDecimal accuDepr = bakCard.getAccuDepr().setScale(currencyScale, 4);
                this.putAmount4AllAccountViews(ctx, deprAccountBak, accuDepr, deprDebitMap, accountMap);
                this.putAmount4AllAccountViews(ctx, deprAccountBiz, accuDepr, deprCreditMap, accountMap);
            }
            AccountViewInfo decAccountBiz = bizCard.getAccountDecValue();
            AccountViewInfo decAccountBak = bakCard.getAccountDecValue();
            String decAccountBakId = "";
            String decAccountBizId = "";
            if (decAccountBak != null && decAccountBak.getId() != null) {
                decAccountBakId = decAccountBak.getId().toString();
            }
            if (decAccountBiz != null && decAccountBiz.getId() != null) {
                decAccountBizId = decAccountBiz.getId().toString();
            }
            if (decAccountBakId.length() <= 0 || decAccountBizId.length() <= 0 || decAccountBizId.equals(decAccountBakId)) continue;
            BigDecimal decValue = bakCard.getDecValue().setScale(currencyScale, 4);
            this.putAmount4AllAccountViews(ctx, decAccountBak, decValue, decDebitMap, accountMap);
            this.putAmount4AllAccountViews(ctx, decAccountBiz, decValue, decCreditMap, accountMap);
        }
        this.putNumber2Result(result, assetDebitMap, assetCreditMap, deprDebitMap, deprCreditMap, decDebitMap, decCreditMap, accountMap, isFromFaAcct);
    }

    private void putAmount4AllAccountViews(Context ctx, AccountViewInfo accountView, BigDecimal amount, HashMap map, HashMap<String, AccountViewInfo> accountMap) throws EASBizException, BOSException {
        this.addUpNumber(map, accountView.getId().toString(), amount);
        accountMap.put(accountView.getId().toString(), accountView);
        AccountViewInfo parent = accountView.getParent();
        while (parent != null) {
            String parentId = parent.getId().toString();
            this.addUpNumber(map, parentId, amount);
            accountMap.put(parentId, parent);
            String parentOql = " select number, name, parent.id, parent.number, parent.name where id = '" + parentId + "' ";
            AccountViewInfo accountWithParent = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo(parentOql);
            parent = accountWithParent.getParent();
            if (parent == null) continue;
            parentId = parent.getId().toString();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void putNumber2Result(HashMap result, HashMap<String, BigDecimal> assetDebitMap, HashMap<String, BigDecimal> assetCreditMap, HashMap<String, BigDecimal> deprDebitMap, HashMap<String, BigDecimal> deprCreditMap, HashMap<String, BigDecimal> decDebitMap, HashMap<String, BigDecimal> decCreditMap, HashMap<String, AccountViewInfo> accountMap, boolean isFromFaAcct) {
        void var13_20;
        BigDecimal resultValue;
        BigDecimal value;
        String resultKey;
        AccountViewInfo accountView;
        BigDecimal resultValue2;
        BigDecimal resultValue3;
        String sumBeginAssetNumber = "ASSET_sumBegin_ASSET_";
        String accountNumber = "ASSET_sumDebit_ASSET_";
        if (isFromFaAcct) {
            sumBeginAssetNumber = "sumBegin_ASSET_ASSET_";
            accountNumber = "sumDebit_ASSET_ASSET_";
        }
        for (String string : assetDebitMap.keySet()) {
            AccountViewInfo accountView3 = accountMap.get(string);
            String resultKey3 = accountNumber + accountView3.getNumber();
            BigDecimal value3 = assetDebitMap.get(string);
            if (result.containsKey(resultKey3)) {
                BigDecimal resultValue32 = (BigDecimal)result.get(resultKey3);
                resultValue32 = resultValue32.add(value3);
                result.put(resultKey3, resultValue32);
            }
            if (!result.containsKey(resultKey3 = sumBeginAssetNumber + accountView3.getNumber())) continue;
            resultValue3 = (BigDecimal)result.get(resultKey3);
            resultValue3 = resultValue3.subtract(value3);
            result.put(resultKey3, resultValue3);
        }
        accountNumber = "ASSET_sumCredit_ASSET_";
        if (isFromFaAcct) {
            accountNumber = "sumCredit_ASSET_ASSET_";
        }
        for (String string : assetCreditMap.keySet()) {
            AccountViewInfo accountView2 = accountMap.get(string);
            String resultKey2 = accountNumber + accountView2.getNumber();
            BigDecimal value2 = assetCreditMap.get(string);
            if (result.containsKey(resultKey2)) {
                resultValue3 = (BigDecimal)result.get(resultKey2);
                resultValue3 = resultValue3.add(value2);
                result.put(resultKey2, resultValue3);
            }
            if (!result.containsKey(resultKey2 = sumBeginAssetNumber + accountView2.getNumber())) continue;
            resultValue3 = (BigDecimal)result.get(resultKey2);
            resultValue3 = resultValue3.add(value2);
            result.put(resultKey2, resultValue3);
        }
        accountNumber = "DECVALUE_sumDebit_ASSET_";
        String sumBeginDecValueNumber = "DECVALUE_sumBegin_ASSET_";
        if (isFromFaAcct) {
            accountNumber = "sumDebit_DEPRE_ASSET_";
            sumBeginDecValueNumber = "sumBegin_DEPRE_ASSET_";
        }
        for (String key : deprDebitMap.keySet()) {
            AccountViewInfo accountView2 = accountMap.get(key);
            String resultKey2 = accountNumber + accountView2.getNumber();
            BigDecimal value2 = deprDebitMap.get(key);
            if (result.containsKey(resultKey2)) {
                BigDecimal resultValue22 = (BigDecimal)result.get(resultKey2);
                resultValue22 = resultValue22.add(value2);
                result.put(resultKey2, resultValue22);
            }
            if (!result.containsKey(resultKey2 = sumBeginDecValueNumber + accountView2.getNumber())) continue;
            resultValue2 = (BigDecimal)result.get(resultKey2);
            resultValue2 = resultValue2.add(value2);
            result.put(resultKey2, resultValue2);
        }
        accountNumber = "DECVALUE_sumCredit_ASSET_";
        if (isFromFaAcct) {
            accountNumber = "sumCredit_DEPRE_ASSET_";
        }
        for (String key : deprCreditMap.keySet()) {
            AccountViewInfo accountView3 = accountMap.get(key);
            String resultKey3 = accountNumber + accountView3.getNumber();
            BigDecimal value3 = deprCreditMap.get(key);
            if (result.containsKey(resultKey3)) {
                resultValue2 = (BigDecimal)result.get(resultKey3);
                resultValue2 = resultValue2.add(value3);
                result.put(resultKey3, resultValue2);
            }
            if (!result.containsKey(resultKey3 = sumBeginDecValueNumber + accountView3.getNumber())) continue;
            resultValue2 = (BigDecimal)result.get(resultKey3);
            resultValue2 = resultValue2.subtract(value3);
            result.put(resultKey3, resultValue2);
        }
        accountNumber = "DEPRE_sumDebit_ASSET_";
        String string = "DEPRE_sumBegin_ASSET_";
        if (isFromFaAcct) {
            accountNumber = "sumDebit_DECVALUE_ASSET_";
            String string2 = "sumBegin_DECVALUE_ASSET_";
        }
        for (String key : decDebitMap.keySet()) {
            accountView = accountMap.get(key);
            resultKey = accountNumber + accountView.getNumber();
            value = decDebitMap.get(key);
            if (result.containsKey(resultKey)) {
                resultValue = (BigDecimal)result.get(resultKey);
                resultValue = resultValue.add(value);
                result.put(resultKey, resultValue);
            }
            if (!result.containsKey(resultKey = (String)var13_20 + accountView.getNumber())) continue;
            resultValue = (BigDecimal)result.get(resultKey);
            resultValue = resultValue.add(value);
            result.put(resultKey, resultValue);
        }
        accountNumber = "DEPRE_sumCredit_ASSET_";
        if (isFromFaAcct) {
            accountNumber = "sumCredit_DECVALUE_ASSET_";
        }
        for (String key : decCreditMap.keySet()) {
            accountView = accountMap.get(key);
            resultKey = accountNumber + accountView.getNumber();
            value = decCreditMap.get(key);
            if (result.containsKey(resultKey)) {
                resultValue = (BigDecimal)result.get(resultKey);
                resultValue = resultValue.add(value);
                result.put(resultKey, resultValue);
            }
            if (!result.containsKey(resultKey = (String)var13_20 + accountView.getNumber())) continue;
            resultValue = (BigDecimal)result.get(resultKey);
            resultValue = resultValue.subtract(value);
            result.put(resultKey, resultValue);
        }
    }

    private void addUpNumber(HashMap<String, BigDecimal> map, String accountViewId, BigDecimal amount) {
        if (map.containsKey(accountViewId)) {
            BigDecimal value = map.get(accountViewId);
            BigDecimal addUpValue = value.add(amount);
            map.put(accountViewId, addUpValue);
        } else {
            map.put(accountViewId, amount);
        }
    }

    private FaChangeBillCollection getChangeBillCollection(Context ctx, PeriodInfo curPeriodInfo, String companyId) throws EASBizException, BOSException {
        FaChangeBillCollection collection = null;
        EntityViewInfo entityView = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("changeBillEntry.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountAsset.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountAsset.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountAsset.name"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountAsset.parent.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountAsset.parent.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountAsset.parent.name"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountAccuDepr.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountAccuDepr.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountAccuDepr.name"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountAccuDepr.parent.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountAccuDepr.parent.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountAccuDepr.parent.name"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountDecValue.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountDecValue.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountDecValue.name"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountDecValue.parent.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountDecValue.parent.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accountDecValue.parent.name"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.assetValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.accuDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.decValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAsset.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAsset.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAsset.name"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAsset.parent.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAsset.parent.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAsset.parent.name"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAccuDepr.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAccuDepr.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAccuDepr.name"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAccuDepr.parent.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAccuDepr.parent.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountAccuDepr.parent.name"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountDecValue.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountDecValue.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountDecValue.name"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountDecValue.parent.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountDecValue.parent.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accountDecValue.parent.name"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.assetValue"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.accuDepr"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.decValue"));
        entityView.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)curPeriodInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)2));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("blockedStatus", (Object)1));
        entityView.setFilter(filter);
        collection = FaChangeBillFactory.getLocalInstance(ctx).getChangeCollectionBySelector(entityView);
        return collection;
    }

    protected HashMap faAcctDetailData(Context ctx, String companyId, HashMap accountMap, boolean isIncludeUnposted, int periodYear, int periodNumber, boolean isUseEvaValue) throws BOSException, EASBizException {
        int number;
        Set s;
        List accountList;
        String PREFIX;
        int i;
        GlUtils.updateBalance((Context)ctx);
        LinkedHashMap<String, Serializable> result = new LinkedHashMap<String, Serializable>();
        CompanyOrgUnitInfo companyOrg = FaManageUtils.getCurrentCompany(ctx, companyId);
        CurrencyInfo currency = companyOrg.getBaseCurrency();
        int currencyScale = currency == null ? 2 : currency.getPrecision();
        result.put("currencyScale", Integer.valueOf(currencyScale));
        HashMap sumGL = new HashMap();
        HashMap sumFA = new HashMap();
        boolean isAssetDebit = this.isAssetAccountDebit(ctx, accountMap);
        boolean isDecCredit = this.isDecAccountCredit(ctx, accountMap);
        boolean isDepreCredit = this.isDepreAccountCredit(ctx, accountMap);
        this.getAllChildAccount(ctx, accountMap, companyOrg);
        ArrayList list = new ArrayList();
        list.add(accountMap.get("ASSET"));
        list.add(accountMap.get("DEPRE"));
        list.add(accountMap.get("DECVALUE"));
        for (i = 0; i < list.size(); ++i) {
            PREFIX = i == 0 ? "ASSET_" : (i == 1 ? "DECVALUE_" : "DEPRE_");
            accountList = (List)list.get(i);
            Iterator items = accountList.iterator();
            AccountViewCollection accounts = new AccountViewCollection();
            while (items.hasNext()) {
                accounts.add((AccountViewInfo)items.next());
            }
            sumGL = this.searchGLBalance(ctx, companyOrg, accounts, periodYear, periodNumber, isIncludeUnposted);
            s = sumGL.keySet();
            for (number = 0; number < s.size(); ++number) {
                result.put(PREFIX + s.toArray()[number], ((BigDecimal)sumGL.get(s.toArray()[number])).setScale(currencyScale, 4));
            }
        }
        for (i = 0; i < list.size(); ++i) {
            PREFIX = i == 0 ? "ASSET_" : (i == 1 ? "DECVALUE_" : "DEPRE_");
            accountList = (List)list.get(i);
            for (AccountViewInfo account : accountList) {
                sumFA = this.searchAssetBalance(ctx, currency.getId().toString(), companyOrg.getId().toString(), periodYear, periodNumber, isUseEvaValue, account, i);
                s = sumFA.keySet();
                for (number = 0; number < s.size(); ++number) {
                    BigDecimal v;
                    String key = (String)s.toArray()[number];
                    BigDecimal value = (BigDecimal)sumFA.get(s.toArray()[number]);
                    if ((key.equalsIgnoreCase("sumBegin_ASSET_ASSET") || key.equalsIgnoreCase("sumEnd_ASSET_ASSET")) && !isAssetDebit || (key.equalsIgnoreCase("sumBegin_DEPRE_ASSET") || key.equalsIgnoreCase("sumEnd_DEPRE_ASSET")) && !isDepreCredit || (key.equalsIgnoreCase("sumBegin_DECVALUE_ASSET") || key.equalsIgnoreCase("sumEnd_DECVALUE_ASSET")) && !isDecCredit) {
                        if (result.containsKey(PREFIX + key)) {
                            v = (BigDecimal)((HashMap)result).get(PREFIX + key);
                            result.put(PREFIX + key, v.add(value.negate().setScale(currencyScale, 4)));
                            continue;
                        }
                        result.put(PREFIX + key, value.negate().setScale(currencyScale, 4));
                        continue;
                    }
                    if (result.containsKey(PREFIX + key)) {
                        v = (BigDecimal)((HashMap)result).get(PREFIX + key);
                        result.put(PREFIX + key, v.add(value.setScale(currencyScale, 4)));
                        continue;
                    }
                    result.put(PREFIX + key, value.setScale(currencyScale, 4));
                }
            }
        }
        result.put("AccountMap", list);
        return result;
    }

    private void getAllChildAccount(Context ctx, HashMap accountMap, CompanyOrgUnitInfo companyOrg) throws BOSException, EASBizException {
        AccountViewInfo _acct;
        String id;
        Comparator comparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                AccountViewInfo v1 = (AccountViewInfo)arg0;
                AccountViewInfo v2 = (AccountViewInfo)arg1;
                return v1.getLongNumber().compareTo(v2.getLongNumber());
            }
        };
        HashMap assetAccount = (HashMap)accountMap.get("ASSET");
        HashMap decAccount = (HashMap)accountMap.get("DECVALUE");
        HashMap depreAccount = (HashMap)accountMap.get("DEPRE");
        String fi = companyOrg.getId().toString();
        String accountTable = companyOrg.getAccountTable().getId().toString();
        IAccountView iAcct = AccountViewFactory.getLocalInstance((Context)ctx);
        AccountViewCollection accts = new AccountViewCollection();
        for (Map.Entry entry : assetAccount.entrySet()) {
            String id2 = (String)entry.getValue();
            AccountViewInfo _acct2 = iAcct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(id2));
            accts.addCollection(iAcct.getAccountViewCollection("select id,number,name,longnumber,longName where companyID.id='" + fi + "' and accountTableID.id = '" + accountTable + "' and (longNumber like '" + _acct2.getLongNumber() + "' or longNumber like '" + _acct2.getLongNumber() + "!%')"));
        }
        List<Object> list = Arrays.asList(accts.toArray());
        Collections.sort(list, comparator);
        accountMap.put("ASSET", list);
        accts = new AccountViewCollection();
        for (Map.Entry entry : decAccount.entrySet()) {
            id = (String)entry.getValue();
            _acct = iAcct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(id));
            accts.addCollection(iAcct.getAccountViewCollection("select id,number,name,longnumber,longName where companyID.id='" + fi + "'  and accountTableID.id = '" + accountTable + "' and (longNumber like '" + _acct.getLongNumber() + "' or longNumber like '" + _acct.getLongNumber() + "!%')"));
        }
        list = Arrays.asList(accts.toArray());
        Collections.sort(list, comparator);
        accountMap.put("DECVALUE", list);
        accts = new AccountViewCollection();
        for (Map.Entry entry : depreAccount.entrySet()) {
            id = (String)entry.getValue();
            _acct = iAcct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(id));
            accts.addCollection(iAcct.getAccountViewCollection("select id,number,name,longnumber,longName where companyID.id='" + fi + "' and  accountTableID.id = '" + accountTable + "' and (longNumber like '" + _acct.getLongNumber() + "' or longNumber like '" + _acct.getLongNumber() + "!%')"));
        }
        list = Arrays.asList(accts.toArray());
        Collections.sort(list, comparator);
        accountMap.put("DEPRE", list);
    }

    private HashMap searchAssetBalance(Context ctx, String currencyId, String companyId, int periodYear, int periodNumber, boolean isUseEvaValue, AccountViewInfo acct, int acctIndex) throws BOSException, EASBizException {
        StringBuffer s = new StringBuffer();
        s.append("select SUM(Fa.FRealBeginBalanceFor) sumRealBeginBalance,        ");
        s.append("       SUM(Fa.FEvalueBeginBalanceFor) sumEvalueBeginBalance,    ");
        s.append("       SUM(Fa.FRealDebitFor) sumRealDebit,                      ");
        s.append("       SUM(Fa.FEvalueDebitFor) sumEvalueDebit,                  ");
        s.append("       SUM(Fa.FRealCreditFor) sumRealCredit,                    ");
        s.append("       SUM(Fa.FEvalueCreditFor) sumEvalueCredit,                ");
        s.append("       SUM(Fa.FRealEndBalanceFor) sumRealEndBalance,            ");
        s.append("       SUM(Fa.FEvalueEndBalanceFor) sumEvalueEndBalance,        ");
        s.append("       SUM(Fa.FDepreBeginBalanceFor) sumBegin_DEPRE_ASSET,      ");
        s.append("       SUM(Fa.FDepreDebitFor) sumDebit_DEPRE_ASSET,             ");
        s.append("       SUM(Fa.FDepreCreditFor) sumCredit_DEPRE_ASSET,           ");
        s.append("       SUM(Fa.FDepreEndBalanceFor) sumEnd_DEPRE_ASSET,          ");
        s.append("       SUM(Fa.FDecValueBeginBalanceFor) sumBegin_DECVALUE_ASSET,");
        s.append("       SUM(Fa.FDecValueDebitFor) sumDebit_DECVALUE_ASSET,       ");
        s.append("       SUM(Fa.FDecValueCreditFor) sumCredit_DECVALUE_ASSET,     ");
        s.append("       SUM(Fa.FDecValueEndBalanceFor) sumEnd_DECVALUE_ASSET     ");
        s.append("  from T_FA_FaAccountBalance Fa,                                ");
        s.append("       T_Bd_Period           Pd,                                ");
        if (this.isCurrentPeriod(ctx, companyId, periodYear, periodNumber)) {
            s.append("       T_FA_FaCurcard        Card,                              ");
        } else {
            s.append("       T_FA_FaMoncard        Card,                              ");
        }
        s.append("       t_Bd_Accountview      Acct                               ");
        s.append(" where Fa.FPeriodID = Pd.FID                                    ");
        s.append("   and Pd.FPeriodYear = ?                                       ");
        s.append("   and Pd.FPeriodNumber = ?                                     ");
        s.append("   and Fa.FCompanyOrgUnitID = ?                                 ");
        s.append("   and Fa.FCurrencyID = ?                                       ");
        if (this.isCurrentPeriod(ctx, companyId, periodYear, periodNumber)) {
            s.append("   and Fa.FFaCurCardID = Card.FID                               ");
        } else {
            s.append("   and Fa.FFaCurCardID = Card.FfacurcardId and   Card.Ffaperiodid=  Pd.FID     ");
        }
        if (acctIndex == 0) {
            s.append("   and Card.Faccountassetid = Acct.Fid                          ");
        } else if (acctIndex == 1) {
            s.append("   and Card.Faccountaccudeprid = Acct.Fid                       ");
        } else {
            s.append("   and Card.Faccountdecvalueid = Acct.fid                       ");
        }
        s.append("   and (Acct.Flongnumber = ? or Acct.Flongnumber like ?)        ");
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        try {
            ArrayList<Object> para = new ArrayList<Object>();
            para.add(new Integer(periodYear));
            para.add(new Integer(periodNumber));
            para.add(companyId);
            para.add(currencyId);
            para.add(acct.getLongNumber());
            para.add(acct.getLongNumber() + "!%");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)s.toString(), (Object[])para.toArray());
            String[] field = new String[]{sumRealBeginBalance, sumEvalueBeginBalance, sumRealDebit, sumEvalueDebit, sumRealCredit, sumEvalueCredit, sumRealEndBalance, sumEvalueEndBalance, sumDepreBeginBalanceFor, sumDepreDebitFor, sumDepreCreditFor, sumDepreEndBalanceFor, sumDecValueBeginBalanceFor, sumDecValueDebitFor, sumDecValueCreditFor, sumDecValueEndBalanceFor};
            while (rowSet.next()) {
                for (int j = 0; j < field.length; ++j) {
                    result.put(field[j], rowSet.getBigDecimal(j + 1) != null ? rowSet.getBigDecimal(j + 1) : this.zeroValue);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (acctIndex == 0) {
            BigDecimal realBegin = !isUseEvaValue ? (BigDecimal)result.get(sumRealBeginBalance) : (BigDecimal)result.get(sumEvalueBeginBalance);
            result.put(sumBegin + "_ASSET_" + acct.getNumber(), realBegin);
            BigDecimal debit = !isUseEvaValue ? (BigDecimal)result.get(sumRealDebit) : (BigDecimal)result.get(sumEvalueDebit);
            result.put(sumDebit + "_ASSET_" + acct.getNumber(), debit);
            BigDecimal credit = !isUseEvaValue ? (BigDecimal)result.get(sumRealCredit) : (BigDecimal)result.get(sumEvalueCredit);
            result.put(sumCredit + "_ASSET_" + acct.getNumber(), credit);
            BigDecimal end = !isUseEvaValue ? (BigDecimal)result.get(sumRealEndBalance) : (BigDecimal)result.get(sumEvalueEndBalance);
            result.put(sumEnd + "_ASSET_" + acct.getNumber(), end);
        } else if (acctIndex == 1) {
            result.put(sumBegin + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDepreBeginBalanceFor));
            result.put(sumDebit + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDepreDebitFor));
            result.put(sumCredit + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDepreCreditFor));
            result.put(sumEnd + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDepreEndBalanceFor));
        } else {
            result.put(sumBegin + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDecValueBeginBalanceFor));
            result.put(sumDebit + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDecValueDebitFor));
            result.put(sumCredit + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDecValueCreditFor));
            result.put(sumEnd + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDecValueEndBalanceFor));
        }
        return result;
    }

    @Override
    protected Map _getZipDataForRPC(Context ctx, List params) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)params.get(0);
        if (comp.getInvalidDate() != null && DateTimeUtils.dayBefore((Date)comp.getInvalidDate(), (Date)new Date())) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Company_Disabled", (Locale)ctx.getOriginLocale());
            throw new EASBizException(new NumericExceptionSubItem("001", strMsg));
        }
        if (!comp.isIsBizUnit()) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.vitualComNotAllowUseThisFun", (Locale)ctx.getOriginLocale());
            throw new EASBizException(new NumericExceptionSubItem("001", strMsg));
        }
        String companyId = comp.getId().toString();
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (IObjectPK)new ObjectUuidPK(companyId));
        if (startPeriod == null) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.FaCurCardEditUI_FANotEndInit", (Locale)ctx.getOriginLocale());
            throw new EASBizException(new NumericExceptionSubItem("001", strMsg));
        }
        result.put("startPeriod", startPeriod);
        PeriodInfo[] periods = FaPeriodCloseFacadeFactory.getLocalInstance(ctx).getLastestPeriod(companyId);
        result.put("currPeriod", periods[1]);
        result.put("lastestPeriod", periods[0]);
        for (int i = startPeriod.getPeriodYear(); i <= periods[0].getPeriodYear(); ++i) {
            int max = PeriodUtils.getMaxPeriodNumber((Context)ctx, (int)i, (IObjectPK)new ObjectUuidPK(companyId));
            int min = PeriodUtils.getMinPeriodNumber((Context)ctx, (int)i, (IObjectPK)new ObjectUuidPK(companyId));
            result.put("maxNumber" + i, new Integer(max));
            result.put("minNumber" + i, new Integer(min));
        }
        return result;
    }

    private boolean isCurrentPeriod(Context ctx, String companyId, String contrastPeriodId) throws EASBizException, BOSException {
        PeriodInfo curPeriodInfo = FaLocalUtils.getCurrentPeriod(ctx, companyId);
        return contrastPeriodId.equals(curPeriodInfo.getId().toString());
    }

    private boolean isCurrentPeriod(Context ctx, String companyId, int periodYear, int periodNumber) throws EASBizException, BOSException {
        PeriodInfo periodInfo = FaLocalUtils.getCurrentPeriod(ctx, companyId);
        return periodInfo.getPeriodYear() == periodYear && periodInfo.getPeriodNumber() == periodNumber;
    }

    private HashMap replaceBegin(HashMap currentResult, HashMap lastResult) {
        HashMap newResult = currentResult;
        Set curResultKeySet = currentResult.keySet();
        Set lastResultKeySet = lastResult.keySet();
        for (int setCount = curResultKeySet.size() - 1; setCount >= 0; --setCount) {
            BigDecimal newCredit;
            BigDecimal oldCredit;
            String creditKey;
            String creditKey_0;
            BigDecimal newDebit;
            BigDecimal oldDebit;
            String debitKey;
            String debitKey_0;
            String curKey = curResultKeySet.toArray()[setCount].toString();
            if (curKey.indexOf("Begin") == -1 || curKey.indexOf("GL") != -1) continue;
            BigDecimal curValue = new BigDecimal(currentResult.get(curKey).toString());
            String lastKey = curKey.replaceAll("Begin", "End");
            BigDecimal lastValue = new BigDecimal(lastResult.get(lastKey).toString());
            newResult.put(curKey, lastValue);
            BigDecimal dif = lastValue.subtract(curValue);
            if (curKey.indexOf("DEPRE") != -1 || curKey.indexOf("DECVALUE") != -1) {
                if (dif.intValue() > 0) {
                    debitKey_0 = curKey.replaceAll("Begin", "Debit");
                    debitKey = debitKey_0.replaceAll("Balance", "");
                    oldDebit = new BigDecimal(currentResult.get(debitKey).toString());
                    newDebit = oldDebit.add(dif);
                    newResult.put(debitKey, newDebit);
                    continue;
                }
                creditKey_0 = curKey.replaceAll("Begin", "Credit");
                creditKey = creditKey_0.replaceAll("Balance", "");
                oldCredit = new BigDecimal(currentResult.get(creditKey).toString());
                newCredit = oldCredit.add(dif.negate());
                newResult.put(creditKey, newCredit);
                continue;
            }
            if (dif.intValue() < 0) {
                debitKey_0 = curKey.replaceAll("Begin", "Debit");
                debitKey = debitKey_0.replaceAll("Balance", "");
                oldDebit = new BigDecimal(currentResult.get(debitKey).toString());
                newDebit = oldDebit.add(dif.negate());
                newResult.put(debitKey, newDebit);
                continue;
            }
            creditKey_0 = curKey.replaceAll("Begin", "Credit");
            creditKey = creditKey_0.replaceAll("Balance", "");
            oldCredit = new BigDecimal(currentResult.get(creditKey).toString());
            newCredit = oldCredit.add(dif);
            newResult.put(creditKey, newCredit);
        }
        return newResult;
    }

    @Override
    protected HashMap _faAcctBySumEnd(Context ctx, String companyID, HashMap accountMap, HashMap catMap, boolean isIncludeUnposted, int periodYear, int periodNumber, boolean isUseEvaValue, boolean isUseCatNumber) throws BOSException, EASBizException {
        if (accountMap == null) {
            throw new IllegalArgumentException("accountMap is NULL");
        }
        if (isUseCatNumber && catMap == null) {
            throw new IllegalArgumentException("catMap is NULL");
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        CompanyOrgUnitInfo companyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
        CurrencyInfo currency = companyOrg.getBaseCurrency();
        HashMap result = isUseCatNumber ? this.faAcctUseCatBySumEnd(ctx, companyOrg, accountMap, catMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue, currency, null) : this.faAcctNotUseCatBySumEnd(ctx, companyOrg, accountMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue, currency);
        result.put("isUseCatNumber", isUseCatNumber);
        result.put("AccountMap", accountMap);
        result.put("CatMap", catMap);
        return result;
    }

    private HashMap faAcctNotUseCatBySumEnd(Context ctx, CompanyOrgUnitInfo companyOrg, HashMap accountMap, boolean isIncludeUnposted, int periodYear, int periodNumber, boolean isUseEvaValue, CurrencyInfo currency) throws BOSException, EASBizException {
        HashMap<Object, Number> result = new HashMap<Object, Number>();
        int currencyScale = currency == null ? 2 : currency.getPrecision();
        result.put("currencyScale", currencyScale);
        HashMap glValue = this.searchGLSumEndBalance(ctx, companyOrg.getNumber(), accountMap, periodYear, periodNumber, isIncludeUnposted);
        Set s = glValue.keySet();
        for (int number = 0; number < s.size(); ++number) {
            result.put(s.toArray()[number], ((BigDecimal)glValue.get(s.toArray()[number])).setScale(currencyScale, 4));
        }
        boolean isAssetDebit = this.isAssetAccountDebit(ctx, accountMap);
        boolean isDecCredit = this.isDecAccountCredit(ctx, accountMap);
        boolean isDepreCredit = this.isDepreAccountCredit(ctx, accountMap);
        PeriodInfo contrastPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)periodYear, (int)periodNumber, (CompanyOrgUnitInfo)companyOrg);
        String contrastPeriodId = contrastPeriodInfo.getId().toString();
        HashMap assetValue = this.searchAssetBalance(ctx, currency.getId().toString(), companyOrg.getId().toString(), contrastPeriodId, isUseEvaValue, null, null);
        s = assetValue.keySet();
        for (int number = 0; number < s.size(); ++number) {
            String key = (String)s.toArray()[number];
            if ((key.equalsIgnoreCase("sumBegin_ASSET_ASSET") || key.equalsIgnoreCase("sumEnd_ASSET_ASSET")) && !isAssetDebit || (key.equalsIgnoreCase("sumBegin_DEPRE_ASSET") || key.equalsIgnoreCase("sumEnd_DEPRE_ASSET")) && !isDepreCredit || (key.equalsIgnoreCase("sumBegin_DECVALUE_ASSET") || key.equalsIgnoreCase("sumEnd_DECVALUE_ASSET")) && !isDecCredit) {
                BigDecimal value = (BigDecimal)assetValue.get(key);
                result.put(key, value.negate().setScale(currencyScale, 4));
                continue;
            }
            result.put(key, ((BigDecimal)assetValue.get(key)).setScale(currencyScale, 4));
        }
        return result;
    }

    private HashMap faAcctUseCatBySumEnd(Context ctx, CompanyOrgUnitInfo companyOrg, HashMap accountMap, HashMap catMap, boolean isIncludeUnposted, int periodYear, int periodNumber, boolean isUseEvaValue, CurrencyInfo currency, String periodId) throws BOSException, EASBizException {
        GlUtils.updateBalance((Context)ctx);
        HashMap<String, Number> result = new HashMap<String, Number>();
        int currencyScale = currency == null ? 2 : currency.getPrecision();
        result.put("currencyScale", currencyScale);
        HashMap sumGL = new HashMap();
        HashMap sumFA = new HashMap();
        boolean isAssetDebit = this.isAssetAccountDebit(ctx, accountMap);
        boolean isDecCredit = this.isDecAccountCredit(ctx, accountMap);
        boolean isDepreCredit = this.isDepreAccountCredit(ctx, accountMap);
        PeriodInfo contrastPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)periodYear, (int)periodNumber, (CompanyOrgUnitInfo)companyOrg);
        String contrastPeriodId = contrastPeriodInfo.getId().toString();
        Set accountMapSet = accountMap.keySet();
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        for (int setCount = 0; setCount < accountMapSet.size(); ++setCount) {
            HashMap accountList = (HashMap)accountMap.get(accountMapSet.toArray()[setCount]);
            for (String id : accountList.values()) {
                int number;
                AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK(id), sic);
                sumGL = this.searchGLSumEndBalance(ctx, companyOrg.getNumber(), account, periodYear, periodNumber, isIncludeUnposted);
                HashMap cats = (HashMap)catMap.get(accountMapSet.toArray()[setCount] + "_" + id);
                if (cats == null) {
                    cats = new HashMap();
                }
                Collection catListPerLine = cats.values();
                sumFA = this.searchAssetBalance(ctx, currency.getId().toString(), companyOrg.getId().toString(), contrastPeriodId, isUseEvaValue, catListPerLine, periodId);
                Set s = sumGL.keySet();
                for (number = 0; number < s.size(); ++number) {
                    result.put(s.toArray()[number] + "_" + accountMapSet.toArray()[setCount].toString(), ((BigDecimal)sumGL.get(s.toArray()[number])).setScale(currencyScale, 4));
                }
                s = sumFA.keySet();
                for (number = 0; number < s.size(); ++number) {
                    String key = (String)s.toArray()[number];
                    if ((key.equalsIgnoreCase("sumBegin_ASSET_ASSET") || key.equalsIgnoreCase("sumEnd_ASSET_ASSET")) && !isAssetDebit || (key.equalsIgnoreCase("sumBegin_DEPRE_ASSET") || key.equalsIgnoreCase("sumEnd_DEPRE_ASSET")) && !isDepreCredit || (key.equalsIgnoreCase("sumBegin_DECVALUE_ASSET") || key.equalsIgnoreCase("sumEnd_DECVALUE_ASSET")) && !isDecCredit) {
                        BigDecimal value = (BigDecimal)sumFA.get(s.toArray()[number]);
                        result.put(key + "_" + account.getNumber(), value.negate().setScale(currencyScale, 4));
                        continue;
                    }
                    result.put(key + "_" + account.getNumber(), ((BigDecimal)sumFA.get(s.toArray()[number])).setScale(currencyScale, 4));
                }
            }
        }
        return result;
    }
}

