/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.TaskEntryInfo;
import com.kingdee.eas.fi.fa.manage.TaskInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDataImportFacadeControllerBean;
import com.kingdee.eas.fi.fa.manage.app.dataimp.AbstractFaBatchDataRunner;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaDataImportFacadeControllerBean
extends AbstractFaDataImportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaDataImportFacadeControllerBean");

    @Override
    protected Map _importData(Context ctx, Map params) throws BOSException, EASBizException {
        String className = (String)params.get("className");
        AbstractFaBatchDataRunner runner = null;
        try {
            runner = (AbstractFaBatchDataRunner)Class.forName(className).newInstance();
            runner.beforeImport(ctx, params);
            Map map = runner.importData(ctx, params);
            return map;
        }
        catch (EASBizException e) {
            logger.error((Object)"import file error!", (Throwable)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)"import file error!", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.error((Object)"import file error!", e);
            throw new BOSException(e);
        }
        finally {
            if (runner != null) {
                runner.afterImport(ctx, params);
            }
        }
    }

    @Override
    protected String _addTask(Context ctx, TaskInfo task) throws BOSException, EASBizException {
        String sql = "insert into T_FA_Task (";
        sql = sql + "FID, FNumber, FName, FOrgUnitID, FSubSys, ";
        sql = sql + "FProgress, FStatus, FResult, ";
        sql = sql + "FCreatorID, FCreateTime, FBeginTime) ";
        sql = sql + "values ";
        sql = sql + "(?, ?, ?, ?, ?, ";
        sql = sql + "?, ?, ?, ";
        sql = sql + "?, getDate(), getDate()) ";
        String id = BOSUuid.create((String)"ABCD1234").toString();
        String orgUnitId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id, task.getNumber(), task.getName(), orgUnitId, 0, 0, 0, 0, userId});
        return id;
    }

    @Override
    protected String _addTaskEntry(Context ctx, TaskEntryInfo entry) throws BOSException, EASBizException {
        String sql = "insert T_FA_TaskEntry (";
        sql = sql + "FID, FTaskID, FStep, FContent, FCreateTime, FBeginTime) ";
        sql = sql + "values";
        sql = sql + "(?, ?, ?, ?, getDate(), getDate()) ";
        String id = BOSUuid.create((String)"ABCD1234").toString();
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id, entry.getTaskId(), entry.getStep(), entry.getContent()});
        return id;
    }

    @Override
    protected void _updateTask(Context ctx, TaskInfo task) throws BOSException, EASBizException {
        if (task != null && task.getId() != null) {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(task.getProgress());
            params.add(task.getStatus());
            params.add(task.getStatus());
            StringBuffer sql = new StringBuffer();
            sql.append("update T_FA_Task set FProgress = ?, FStatus = ?, FResult = ? \n");
            if (task.getStatus() == 2) {
                sql.append(", FEndTime = getDate() \n");
            }
            sql.append("where FID = ? \n");
            params.add(task.getId());
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        }
    }

    @Override
    protected TaskInfo _getTask(Context ctx, String id, int step) throws BOSException, EASBizException {
        TaskInfo task = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select * from T_FA_Task where FID = ?", (Object[])new String[]{id});
        try {
            if (rs.next()) {
                task = new TaskInfo();
                task.setId(rs.getString("FID"));
                task.setNumber(rs.getString("FNumber"));
                task.setName(rs.getString("FName"));
                task.setOrgUnitId(rs.getString("FOrgUnitID"));
                task.setSubSys(rs.getInt("FSubSys"));
                task.setProgress(rs.getInt("FProgress"));
                task.setStatus(rs.getInt("FStatus"));
                task.setResult(rs.getInt("FResult"));
                task.setCreatorId(rs.getString("FCreatorID"));
                task.setCreateTime(rs.getDate("FCreateTime"));
                task.setBeginTime(rs.getDate("FBeginTime"));
                task.setEndTime(rs.getDate("FEndTime"));
                rs = DbUtil.executeQuery((Context)ctx, (String)"select * from T_FA_TaskEntry where FTaskID = ? and FStep > ? order by FStep", (Object[])new Object[]{id, step});
                ArrayList<TaskEntryInfo> entries = new ArrayList<TaskEntryInfo>();
                while (rs.next()) {
                    TaskEntryInfo entry = new TaskEntryInfo();
                    entry.setId(rs.getString("FID"));
                    entry.setTaskId(rs.getString("FTaskID"));
                    entry.setStep(rs.getInt("FStep"));
                    entry.setContent(rs.getString("FContent"));
                    entry.setCreateTime(rs.getDate("FCreateTime"));
                    entries.add(entry);
                }
                task.setEntries(entries);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return task;
    }

    @Override
    protected void _deleteTask(Context ctx, String id) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)"delete from T_FA_Task where FID = ?", (Object[])new String[]{id});
        DbUtil.execute((Context)ctx, (String)"delete from T_FA_TaskEntry where FTaskID = ?", (Object[])new String[]{id});
    }
}

