/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FADecValuePolicyInfo;
import com.kingdee.eas.fi.fa.basedata.FaAlterModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaDecValueRuleEnum;
import com.kingdee.eas.fi.fa.manage.FaAppLogForBusinessTypeEnum;
import com.kingdee.eas.fi.fa.manage.FaBillBizProcessor;
import com.kingdee.eas.fi.fa.manage.FaBizStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDecValueCollection;
import com.kingdee.eas.fi.fa.manage.FaDecValueEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDecValueEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDecValueException;
import com.kingdee.eas.fi.fa.manage.FaDecValueFactory;
import com.kingdee.eas.fi.fa.manage.FaDecValueInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDecValueControllerBean;
import com.kingdee.eas.fi.fa.manage.app.AbstractPrcFaManageStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaLastPeriodChangeUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.PrcDecValueStrategy;
import com.kingdee.eas.fi.fa.manage.app.PrcFaCoreManager;
import com.kingdee.eas.fi.fa.manage.app.falog.event.FaMethodCalcOrderEnum;
import com.kingdee.eas.fi.fa.manage.app.falog.utils.FaRPCMethodMappingUtils;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaDecValueControllerBean
extends AbstractFaDecValueControllerBean {
    private static final long serialVersionUID = 1479025699323957799L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.manage.app.FaDecValueControllerBean");
    public static final String FACARDRESOURCE = "com.kingdee.eas.fi.fa.manage.FaCardResource";
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaDecValueResource";
    private int periodYear;
    private int periodNumber;
    private Context newCtx;

    private Context getContext() {
        return this.newCtx;
    }

    @Override
    public FaDecValueInfo _getFaDecValueInfo(Context ctx, EntityViewInfo view) throws BOSException {
        this.newCtx = ctx;
        FaDecValueInfo editData = new FaDecValueInfo();
        editData.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
        try {
            this.periodYear = (Integer)view.get("periodYear");
            this.periodNumber = (Integer)view.get("periodNumber");
            PeriodInfo period = new PeriodInfo();
            period.setPeriodYear(this.periodYear);
            period.setPeriodNumber(this.periodNumber);
            editData.setPeriod(period);
            String fName = "FName_" + ctx.getLocale().toString();
            StringBuffer sql = new StringBuffer();
            CompanyOrgUnitInfo currCompanyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            if (currCompanyInfo.get("isbizunit").toString().equalsIgnoreCase("false")) {
                OrgUnitInfo[] orgs = this.getAuthorizedBizOrgUnits(1, null);
                currCompanyInfo = (CompanyOrgUnitInfo)orgs[0];
            }
            editData.setCompany(currCompanyInfo);
            PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)currCompanyInfo);
            boolean isCurrPeriod = currPeriod.getPeriodYear() == this.periodYear && currPeriod.getPeriodNumber() == this.periodNumber;
            sql.append("select distinct assetCat,assetNumber,oldNumber,assetName,specs,changebillid,");
            sql.append("neatValue,decedValue,decValuePolicy,cardID,decValue from (");
            if (isCurrPeriod && !this._isDecAudited(ctx, this.periodYear, this.periodNumber)) {
                sql.append("select cat.").append(fName).append(" as assetCat,cat.fnumber as assetcatNumber,");
                sql.append("card.fnumber as assetNumber,card.fassetname as assetName,card.fspecs as specs,to_char(null) as changebillid,");
                sql.append("card.fOldNumber as oldNumber, ");
                sql.append("card.fneatvalue as neatValue,card.fdecvalue as decedValue, p.fdecValRule as decValuePolicy, ");
                sql.append("card.fid as cardID, 0 as decValue from t_fa_facurcard card ");
                sql.append(" inner join t_bd_period pd on card.fperiodid = pd.fid ");
                sql.append(" inner join t_fa_cat cat on card.fassetcatid = cat.fid");
                sql.append(" inner join T_FA_FADecValuePolicy p on cat.fdecvalpolicyid = p.fid");
                sql.append(" where card.fcheckedstatus = ").append(2);
                sql.append(" and card.fblockedStatus = ").append(1);
                sql.append(" and card.fdeletedstatus != ").append(2);
                sql.append(" and right(card.fbizstatus,2) = '99' ");
                sql.append(" and card.fleaseStatus = 0");
                sql.append(" and p.fdecvalrule != ").append(1);
                sql.append(" and card.fid not in(select entry.fcurcardid from t_fa_fadecvalue decv");
                sql.append(" inner join t_fa_fadecvalueentry entry on entry.fheadid = decv.fid");
                sql.append(" inner join t_bd_period period on decv.fperiodid = period.fid");
                sql.append(" where period.fperiodyear = ").append(this.periodYear);
                sql.append(" and period.fperiodnumber = ").append(this.periodNumber);
                sql.append(" and decv.fcompanyid = '").append(currCompanyInfo.getId().toString()).append("')");
                sql.append(" and card.fcompanyid = '").append(currCompanyInfo.getId().toString()).append("'");
                sql.append(" and pd.fnumber <= ").append(100 * this.periodYear + this.periodNumber);
                sql.append(" union all ");
            }
            sql.append("select cat.").append(fName).append(" as assetCat,cat.fnumber as assetcatNumber,");
            sql.append("card.fnumber as assetNumber,card.fassetname as assetName,card.fspecs as specs,entry.fchangebillid as changebillid,");
            sql.append("card.fOldNumber as oldNumber, ");
            sql.append("card.fneatvalue as neatValue,card.fdecvalue as decedValue,p.fdecValRule as decValuePolicy, ");
            sql.append("card.fid as cardID,entry.fdecvalue as decValue");
            sql.append(" from t_fa_fadecvalue decv ");
            sql.append(" inner join t_fa_fadecvalueentry entry on decv.fid = entry.fheadid");
            sql.append(" inner join t_bd_period period on decv.fperiodid = period.fid");
            String card = isCurrPeriod ? "card" : "c";
            sql.append(" inner join t_fa_facurcard ").append(card).append(" on ").append(card).append(".fid = entry.fcurcardid");
            if (!isCurrPeriod) {
                sql.append(" inner join t_fa_famoncard card on card.ffacurcardid = c.fid and card.ffaperiodid = period.fid");
            }
            sql.append(" inner join t_fa_cat cat on ").append(card).append(".fassetcatid = cat.fid");
            sql.append(" inner join T_FA_FADecValuePolicy p on cat.fdecvalpolicyid = p.fid");
            sql.append(" where period.fperiodyear = ").append(this.periodYear);
            sql.append(" and period.fperiodnumber = ").append(this.periodNumber);
            sql.append(" and decv.fcompanyid = '").append(currCompanyInfo.getId().toString()).append("'");
            sql.append(") as c");
            FilterInfo filter = view.getFilter();
            if (filter != null && filter.toString().trim().length() > 0) {
                if (filter.toString().indexOf("asstActType.fnumber") != -1 || filter.toString().indexOf("asstActItem.fname_l2") != -1) {
                    sql.append(" left outer join t_fa_facurcostcenter as facurcostcenter on  c.cardid = facurcostcenter.ffacurcardid left outer join t_fa_facurasstactcomposit as facurasstactcomposit on facurcostcenter.fid =facurasstactcomposit.ffacurcostcenterid");
                }
                if (filter.toString().indexOf("asstActType.fnumber") != -1) {
                    sql.append(" left outer join t_bd_asstacttype as asstacttype on facurasstactcomposit.fasstacttype =asstacttype.fid");
                }
                if (filter.toString().indexOf("asstActItem.fname_l2") != -1) {
                    sql.append(" left outer join t_fa_assistactitem as asstactitem on facurasstactcomposit.fasstactitem =asstactitem.fid");
                }
                if (filter.toString().indexOf("curcard.oldNumber") != -1) {
                    filter = new FilterInfo(filter.toString().replaceAll("curcard.oldNumber", "c.oldNumber"));
                }
                if (filter.toString().indexOf("assetCat.number") != -1) {
                    filter = new FilterInfo(filter.toString().replaceAll("assetCat.number", "assetcatNumber"));
                }
                sql.append(" where ").append(filter);
            }
            if (view.getSorter().toString() != null && view.getSorter().toString().trim().length() > 0) {
                sql.append(" order by ").append(view.getSorter().toString());
            } else {
                sql.append(" order by assetNumber");
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)FaLocalUtils.transformLocal(ctx, sql.toString()));
            while (rowSet.next()) {
                FaDecValueEntryInfo entryInfo = new FaDecValueEntryInfo();
                FaCatInfo catInfo = new FaCatInfo();
                catInfo.setName(rowSet.getString("assetCat"));
                FADecValuePolicyInfo decP = new FADecValuePolicyInfo();
                decP.setDecValRule(FaDecValueRuleEnum.getEnum((int)rowSet.getInt("decValuePolicy")));
                catInfo.setDecValPolicy(decP);
                FaCurCardInfo cardInfo = new FaCurCardInfo();
                cardInfo.setNumber(rowSet.getString("assetNumber"));
                cardInfo.setOldNumber(rowSet.getString("oldNumber"));
                cardInfo.setAssetName(rowSet.getString("assetName"));
                cardInfo.setSpecs(rowSet.getString("specs"));
                cardInfo.setNeatValue(rowSet.getBigDecimal("neatValue"));
                cardInfo.setDecValue(rowSet.getBigDecimal("decedValue"));
                cardInfo.setAssetCat(catInfo);
                cardInfo.setId(BOSUuid.read((String)rowSet.getString("cardId")));
                if (rowSet.getString("changebillid") != null) {
                    FaChangeBillInfo changebill = new FaChangeBillInfo();
                    changebill.setId(BOSUuid.read((String)rowSet.getString("changebillid")));
                    entryInfo.setChangeBill(changebill);
                }
                entryInfo.setCurcard(cardInfo);
                entryInfo.setDecValue(rowSet.getBigDecimal("decValue"));
                editData.getEntry().add(entryInfo);
            }
            Object[] params = new Object[]{new Integer(this.periodYear), new Integer(this.periodNumber), ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()};
            sql = new StringBuffer();
            sql.append("select decv.fid as fid,alterMode.fid as alterId,alterMode.").append(fName).append(" as alterName,");
            sql.append(" altermode.fnumber as alterNumber,decv.fcheckedstatus as fcheckedstatus,decv.ffivouchered as ffivouchered");
            sql.append(" from t_fa_fadecvalue decv inner join t_bd_period period on period.fid = decv.fperiodid");
            sql.append(" left outer join t_fa_altermode altermode on altermode.fid = decv.faltermodeid");
            sql.append(" where period.fperiodyear = ? and period.fperiodnumber = ? and decv.fcompanyid = ?");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                editData.setId(BOSUuid.read((String)rowSet.getString("fid")));
                FaAlterModeInfo alterModeInfo = new FaAlterModeInfo();
                alterModeInfo.setId(BOSUuid.read((String)rowSet.getString("alterId")));
                alterModeInfo.setIsLeaf(true);
                alterModeInfo.setName(rowSet.getString("alterName"));
                alterModeInfo.setNumber(rowSet.getString("alterNumber"));
                editData.setAlterMode(alterModeInfo);
                editData.setCheckedStatus(CheckedStatusEnum.getEnum((int)rowSet.getInt("fcheckedstatus")));
                editData.setFiVouchered(rowSet.getBoolean("ffivouchered"));
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return editData;
    }

    public OrgUnitInfo[] getAuthorizedBizOrgUnits(int orgType, String permissionItem) throws EASBizException, BOSException {
        OrgUnitCollection collection = this.getAuthOrgByPermItem(OrgType.getEnum((int)orgType), permissionItem);
        if (collection == null || collection.size() == 0) {
            return new OrgUnitInfo[0];
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            keys.add(collection.get(i).getId().toString());
        }
        OrgUnitInfo[] results = this.getOrgUnitInfosByType(keys, orgType);
        return results;
    }

    public OrgUnitInfo[] getOrgUnitInfosByType(Set<String> keys, int orgTypeValue) throws BOSException, EASBizException {
        OrgType orgType = OrgType.getEnum((int)orgTypeValue);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        }
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("number"));
        view.setSorter(sortCol);
        view.setFilter(filter);
        view.setSelector(this.getOrgInfoSelector(orgType));
        Context ctx = this.getContext();
        OrgUnitInfo[] results = null;
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    view.getSelector().add(new SelectorItemInfo("baseCurrency.precision"));
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 2: {
                    ISaleOrgUnit iSale = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 4: {
                    IStorageOrgUnit iStorage = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 24: {
                    ITransportOrgUnit iTransport = TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                    TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return results;
    }

    public SelectorItemCollection getOrgInfoSelector(OrgType orgType) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        if (orgType.getValue() == 1) {
            selector.add(new SelectorItemInfo("baseCurrency.id"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            selector.add(new SelectorItemInfo("baseCurrency.number"));
            selector.add(new SelectorItemInfo("baseCurrency.precision"));
        }
        return selector;
    }

    protected OrgUnitCollection getAuthOrgByPermItem(OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getLocalInstance((Context)this.getContext());
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        FullOrgUnitCollection result = permission.getAuthorizedOrg(this.getContext().getCaller(), orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        String pk = model.get("id") == null ? null : model.get("id").toString();
        FaBillBizProcessor.lockTable(ctx, pk);
        this.checkBeforeSubmin(ctx, (IObjectValue)model);
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        FaDecValueInfo decValueInfo = (FaDecValueInfo)model;
        if (decValueInfo != null && decValueInfo.getId() != null) {
            prcFaCoreManager.getFaManageStrategy().checkForEdit(ctx, (IObjectValue)decValueInfo);
        } else if (decValueInfo.getCompany() != null && decValueInfo.getCompany().getId() != null) {
            prcFaCoreManager.getFaManageStrategy().checkUnAuditFaDep(ctx, prcFaCoreManager.getFaManageStrategy().getCurrentPeriod(ctx, decValueInfo), decValueInfo.getCompany());
        }
        logger.debug((Object)"_submit");
        return prcFaCoreManager.getFaManageStrategy().submitBill(ctx, (IObjectValue)model);
    }

    @Override
    protected FaDecValueInfo _verifySubmit(Context ctx, FaDecValueInfo decValueInfo) throws BOSException, EASBizException {
        int i;
        String cardId;
        FaDecValueEntryCollection entryColl = decValueInfo.getEntry();
        FaDecValueInfo decVInfo = decValueInfo.getId() == null ? null : this.getFaDecValueInfo(ctx, decValueInfo);
        FaDecValueEntryCollection newEntryColl = new FaDecValueEntryCollection();
        if (entryColl.isEmpty()) {
            return null;
        }
        String strCard = ResourceBase.getString((String)RES_PATH, (String)"card", (Locale)ctx.getOriginLocale());
        Iterator items = entryColl.iterator();
        StringBuffer ids = new StringBuffer();
        boolean isDecValue = false;
        while (items.hasNext()) {
            isDecValue = false;
            FaDecValueEntryInfo entryInfo = (FaDecValueEntryInfo)items.next();
            if (entryInfo.getCurcard() == null) continue;
            if (decVInfo != null && decVInfo.getEntry().size() > 0) {
                int size = decVInfo.getEntry().size();
                for (int i2 = 0; i2 < size; ++i2) {
                    FaDecValueEntryInfo entry = decVInfo.getEntry().get(i2);
                    if (entry.getCurcard() == null || !entryInfo.getCurcard().getId().equals((Object)entry.getCurcard().getId())) continue;
                    isDecValue = true;
                    break;
                }
            }
            if (entryInfo.getDecValue() == null && !isDecValue) {
                String strExecption = ResourceBase.getString((String)RES_PATH, (String)"neatValueIsNull", (Locale)ctx.getOriginLocale());
                throw new EASBizException(new NumericExceptionSubItem("1", strExecption));
            }
            if (entryInfo.getDecValue().doubleValue() == 0.0 && !isDecValue) continue;
            ids.append(",'").append(entryInfo.getCurcard().getId().toString()).append("'");
            newEntryColl.add(entryInfo);
        }
        entryColl.clear();
        entryColl.addCollection(newEntryColl);
        if (ids.length() == 0) {
            return decValueInfo;
        }
        StringBuffer info = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("select card.fid as cardId,card.fnumber as assetNumber,card.fassetName as assetName");
        sql.append(" from t_fa_facurcard card ");
        sql.append(" inner join t_fa_cat cat on card.fassetcatid = cat.fid");
        sql.append(" inner join T_FA_FADecValuePolicy p on cat.fdecvalpolicyid = p.fid");
        sql.append(" where card.fdeletedstatus = ").append(2);
        sql.append(" and card.fid in(").append(ids.substring(1)).append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            block8: while (rowSet.next()) {
                info.append("\uff1b");
                info.append(strCard).append(rowSet.getString("assetNumber"));
                info.append("(").append(rowSet.getString("assetName")).append(")");
                info.append(ResourceBase.getString((String)RES_PATH, (String)"alreadyDeleted", (Locale)ctx.getOriginLocale()));
                cardId = rowSet.getString("cardId");
                for (i = 0; i < entryColl.size(); ++i) {
                    if (!cardId.equals(entryColl.get(i).getCurcard().getId().toString())) continue;
                    entryColl.remove(entryColl.get(i));
                    continue block8;
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        sql = new StringBuffer();
        sql.append("select card.fid as cardId,card.fnumber as assetNumber,card.fassetName as assetName,card.fbizstatus as bizStatus");
        sql.append(" from t_fa_facurcard card ");
        sql.append(" inner join t_fa_cat cat on card.fassetcatid = cat.fid");
        sql.append(" inner join T_FA_FADecValuePolicy p on cat.fdecvalpolicyid = p.fid");
        sql.append(" where right(card.fbizstatus,2) != '99'");
        sql.append(" and card.fleaseStatus != 0");
        sql.append(" and card.fbizstatus != '0901'");
        sql.append(" and card.fid in(").append(ids.substring(1)).append(")");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            block10: while (rowSet.next()) {
                info.append("\uff1b");
                info.append(strCard).append(rowSet.getString("assetNumber"));
                info.append("(").append(rowSet.getString("assetName")).append(")");
                info.append(FaBizStatusEnum.getEnum(rowSet.getString("bizStatus")).getAlias());
                info.append("\uff0c").append(ResourceBase.getString((String)RES_PATH, (String)"cantDecValue", (Locale)ctx.getOriginLocale()));
                cardId = rowSet.getString("cardId");
                for (i = 0; i < entryColl.size(); ++i) {
                    if (!cardId.equals(entryColl.get(i).getCurcard().getId().toString())) continue;
                    entryColl.remove(entryColl.get(i));
                    continue block10;
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        sql = new StringBuffer();
        sql.append("select card.fid as cardId,card.fnumber as assetNumber,card.fassetName as assetName");
        sql.append(" from t_fa_facurcard card ");
        sql.append(" inner join t_fa_cat cat on card.fassetcatid = cat.fid");
        sql.append(" inner join T_FA_FADecValuePolicy p on cat.fdecvalpolicyid = p.fid");
        sql.append(" where p.fdecvalrule = ").append(1);
        sql.append(" and card.fid in(").append(ids.substring(1)).append(")");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            block12: while (rowSet.next()) {
                info.append("\uff1b");
                info.append(strCard).append(rowSet.getString("assetNumber"));
                info.append("(").append(rowSet.getString("assetName")).append(")");
                info.append(ResourceBase.getString((String)RES_PATH, (String)"decValuePolicyNotFit", (Locale)ctx.getOriginLocale()));
                cardId = rowSet.getString("cardId");
                for (i = 0; i < entryColl.size(); ++i) {
                    if (!cardId.equals(entryColl.get(i).getCurcard().getId().toString())) continue;
                    entryColl.remove(entryColl.get(i));
                    continue block12;
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (info.length() > 0) {
            info.append("\u3002").append(ResourceBase.getString((String)RES_PATH, (String)"isContinue", (Locale)ctx.getOriginLocale()));
            decValueInfo.put("errorInfo", info.substring(1));
        }
        if (decValueInfo.getPeriod().getId() == null) {
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)this.periodYear, (int)this.periodNumber, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
            decValueInfo.setPeriod(periodInfo);
        }
        FaLocalUtils.verifyForLastestPeriod(ctx, (IObjectValue)decValueInfo, 3);
        return decValueInfo;
    }

    private FaDecValueInfo getFaDecValueInfo(Context ctx, FaDecValueInfo decValueInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        boolean hasSeved = decValueInfo != null && decValueInfo.getPeriod() != null && decValueInfo.getPeriod().getId() != null;
        PeriodInfo currentPeriod = hasSeved ? decValueInfo.getPeriod() : SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)currCompany);
        String getDecValueSql = "select id,entry.decValue,entry.curcard.id where period.id = '" + currentPeriod.getId() + "' and company.id = '" + currCompany.getId().toString() + "'";
        FaDecValueInfo faDecValueInfo = FaDecValueFactory.getLocalInstance(ctx).getFaDecValueInfo(getDecValueSql);
        return faDecValueInfo;
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FaDecValueInfo decValueInfo = FaDecValueFactory.getLocalInstance(ctx).getFaDecValueInfo(pk);
        FaBillBizProcessor.lockTable(ctx, decValueInfo.getId().toString());
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForAudit(ctx, pk);
        prcFaCoreManager.getFaManageStrategy().auditBill(ctx, (IObjectValue)decValueInfo);
        this.passAuditSelf(ctx, pk, decValueInfo);
        logger.debug((Object)"_passAudit");
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)currCompany);
        FaDecValueInfo decValueinfo = FaDecValueFactory.getLocalInstance(ctx).getFaDecValueInfo(pk);
        FaBillBizProcessor.lockTable(ctx, decValueinfo.getId().toString());
        PrcFaCoreManager prcFaCoreManager = new PrcFaCoreManager(this.getBillStrategy());
        prcFaCoreManager.getFaManageStrategy().checkForUnAudit(ctx, pk);
        FaLocalUtils.verifyForLastestPeriod(ctx, (IObjectValue)decValueinfo, 3);
        prcFaCoreManager.getFaManageStrategy().unAuditBill(ctx, (IObjectValue)decValueinfo);
        this.unpassAuditSelf(ctx, pk, decValueinfo);
        logger.debug((Object)"_unpassAudit");
    }

    @Override
    protected void _passAuditSelf(Context ctx, IObjectPK pk, FaDecValueInfo model) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("update T_Fa_FaDecValue set");
        _sql.append(" FCheckedStatus = ?");
        _sql.append(",FAuditorId = ?");
        _sql.append(",FBizDate = ?");
        _sql.append(" where fid = ?");
        Object[] params = new Object[4];
        params[0] = new Integer(2);
        params[1] = ctx.getCaller().toString();
        CompanyOrgUnitInfo company = model.getCompany();
        if (company == null || company.getId() == null) {
            company = (CompanyOrgUnitInfo)this.getValue(ctx, "select company.id where id ='" + pk + "'").get("company");
        }
        params[2] = new Timestamp(FaLocalUtils.getBizDate(ctx, company.getId().toString()).getTime());
        params[3] = pk.toString();
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, company.getId().toString(), pk.toString(), 4);
    }

    @Override
    protected void _unpassAuditSelf(Context ctx, IObjectPK pk, FaDecValueInfo model) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("update T_Fa_FaDecValue set");
        _sql.append(" FCheckedStatus = ?");
        _sql.append(",FAuditorId = null");
        _sql.append(" where fid = ?");
        Object[] params = new Object[]{new Integer(1), pk.toString()};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, model.getObjectValue("company").get("id").toString(), pk.toString(), 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpassAuditSelf(Context ctx, IObjectPK pk, FaDecValueInfo model) throws BOSException, EASBizException {
        try {
            this.setWorkflowServiceState(ctx, (IObjectPK)(model.getId() != null ? new ObjectStringPK(model.getId().toString()) : null));
            super.unpassAuditSelf(ctx, pk, model);
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    protected void calAmount(FaCurCardInfo cardInfo, HashMap decValues) {
        cardInfo.setDecValue(cardInfo.getDecValue().add((BigDecimal)decValues.get(cardInfo.getId().toString())));
        BigDecimal decPrepare = cardInfo.getDecValue();
        BigDecimal netAmount = cardInfo.getNeatValue().subtract(decPrepare);
        cardInfo.setNeatAmt(netAmount);
    }

    protected SelectorItemCollection getSelfSelctor() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("period.id"));
        return sic;
    }

    @Override
    protected boolean _isDecAudited(Context ctx, int periodYear, int periodNumber) throws BOSException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)new Integer(periodYear)));
        filterInfo.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)new Integer(periodNumber)));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)currCompany.getId().toString()));
        view.setFilter(filterInfo);
        view.getSelector().add(new SelectorItemInfo("checkedStatus"));
        FaDecValueCollection coll = this.getFaDecValueCollection(ctx, view);
        if (!coll.isEmpty()) {
            return CheckedStatusEnum.AUDITED.equals((Object)coll.get(0).getCheckedStatus());
        }
        return false;
    }

    @Override
    protected boolean _isNotDecValue(Context ctx, int periodYear, int periodNumber) throws BOSException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)new Integer(periodYear)));
        filterInfo.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)new Integer(periodNumber)));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)currCompany.getId().toString()));
        view.setFilter(filterInfo);
        view.getSelector().add(new SelectorItemInfo("id"));
        FaDecValueCollection coll = this.getFaDecValueCollection(ctx, view);
        return coll.isEmpty();
    }

    @Override
    protected boolean _isFiVouchered(Context ctx, int periodYear, int periodNumber) throws BOSException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)new Integer(periodYear)));
        filterInfo.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)new Integer(periodNumber)));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)currCompany.getId().toString()));
        view.setFilter(filterInfo);
        view.getSelector().add(new SelectorItemInfo("fiVouchered"));
        FaDecValueCollection coll = this.getFaDecValueCollection(ctx, view);
        if (!coll.isEmpty()) {
            return coll.get(0).isFiVouchered();
        }
        return false;
    }

    private boolean isFiVouchered(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("fiVouchered"));
        FaDecValueInfo decValueInfo = this.getFaDecValueInfo(ctx, sourceBillPk, selectors);
        if (decValueInfo != null) {
            return decValueInfo.isFiVouchered();
        }
        return false;
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        if (!this.isFiVouchered(ctx, sourceBillPk)) {
            throw new FaDecValueException(FaDecValueException.NOT_GENERATE_VOUCHER);
        }
        return super._deleteVoucher(ctx, sourceBillPk);
    }

    protected void _generateVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        if (this.isFiVouchered(ctx, sourceBillPk)) {
            throw new FaDecValueException(FaDecValueException.HAVE_GENERATE_VOUCHER);
        }
        super._generateVoucher(ctx, sourceBillPk);
    }

    protected SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entry.curcard.accountAsset.id"));
        sic.add(new SelectorItemInfo("entry.curcard.accountAccuDepr.id"));
        sic.add(new SelectorItemInfo("entry.curcard.accountDecValue.*"));
        sic.add(new SelectorItemInfo("entry.curcard.assetValue"));
        sic.add(new SelectorItemInfo("entry.curcard.accountAsset"));
        sic.add(new SelectorItemInfo("entry.curcard.accuDeprAll"));
        sic.add(new SelectorItemInfo("entry.curcard.assetCat.id"));
        sic.add(new SelectorItemInfo("entry.curcard.accuDepr"));
        sic.add(new SelectorItemInfo("entry.curcard.currency.*"));
        return sic;
    }

    protected AbstractPrcFaManageStrategy getBillStrategy() {
        return new PrcDecValueStrategy();
    }

    @Override
    protected IObjectPK _submitSelf(Context ctx, FaDecValueInfo decValueInfo) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, (IObjectValue)decValueInfo);
        FaLastPeriodChangeUtils.updateCardLastPeriodChange(ctx, decValueInfo.getCompany().getId().toString(), pk.toString(), 3);
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectPK submitSelf(Context ctx, FaDecValueInfo decValueInfo) throws BOSException, EASBizException {
        try {
            IObjectPK pk;
            this.setWorkflowServiceState(ctx, (IObjectPK)(decValueInfo.getId() != null ? new ObjectStringPK(decValueInfo.getId().toString()) : null));
            IObjectPK iObjectPK = pk = super.submitSelf(ctx, decValueInfo);
            return iObjectPK;
        }
        finally {
            WfEventListenerStateManager.getInstance().enableEventListener();
        }
    }

    private void checkBeforeSubmin(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FaDecValueInfo decValue = (FaDecValueInfo)model;
        FaDecValueEntryCollection entryColl = decValue.getEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo card = entryColl.get(i).getCurcard();
            if (card == null || card.getId() == null) continue;
            Timestamp lastUpdateTime = FaBillBizProcessor.lockCurCard(ctx, card.getId().toString());
            FaBillBizProcessor.checkFaCurCardVersion(ctx, card.getId().toString(), lastUpdateTime);
        }
    }

    protected void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        String companyId = null;
        if (objId != null) {
            CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.getFaDecValueInfo(ctx, "select company.id where id='" + objId + "'").get("company");
            companyId = comp.getId().toString();
        }
        this.setWorkflowServiceState(ctx, companyId, objId != null ? objId.toString() : null);
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        boolean isUseWorkflow = FaManageUtils.isUseWorkflow(ctx, companyId, this.getClass());
        if (!isUseWorkflow && (objId == null || objId != null && !FaLocalUtils.isRunningWorkflow(ctx, objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    protected void invokeServiceBefore(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_DEC, FaMethodCalcOrderEnum.BEFORE);
        super.invokeServiceBefore(svcCtx);
    }

    protected void invokeServiceAfter(ServiceContext svcCtx) throws BOSException {
        FaRPCMethodMappingUtils.invokeRPCMethodEventListener(svcCtx, FaAppLogForBusinessTypeEnum.FA_DEC, FaMethodCalcOrderEnum.AFTER);
        super.invokeServiceAfter(svcCtx);
    }
}

