/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepCalExecutor;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import java.math.BigDecimal;
import java.util.HashMap;

public class FaDepCalAveUsingAgeTaxStrategy
extends AbstractFaDepCalStrategy {
    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        HashMap<Integer, BigDecimal> returnValue = new HashMap<Integer, BigDecimal>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal periodDepreAmount = null;
        BigDecimal periodDepreRate = null;
        BigDecimal assetValue = faCardInfo.getEvalAssetValue() == null ? new BigDecimal("0") : faCardInfo.getEvalAssetValue();
        BigDecimal leftAmount = this.getLeftAmount(faCardInfo);
        BigDecimal leftPeriod = this.getLeftLife(faCardInfo);
        if (leftAmount.compareTo(zero) <= 0 || leftPeriod.compareTo(zero) <= 0) {
            return null;
        }
        periodDepreAmount = leftAmount.divide(leftPeriod, baseCurPrecision, 4);
        periodDepreRate = periodDepreAmount.multiply(new BigDecimal("100")).divide(assetValue, depreRatePrecision, 4);
        periodDepreAmount = this.dealPeriodAmount(faCardInfo, periodDepreAmount);
        returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
        returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
        String companyId = faCardInfo.getCompany().getId().toString();
        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
        if (prePeriod != null && prePeriod.isIsAdjustPeriod()) {
            prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)prePeriod);
        }
        FaEvalDepreciationEntryInfo entry = FaDepCalExecutor.genEvalDepEntryInfo(ctx, faCardInfo, returnValue, companyId, prePeriod);
        returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, entry.getDepreciation());
        returnValue.put(FaDepreCalculator.FA_DEP_RATE, entry.getMonthDepreRate());
        returnValue.put(FaDepreCalculator.FA_DEP_SHOULDAMT, entry.getShouldDepre());
        return returnValue;
    }

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        return this.calcuatePeriodDepreResultDynamic(ctx, faCardInfo, period);
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("evalAssetValue", "");
        hm.put("evalMonthRate", "");
        hm.put("evalRemValue", "");
        hm.put("evalDecValue", "");
        hm.put("evalAddDepr", "");
        return hm;
    }

    @Override
    protected BigDecimal getLeftLife(FaCurCardInfo faCardInfo) {
        BigDecimal deprTermCount;
        BigDecimal bigDecimal = deprTermCount = faCardInfo.getEvalTaxLeftPeriod() == null ? new BigDecimal("0") : faCardInfo.getEvalTaxLeftPeriod();
        if (deprTermCount.compareTo(new BigDecimal("0")) < 0) {
            return new BigDecimal("0");
        }
        return deprTermCount;
    }

    @Override
    protected BigDecimal getLeftAmount(FaCurCardInfo faCardInfo) {
        BigDecimal assetValue = faCardInfo.getEvalAssetValue();
        if (assetValue == null || assetValue.compareTo(new BigDecimal("0")) <= 0) {
            return new BigDecimal("0");
        }
        BigDecimal accuDepr = faCardInfo.getEvalAddDepr() == null ? new BigDecimal("0") : faCardInfo.getEvalAddDepr();
        BigDecimal decValue = faCardInfo.getEvalDecValue() == null ? new BigDecimal("0") : faCardInfo.getEvalDecValue();
        BigDecimal neatRemValue = faCardInfo.getEvalRemValue() == null ? new BigDecimal("0") : faCardInfo.getEvalRemValue();
        BigDecimal result = assetValue.subtract(accuDepr).subtract(decValue).subtract(neatRemValue);
        if (result.compareTo(new BigDecimal("0")) > 0) {
            return result;
        }
        return new BigDecimal("0");
    }
}

