/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FaDepCalAveUsingOriginAgeStrategy
extends AbstractFaDepCalStrategy {
    private boolean if_lastPeriod_depTotal = true;
    Logger logger = Logger.getLogger((String)FaDepCalAveUsingOriginAgeStrategy.class.getName());

    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        return this.calcuatePeriodDepreResultStatic(ctx, faCardInfo, period);
    }

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        this.beforeDepcal(ctx);
        HashMap<Integer, BigDecimal> returnValue = new HashMap<Integer, BigDecimal>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal assetValue = faCardInfo.getAssetValue();
        BigDecimal prePureRate = faCardInfo.getNeatLeftRate() == null ? zero : faCardInfo.getNeatLeftRate().divide(new BigDecimal("100"), depreRatePrecision, 4);
        BigDecimal leftAmount = this.getLeftAmount(faCardInfo);
        if (leftAmount.compareTo(zero) <= 0) {
            return null;
        }
        if (this.isYearDep(faCardInfo)) {
            BigDecimal yearDepreRate = new BigDecimal("1").subtract(prePureRate).divide(faCardInfo.getUseYears(), depreRatePrecision, 4);
            BigDecimal yearDepreAmount = assetValue.multiply(yearDepreRate).setScale(baseCurPrecision, 4);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, yearDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, yearDepreRate.multiply(new BigDecimal("100")));
        } else {
            BigDecimal periodDepreRate = new BigDecimal("1").subtract(prePureRate).divide(faCardInfo.getUseTermCount(), depreRatePrecision, 4);
            BigDecimal periodDepreAmount = assetValue.multiply(periodDepreRate).setScale(baseCurPrecision, 4);
            this.if_lastPeriod_depTotal = this.getDepParameter();
            periodDepreAmount = this.dealPeriodAmount(faCardInfo, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate.multiply(new BigDecimal("100")));
        }
        return returnValue;
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("assetValue", "");
        hm.put("accuDepr", "");
        hm.put("decValue", "");
        hm.put("neatRemValue", "");
        return hm;
    }

    protected boolean isNeedDepr(FaCurCardInfo card) throws EASBizException, BOSException {
        BigDecimal leftAmount = this.getLeftAmount(card);
        return leftAmount.compareTo(zero) > 0;
    }

    @Override
    public boolean haveLifeForDep(FaCurCardInfo faCardInfo, Context ctx) throws BOSException {
        try {
            this.beforeDepcal(ctx);
        }
        catch (EASBizException e) {
            this.logger.info((Object)e);
        }
        if (this.if_lastPeriod_depTotal) {
            return super.haveLifeForDep(faCardInfo, ctx);
        }
        return faCardInfo.getUseTermCount().compareTo(new BigDecimal("0")) > 0;
    }

    @Override
    protected boolean isFinalyDepCal(FaCurCardInfo card) {
        if (this.if_lastPeriod_depTotal) {
            BigDecimal left = this.getLeftLife(card);
            return left.compareTo(new BigDecimal(1)) == 0;
        }
        return false;
    }

    private void beforeDepcal(Context ctx) throws BOSException, EASBizException {
        String afterPeriodContinue;
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        ObjectUuidPK companyPK = new ObjectUuidPK(aCompanyOrgUnitInfo.getId());
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("FA_051", companyPK);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmResult = iParamControl.getParamHashMap(paramKeyMap);
        this.if_lastPeriod_depTotal = hmResult == null || hmResult.size() == 0 ? true : (afterPeriodContinue = (String)hmResult.get("FA_051")) == null || afterPeriodContinue.trim().length() <= 0 || !afterPeriodContinue.trim().equalsIgnoreCase("true");
    }

    private boolean getDepParameter() {
        return this.if_lastPeriod_depTotal;
    }
}

