/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import java.math.BigDecimal;
import java.util.HashMap;

public class FaDepCalDoubleSubtractStaticStrategy
extends AbstractFaDepCalStrategy {
    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        return this.calcuatePeriodDepreResultStatic(ctx, faCardInfo, period);
    }

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        HashMap<Integer, Number> returnValue = new HashMap<Integer, Number>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal yearDepreAmount = null;
        BigDecimal periodDepreAmount = null;
        BigDecimal yearDepreRate = null;
        BigDecimal periodDepreRate = null;
        BigDecimal percent = new BigDecimal(100);
        BigDecimal assetValue = faCardInfo.getAssetValue() == null ? new BigDecimal("0") : faCardInfo.getAssetValue();
        BigDecimal decValue = faCardInfo.getDecValue() == null ? new BigDecimal("0") : faCardInfo.getDecValue();
        BigDecimal accuDepr = this.getCalDepAmount(faCardInfo, ctx, period);
        int depCount = this.getDepCount(ctx, faCardInfo, period);
        if (!this.isLastTwoYear(faCardInfo)) {
            int useYear = faCardInfo.getUseYears().intValue();
            yearDepreRate = new BigDecimal(2).divide(new BigDecimal(useYear), depreRatePrecision, 4);
            BigDecimal bOne = new BigDecimal("1");
            int deprYear = this.getDeprYear(ctx, faCardInfo, period);
            double dtemp = bOne.subtract(yearDepreRate).doubleValue();
            dtemp = Math.pow(dtemp, deprYear);
            BigDecimal temp1 = new BigDecimal(dtemp);
            yearDepreAmount = temp1.multiply(assetValue.subtract(decValue)).multiply(yearDepreRate);
            depCount = depCount >= this.getValidPeriodCountofYear(ctx, period) ? 1 : ++depCount;
            periodDepreRate = yearDepreRate.divide(new BigDecimal(this.getPeriodCount()), depreRatePrecision, 4);
            periodDepreAmount = yearDepreAmount.divide(new BigDecimal(this.getPeriodCount()), baseCurPrecision, 4);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate.multiply(percent));
            returnValue.put(FaDepreCalculator.FA_DEP_LEFTYEAR, new BigDecimal(useYear));
            returnValue.put(FaDepreCalculator.FA_DEP_CALDEPAMOUNT, accuDepr);
            returnValue.put(FaDepreCalculator.FA_DEP_DEPCOUNT, new Integer(depCount));
        } else {
            BigDecimal leftAmount = this.getLastTwoYearDepr(faCardInfo);
            BigDecimal leftPeriod = this.getLeftLife(faCardInfo);
            leftAmount = this.getLeftAmount(faCardInfo);
            periodDepreAmount = leftAmount.divide(leftPeriod, baseCurPrecision, 4);
            periodDepreRate = periodDepreAmount.multiply(new BigDecimal("100")).divide(assetValue, depreRatePrecision, 4);
            if (this.isFinalyDepCal(faCardInfo)) {
                periodDepreAmount = this.getLeftAmount(faCardInfo);
            }
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
            returnValue.put(FaDepreCalculator.FA_DEP_CALDEPAMOUNT, leftAmount);
        }
        return returnValue;
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) throws BOSException, EASBizException {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("assetValue", "");
        hm.put("accuDepr", "");
        hm.put("decValue", "");
        hm.put("useTermCount", "");
        hm.put("useYears", "");
        hm.put("neatRemValue", "");
        return hm;
    }

    private int getDeprYear(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        int periodCount = this.getValidPeriodCountofYear(ctx, period);
        BigDecimal deprTermCount = card.getDeprTermCount() == null ? new BigDecimal("0") : card.getDeprTermCount();
        int deprTerm = deprTermCount.intValue();
        return deprTerm / periodCount;
    }

    private int getDepCount(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT) != null) {
            Integer depCount = (Integer)hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT);
            return depCount;
        }
        return 0;
    }

    private BigDecimal getCalDepAmount(FaCurCardInfo faCardInfo, Context ctx, PeriodInfo period) throws BOSException {
        HashMap hm = (HashMap)this.getUserObject();
        BigDecimal accuDepr = new BigDecimal("0");
        accuDepr = hm != null && hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT) != null && hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT) != null && (Integer)hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT) < this.getValidPeriodCountofYear(ctx, period) ? (BigDecimal)hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT) : (faCardInfo.getAccuDepr() == null ? new BigDecimal("0") : faCardInfo.getAccuDepr());
        return accuDepr;
    }

    private boolean isLastTwoYear(FaCurCardInfo card) throws BOSException {
        BigDecimal depTermCount;
        BigDecimal useTermCount = card.getUseTermCount();
        BigDecimal temp = useTermCount.subtract(depTermCount = card.getDeprTermCount() == null ? new BigDecimal(0) : card.getDeprTermCount()).divide(new BigDecimal(this.getPeriodCount()), 2, 4);
        return temp.compareTo(new BigDecimal(2)) <= 0;
    }

    private boolean hasChanged(FaCurCardInfo card) throws BOSException {
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_LEFTYEARUP) != null) {
            Integer depCount = (Integer)hm.get(FaDepreCalculator.FA_DEP_LEFTYEARUP);
            return depCount == 1;
        }
        return false;
    }

    private BigDecimal getLastTwoYearDepr(FaCurCardInfo faCardInfo) {
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT) != null) {
            BigDecimal lastTwoYearDepr = (BigDecimal)hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT);
            return lastTwoYearDepr;
        }
        return this.getLeftAmount(faCardInfo);
    }

    @Override
    protected BigDecimal getLeftAmount(FaCurCardInfo faCardInfo) {
        BigDecimal assetValue = faCardInfo.getAssetValue();
        if (assetValue == null || assetValue.compareTo(new BigDecimal("0")) <= 0) {
            return new BigDecimal("0");
        }
        BigDecimal accuDepr = faCardInfo.getAccuDepr() == null ? new BigDecimal("0") : faCardInfo.getAccuDepr();
        BigDecimal decValue = faCardInfo.getDecValue() == null ? new BigDecimal("0") : faCardInfo.getDecValue();
        BigDecimal neatRemValue = faCardInfo.getNeatRemValue() == null ? new BigDecimal("0") : faCardInfo.getNeatRemValue();
        BigDecimal result = assetValue.subtract(accuDepr).subtract(neatRemValue).subtract(decValue);
        if (result.compareTo(new BigDecimal("0")) > 0) {
            return result;
        }
        return new BigDecimal("0");
    }
}

