/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCardCollection;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.IFaMonCard;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;

public class FaDepCalDoubleSubtractStrategy
extends AbstractFaDepCalStrategy {
    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        HashMap<Integer, Number> returnValue = new HashMap<Integer, Number>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal yearDepreAmount = null;
        BigDecimal periodDepreAmount = null;
        BigDecimal yearDepreRate = null;
        BigDecimal periodDepreRate = null;
        BigDecimal percent = new BigDecimal(100);
        BigDecimal assetValue = faCardInfo.getAssetValue() == null ? new BigDecimal("0") : faCardInfo.getAssetValue();
        BigDecimal decValue = faCardInfo.getDecValue() == null ? new BigDecimal("0") : faCardInfo.getDecValue();
        BigDecimal accuDepr = this.getCalDepAmount(faCardInfo, ctx, period);
        int depCount = this.getDepCount(ctx, faCardInfo, period);
        boolean yearDep = this.isYearDep(faCardInfo);
        if (!this.isLastTwoYear(faCardInfo)) {
            BigDecimal useYear = this.getDownLeftYear(ctx, faCardInfo, period);
            BigDecimal useTermCount = faCardInfo.getUseTermCount();
            int periodCount = this.getPeriodCount();
            yearDepreRate = new BigDecimal(2).multiply(percent).multiply(new BigDecimal(periodCount)).divide(useTermCount, depreRatePrecision, 4);
            BigDecimal temp1 = assetValue.subtract(decValue).subtract(accuDepr);
            yearDepreAmount = temp1.multiply(yearDepreRate).divide(percent, baseCurPrecision, 4);
            if (yearDep) {
                returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, yearDepreAmount);
                returnValue.put(FaDepreCalculator.FA_DEP_RATE, yearDepreRate);
            } else {
                depCount = depCount >= this.getValidPeriodCountofYear(ctx, period) ? 1 : ++depCount;
                periodDepreRate = yearDepreRate.divide(new BigDecimal(this.getPeriodCount()), depreRatePrecision, 4);
                periodDepreAmount = yearDepreAmount.divide(new BigDecimal(this.getPeriodCount()), baseCurPrecision, 4);
                returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
                returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
                returnValue.put(FaDepreCalculator.FA_DEP_LEFTYEAR, useYear);
                returnValue.put(FaDepreCalculator.FA_DEP_CALDEPAMOUNT, accuDepr);
                returnValue.put(FaDepreCalculator.FA_DEP_DEPCOUNT, new Integer(depCount));
            }
        } else if (yearDep) {
            yearDepreAmount = this.getYearAmountLastTwoYear(ctx, faCardInfo);
            yearDepreRate = yearDepreAmount.multiply(percent).divide(assetValue, depreRatePrecision, 4);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, yearDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, yearDepreRate);
        } else {
            BigDecimal leftAmount = this.getLeftAmount(faCardInfo);
            BigDecimal leftPeriod = this.getLeftLife(faCardInfo);
            depCount = depCount >= this.getValidPeriodCountofYear(ctx, period) ? 1 : ++depCount;
            periodDepreAmount = leftAmount.divide(leftPeriod, baseCurPrecision, 4);
            periodDepreRate = periodDepreAmount.multiply(new BigDecimal("100")).divide(assetValue, depreRatePrecision, 4);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
        }
        return returnValue;
    }

    private BigDecimal getYearAmountLastTwoYear(Context ctx, FaCurCardInfo card) throws BOSException, EASBizException {
        Date date = this.getLastTwoYearDate(card);
        PeriodInfo period1 = PeriodUtils.getPeriodInfo((Context)ctx, (Date)date, (CompanyOrgUnitInfo)FaDepLocalUtils.getSimpleCurrentCompany(ctx));
        PeriodInfo period2 = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period1);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("assetValue"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("accuDepr"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("decValue"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("neatRemValue"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("faPeriod", (Object)period2.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("faCurCard", (Object)card.getId(), CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        IFaMonCard monCard = FaMonCardFactory.getLocalInstance(ctx);
        FaMonCardCollection monCardCollection = monCard.getFaMonCardCollection(entityViewInfo);
        if (monCardCollection.size() == 0) {
            return new BigDecimal("0");
        }
        FaMonCardInfo monCardInfo = monCardCollection.get(0);
        BigDecimal assetValue = monCardInfo.getAssetValue() == null ? new BigDecimal("0") : monCardInfo.getAssetValue();
        BigDecimal accuDepr = monCardInfo.getAccuDepr() == null ? new BigDecimal("0") : monCardInfo.getAccuDepr();
        BigDecimal decValue = monCardInfo.getDecValue() == null ? new BigDecimal("0") : monCardInfo.getDecValue();
        BigDecimal neatRemValue = monCardInfo.getNeatRemValue() == null ? new BigDecimal("0") : monCardInfo.getNeatRemValue();
        BigDecimal result = assetValue.subtract(accuDepr).subtract(decValue).subtract(neatRemValue);
        if (assetValue.compareTo(new BigDecimal("0")) <= 0) {
            return new BigDecimal("0");
        }
        return assetValue.subtract(accuDepr).subtract(decValue).subtract(neatRemValue).divide(new BigDecimal(2), this.getBaseCurrencyPrecision(ctx, card.getCompany()), 4);
    }

    private boolean isLastTwoYear(FaCurCardInfo card) throws BOSException {
        BigDecimal depTermCount;
        BigDecimal useTermCount = card.getUseTermCount();
        BigDecimal temp = useTermCount.subtract(depTermCount = card.getDeprTermCount() == null ? new BigDecimal("0") : card.getDeprTermCount()).divide(new BigDecimal(this.getPeriodCount()), 2, 4);
        return temp.compareTo(new BigDecimal(2)) <= 0;
    }

    private Date getLastTwoYearDate(FaCurCardInfo card) {
        Date beginDate = card.getStartUseDate();
        int useYear = card.getUseYears().intValue();
        int year = beginDate.getYear() + useYear - 2;
        beginDate.setYear(year);
        return beginDate;
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("assetValue", "");
        hm.put("accuDepr", "");
        hm.put("decValue", "");
        hm.put("useYears", "");
        hm.put("neatRemValue", "");
        return hm;
    }

    private int getDepCount(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT) != null) {
            Integer depCount = (Integer)hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT);
            return depCount;
        }
        return 0;
    }

    private BigDecimal getDownLeftYear(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        Integer leftYear;
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_LEFTYEAR) != null && (leftYear = (Integer)hm.get(FaDepreCalculator.FA_DEP_LEFTYEAR)) > 0) {
            return new BigDecimal(leftYear);
        }
        int periodCount = this.getValidPeriodCountofYear(ctx, period);
        BigDecimal remainderPeriod = this.getLeftLife(card);
        BigDecimal remainderYear = remainderPeriod.divide(new BigDecimal(periodCount), 0, 4);
        if (remainderYear.doubleValue() < 1.0) {
            remainderYear = remainderPeriod.divide(new BigDecimal(periodCount), 10, 4);
        }
        return remainderYear;
    }

    private BigDecimal getCalDepAmount(FaCurCardInfo faCardInfo, Context ctx, PeriodInfo period) throws BOSException {
        HashMap hm = (HashMap)this.getUserObject();
        BigDecimal accuDepr = new BigDecimal("0");
        accuDepr = hm != null && hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT) != null && hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT) != null && (Integer)hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT) < this.getValidPeriodCountofYear(ctx, period) ? (BigDecimal)hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT) : (faCardInfo.getAccuDepr() == null ? new BigDecimal("0") : faCardInfo.getAccuDepr());
        return accuDepr;
    }

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        HashMap<Integer, Number> returnValue = new HashMap<Integer, Number>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal yearDepreAmount = null;
        BigDecimal periodDepreAmount = null;
        BigDecimal yearDepreRate = null;
        BigDecimal periodDepreRate = null;
        BigDecimal percent = new BigDecimal(100);
        BigDecimal assetValue = faCardInfo.getAssetValue() == null ? new BigDecimal("0") : faCardInfo.getAssetValue();
        BigDecimal decValue = faCardInfo.getDecValue() == null ? new BigDecimal("0") : faCardInfo.getDecValue();
        BigDecimal accuDepr = this.getCalDepAmount(faCardInfo, ctx, period);
        int depCount = this.getDepCount(ctx, faCardInfo, period);
        boolean yearDep = this.isYearDep(faCardInfo);
        if (!this.isLastTwoYear(faCardInfo)) {
            int useYear = faCardInfo.getUseYears().intValue();
            yearDepreRate = new BigDecimal(2).divide(new BigDecimal(useYear), depreRatePrecision, 4);
            BigDecimal bOne = new BigDecimal("1");
            int deprYear = this.getDeprYear(ctx, faCardInfo, period);
            double dtemp = bOne.subtract(yearDepreRate).doubleValue();
            dtemp = Math.pow(dtemp, deprYear);
            BigDecimal temp1 = new BigDecimal(dtemp);
            yearDepreAmount = temp1.multiply(assetValue).multiply(yearDepreRate);
            if (yearDep) {
                returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, yearDepreAmount);
                returnValue.put(FaDepreCalculator.FA_DEP_RATE, yearDepreRate.multiply(percent));
            } else {
                depCount = depCount >= this.getValidPeriodCountofYear(ctx, period) ? 1 : ++depCount;
                periodDepreRate = yearDepreRate.divide(new BigDecimal(this.getPeriodCount()), depreRatePrecision, 4);
                periodDepreAmount = yearDepreAmount.divide(new BigDecimal(this.getPeriodCount()), baseCurPrecision, 4);
                returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
                returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate.multiply(percent));
                returnValue.put(FaDepreCalculator.FA_DEP_LEFTYEAR, new BigDecimal(useYear));
                returnValue.put(FaDepreCalculator.FA_DEP_CALDEPAMOUNT, accuDepr);
                returnValue.put(FaDepreCalculator.FA_DEP_DEPCOUNT, new Integer(depCount));
            }
        } else if (yearDep) {
            yearDepreAmount = this.getYearAmountLastTwoYear(ctx, faCardInfo);
            yearDepreRate = yearDepreAmount.multiply(percent).divide(assetValue, depreRatePrecision, 4);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, yearDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, yearDepreRate);
        } else {
            BigDecimal leftAmount = this.getLeftAmount(faCardInfo);
            BigDecimal leftPeriod = this.getLeftLife(faCardInfo);
            depCount = depCount >= this.getValidPeriodCountofYear(ctx, period) ? 1 : ++depCount;
            periodDepreAmount = leftAmount.divide(leftPeriod, baseCurPrecision, 4);
            periodDepreRate = periodDepreAmount.multiply(percent).divide(assetValue, depreRatePrecision, 4);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
        }
        return returnValue;
    }

    private int getDeprYear(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        int periodCount = this.getValidPeriodCountofYear(ctx, period);
        BigDecimal deprTermCount = card.getDeprTermCount() == null ? new BigDecimal("0") : card.getDeprTermCount();
        int deprTerm = deprTermCount.intValue();
        return deprTerm / periodCount;
    }
}

