/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDpreCalcException;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import java.math.BigDecimal;
import java.util.HashMap;

public class FaDepCalDyAveUsingAgeStrategy
extends AbstractFaDepCalStrategy {
    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo periodInfo) throws BOSException, EASBizException {
        HashMap<Integer, BigDecimal> returnValue = new HashMap<Integer, BigDecimal>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal yearDepreAmount = null;
        BigDecimal periodDepreAmount = null;
        BigDecimal yearDepreRate = null;
        BigDecimal periodDepreRate = null;
        BigDecimal assetValue = faCardInfo.getAssetValue() == null ? new BigDecimal("0") : faCardInfo.getAssetValue();
        BigDecimal leftAmount = this.getLeftAmount(faCardInfo);
        BigDecimal leftPeriod = this.getLeftLife(faCardInfo);
        if (this.isYearDep(faCardInfo)) {
            yearDepreAmount = leftAmount.divide(new BigDecimal(this.getRemainderYear(ctx, faCardInfo, periodInfo)), baseCurPrecision, 4);
            yearDepreRate = yearDepreAmount.multiply(new BigDecimal("100")).divide(assetValue, depreRatePrecision, 4);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, yearDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, yearDepreRate);
        } else {
            periodDepreAmount = leftAmount.divide(leftPeriod, baseCurPrecision, 4);
            periodDepreRate = periodDepreAmount.multiply(new BigDecimal("100")).divide(assetValue, depreRatePrecision, 4);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
        }
        return returnValue;
    }

    private int getRemainderYear(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo periodInfo) throws BOSException, EASBizException {
        BigDecimal remainderPeriod = this.getLeftLife(faCardInfo);
        BigDecimal periodCountofYear = null;
        periodCountofYear = new BigDecimal(this.getValidPeriodCountofYear(ctx, periodInfo));
        BigDecimal remainderYear = null;
        if (periodCountofYear.compareTo(new BigDecimal("0")) < 0) {
            throw new FaDpreCalcException(FaDpreCalcException.EXP_USE_YEAR_ISZERO);
        }
        remainderYear = remainderPeriod.divide(periodCountofYear, 0, 0);
        return remainderYear.intValue();
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("assetValue", "");
        hm.put("accuDepr", "");
        hm.put("decValue", "");
        hm.put("neatRemValue", "");
        return hm;
    }

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        return null;
    }
}

