/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.common.AccountConstant;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FADepreciationPolicyInfo;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepEntryStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaEvalDepreciationInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepCalExecutor;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepORMapping;
import com.kingdee.eas.fi.fa.manage.app.FaDepStrategyFactory;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.IFaDepCalStrategy;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FaDepCalHelper {
    private static Logger logger = Logger.getLogger(FaDepCalHelper.class);
    private static String CAL_CARD = "calcard";
    private static String CAL_DEP = "tempcaldep";
    private static boolean LAST_PERIOD_CONTINUE = false;
    protected static final String BOSTYPE_DEPENTRY = "3EB04861";
    protected static final String BOSTYPE_DEPDISTRBUTE = "F7EB9ACC";
    protected static final String BOSTYPE_DEPASSETACTCOM = "23552A32";
    private static String floatValue = "0.0000000000000000";

    private FaDepCalHelper() {
    }

    public static void main(String[] args) {
        Context ctx = null;
        String depmethodNumber = "001";
        String depID = "depID";
        String curPeriodID = "curPeriodID";
        String companyID = "companyID";
        int baseCurPrecision = 2;
        int depreRatePrecision = 4;
        try {
            logger.info((Object)FaDepCalHelper.getCalDepEntrySQL(ctx, depmethodNumber, depID, baseCurPrecision, depreRatePrecision, true, ""));
            logger.info((Object)FaDepCalHelper.getCalDepDistributeSQL(ctx, baseCurPrecision));
            logger.info((Object)FaDepCalHelper.getUpdateCurcardSQL(ctx, curPeriodID, companyID, "depmethodID"));
            logger.info((Object)FaDepCalHelper.getUpdateBalanceSQL(ctx, curPeriodID, companyID, depmethodNumber));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static void calDepBySQL(Context ctx, String depID, String[] depmethodNumber, String companyID, String curPeriodID, boolean updateCard, boolean insertDep, String tempTable) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select baseCurrency.precision where id = '" + companyID + "'");
        int baseCurPrecision = company.getBaseCurrency() == null ? 2 : company.getBaseCurrency().getPrecision();
        ObjectUuidPK pk = new ObjectUuidPK(company.getId());
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("FA_007", pk);
        paramKeyMap.put("FA_051", pk);
        HashMap hmParam = ParamManager.getParamHashMap((Context)ctx, paramKeyMap);
        String scale = (String)hmParam.get("FA_007");
        int depreRatePrecision = scale == null ? 4 : Integer.valueOf(scale);
        boolean bl = LAST_PERIOD_CONTINUE = hmParam.get("FA_051") == null ? false : "true".equals(hmParam.get("FA_051").toString());
        if (insertDep) {
            Object[] sqlParaCalDepEntry = new Object[]{companyID, curPeriodID};
            for (int i = 0; i < depmethodNumber.length; ++i) {
                DbUtil.execute((Context)ctx, (String)("/*dialect*/" + FaDepCalHelper.getCalDepEntrySQL(ctx, depmethodNumber[i], depID, baseCurPrecision, depreRatePrecision, insertDep && updateCard, curPeriodID).toString()), (Object[])sqlParaCalDepEntry);
                logger.debug((Object)FaDepCalHelper.getCalDepEntrySQL(ctx, depmethodNumber[i], depID, baseCurPrecision, depreRatePrecision, insertDep && updateCard, curPeriodID));
            }
            PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(curPeriodID));
            if (prePeriod != null && prePeriod.isIsAdjustPeriod()) {
                prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(prePeriod.getId().toString()));
            }
            if (prePeriod != null && prePeriod.getId() != null) {
                String depSQL = "select fid as id from t_fa_fadepreciation where fperiod=? and fcompanyid=? and fdepType=?";
                Object[] depPara = new Object[]{prePeriod.getId().toString(), companyID, new Integer(0)};
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)depSQL, (Object[])depPara);
                try {
                    if (rowSet.next()) {
                        for (int i = 0; i < depmethodNumber.length; ++i) {
                            String depMethodId = FaLocalUtils.getMethodID(ctx, depmethodNumber[i]);
                            DbUtil.execute((Context)ctx, (String)("delete from " + tempTable));
                            DbUtil.execute((Context)ctx, (String)FaDepCalHelper.insertDataIntoTempTable(ctx, curPeriodID, prePeriod.getId().toString(), companyID, depMethodId, depmethodNumber[i], depID, tempTable).toString());
                            logger.debug((Object)FaDepCalHelper.insertDataIntoTempTable(ctx, curPeriodID, prePeriod.getId().toString(), companyID, depMethodId, depmethodNumber[i], depID, tempTable));
                            DbUtil.execute((Context)ctx, (String)FaDepCalHelper.getUpdateLastDepValueSQL(ctx, depID, tempTable).toString());
                            logger.debug((Object)FaDepCalHelper.getUpdateLastDepValueSQL(ctx, depID, tempTable));
                        }
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            Object[] sqlParaCalDepDistribute = new Object[]{curPeriodID, companyID, depmethodNumber[0], depmethodNumber[1], companyID, curPeriodID};
            DbUtil.execute((Context)ctx, (String)FaDepCalHelper.getCalDepDistributeSQL(ctx, baseCurPrecision).toString(), (Object[])sqlParaCalDepDistribute);
            Object[] sqlParaCalDepDistribute1 = new Object[]{curPeriodID, companyID};
            DbUtil.execute((Context)ctx, (String)FaDepCalHelper.getCalDepComDistributeSQL(ctx, baseCurPrecision).toString(), (Object[])sqlParaCalDepDistribute1);
            logger.debug((Object)FaDepCalHelper.getCalDepDistributeSQL(ctx, baseCurPrecision));
            logger.debug((Object)FaDepCalHelper.getCalDepComDistributeSQL(ctx, baseCurPrecision));
        }
        if (updateCard) {
            String depMethodId = " (";
            for (int i = 0; i < depmethodNumber.length; ++i) {
                depMethodId = depMethodId + "'";
                depMethodId = depMethodId + FaLocalUtils.getMethodID(ctx, depmethodNumber[i]);
                depMethodId = depMethodId + "'";
                if (i == depmethodNumber.length - 1) continue;
                depMethodId = depMethodId + ",";
            }
            depMethodId = depMethodId + ") ";
            DbUtil.execute((Context)ctx, (String)FaDepCalHelper.getUpdateCurcardSQL(ctx, curPeriodID, companyID, depMethodId).toString());
            logger.debug((Object)FaDepCalHelper.getUpdateCurcardSQL(ctx, curPeriodID, companyID, depMethodId));
            DbUtil.execute((Context)ctx, (String)FaDepCalHelper.getUpdateBalanceSQL(ctx, curPeriodID, companyID, depMethodId).toString());
            logger.debug((Object)FaDepCalHelper.getUpdateBalanceSQL(ctx, curPeriodID, companyID, depMethodId));
        }
    }

    public static void calEvalDepBySQL(Context ctx, Connection conn, FaEvalDepreciationInfo evalInfo, CompanyOrgUnitInfo company, String[] depmethodNumber, PeriodInfo period, int depreRatePrecision, boolean updateCard, boolean insertDep, String tempTable) throws BOSException, EASBizException {
        FaCurCardCollection updateCards = new FaCurCardCollection();
        try {
            PeriodInfo currperiod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
            String numberString = " ('001','010') ";
            String sql = "/*dialect*/" + FaDepCalHelper.getCalCardSQL(ctx, numberString, currperiod.getId().toString(), true).toString();
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{company.getId().toString(), period.getId().toString()});
            HashSet<String> set = new HashSet<String>();
            while (rowset.next()) {
                set.add(rowset.getString("fid"));
            }
            FaDepCalHelper.InsertFaCurCardIDintoTempTable(ctx, conn, tempTable, set);
            int length = 5000;
            for (int i = 0; i < set.size() / length + 1 && set.size() != 0; ++i) {
                String getCardInfoSql = "/*dialect*/" + FaDepCalHelper.getCardInfoSQL(ctx, tempTable, length, i).toString();
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getCardInfoSql, (Object[])new Object[]{i * length, (i + 1) * length, company.getId().toString()});
                FaDepreCalculator calculator = new FaDepreCalculator();
                int periodCount = FaDepLocalUtils.getValidPeriodCountofYear(ctx, currperiod, false);
                while (rs.next()) {
                    String companyId;
                    FaEvalDepreciationEntryInfo entry;
                    HashMap result;
                    FaDepreciationModeInfo deprMethod = new FaDepreciationModeInfo();
                    String deprModeId = rs.getString("FEvalDeprModeID");
                    deprMethod.setId(deprModeId == null || deprModeId.length() == 0 ? null : BOSUuid.read((String)deprModeId));
                    deprMethod.setNumber(rs.getString("FEvalDeprModeNum"));
                    deprMethod.setIsWorkload(rs.getBoolean("FEvalModeIsWorkLoad"));
                    deprMethod.setIsCustom(rs.getBoolean("FEvalDeprModeIsCustom"));
                    deprMethod.setIsUseTaxCalc(rs.getBoolean("FEvalDeprModeIsUseTax"));
                    IFaDepCalStrategy strategy = FaDepStrategyFactory.getStrategyByMethod(deprMethod);
                    if (strategy == null) continue;
                    FaCurCardInfo card = new FaCurCardInfo();
                    card.setId(BOSUuid.read((String)rs.getString("fid")));
                    card.setEvalDeprPeriodNum(rs.getBigDecimal("FEvalDeprPeriodNum"));
                    card.setEvalDeprMode(deprMethod);
                    card.setEvalMonthRate(rs.getBigDecimal("FEvalMonthRate"));
                    card.setEvalAddDepr(rs.getBigDecimal("FEvalAddDepr"));
                    card.setEvalRemValue(rs.getBigDecimal("FEvalRemValue"));
                    card.setEvalYearDepr(rs.getBigDecimal("FEvalYearDepr"));
                    card.setEvalDecValue(rs.getBigDecimal("FEvalDecValue"));
                    card.setEvalNeatValue(rs.getBigDecimal("FEvalNeatValue"));
                    card.setEvalNeatAmt(rs.getBigDecimal("FEvalNeatAmt"));
                    card.setEvalAssetValue(rs.getBigDecimal("FEvalAssetValue"));
                    card.setEvalTaxLeftPeriod(rs.getBigDecimal("FEvalTaxLeftPeriod"));
                    card.setEvalUseTermCount(rs.getBigDecimal("FEvalUseTermCount"));
                    card.setEvalNeatLeftRate(rs.getBigDecimal("FEvalNeatLeftRate"));
                    card.setCompany(company);
                    FaCatInfo cat = new FaCatInfo();
                    String catId = rs.getString("assetCatId");
                    cat.setId(catId == null || catId.length() == 0 ? null : BOSUuid.read((String)catId));
                    card.setAssetCat(cat);
                    FADepreciationPolicyInfo policy = new FADepreciationPolicyInfo();
                    policy.setTailDispose(rs.getBoolean("ftaildispose"));
                    cat.setDepreciationPolicy(policy);
                    strategy.setDeprRatePrecision(depreRatePrecision);
                    strategy.setPeriodCount(periodCount);
                    calculator.setDefaultDpereStrategy(null, strategy);
                    if (!calculator.isHaveAmountAndLifeForDep(card, ctx) || (result = calculator.getEvalDepreResult(ctx, card, currperiod)) == null || result.size() == 0) continue;
                    if (insertDep && (entry = FaDepCalExecutor.genEvalDepEntryInfo(ctx, card, result, companyId = company.getId().toString(), null)) != null) {
                        entry.setLnkFaDepreEntry(evalInfo);
                        entry.setState(insertDep && updateCard ? FaDepEntryStatusEnum.YAUDIT_NMODIFY : FaDepEntryStatusEnum.NAUDIT_NMODIFY);
                        evalInfo.getLnkFaDepreEntry().add(entry);
                    }
                    if (!updateCard) continue;
                    FaDepLocalUtils.updateCardDepForTax(card, result);
                    updateCards.add(card);
                }
            }
            if (updateCards.size() > 0) {
                FaDepORMapping.batchUpdateEvalDepForCard(conn, (IObjectCollection)updateCards);
            }
            if (evalInfo.getLnkFaDepreEntry().size() > 0) {
                FaEvalDepreciationFactory.getLocalInstance(ctx).submit((CoreBaseInfo)evalInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private static Object getCardInfoSQL(Context ctx, String tempTable, int length, int i) {
        StringBuffer result = new StringBuffer();
        result.append("SELECT " + FaDepCalHelper.getCalEvalCardColumn() + " FROM t_fa_facurcard curcard \t\t\t\n");
        result.append("INNER JOIN t_fa_cat t1 ON curcard.fassetcatid = t1.fid  \t\t\t\t\t\t\n");
        result.append("INNER JOIN t_fa_depreciationpolicy t2 ON t1.fdepreciationpolicyid = t2.fid \t\n");
        result.append("INNER JOIN " + tempTable + " t3 ON curcard.FID = t3.FFaCurCardID \t\t\t\n");
        result.append("INNER JOIN t_fa_depreciationmode t5 ON curcard.FEvalDeprModeID = t5.fid \n");
        result.append("WHERE \t\t\t\t\t\t\n");
        result.append("t3.FSEQ > ? \t\t\t\t\t\n");
        result.append("AND t3.FSEQ <= ? \t\t\t\n");
        result.append("AND curcard.fcompanyid = ? \t\n");
        logger.debug((Object)result.toString());
        return result;
    }

    private static String getCalEvalCardColumn() {
        StringBuffer result = new StringBuffer();
        result.append("curcard.fid AS fid, ");
        result.append("curcard.fevalleftperiod AS fevalleftperiod, ");
        result.append("t2.finitoldasset AS finitoldasset, ");
        result.append("t2.ftaildispose AS ftaildispose,");
        result.append("t1.fid as assetCatId,");
        result.append("curcard.FEvalDeprPeriodNum as FEvalDeprPeriodNum,");
        result.append("t5.fid as FEvalDeprModeID,");
        result.append("t5.fnumber as FEvalDeprModeNum,");
        result.append("t5.FIsWorkLoad as FEvalModeIsWorkLoad,");
        result.append("t5.FIsCustom as FEvalDeprModeIsCustom,");
        result.append("t5.FIsUseTaxCalc as FEvalDeprModeIsUseTax,");
        result.append("curcard.FEvalMonthRate as FEvalMonthRate,");
        result.append("curcard.FEvalAddDepr as FEvalAddDepr,");
        result.append("curcard.FEvalRemValue as FEvalRemValue,");
        result.append("curcard.FEvalYearDepr as FEvalYearDepr,");
        result.append("curcard.FEvalDecValue as FEvalDecValue,");
        result.append("curcard.FEvalNeatValue as FEvalNeatValue,");
        result.append("curcard.FEvalNeatAmt as FEvalNeatAmt,");
        result.append("curcard.FEvalAssetValue as FEvalAssetValue,");
        result.append("curcard.FEvalTaxLeftPeriod as FEvalTaxLeftPeriod,");
        result.append("curcard.FEvalUseTermCount as FEvalUseTermCount,");
        result.append("curcard.FEvalNeatLeftRate as FEvalNeatLeftRate \n");
        return result.toString();
    }

    private static void InsertFaCurCardIDintoTempTable(Context ctx, Connection conn, String tempTable, Set set) throws BOSException {
        PreparedStatement pst = null;
        try {
            if (tempTable == null || set.size() == 0) {
                return;
            }
            pst = conn.prepareStatement("Insert into " + tempTable + "(FFaCurCardID, FSEQ) values(?,?)");
            Iterator it = set.iterator();
            int i = 1;
            while (it.hasNext()) {
                String id = it.next().toString();
                pst.setString(1, id);
                pst.setInt(2, i);
                pst.addBatch();
                if (i % 2000 == 0) {
                    pst.executeBatch();
                    pst.clearParameters();
                }
                ++i;
            }
            pst.executeBatch();
            SQLUtils.cleanup((Statement)pst);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pst);
        }
    }

    private static StringBuffer getCalDepEntrySQL(Context ctx, String number, String depID, int baseCurPrecision, int depreRatePrecision, boolean isAudit, String currPeriodId) throws BOSException {
        StringBuffer result = new StringBuffer();
        result.append("INSERT INTO t_fa_fadepreciationentry \n");
        result.append("(fid, fmonthdeprerate, fbegindepre, fdepreciation, fshoulddepre, fnotdepre, fyearaddupdep, fenddepre, flnkfadepreentry, ffacurcardid, fstate)\n");
        result.append("SELECT " + FaLocalUtils.newBosID(ctx, BOSTYPE_DEPENTRY, true) + " AS fid,\n");
        result.append("ROUND (tempcaldep.fa_dep_rate, " + depreRatePrecision + ") AS monthdeprerate, \n");
        result.append("ROUND (tempcaldep.deprebeginbalancefor, " + baseCurPrecision + ") AS begindepre, \n");
        result.append("ROUND (" + FaDepCalHelper.dealPeriodAmount(number, baseCurPrecision) + ", " + baseCurPrecision + ") AS depreciation, \n");
        result.append("ROUND (" + FaDepCalHelper.dealPeriodAmount(number, baseCurPrecision) + ", " + baseCurPrecision + ") AS shoulddepre, \n");
        result.append("ROUND ((tempcaldep.orgneatamt - " + FaDepCalHelper.dealPeriodAmount(number, baseCurPrecision) + " - tempcaldep.orgneatremvalue), " + baseCurPrecision + ") AS notdepre, \n");
        result.append("ROUND ((" + FaDepCalHelper.dealPeriodAmount(number, baseCurPrecision) + " + tempcaldep.addupyeardepre), " + baseCurPrecision + ") AS yearaddupdep, \n");
        result.append("ROUND ((tempcaldep.orgfaccudepr + " + FaDepCalHelper.dealPeriodAmount(number, baseCurPrecision) + "), " + baseCurPrecision + ") AS enddepre, \n");
        result.append("'" + depID + "' AS deprehead, \n");
        result.append("tempcaldep.fid AS curcardid, \n");
        result.append((isAudit ? 3 : 1) + " AS state \n");
        result.append("FROM ( " + FaDepCalHelper.getCalDepSQL(ctx, number, baseCurPrecision, currPeriodId) + " ) " + CAL_DEP);
        return result;
    }

    private static String dealPeriodAmount(String depMethodNumber, int baseCurPrecision) {
        StringBuffer result = new StringBuffer();
        if (depMethodNumber.equals("010") && LAST_PERIOD_CONTINUE) {
            result.append(" CASE \n");
            result.append("    WHEN tempcaldep.leftamount - ROUND (tempcaldep.fa_dep_amount, " + baseCurPrecision + ") < 0 ");
            result.append("      \n");
            result.append("       THEN tempcaldep.leftamount \n");
            result.append("    ELSE ROUND (tempcaldep.fa_dep_amount, " + baseCurPrecision + ") \n");
            result.append(" END \n");
        } else {
            result.append(" CASE \n");
            result.append("    WHEN tempcaldep.leftamount - ROUND (tempcaldep.fa_dep_amount, " + baseCurPrecision + ") < 0 ");
            result.append("     OR (tempcaldep.leftlife = 1 AND tempcaldep.ftaildispose = 1) \n");
            result.append("       THEN tempcaldep.leftamount \n");
            result.append("    ELSE ROUND (tempcaldep.fa_dep_amount, " + baseCurPrecision + ") \n");
            result.append(" END \n");
        }
        return result.toString();
    }

    public static StringBuffer getCalDepComDistributeSQL(Context ctx, int baseCurPrecision) {
        StringBuffer result = new StringBuffer();
        result.append("INSERT INTO T_FA_FaDepAsstActComposit \n");
        result.append("(fid, fseq, fasstacttypeid, fasstactitem,fbillid)\n");
        result.append("SELECT " + FaLocalUtils.newBosID(ctx, BOSTYPE_DEPASSETACTCOM) + " AS fid, \n");
        result.append("costcenterNew.fseq AS seq, costcenterNew.FAsstActType AS assttype, costcenterNew.fasstactitem AS asstitem,\n");
        result.append("            distribute.fid AS fbillid\n");
        result.append("       FROM t_fa_fadepreciationentry depentry INNER JOIN t_fa_facurcard curcard ON curcard.fid = depentry.ffacurcardid\n");
        result.append("       INNER JOIN T_FA_FaDepDistribute distribute ON distribute.FDepEntryID = depentry.fid\n");
        result.append("       INNER JOIN t_fa_facurcostcenter costcenter ON costcenter.ffacurcardid = depentry.ffacurcardid\n");
        result.append("       AND costcenter.fseq = distribute.fseq \n");
        result.append("       INNER JOIN T_FA_FaCurAsstActComposit costcenterNew ON costcenterNew.FFaCurCostCenterID = costcenter.fid\n");
        result.append("       INNER JOIN t_fa_fadepreciation dep ON depentry.flnkfadepreentry = dep.fid\n");
        result.append("WHERE \n");
        result.append(" dep.fperiod = ? \n");
        result.append(" AND dep.fcompanyid = ? \n");
        return result;
    }

    public static StringBuffer getCalDepDistributeSQL(Context ctx, int baseCurPrecision) {
        StringBuffer result = new StringBuffer();
        result.append("INSERT INTO t_fa_fadepdistribute \n");
        result.append("(fid, fseq, faccountviewid, famount, fdepentryid,FApportionScale,FProfitCenterID)\n");
        result.append("SELECT " + FaLocalUtils.newBosID(ctx, BOSTYPE_DEPDISTRBUTE) + " AS fid, \n");
        result.append("costcenter.fseq AS seq, costcenter.faccountviewid AS accountview, \n");
        result.append("\t\t\t   CASE\n");
        result.append("               WHEN (   x.countseq * x.maxscale = 100 AND costcenter.fseq = x.minseq\n");
        result.append("                     OR (x.countseq * x.maxscale != 100) AND (costcenter.fapportionscale = x.maxscale AND costcenter.fseq = x.minseqofmaxscale) \n");
        result.append("                    )\n");
        result.append("                  THEN ROUND (costcenter.fapportionscale * depentry.fdepreciation / 100, " + baseCurPrecision + ") + tempoffset.toffset\n");
        result.append("              ELSE ROUND (costcenter.fapportionscale * depentry.fdepreciation / 100, " + baseCurPrecision + ")\n");
        result.append("            END AS amount,\n");
        result.append("            depentry.fid AS depentryid,costcenter.FApportionScale AS FApportionScale \n");
        result.append("            ,costcenter.FProfitCenterID AS FProfitCenterID \n");
        result.append("       FROM t_fa_fadepreciationentry depentry INNER JOIN t_fa_facurcard curcard ON curcard.fid = depentry.ffacurcardid\n");
        result.append("            INNER JOIN t_fa_facurcostcenter costcenter ON costcenter.ffacurcardid = depentry.ffacurcardid\n");
        result.append("            INNER JOIN (\n");
        result.append("            SELECT   MIN (center.fseq) AS minseqofmaxscale, center.ffacurcardid AS ffacurcardid, tmpcenter.MAX AS maxscale, tmpcenter.MIN AS minseq,\n");
        result.append("                     tmpcenter.countseq AS countseq\n");
        result.append("                FROM t_fa_facurcostcenter center INNER JOIN (SELECT   MAX (fapportionscale) AS MAX, MIN (fseq) AS MIN, ffacurcardid AS cardid,\n");
        result.append("                                                                      COUNT (fseq) AS countseq\n");
        result.append("                                                                 FROM t_fa_facurcostcenter\n");
        result.append("                                                             GROUP BY ffacurcardid) tmpcenter ON center.ffacurcardid = tmpcenter.cardid\n");
        result.append("               WHERE center.fapportionscale = tmpcenter.MAX\n");
        result.append("            GROUP BY center.ffacurcardid, tmpcenter.MAX, tmpcenter.MIN, tmpcenter.countseq\n");
        result.append("            ) x ON x.ffacurcardid = depentry.ffacurcardid\n");
        result.append("            INNER JOIN t_fa_fadepreciation dep ON depentry.flnkfadepreentry = dep.fid\n");
        result.append("            INNER JOIN t_fa_depreciationmode t4 ON curcard.fdeprmethodid = t4.fid \n");
        result.append("\t\t\t   INNER JOIN (" + FaDepCalHelper.getSumDepEntryAmount(baseCurPrecision) + ") tempoffset ON tempoffset.curcardid = depentry.ffacurcardid \n");
        result.append("WHERE \n");
        result.append(FaDepCalHelper.getDepCondition("curcard"));
        result.append("AND (t4.fnumber = ? \n");
        result.append("OR t4.fnumber = ? )\n");
        result.append("AND dep.fdeptype = 0 \n");
        result.append("AND dep.fcompanyid = ? \n");
        result.append("AND dep.fperiod = ? \n");
        result.append("GROUP BY depentry.fid,\n");
        result.append("      costcenter.fapportionscale,\n");
        result.append("      costcenter.fseq,\n");
        result.append("      costcenter.faccountviewid,\n");
        result.append("      costcenter.FProfitCenterID,\n");
        result.append("      depentry.fdepreciation,\n");
        result.append("      tempoffset.toffset,");
        result.append("      x.countseq,");
        result.append("      x.maxscale,");
        result.append("      x.minseqofmaxscale,");
        result.append("      x.minseq");
        return result;
    }

    private static StringBuffer getUpdateCurcardSQL(Context ctx, String curPeriodID, String companyID, String depmethodID) {
        StringBuffer result = new StringBuffer();
        result.append("UPDATE t_fa_facurcard\n");
        result.append("   SET (fdeprtterm, faccudepr, faccudeprtyear, faccudeprall, fneatvalue, fneatamt, fdeprtermcount, fisneedredepr, flastupdatetime, fmonthdeprerate, fisoveraged) =\n");
        result.append("          (SELECT depentry.fdepreciation, t_fa_facurcard.faccudepr + depentry.fdepreciation,\n");
        result.append("                  t_fa_facurcard.faccudeprtyear + depentry.fdepreciation, t_fa_facurcard.faccudeprall + depentry.fdepreciation,\n");
        result.append("                  t_fa_facurcard.fneatvalue - depentry.fdepreciation, t_fa_facurcard.fneatamt - depentry.fdepreciation,\n");
        result.append("                  t_fa_facurcard.fdeprtermcount + 1, 0, GETDATE(), depentry.fmonthdeprerate, \n");
        result.append("                  CASE WHEN t_fa_facurcard.fusetermcount <= t_fa_facurcard.fdeprtermcount + 1 THEN 1 ELSE 0 END \n");
        result.append("             FROM t_fa_fadepreciationentry depentry INNER JOIN t_fa_fadepreciation dep ON depentry.flnkfadepreentry = dep.fid\n");
        result.append("            WHERE depentry.ffacurcardid = t_fa_facurcard.fid\n");
        result.append("              AND dep.fperiod = '" + curPeriodID + "'\n");
        result.append("              AND dep.fcompanyid = '" + companyID + "'\n");
        result.append("              AND dep.fdeptype = 0)\n");
        result.append(" WHERE t_fa_facurcard.fcompanyid = '" + companyID + "'\n");
        result.append("   AND t_fa_facurcard.fdeprmethodid in " + depmethodID + "\n");
        result.append("   AND " + FaDepCalHelper.getDepCondition("t_fa_facurcard"));
        return result;
    }

    private static StringBuffer getUpdateBalanceSQL(Context ctx, String curPeriodID, String companyID, String depmethodId) {
        StringBuffer result = new StringBuffer();
        result.append("UPDATE t_fa_faaccountbalance\n");
        result.append("   SET (fdeprecreditfor, fdepreendbalancefor, faddupyeardepre, fdepreterm) =\n");
        result.append("          (SELECT t_fa_faaccountbalance.fdeprecreditfor + depentry.fdepreciation,\n");
        result.append("                  t_fa_faaccountbalance.fdepreendbalancefor + depentry.fdepreciation,\n");
        result.append("                  t_fa_faaccountbalance.faddupyeardepre + depentry.fdepreciation, depentry.fdepreciation\n");
        result.append("             FROM t_fa_fadepreciationentry depentry INNER JOIN t_fa_fadepreciation dep ON depentry.flnkfadepreentry = dep.fid\n");
        result.append("                  INNER JOIN t_fa_facurcard curcard ON depentry.ffacurcardid = curcard.fid\n");
        result.append("                  INNER JOIN t_fa_depreciationmode t4 ON curcard.fdeprmethodid = t4.fid\n");
        result.append("            WHERE depentry.ffacurcardid = t_fa_faaccountbalance.ffacurcardid\n");
        result.append("              AND dep.fperiod = '" + curPeriodID + "'\n");
        result.append("              AND dep.fcompanyid = '" + companyID + "'\n");
        result.append("              AND dep.fdeptype = 0\n");
        result.append("              AND t4.fid in " + depmethodId + "\n");
        result.append("              AND " + FaDepCalHelper.getDepCondition("curcard") + ")\n");
        result.append(" WHERE t_fa_faaccountbalance.fperiodid = '" + curPeriodID + "' AND t_fa_faaccountbalance.fcompanyorgunitid = '" + companyID + "'");
        return result;
    }

    private static StringBuffer insertDataIntoTempTable(Context ctx, String curPeriodID, String prePeriodID, String companyID, String depmethodID, String depMethodNumber, String currentDepID, String tempTable) {
        StringBuffer result = new StringBuffer();
        result.append("Insert Into ").append(tempTable).append("(FMonthDepreRate, FDepreciation, FShouldDepre, FNotDepre, FYearAddUpDep, FEndDepre, FFaCurCardID)\t\t\t\r\n");
        result.append("SELECT ISNULL (tmpcard.fmonthdeprerate, outentry.fmonthdeprerate) AS fmonthdeprerate,\t\t\t\t\t\t\r\n");
        result.append("       ISNULL (tmpcard.fdepreciation, outentry.fdepreciation) AS fdepreciation,\t\t\t\t\t\t\t\t\r\n");
        result.append("       ISNULL (tmpcard.fshoulddepre, outentry.fshoulddepre) AS fshoulddepre,\t\t\t\t\t\t\t\t\t\r\n");
        result.append("       ISNULL (tmpcard.fnotdepre, outentry.fnotdepre) AS fnotdepre,\t\t\t\t\t\t\t\t\t\t\t\r\n");
        result.append("       ISNULL (tmpcard.fyearaddupdep, outentry.fyearaddupdep) AS fyearaddupdep,\t\t\t\t\t\t\t\t\r\n");
        result.append("       ISNULL (tmpcard.fenddepre, outentry.fenddepre) AS fenddepre, outentry.ffacurcardid AS ffacurcardid\t\r\n");
        result.append("  FROM (" + FaDepCalHelper.getUpdateLastDepCard(ctx, curPeriodID, prePeriodID, companyID, depmethodID, depMethodNumber) + ") tmpcard RIGHT OUTER JOIN T_FA_FADEPRECIATIONENTRY outentry ON outentry.ffacurcardid = tmpcard.curcardid\t\t\r\n");
        result.append(" WHERE outentry.flnkfadepreentry = '" + currentDepID + "'\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        return result;
    }

    private static StringBuffer getUpdateLastDepValueSQL(Context ctx, String currentDepID, String tempTable) {
        StringBuffer result = new StringBuffer();
        result.append("UPDATE t_fa_fadepreciationentry\n");
        result.append("   SET (fmonthdeprerate, fdepreciation, fshoulddepre, fnotdepre, fyearaddupdep, fenddepre) =\n");
        result.append("        (SELECT tmpentry.fmonthdeprerate, tmpentry.fdepreciation, tmpentry.fshoulddepre, tmpentry.fnotdepre, tmpentry.fyearaddupdep,\n");
        result.append("                tmpentry.fenddepre\n");
        result.append("           FROM " + tempTable + " tmpentry\n");
        result.append("          WHERE tmpentry.ffacurcardid = T_FA_FADEPRECIATIONENTRY.ffacurcardid)\n");
        result.append(" WHERE t_fa_fadepreciationentry.flnkfadepreentry = '" + currentDepID + "'\n");
        return result;
    }

    private static StringBuffer getUpdateLastDepCard(Context ctx, String curPeriodID, String prePeriodID, String companyID, String depmethodID, String depMethodNumber) {
        String fieldName = depMethodNumber.equals("001") ? "FDepreciation" : "fshoulddepre";
        StringBuffer result = new StringBuffer();
        result.append("SELECT depentry.fmonthdeprerate AS fmonthdeprerate, depentry." + fieldName.trim() + " AS fdepreciation, curcard.fid AS curcardid,\n");
        result.append("       depentry.fshoulddepre AS fshoulddepre,\n");
        result.append("       curcard.fneatamt - depentry." + fieldName.trim() + " - curcard.fneatremvalue AS fnotdepre,\n");
        result.append("       depentry." + fieldName.trim() + " + balance.faddupyeardepre AS fyearaddupdep,\n");
        result.append("       depentry." + fieldName.trim() + " + curcard.faccudepr AS fenddepre\n");
        result.append("  FROM t_fa_famoncard moncard INNER JOIN t_fa_faaccountbalance balance ON moncard.ffacurcardid = balance.ffacurcardid\n");
        result.append("       INNER JOIN t_fa_facurcard curcard ON moncard.ffacurcardid = curcard.fid\n");
        result.append("       INNER JOIN t_fa_cat t1 ON curcard.fassetcatid = t1.fid\n");
        result.append("       INNER JOIN t_fa_depreciationpolicy t2 ON t1.fdepreciationpolicyid = t2.fid\n");
        result.append("       INNER JOIN t_fa_fadepreciationentry depentry ON depentry.ffacurcardid = moncard.ffacurcardid\n");
        result.append("       INNER JOIN t_fa_fadepreciation dep ON dep.fid = depentry.flnkfadepreentry\n");
        result.append("       LEFT OUTER JOIN (SELECT faccudepr, fdeprtermcount, ffacurcardid FROM t_fa_famoncard WHERE ffaperiodid IS NULL AND fcompanyid = '" + companyID + "') initcard ON moncard.ffacurcardid = initcard.ffacurcardid\n");
        result.append(" WHERE moncard.fcompanyid = '" + companyID + "'\n");
        result.append("   AND moncard.ffaperiodid = '" + prePeriodID + "'\n");
        result.append("   AND moncard.fhaschanged != 2\n");
        result.append("   AND moncard.fhascleared = 0\n");
        result.append("   AND dep.fperiod = moncard.ffaperiodid\n");
        result.append("   AND balance.fperiodid = '" + curPeriodID + "'\n");
        result.append("   AND curcard.fdeprmethodid = '" + depmethodID + "'\n");
        result.append("   AND (curcard.fhaschanged = 3 OR curcard.fhaschanged = 0  OR  curcard.fhaschanged = 2 )\n");
        result.append("   AND (curcard.fhascleared = 0 OR (t2.fstartdeprtime = 1 AND curcard.fhascleared != 0))\n");
        if (depMethodNumber.equals("001")) {
            result.append("   AND NOT (    curcard.foriginflag = 0\n");
            result.append("            AND curcard.fisinitchange != 1\n");
            result.append("            AND t2.finitoldasset != 1\n");
            result.append("            AND (initcard.fdeprtermcount != 0 OR initcard.faccudepr != 0)\n");
            result.append("            )\n");
        }
        result.append("   AND (   (curcard.fusetermcount - curcard.fdeprtermcount > 1)\n");
        result.append("      OR ((curcard.fusetermcount - curcard.fdeprtermcount <= 1) AND t2.ftaildispose = 0)\n");
        result.append("       )\n");
        result.append("   AND (moncard.fassetvalue - moncard.faccudepr - moncard.fdecvalue - moncard.fneatremvalue - depentry." + fieldName.trim() + " >= 0\n");
        result.append("       )");
        return result;
    }

    private static StringBuffer getSumDepEntryAmount(int baseCurPrecision) {
        StringBuffer result = new StringBuffer();
        result.append("SELECT \n");
        result.append("tempcal.fdepreciation - SUM (disamount) AS toffset, \n");
        result.append("tempcal.fdepreciation, \n");
        result.append("SUM (disamount) AS sumdisamount, \n");
        result.append("tempcal.ffacurcardid AS curcardid \n");
        result.append("FROM (\n");
        result.append("SELECT depentry.fdepreciation AS fdepreciation, costcenter.fapportionscale, \n");
        result.append("ROUND (costcenter.fapportionscale * depentry.fdepreciation / 100, " + baseCurPrecision + ") AS disamount, \n");
        result.append("costcenter.ffacurcardid, costcenter.fseq \n");
        result.append("FROM t_fa_fadepreciationentry depentry \n");
        result.append("INNER JOIN t_fa_fadepreciation dep ON depentry.flnkfadepreentry = dep.fid \n");
        result.append("INNER JOIN t_fa_facurcostcenter costcenter ON costcenter.ffacurcardid = depentry.ffacurcardid \n");
        result.append("WHERE dep.fdeptype = 0 AND dep.fperiod = ? \n");
        result.append("AND dep.fcompanyid = ? \n");
        result.append(") tempcal \n");
        result.append("GROUP BY tempcal.ffacurcardid, tempcal.fdepreciation\n");
        return result;
    }

    private static StringBuffer getCalDepSQL(Context ctx, String number, int baseCurPrecision, String currPeriodId) throws BOSException {
        String numberString = " ('" + number + "') ";
        StringBuffer result = new StringBuffer();
        result.append("SELECT " + FaDepCalHelper.getCalDepColumn(ctx, number, baseCurPrecision) + " FROM ( " + FaDepCalHelper.getCalCardSQL(ctx, numberString, currPeriodId, false) + " ) \n");
        result.append(CAL_CARD + " \n");
        result.append("WHERE \n");
        if (!number.equals("010") || !LAST_PERIOD_CONTINUE) {
            result.append("(calcard.fusetermcount - calcard.fdeprtermcount) > 0 AND\n");
        }
        result.append(" (calcard.fassetvalue - calcard.faccudepr - calcard.fdecvalue - calcard.fneatremvalue) > 0 \n");
        return result;
    }

    private static StringBuffer getCalDepColumn(Context ctx, String number, int baseCurPrecision) throws BOSException {
        StringBuffer result = new StringBuffer();
        String DepAmountStatic = FaDepCalHelper.getDepAmount_AvgYearMethod_Static();
        String DepAmountDynamic = FaDepCalHelper.getDepAmount_AvgYearMethod_Dynamic();
        String DepRateStatic = FaDepCalHelper.getDepRate_AvgYearMethod_Static(baseCurPrecision);
        String DepRateDynamic = FaDepCalHelper.getDepRate_AvgYearMethod_Dynamic(baseCurPrecision);
        if (number.equals("001")) {
            result.append(" CASE\n");
            result.append("    WHEN (    calcard.foriginflag = 0\n");
            result.append("          AND calcard.fisinitchange != 1\n");
            result.append("          AND calcard.finitoldasset != 1\n");
            result.append("          AND (calcard.initdeprtermcount != 0 OR calcard.initaccudepr != 0)\n");
            result.append("         )\n");
            result.append("       THEN " + DepAmountStatic);
            result.append("    ELSE   " + DepAmountDynamic);
            result.append(" END AS fa_dep_amount,\n");
            result.append(" CASE\n");
            result.append("    WHEN (    calcard.foriginflag = 0\n");
            result.append("          AND calcard.fisinitchange != 1\n");
            result.append("          AND calcard.finitoldasset != 1\n");
            result.append("          AND (calcard.initdeprtermcount != 0 OR calcard.initaccudepr != 0)\n");
            result.append("         )\n");
            result.append("       THEN " + DepRateStatic);
            result.append("    ELSE   " + DepRateDynamic);
            result.append(" END AS fa_dep_rate,\n");
            result.append(" CASE\n");
            result.append("    WHEN (    calcard.foriginflag = 0\n");
            result.append("          AND calcard.fisinitchange != 1\n");
            result.append("          AND calcard.finitoldasset != 1\n");
            result.append("          AND (calcard.initdeprtermcount != 0 OR calcard.initaccudepr != 0)\n");
            result.append("         )\n");
            result.append("       THEN 'static'\n");
            result.append("    ELSE 'dynamic'\n");
            result.append(" END AS isdynamic,\n");
        } else {
            HashMap faParam = new HashMap();
            try {
                faParam = FaManageUtils.getFAParameter(BOSUuid.read((String)FaLocalUtils.getCurrentCompanyId(ctx)), ctx);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
            catch (UuidException e) {
                throw new BOSException((Throwable)e);
            }
            String scale = (String)faParam.get("FA_007");
            int depreRatePrecision = scale == null ? 4 : Integer.valueOf(scale);
            result.append("  " + FaDepCalHelper.getDepAmount_AvgYearOriginMethod(depreRatePrecision));
            result.append("  AS fa_dep_amount,\n");
            result.append("  " + FaDepCalHelper.getDepRate_AvgYearOriginMethod(depreRatePrecision));
            result.append("  AS fa_dep_rate,\n");
            result.append("  'static'\n");
            result.append("  AS isdynamic,\n");
        }
        result.append(" (calcard.fassetvalue - calcard.faccudepr - calcard.fdecvalue - calcard.fneatremvalue) AS leftamount,\n");
        result.append(" (calcard.fusetermcount - calcard.fdeprtermcount) AS leftlife,\n");
        result.append(" calcard.deprebeginbalancefor AS deprebeginbalancefor, calcard.addupyeardepre AS addupyeardepre,\n");
        result.append(" calcard.orgfaccudepr AS orgfaccudepr, calcard.orgneatamt AS orgneatamt, calcard.orgneatremvalue AS orgneatremvalue,\n");
        result.append(" calcard.fid AS fid, calcard.ftaildispose AS ftaildispose \n");
        return result;
    }

    private static String getDepAmount_AvgYearMethod_Static() {
        return " ROUND((calcard.fassetvalue - calcard.fneatremvalue) * POWER ((calcard.fusetermcount - " + floatValue + "), -1),6) ";
    }

    private static String getDepRate_AvgYearMethod_Static(int baseCurPrecision) {
        return " 100 * ROUND ((calcard.fassetvalue - calcard.fneatremvalue) * POWER (calcard.fusetermcount - " + floatValue + ", -1), " + baseCurPrecision + ") * POWER (calcard.fassetvalue - " + floatValue + ", -1) ";
    }

    private static String getDepAmount_AvgYearMethod_Dynamic() {
        return " ROUND((calcard.fassetvalue - calcard.faccudepr - calcard.fdecvalue - calcard.fneatremvalue) * POWER ((calcard.fusetermcount - calcard.fdeprtermcount - " + floatValue + "), -1),6) ";
    }

    private static String getDepRate_AvgYearMethod_Dynamic(int baseCurPrecision) {
        return " 100 * ROUND ((calcard.fassetvalue - calcard.faccudepr - calcard.fdecvalue - calcard.fneatremvalue) * POWER ((calcard.fusetermcount - calcard.fdeprtermcount - " + floatValue + "), -1), " + baseCurPrecision + ") * POWER (calcard.fassetvalue - " + floatValue + ", -1) ";
    }

    private static String getDepRate_AvgYearOriginMethod(int depreRatePrecision) {
        return " ROUND ((100 - calcard.fneatleftrate) * POWER ((calcard.fusetermcount - " + floatValue + "), -1), " + depreRatePrecision + ") ";
    }

    private static String getDepAmount_AvgYearOriginMethod(int depreRatePrecision) {
        return " calcard.fassetvalue * ROUND ((100 - calcard.fneatleftrate) * POWER ((calcard.fusetermcount - " + floatValue + "), -1), " + depreRatePrecision + ") / 100 ";
    }

    private static StringBuffer getCalCardColumn() {
        StringBuffer result = new StringBuffer();
        result.append("curcard.fid AS fid, ");
        result.append("curcard.fdeprtermcount AS fdeprtermcount, ");
        result.append("balance.fdeprebeginbalancefor AS deprebeginbalancefor, ");
        result.append("balance.faddupyeardepre AS addupyeardepre, ");
        result.append("curcard.faccudepr AS orgfaccudepr, ");
        result.append("curcard.fneatamt AS orgneatamt, ");
        result.append("curcard.fneatremvalue AS orgneatremvalue, ");
        result.append("(CASE \n");
        result.append("    WHEN t4.fdepvaluepolicy = 1 \n");
        result.append("       THEN curcard.fassetvalue \n");
        result.append("    WHEN t4.fdepvaluepolicy = 2 \n");
        result.append("       THEN curcard.finitevalvalue \n");
        result.append("    WHEN (t4.fdepvaluepolicy = 3 AND curcard.fassetvalue < curcard.finitevalvalue) \n");
        result.append("       THEN curcard.fassetvalue \n");
        result.append("    WHEN (t4.fdepvaluepolicy = 3 AND curcard.fassetvalue > curcard.finitevalvalue) \n");
        result.append("       THEN curcard.finitevalvalue \n");
        result.append("    WHEN (t4.fdepvaluepolicy = 3 AND curcard.fassetvalue = curcard.finitevalvalue) \n");
        result.append("       THEN curcard.fassetvalue \n");
        result.append("    ELSE curcard.fassetvalue \n");
        result.append(" END) AS fassetvalue, ");
        result.append("curcard.faccudepr AS faccudepr, ");
        result.append("curcard.fdecvalue AS fdecvalue, ");
        result.append("curcard.fneatremvalue AS fneatremvalue, ");
        result.append("curcard.fneatleftrate AS fneatleftrate, ");
        result.append("curcard.fusetermcount AS fusetermcount, ");
        result.append("curcard.fevalleftperiod AS fevalleftperiod, ");
        result.append("curcard.foriginflag AS foriginflag,");
        result.append("curcard.fisinitchange AS fisinitchange, ");
        result.append("initcard.faccudepr AS initaccudepr, ");
        result.append("initcard.fdeprtermcount AS initdeprtermcount, ");
        result.append("t2.finitoldasset AS finitoldasset, ");
        result.append("t2.ftaildispose AS ftaildispose,");
        result.append("t1.fid as assetCatId,");
        result.append("curcard.FEvalDeprPeriodNum as FEvalDeprPeriodNum,");
        result.append("t5.fid as FEvalDeprModeID,");
        result.append("t5.fnumber as FEvalDeprModeNum,");
        result.append("t5.FIsWorkLoad as FEvalModeIsWorkLoad,");
        result.append("t5.FIsCustom as FEvalDeprModeIsCustom,");
        result.append("curcard.FEvalMonthRate as FEvalMonthRate,");
        result.append("curcard.FEvalAddDepr as FEvalAddDepr,");
        result.append("curcard.FEvalRemValue as FEvalRemValue,");
        result.append("curcard.FEvalYearDepr as FEvalYearDepr,");
        result.append("curcard.FEvalDecValue as FEvalDecValue,");
        result.append("curcard.FEvalNeatValue as FEvalNeatValue,");
        result.append("curcard.FEvalNeatAmt as FEvalNeatAmt,");
        result.append("curcard.FEvalAssetValue as FEvalAssetValue,");
        result.append("curcard.FEvalTaxLeftPeriod as FEvalTaxLeftPeriod,");
        result.append("curcard.FEvalUseTermCount as FEvalUseTermCount,");
        result.append("curcard.FEvalNeatLeftRate as FEvalNeatLeftRate \n");
        return result;
    }

    private static StringBuffer getCalCardSQL(Context ctx, String numberString, String currPeriodId, boolean isOnlyFID) throws BOSException {
        String newGovermentAccountingSystem;
        StringBuffer result = new StringBuffer();
        StringBuffer column = new StringBuffer();
        if (isOnlyFID) {
            column.append("curcard.fid AS fid");
        } else {
            column = FaDepCalHelper.getCalCardColumn();
        }
        result.append("SELECT " + column + " FROM t_fa_facurcard curcard \n");
        result.append("INNER JOIN t_fa_faaccountbalance balance ON curcard.fid = balance.ffacurcardid \n");
        result.append("INNER JOIN t_fa_cat t1 ON curcard.fassetcatid = t1.fid INNER JOIN t_fa_usestatus t3 ON curcard.fusestatusid = t3.fid \n");
        result.append("INNER JOIN t_fa_depreciationmode t4 ON curcard.fdeprmethodid = t4.fid \n");
        result.append("LEFT OUTER JOIN t_fa_depreciationmode t5 ON curcard.FEvalDeprModeID = t5.fid \n");
        result.append("INNER JOIN t_fa_depreciationpolicy t2 ON t1.fdepreciationpolicyid = t2.fid \n");
        result.append("LEFT OUTER JOIN t_fa_famoncard initcard ON (curcard.fid = initcard.ffacurcardid and initcard.ffaperiodid is null) \n");
        result.append("WHERE \n");
        result.append(FaDepCalHelper.getDepCondition("curcard"));
        result.append("AND curcard.feffectedstatus = 2 \n");
        result.append("AND curcard.fhasdisabled = 0 \n");
        result.append("AND curcard.fcheckedstatus = 2 \n");
        result.append("AND curcard.fblockedstatus = 1 \n");
        result.append("AND curcard.fbizstatus LIKE '%99' \n");
        result.append("AND curcard.FLeaseStatus != 2 \n");
        result.append("AND curcard.fdeprmethodid IS NOT NULL \n");
        Map paramMap = new HashMap();
        try {
            paramMap = FaDepLocalUtils.getParamNewGovermentAccSystem(ctx);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        String string = newGovermentAccountingSystem = paramMap.get(AccountConstant.GovermentAccountingSystem) != null ? (String)paramMap.get(AccountConstant.GovermentAccountingSystem) : "false";
        if ("true".equalsIgnoreCase(newGovermentAccountingSystem)) {
            result.append("AND (t1.fnotcaldep = 0 OR t1.fnotcaldep is null) \n");
        }
        result.append("AND (t2.fdeprrule = 1");
        result.append(" OR (t2.fdeprrule = 0 AND t3.fisdepreciation = 1)) \n");
        result.append("AND (    NOT (curcard.fhasnew = 1 AND curcard.fhascleared = 2)\n");
        result.append("     AND NOT (    t2.fstartdeprtime = 1\n");
        result.append("              AND (   curcard.fhasnew = 1\n");
        result.append("                   OR (    (curcard.fbizstatus = '0399' OR curcard.fbizstatus = '0499' OR curcard.fbizstatus = '0599')\n");
        result.append("                       AND curcard.fhascleared = 0");
        result.append("                      )\n");
        result.append("                  )\n");
        result.append("                    )\n");
        result.append("     AND NOT (    t2.fstartdeprtime = 0\n");
        result.append("              AND (   (curcard.fhascleared = 2 OR curcard.fhascleared = 1)\n");
        result.append("                   OR (    (curcard.fbizstatus = '0399' OR curcard.fbizstatus = '0499' OR curcard.fbizstatus = '0599')\n");
        result.append("                       AND curcard.fhascleared = 0");
        result.append("                      )\n");
        result.append("                  )\n");
        result.append("             )\n");
        result.append("     ) \n");
        result.append("AND curcard.fcompanyid = ? \n");
        result.append("AND (curcard.fbizstatus != '9999' or (curcard.fbizstatus = '9999' and curcard.fdeletedstatus != 2))\n");
        result.append("AND balance.fperiodid = ? \n");
        result.append("AND  t4.fnumber in " + numberString + "\n");
        String laterPeriodIds = FaLocalUtils.getLaterPeriodIds(ctx, currPeriodId);
        if (laterPeriodIds.length() > 0) {
            result.append("AND curcard.fperiodid not in (" + laterPeriodIds + ") ");
        }
        logger.debug((Object)result.toString());
        return result;
    }

    public static HashMap getDepSumInfo(Context ctx, String companyID, String curPeriodID) throws EASBizException, BOSException {
        IRowSet rowSet;
        HashMap<String, Number> result = new HashMap<String, Number>();
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT (depentry.fid) AS COUNT, SUM (depentry.fdepreciation) AS amount \n");
        sql.append("  FROM t_fa_fadepreciationentry depentry INNER JOIN t_fa_fadepreciation dep ON depentry.flnkfadepreentry = dep.fid \n");
        sql.append(" WHERE dep.fperiod = ? \n");
        sql.append("   AND dep.fcompanyid = ? \n");
        sql.append("   AND dep.fdeptype = 0");
        Object[] sqlParaUpdateCurcard = new Object[]{curPeriodID, companyID};
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlParaUpdateCurcard);
            while (rowSet.next()) {
                count = rowSet.getInt("COUNT");
                result.put("DepCount", new Integer(rowSet.getInt("COUNT")));
                result.put("DepAmount", rowSet.getBigDecimal("amount"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (count == 0) {
            sql = new StringBuffer();
            sql.append("SELECT COUNT (depentry.fid) AS COUNT, SUM (depentry.fdepreciation) AS amount \n");
            sql.append("  FROM t_fa_faevaldepreciationentry depentry INNER JOIN t_fa_faevaldepreciation dep ON depentry.flnkfadepreentry = dep.fid \n");
            sql.append(" WHERE dep.fperiod = ? \n");
            sql.append("   AND dep.fcompanyid = ? \n");
            try {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sqlParaUpdateCurcard);
                while (rowSet.next()) {
                    result.put("DepCount", new Integer(rowSet.getInt("COUNT")));
                    result.put("DepAmount", rowSet.getBigDecimal("amount"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    private static String getDepCondition(String preFix) {
        return " (" + preFix + ".fhaschanged = " + 0 + " OR " + preFix + ".fhaschanged is null  ) \nAND (" + preFix + ".fhascleared = " + 0 + " OR " + preFix + ".fhascleared is null) \n";
    }
}

