/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import java.math.BigDecimal;
import java.util.HashMap;

public class FaDepCalStraightTaxStrategy
extends AbstractFaDepCalStrategy {
    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        BigDecimal monthDepRate;
        HashMap<Integer, BigDecimal> returnValue = new HashMap<Integer, BigDecimal>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal periodDepreAmount = null;
        BigDecimal periodDepreRate = null;
        BigDecimal assetValue = faCardInfo.getEvalAssetValue() == null ? new BigDecimal("0") : faCardInfo.getEvalAssetValue();
        BigDecimal leftAmount = this.getLeftAmount(faCardInfo);
        if (leftAmount.compareTo(zero) <= 0) {
            return null;
        }
        BigDecimal bigDecimal = monthDepRate = faCardInfo.getEvalMonthRate() == null ? new BigDecimal("0") : faCardInfo.getEvalMonthRate();
        if (monthDepRate.compareTo(zero) == 0) {
            return null;
        }
        periodDepreAmount = assetValue.multiply(monthDepRate).divide(new BigDecimal("100"), baseCurPrecision, 4);
        periodDepreRate = monthDepRate.setScale(depreRatePrecision, 4);
        periodDepreAmount = this.dealPeriodAmount(faCardInfo, periodDepreAmount);
        returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
        returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
        return returnValue;
    }

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        return this.calcuatePeriodDepreResultDynamic(ctx, faCardInfo, period);
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("evalAssetValue", "");
        hm.put("evalMonthRate", "");
        hm.put("evalRemValue", "");
        hm.put("evalDecValue", "");
        hm.put("evalAddDepr", "");
        return hm;
    }

    @Override
    protected BigDecimal getLeftLife(FaCurCardInfo faCardInfo) {
        BigDecimal deprTermCount;
        BigDecimal bigDecimal = deprTermCount = faCardInfo.getEvalTaxLeftPeriod() == null ? new BigDecimal("0") : faCardInfo.getEvalTaxLeftPeriod();
        if (deprTermCount.compareTo(new BigDecimal("0")) < 0) {
            return new BigDecimal("0");
        }
        return deprTermCount;
    }

    @Override
    protected BigDecimal getLeftAmount(FaCurCardInfo faCardInfo) {
        BigDecimal assetValue = faCardInfo.getEvalAssetValue();
        if (assetValue == null || assetValue.compareTo(new BigDecimal("0")) <= 0) {
            return new BigDecimal("0");
        }
        BigDecimal accuDepr = faCardInfo.getEvalAddDepr() == null ? new BigDecimal("0") : faCardInfo.getEvalAddDepr();
        BigDecimal decValue = faCardInfo.getEvalDecValue() == null ? new BigDecimal("0") : faCardInfo.getEvalDecValue();
        BigDecimal neatRemValue = faCardInfo.getEvalRemValue() == null ? new BigDecimal("0") : faCardInfo.getEvalRemValue();
        BigDecimal result = assetValue.subtract(accuDepr).subtract(decValue).subtract(neatRemValue);
        if (result.compareTo(new BigDecimal("0")) > 0) {
            return result;
        }
        return new BigDecimal("0");
    }

    @Override
    public boolean haveLifeForDep(FaCurCardInfo faCardInfo, Context ctx) {
        return true;
    }

    @Override
    protected BigDecimal dealPeriodAmount(FaCurCardInfo faCardInfo, BigDecimal oldAmount) throws BOSException {
        BigDecimal leftAmount = this.getLeftAmount(faCardInfo);
        if (oldAmount.compareTo(leftAmount) > 0) {
            oldAmount = leftAmount;
        }
        return oldAmount;
    }
}

