/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.app.FaDepCalExecutor;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FaDepCalThread
implements Callable {
    private static Logger logger = Logger.getLogger(FaDepCalThread.class);
    private Context ctx;
    private boolean alreadyCal;
    private boolean isAll;
    private Set cardSet;
    private FaDepCalExecutor owner;
    private String companyID;

    public FaDepCalThread(Context ctx, boolean alreadyCal, boolean isAll, Set cardSet, String companyID, FaDepCalExecutor owner) {
        this.ctx = ctx;
        this.alreadyCal = alreadyCal;
        this.isAll = isAll;
        this.cardSet = cardSet;
        this.owner = owner;
        this.companyID = companyID;
    }

    public Object call() throws Exception {
        StringBuffer cardNumber = null;
        try {
            HashMap hmResult = new HashMap();
            FaDepCalExecutor executor = new FaDepCalExecutor(this.companyID);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().addObjectCollection((IObjectCollection)FaDepLocalUtils.getDepCardSelector());
            entityViewInfo.getSelector().addObjectCollection((IObjectCollection)executor.getUserSchemeSic(this.ctx));
            entityViewInfo.put("ignoreAsstActName", (Object)Boolean.TRUE);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.cardSet, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            FaCurCardCollection cardCollection = FaCurCardFactory.getLocalInstance(this.ctx).getFaCurCardCollection(entityViewInfo);
            executor.filteCard(this.ctx, cardCollection);
            if (cardCollection.size() == 0) {
                return null;
            }
            if (this.alreadyCal && !this.isAll) {
                executor._undoDep(this.ctx, (IObjectValue)executor.getCurrentPeriod(this.ctx, this.companyID), (IObjectCollection)cardCollection, true);
                executor.removeCardDep(cardCollection);
            }
            executor.getLastPeriodCardCollection(this.ctx, cardCollection);
            this.owner.hmLastCard.putAll(executor.hmLastCard);
            executor.getBalanceCollection(this.ctx, cardCollection);
            this.owner.hmBalance.putAll(executor.hmBalance);
            for (int ii = 0; ii < cardCollection.size(); ++ii) {
                FaCurCardInfo card = cardCollection.get(ii);
                cardNumber = new StringBuffer(card.getNumber());
                FaCurCardInfo cloneCard = (FaCurCardInfo)card.clone();
                HashMap ht = executor.privateCalOneCardDep(this.ctx, cloneCard);
                if (ht == null) continue;
                card.put("faCurCostCenter", (Object)cloneCard.getFaCurCostCenter());
                if (ht != null) {
                    FaCurCardInfo faCurCardInfo = this.getCurCardInfo(card);
                    Vector<HashMap> vec = new Vector<HashMap>();
                    vec.add(ht);
                    hmResult.put(faCurCardInfo, vec);
                }
                cardNumber = null;
            }
            executor = null;
            return hmResult;
        }
        catch (Exception e) {
            logger.error((Object)"----------------------FaDepCalThread print log begin------------------------------");
            logger.error((Object)(e.getMessage() + ",card number is: " + cardNumber));
            logger.error((Object)"----------------------FaDepCalThread print log end------------------------------");
            throw new BOSException(e.getMessage() + ",card number is: " + cardNumber);
        }
    }

    private FaCurCardInfo getCurCardInfo(FaCurCardInfo card) {
        FaCurCardInfo faCurCardInfo = new FaCurCardInfo();
        faCurCardInfo.setId(card.getId());
        faCurCardInfo.setCompany(card.getCompany());
        faCurCardInfo.setAssetName(card.getAssetName());
        faCurCardInfo.setAccuDepr(card.getAccuDepr());
        faCurCardInfo.setNeatAmt(card.getNeatAmt());
        faCurCardInfo.setNeatRemValue(card.getNeatRemValue());
        faCurCardInfo.getFaCurCostCenter().addCollection(card.getFaCurCostCenter());
        faCurCardInfo.setAccuDeprTYear(card.getAccuDeprTYear());
        faCurCardInfo.setAccuDeprAll(card.getAccuDeprAll());
        faCurCardInfo.setNeatValue(card.getNeatValue());
        faCurCardInfo.setDeprMethod(card.getDeprMethod());
        faCurCardInfo.setDeprTermCount(card.getDeprTermCount());
        faCurCardInfo.setLeftYear(card.getLeftYear());
        faCurCardInfo.setAccuDeprForCal(card.getAccuDeprForCal());
        faCurCardInfo.setLeftYearUp(card.getLeftYearUp());
        faCurCardInfo.setDeprCount(card.getDeprCount());
        faCurCardInfo.setLastPeriodCount(card.getLastPeriodCount());
        faCurCardInfo.setLeftYearTwo(card.getLeftYearTwo());
        faCurCardInfo.setWellDeprValue(card.getWellDeprValue());
        faCurCardInfo.setTempDeprMethod(card.getTempDeprMethod());
        faCurCardInfo.setEvalAddDepr(card.getEvalAddDepr());
        faCurCardInfo.setEvalNeatAmt(card.getEvalNeatAmt());
        faCurCardInfo.setEvalRemValue(card.getEvalRemValue());
        faCurCardInfo.setEvalYearDepr(card.getEvalYearDepr());
        faCurCardInfo.setEvalNeatValue(card.getEvalNeatValue());
        faCurCardInfo.setEvalDeprMode(card.getEvalDeprMode());
        faCurCardInfo.setEvalDeprPeriodNum(card.getEvalDeprPeriodNum());
        faCurCardInfo.setEvalTaxLeftPeriod(card.getEvalTaxLeftPeriod());
        return faCurCardInfo;
    }
}

