/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import java.math.BigDecimal;
import java.util.HashMap;

public class FaDepCalTotalYearStrategy
extends AbstractFaDepCalStrategy {
    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        HashMap<Integer, Number> returnValue = new HashMap<Integer, Number>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal yearDepreAmount = null;
        BigDecimal periodDepreAmount = null;
        BigDecimal yearDepreRate = null;
        BigDecimal periodDepreRate = null;
        BigDecimal percent = new BigDecimal(100);
        BigDecimal downLeftYear = this.getDownLeftYear(ctx, faCardInfo, period);
        int depCount = this.getDepCount(ctx, faCardInfo, period);
        BigDecimal temp1 = downLeftYear.multiply(downLeftYear.add(new BigDecimal("1"))).divide(new BigDecimal("2"), depreRatePrecision, 4);
        BigDecimal temp2 = new BigDecimal(this.getUpLeftYear(ctx, faCardInfo, period));
        if (depCount >= this.getValidPeriodCountofYear(ctx, period)) {
            depCount = 1;
            temp2 = temp2.subtract(new BigDecimal(1));
        } else {
            ++depCount;
        }
        BigDecimal leftAmount = this.getCalAmount(faCardInfo);
        if (temp2.compareTo(new BigDecimal("1")) <= 0) {
            temp2 = new BigDecimal("1");
        }
        if (temp1.compareTo(new BigDecimal("1")) <= 0) {
            temp1 = new BigDecimal("1");
        }
        yearDepreRate = temp2.multiply(percent).divide(temp1, depreRatePrecision, 4);
        yearDepreAmount = temp2.compareTo(new BigDecimal("1")) <= 0 ? this.getLeftAmount(faCardInfo) : leftAmount.multiply(temp2).divide(temp1, baseCurPrecision, 4);
        if (yearDepreAmount.compareTo(this.getLeftAmount(faCardInfo)) > 0) {
            yearDepreAmount = this.getLeftAmount(faCardInfo);
        }
        if (this.isYearDep(faCardInfo)) {
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, yearDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, yearDepreRate);
        } else {
            BigDecimal periodCount = new BigDecimal("0");
            if (temp2.compareTo(new BigDecimal(1)) == 0) {
                periodCount = new BigDecimal(this.getLastPeriodCount(ctx, faCardInfo, period));
                returnValue.put(FaDepreCalculator.FA_DEP_LASTPERIODCOUNT, new Integer(periodCount.intValue()));
                periodDepreRate = yearDepreRate.divide(periodCount, depreRatePrecision, 4);
                periodDepreAmount = yearDepreAmount.divide(new BigDecimal(periodCount.intValue() - depCount + 1), baseCurPrecision, 4);
                periodDepreAmount = this.dealPeriodAmount(faCardInfo, periodDepreAmount);
            } else {
                periodCount = new BigDecimal(this.getValidPeriodCountofYear(ctx, period));
                periodDepreRate = yearDepreRate.divide(periodCount, depreRatePrecision, 4);
                periodDepreAmount = yearDepreAmount.divide(periodCount, baseCurPrecision, 4);
            }
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
            returnValue.put(FaDepreCalculator.FA_DEP_LEFTYEAR, downLeftYear);
            returnValue.put(FaDepreCalculator.FA_DEP_LEFTYEARUP, temp2);
            returnValue.put(FaDepreCalculator.FA_DEP_DEPCOUNT, new Integer(depCount));
            returnValue.put(FaDepreCalculator.FA_DEP_CALDEPAMOUNT, this.getCalDepAmount(faCardInfo));
        }
        return returnValue;
    }

    private int getDepCount(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT) != null) {
            Integer depCount = (Integer)hm.get(FaDepreCalculator.FA_DEP_DEPCOUNT);
            return depCount;
        }
        return 0;
    }

    private int getLastPeriodCount(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_LASTPERIODCOUNT) != null && (Integer)hm.get(FaDepreCalculator.FA_DEP_LASTPERIODCOUNT) > 0) {
            Integer lastPeriodCount = (Integer)hm.get(FaDepreCalculator.FA_DEP_LASTPERIODCOUNT);
            return lastPeriodCount;
        }
        BigDecimal depTermCount = card.getDeprTermCount() == null ? new BigDecimal("0") : card.getDeprTermCount();
        BigDecimal periodCount = card.getUseTermCount().subtract(depTermCount);
        return periodCount.intValue();
    }

    private BigDecimal getDownLeftYear(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        Integer leftYear;
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_LEFTYEAR) != null && (leftYear = (Integer)hm.get(FaDepreCalculator.FA_DEP_LEFTYEAR)) > 0) {
            return new BigDecimal(leftYear);
        }
        int periodCount = this.getValidPeriodCountofYear(ctx, period);
        BigDecimal remainderPeriod = this.getLeftLife(card);
        BigDecimal remainderYear = remainderPeriod.divide(new BigDecimal(periodCount), 0, 4);
        if (remainderYear.doubleValue() < 1.0) {
            remainderYear = remainderPeriod.divide(new BigDecimal(periodCount), 10, 4);
        }
        return remainderYear;
    }

    private int getUpLeftYear(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        Integer leftYearUp;
        HashMap hm = (HashMap)this.getUserObject();
        if (hm != null && hm.get(FaDepreCalculator.FA_DEP_LEFTYEARUP) != null && (leftYearUp = (Integer)hm.get(FaDepreCalculator.FA_DEP_LEFTYEARUP)) > 0) {
            return leftYearUp;
        }
        int periodCount = this.getValidPeriodCountofYear(ctx, period);
        int temp = this.getLeftLife(card).intValue();
        if (temp % periodCount != 0) {
            return new BigDecimal(temp).divide(new BigDecimal(periodCount), 0, 4).intValue();
        }
        return temp / periodCount;
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("assetValue", "");
        hm.put("decValue", "");
        hm.put("neatRemValue", "");
        hm.put("useYears", "");
        return hm;
    }

    private BigDecimal getCalDepAmount(FaCurCardInfo faCardInfo) {
        HashMap hm = (HashMap)this.getUserObject();
        BigDecimal accuDepr = new BigDecimal("0");
        accuDepr = hm != null && hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT) != null ? (BigDecimal)hm.get(FaDepreCalculator.FA_DEP_CALDEPAMOUNT) : (faCardInfo.getAccuDepr() == null ? new BigDecimal("0") : faCardInfo.getAccuDepr());
        return accuDepr;
    }

    protected BigDecimal getCalAmount(FaCurCardInfo faCardInfo) {
        BigDecimal assetValue = faCardInfo.getAssetValue();
        if (assetValue == null || assetValue.compareTo(new BigDecimal("0")) <= 0) {
            return new BigDecimal("0");
        }
        HashMap hm = (HashMap)this.getUserObject();
        BigDecimal accuDepr = this.getCalDepAmount(faCardInfo);
        BigDecimal decValue = faCardInfo.getDecValue() == null ? new BigDecimal("0") : faCardInfo.getDecValue();
        BigDecimal neatRemValue = faCardInfo.getNeatRemValue() == null ? new BigDecimal("0") : faCardInfo.getNeatRemValue();
        BigDecimal result = assetValue.subtract(accuDepr).subtract(decValue).subtract(neatRemValue);
        if (result.compareTo(new BigDecimal("0")) > 0) {
            return result;
        }
        return new BigDecimal("0");
    }

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        HashMap<Integer, Number> returnValue = new HashMap<Integer, Number>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal yearDepreAmount = null;
        BigDecimal periodDepreAmount = null;
        BigDecimal yearDepreRate = null;
        BigDecimal periodDepreRate = null;
        BigDecimal percent = new BigDecimal(100);
        BigDecimal assetValue = faCardInfo.getAssetValue() == null ? new BigDecimal("0") : faCardInfo.getAssetValue();
        BigDecimal neatRemValue = faCardInfo.getNeatRemValue() == null ? new BigDecimal("0") : faCardInfo.getNeatRemValue();
        BigDecimal useYears = faCardInfo.getUseYears();
        BigDecimal leftYear = new BigDecimal(this.getLeftYearForStatic(ctx, faCardInfo, period));
        int depCount = this.getDepCount(ctx, faCardInfo, period);
        BigDecimal temp1 = useYears.multiply(useYears.add(new BigDecimal("1"))).divide(new BigDecimal("2"), depreRatePrecision, 4);
        depCount = depCount >= this.getValidPeriodCountofYear(ctx, period) ? 1 : ++depCount;
        if (leftYear.compareTo(new BigDecimal("1")) <= 0) {
            leftYear = new BigDecimal("1");
        }
        if (temp1.compareTo(new BigDecimal("1")) <= 0) {
            temp1 = new BigDecimal("1");
        }
        yearDepreRate = leftYear.multiply(percent).divide(temp1, depreRatePrecision, 4);
        yearDepreAmount = assetValue.subtract(neatRemValue).multiply(yearDepreRate).divide(percent, baseCurPrecision, 4);
        if (this.isYearDep(faCardInfo)) {
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, yearDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, yearDepreRate);
        } else {
            BigDecimal periodCount;
            if (leftYear.compareTo(new BigDecimal(1)) == 0) {
                periodCount = new BigDecimal(this.getLastPeriodCount(ctx, faCardInfo, period));
                returnValue.put(FaDepreCalculator.FA_DEP_LASTPERIODCOUNT, new Integer(periodCount.intValue()));
            } else {
                periodCount = new BigDecimal(this.getValidPeriodCountofYear(ctx, period));
            }
            periodDepreRate = yearDepreRate.divide(periodCount, depreRatePrecision, 4);
            periodDepreAmount = yearDepreAmount.divide(periodCount, baseCurPrecision, 4);
            periodDepreAmount = this.dealPeriodAmount(faCardInfo, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate);
            returnValue.put(FaDepreCalculator.FA_DEP_DEPCOUNT, new Integer(depCount));
            returnValue.put(FaDepreCalculator.FA_DEP_CALDEPAMOUNT, this.getCalDepAmount(faCardInfo));
        }
        return returnValue;
    }

    private int getLeftYearForStatic(Context ctx, FaCurCardInfo card, PeriodInfo period) throws BOSException {
        int periodCount = this.getValidPeriodCountofYear(ctx, period);
        int temp = this.getLeftLife(card).intValue();
        if (temp % periodCount != 0) {
            return temp / periodCount + 1;
        }
        return temp / periodCount;
    }
}

