/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.kscript.IFunctionProvider;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationSchemeInfo;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDecValueCollection;
import com.kingdee.eas.fi.fa.manage.FaDecValueEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDecValueFactory;
import com.kingdee.eas.fi.fa.manage.FaDecValueInfo;
import com.kingdee.eas.fi.fa.manage.FaDpreCalcException;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadFactory;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadInfo;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepCalRateCode;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.util.ResourceBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaDepCalUserDefinedStrategy
extends AbstractFaDepCalStrategy {
    private boolean hasInited = false;
    private HashMap deprModes = null;
    private HashMap decValueCache = null;
    private HashMap customSelector = new HashMap();
    private static final Logger logger = CoreUIObject.getLogger(FaDepCalUserDefinedStrategy.class);

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo _faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        BigDecimal leftPeriod;
        BigDecimal leftAmount;
        FaDepreciationSchemeInfo schemeInfo;
        FaCurCardInfo faCardInfo = (FaCurCardInfo)_faCardInfo.clone();
        if (!this.hasInited) {
            this.initModes(ctx);
        }
        if (faCardInfo.getId() != null && this.decValueCache == null) {
            this.initDecCache(ctx, faCardInfo.getCompany().getId().toString(), period.getId().toString());
        }
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        if (faCardInfo.getId() != null && this.decValueCache.containsKey(faCardInfo.getId().toString())) {
            faCardInfo.setDecValueForDAP((BigDecimal)this.decValueCache.get(faCardInfo.getId().toString()));
        } else {
            faCardInfo.setDecValueForDAP(new BigDecimal("0"));
        }
        if (faCardInfo.getId() != null && faCardInfo.getDeprMethod().isIsCustom() && faCardInfo.getDeprMethod().isIsWorkload()) {
            this.initWorkLoad(ctx, faCardInfo.getCompany().getId().toString(), period.getId().toString(), faCardInfo);
        } else {
            faCardInfo.setWorkloadForDAP(new BigDecimal("0"));
        }
        if (faCardInfo.getMonthDepreRate() != null) {
            faCardInfo.setMonthDepreRate(faCardInfo.getMonthDepreRate().divide(new BigDecimal("100"), depreRatePrecision, 4));
        } else {
            faCardInfo.setMonthDepreRate(new BigDecimal("0"));
        }
        faCardInfo.setDeprTTerm(new BigDecimal("0"));
        if (faCardInfo.getNeatLeftRate() != null) {
            faCardInfo.setNeatLeftRate(faCardInfo.getNeatLeftRate().divide(new BigDecimal("100"), 6, 4));
        } else {
            faCardInfo.setNeatLeftRate(new BigDecimal("0"));
        }
        if (faCardInfo.getAssetCat() != null) {
            FaCatInfo cat = faCardInfo.getAssetCat();
            if (cat.getPrePureRate() != null) {
                cat.setPrePureRate(cat.getPrePureRate().divide(new BigDecimal("100"), 6, 4));
            } else {
                cat.setPrePureRate(new BigDecimal("0"));
            }
        }
        FaDepreciationModeInfo mode = null;
        boolean isEval = faCardInfo.containsKey("isEval") ? (Boolean)faCardInfo.get("isEval") : false;
        if (isEval) {
            mode = (FaDepreciationModeInfo)this.deprModes.get(faCardInfo.getEvalDeprMode().getNumber());
            schemeInfo = mode.getScheme().get(0);
            leftAmount = this.getEvalLeftAmount(faCardInfo);
            leftPeriod = this.getEvalLeftLife(faCardInfo);
            if (leftAmount.compareTo(zero) <= 0) {
                return null;
            }
            if (leftPeriod.compareTo(zero) <= 0 && schemeInfo.isStopZeroPeriodCnt()) {
                return null;
            }
        } else {
            mode = (FaDepreciationModeInfo)this.deprModes.get(faCardInfo.getDeprMethod().getNumber());
            schemeInfo = mode.getScheme().get(0);
            leftAmount = this.getLeftAmount(faCardInfo);
            leftPeriod = this.getLeftLife(faCardInfo);
            if (leftAmount.compareTo(zero) <= 0) {
                return null;
            }
            if (leftPeriod.compareTo(zero) <= 0 && schemeInfo.isStopZeroPeriodCnt()) {
                return null;
            }
        }
        FaDepreciationSchemeInfo scheme = mode.getScheme().get(0);
        Interpreter interpreter = new Interpreter(ctx);
        HashMap localCtx = new HashMap();
        this.initInterpreter(ctx, faCardInfo, interpreter, localCtx);
        Object _periodDepreRate = null;
        Object _periodDepreAmount = null;
        BigDecimal periodDepreRate = new BigDecimal("0");
        if (mode.isIsBaseDeprRateTable()) {
            boolean rateFlag = false;
            boolean stopFlag = false;
            if (isEval) {
                stopFlag = faCardInfo.getEvalTaxLeftPeriod().compareTo(new BigDecimal("0")) <= 0;
            } else {
                boolean bl = stopFlag = faCardInfo.getEvalLeftPeriod().compareTo(new BigDecimal("0")) <= 0;
            }
            if (stopFlag && scheme.isStopZeroPeriodCnt()) {
                return null;
            }
            if (isEval) {
                rateFlag = faCardInfo.getEvalAssetValue().compareTo(faCardInfo.getEvalAddDepr().add(faCardInfo.getEvalDecValue().add(faCardInfo.getEvalRemValue()))) > 0;
            } else {
                boolean bl = rateFlag = faCardInfo.getAssetValue().compareTo(faCardInfo.getAccuDepr().add(faCardInfo.getDecValue().add(faCardInfo.getNeatRemValue()))) > 0;
            }
            if (!rateFlag) {
                if (scheme.isStopZeroAmt()) {
                    return null;
                }
                HashMap<Integer, BigDecimal> returnValue = new HashMap<Integer, BigDecimal>();
                returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, new BigDecimal("0"));
                returnValue.put(FaDepreCalculator.FA_DEP_RATE, new BigDecimal("0"));
                return returnValue;
            }
            PeriodInfo info = FaLocalUtils.getFACurrentPeriod(faCardInfo.getCompany().getId().toString(), ctx);
            int count = PeriodUtils.getPeriodCount((Context)ctx, (PeriodInfo)info, (boolean)true);
            FaDepCalRateCode fadcr = new FaDepCalRateCode();
            periodDepreRate = fadcr.getDeprRate(ctx, faCardInfo, count, mode, isEval, fadcr.getDeprRate(ctx));
        } else {
            _periodDepreRate = interpreter.eval(scheme.getMonDepRateExpr(), localCtx);
            if (!(_periodDepreRate instanceof Number)) {
                throw new FaDpreCalcException(FaDpreCalcException.DEPRRATE_NOT_NUMBER, new Object[]{faCardInfo.getNumber(), _periodDepreRate == null ? ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"76_FaDepCalUserDefinedStrategy", (Locale)ctx.getOriginLocale()) : _periodDepreRate.toString()});
            }
            periodDepreRate = new BigDecimal(_periodDepreRate.toString()).setScale(depreRatePrecision, 4);
            if (!(periodDepreRate.compareTo(new BigDecimal("0")) > 0 && periodDepreRate.compareTo(new BigDecimal("1")) <= 0 || faCardInfo.getDeprMethod().isIsCustom() && faCardInfo.getDeprMethod().isIsWorkload() && periodDepreRate.compareTo(new BigDecimal("0")) == 0)) {
                throw new FaDpreCalcException(FaDpreCalcException.DEPRRATE_INVALID, new Object[]{faCardInfo.getNumber(), periodDepreRate});
            }
            faCardInfo.setMonthDepreRate(periodDepreRate);
        }
        try {
            BigDecimal oldMonthRate = new BigDecimal("0");
            if (isEval) {
                oldMonthRate = faCardInfo.getMonthDepreRate();
                faCardInfo.setEvalMonthRate(periodDepreRate);
                faCardInfo.setMonthDepreRate(periodDepreRate);
            } else {
                faCardInfo.setMonthDepreRate(periodDepreRate);
            }
            _periodDepreAmount = interpreter.eval(scheme.getMonDepExpr(), localCtx);
            if (!(_periodDepreAmount instanceof Number)) {
                throw new FaDpreCalcException(FaDpreCalcException.DEPRVALUE_NOT_NUMBER, new Object[]{faCardInfo.getNumber(), _periodDepreAmount == null ? ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"76_FaDepCalUserDefinedStrategy", (Locale)ctx.getOriginLocale()) : _periodDepreAmount.toString()});
            }
            BigDecimal periodDepreAmount = new BigDecimal(_periodDepreAmount.toString()).setScale(baseCurPrecision, 4);
            if (periodDepreAmount.compareTo(new BigDecimal("0")) < 0) {
                throw new FaDpreCalcException(FaDpreCalcException.DEPRVALUE_NEGATIVE, new Object[]{faCardInfo.getNumber(), periodDepreAmount});
            }
            periodDepreAmount = !isEval ? this.dealPeriodAmount(faCardInfo, periodDepreAmount).setScale(baseCurPrecision, 4) : this.dealEvalPeriodAmount(faCardInfo, periodDepreAmount).setScale(baseCurPrecision, 4);
            if (isEval) {
                faCardInfo.setMonthDepreRate(oldMonthRate);
            }
            HashMap<Integer, BigDecimal> returnValue = new HashMap<Integer, BigDecimal>();
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate.multiply(new BigDecimal("100")));
            return returnValue;
        }
        catch (InterpreterException e) {
            logger.error((Object)e);
            throw new FaDpreCalcException(FaDpreCalcException.DEPR_EVAL_ERROR, e, new Object[]{faCardInfo.getNumber(), e.getMessage() == null ? "Unexpected Exception" : e.getMessage()});
        }
    }

    private void initDecCache(Context ctx, String companyId, String periodId) throws BOSException {
        String sql = "select entry.curcard,entry.decValue where period.id='" + periodId + "' and company.id='" + companyId + "' and checkedStatus=" + 2;
        FaDecValueCollection decInfos = FaDecValueFactory.getLocalInstance(ctx).getFaDecValueCollection(sql);
        if (decInfos.size() == 0) {
            this.decValueCache = new HashMap();
        } else {
            this.decValueCache = new HashMap();
            FaDecValueInfo decInfo = decInfos.get(0);
            for (int i = 0; i < decInfo.getEntry().size(); ++i) {
                FaDecValueEntryInfo decEntry = decInfo.getEntry().get(i);
                this.decValueCache.put(decEntry.getCurcard().getId().toString(), decEntry.getDecValue());
            }
        }
    }

    private void initWorkLoad(Context ctx, String companyId, String periodId, FaCurCardInfo faCardInfo) throws BOSException, EASBizException {
        String sql = "select currentWorkLoad where period.id='" + periodId + "' and company.id='" + companyId + "' and curCard.id = '" + faCardInfo.getId().toString() + "' ";
        FaWorkLoadInfo faWorkLoadInfo = FaWorkLoadFactory.getLocalInstance(ctx).getFaWorkLoadInfo(sql);
        faCardInfo.setWorkloadForDAP(faWorkLoadInfo.getCurrentWorkLoad());
    }

    private void initInterpreter(Context ctx, FaCurCardInfo faCardInfo, Interpreter interpreter, Map localCtx) throws DataAccessException, KScriptException, BOSException {
        localCtx.put("__bosContext", ctx);
        localCtx.put("__src", faCardInfo);
        BOTMappingInfo botMappingInfo = new BOTMappingInfo();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo srcEntity = loader.getEntity(new FaCurCardInfo().getBOSType());
        botMappingInfo.setSrcEntity(srcEntity);
        botMappingInfo.setDestEntity(srcEntity);
        List funcProviderList = new ArrayList();
        try {
            funcProviderList = BOTPTools.getBOTTransform((Context)ctx, (BOTMappingInfo)botMappingInfo).getFunctionProviderList();
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < funcProviderList.size(); ++i) {
            interpreter.addFunctionProvider((IFunctionProvider)funcProviderList.get(i));
        }
        interpreter.setProperyExprOwnerNullIgore(true);
        interpreter.setForBot(true);
        interpreter.setDefaultObject((Object)faCardInfo);
    }

    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        return this.calcuatePeriodDepreResultStatic(ctx, faCardInfo, period);
    }

    @Override
    public boolean haveAmountForDep(FaCurCardInfo faCardInfo, Context ctx) throws BOSException {
        if (!this.hasInited) {
            this.initModes(ctx);
        }
        return this.getLeftAmount(faCardInfo).compareTo(new BigDecimal("0")) > 0;
    }

    @Override
    public boolean haveLifeForDep(FaCurCardInfo faCardInfo, Context ctx) throws BOSException {
        FaDepreciationModeInfo mode;
        FaDepreciationSchemeInfo scheme;
        if (!this.hasInited) {
            this.initModes(ctx);
        }
        if ((scheme = (mode = (FaDepreciationModeInfo)this.deprModes.get(faCardInfo.getDeprMethod().getNumber())).getScheme().get(0)).isStopZeroPeriodCnt()) {
            return this.getLeftLife(faCardInfo).compareTo(new BigDecimal("0")) > 0;
        }
        return true;
    }

    @Override
    protected boolean isYearDep(FaCurCardInfo card) throws BOSException {
        return false;
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) throws BOSException {
        HashMap<String, String> hm = new HashMap<String, String>();
        if (this.customSelector.containsKey(mode.getId().toString())) {
            return (HashMap)this.customSelector.get(mode.getId().toString());
        }
        SelectorItemCollection sic = FaDepLocalUtils.getUserDepSelector(ctx, null, mode.getId().toString());
        for (int i = 0; i < sic.size(); ++i) {
            if (sic.get(i).getPropertyName().indexOf(".") != -1) continue;
            hm.put(sic.get(i).getPropertyName(), "");
        }
        this.customSelector.put(mode.getId().toString(), hm);
        return hm;
    }

    public void initModes(Context ctx) throws BOSException {
        this.deprModes = FaUtils.getUserDepreciationMode((Context)ctx, (boolean)false);
        this.hasInited = true;
    }

    protected BigDecimal getEvalLeftLife(FaCurCardInfo faCardInfo) {
        BigDecimal deprTermCount;
        BigDecimal bigDecimal = deprTermCount = faCardInfo.getEvalTaxLeftPeriod() == null ? new BigDecimal("0") : faCardInfo.getEvalTaxLeftPeriod();
        if (deprTermCount.compareTo(new BigDecimal("0")) < 0) {
            return new BigDecimal("0");
        }
        return deprTermCount;
    }

    protected BigDecimal getEvalLeftAmount(FaCurCardInfo faCardInfo) {
        BigDecimal assetValue = faCardInfo.getEvalAssetValue();
        if (assetValue == null || assetValue.compareTo(new BigDecimal("0")) <= 0) {
            return new BigDecimal("0");
        }
        BigDecimal accuDepr = faCardInfo.getEvalAddDepr() == null ? new BigDecimal("0") : faCardInfo.getEvalAddDepr();
        BigDecimal decValue = faCardInfo.getEvalDecValue() == null ? new BigDecimal("0") : faCardInfo.getEvalDecValue();
        BigDecimal neatRemValue = faCardInfo.getEvalRemValue() == null ? new BigDecimal("0") : faCardInfo.getEvalRemValue();
        BigDecimal result = assetValue.subtract(accuDepr).subtract(decValue).subtract(neatRemValue);
        if (result.compareTo(new BigDecimal("0")) > 0) {
            return result;
        }
        return new BigDecimal("0");
    }

    protected BigDecimal dealEvalPeriodAmount(FaCurCardInfo faCardInfo, BigDecimal oldAmount) throws BOSException {
        BigDecimal leftAmount = this.getEvalLeftAmount(faCardInfo);
        if (oldAmount.compareTo(leftAmount) > 0 || this.isEvalFinalyDepCal(faCardInfo) && this.isFinalyDepAllLeft(faCardInfo)) {
            oldAmount = leftAmount;
        }
        return oldAmount;
    }

    protected boolean isEvalFinalyDepCal(FaCurCardInfo card) {
        BigDecimal left = this.getEvalLeftLife(card);
        return left.compareTo(new BigDecimal(1)) == 0;
    }
}

