/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.kscript.IFunctionProvider;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationModeInfo;
import com.kingdee.eas.fi.fa.basedata.FaDepreciationSchemeInfo;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDecValueCollection;
import com.kingdee.eas.fi.fa.manage.FaDecValueEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDecValueFactory;
import com.kingdee.eas.fi.fa.manage.FaDecValueInfo;
import com.kingdee.eas.fi.fa.manage.FaDpreCalcException;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadCollection;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadFactory;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadInfo;
import com.kingdee.eas.fi.fa.manage.IFaWorkLoad;
import com.kingdee.eas.fi.fa.manage.app.AbstractFaDepCalStrategy;
import com.kingdee.eas.fi.fa.manage.app.FaDepLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.FaDepreCalculator;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaDepCalWorkloadStrategy
extends AbstractFaDepCalStrategy {
    private boolean hasInited = false;
    private HashMap deprModes = null;
    private HashMap workLoadCache = null;
    private HashMap decValueCache = null;
    private HashMap customSelector = new HashMap();
    private static final Logger logger = CoreUIObject.getLogger(FaDepCalWorkloadStrategy.class);

    @Override
    public HashMap calcuatePeriodDepreResultDynamic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (FaUtils.isUserDefinedMethod((FaDepreciationModeInfo)faCardInfo.getDeprMethod())) {
            return this.calcByFormula(ctx, faCardInfo, periodInfo);
        }
        HashMap<Integer, BigDecimal> returnValue = new HashMap<Integer, BigDecimal>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal depAmount = null;
        BigDecimal depRate = null;
        BigDecimal thisPeriodWorkLoad = this.getThisPeriodWorkload(ctx, faCardInfo, periodInfo);
        BigDecimal assetValue = faCardInfo.getAssetValue() == null ? new BigDecimal("0") : faCardInfo.getAssetValue();
        BigDecimal leftAmount = this.getLeftAmount(faCardInfo);
        BigDecimal leftWorkLoad = this.getLeftLife(faCardInfo).add(thisPeriodWorkLoad);
        if (leftAmount.compareTo(zero) <= 0 || leftWorkLoad.compareTo(zero) <= 0) {
            return null;
        }
        depAmount = leftAmount.multiply(thisPeriodWorkLoad).divide(leftWorkLoad, baseCurPrecision, 4);
        depRate = depAmount.multiply(new BigDecimal("100")).divide(assetValue, depreRatePrecision, 4);
        returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, depAmount);
        returnValue.put(FaDepreCalculator.FA_DEP_RATE, depRate);
        return returnValue;
    }

    private HashMap calcByFormula(Context ctx, FaCurCardInfo _faCardInfo, PeriodInfo periodInfo) throws BOSException, EASBizException {
        FaCurCardInfo faCardInfo = (FaCurCardInfo)_faCardInfo.clone();
        if (!this.hasInited) {
            this.initModes(ctx);
        }
        if (faCardInfo.getId() != null && this.decValueCache == null) {
            this.initDecCache(ctx, faCardInfo.getCompany().getId().toString(), periodInfo.getId().toString());
        }
        if (faCardInfo.getId() != null && this.workLoadCache == null) {
            this.initWorkloadCache(ctx, faCardInfo.getCompany().getId().toString(), periodInfo.getId().toString());
        }
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        if (faCardInfo.getId() != null && this.decValueCache.containsKey(faCardInfo.getId().toString())) {
            faCardInfo.setDecValueForDAP((BigDecimal)this.decValueCache.get(faCardInfo.getId().toString()));
        } else {
            faCardInfo.setDecValueForDAP(new BigDecimal("0"));
        }
        if (faCardInfo.getId() != null && this.workLoadCache.containsKey(faCardInfo.getId().toString())) {
            faCardInfo.setWorkloadForDAP((BigDecimal)this.workLoadCache.get(faCardInfo.getId().toString()));
        } else {
            faCardInfo.setWorkloadForDAP(new BigDecimal("0"));
        }
        if (faCardInfo.getMonthDepreRate() != null) {
            faCardInfo.setMonthDepreRate(faCardInfo.getMonthDepreRate().divide(new BigDecimal("100"), depreRatePrecision, 4));
        } else {
            faCardInfo.setMonthDepreRate(new BigDecimal("0"));
        }
        faCardInfo.setDeprTTerm(new BigDecimal("0"));
        if (faCardInfo.getNeatLeftRate() != null) {
            faCardInfo.setNeatLeftRate(faCardInfo.getNeatLeftRate().divide(new BigDecimal("100"), 6, 4));
        } else {
            faCardInfo.setNeatLeftRate(new BigDecimal("0"));
        }
        if (faCardInfo.getAssetCat() != null) {
            FaCatInfo cat = faCardInfo.getAssetCat();
            if (cat.getPrePureRate() != null) {
                cat.setPrePureRate(cat.getPrePureRate().divide(new BigDecimal("100"), 6, 4));
            } else {
                cat.setPrePureRate(new BigDecimal("0"));
            }
        }
        FaDepreciationModeInfo mode = (FaDepreciationModeInfo)this.deprModes.get(faCardInfo.getDeprMethod().getNumber());
        FaDepreciationSchemeInfo scheme = mode.getScheme().get(0);
        Interpreter interpreter = new Interpreter(ctx);
        HashMap localCtx = new HashMap();
        this.initInterpreter(ctx, faCardInfo, interpreter, localCtx);
        Object _periodDepreRate = null;
        Object _periodDepreAmount = null;
        try {
            _periodDepreRate = interpreter.eval(scheme.getMonDepRateExpr(), localCtx);
            if (!(_periodDepreRate instanceof Number)) {
                throw new FaDpreCalcException(FaDpreCalcException.DEPRRATE_NOT_NUMBER, new Object[]{faCardInfo.getNumber(), _periodDepreRate == null ? ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"76_FaDepCalUserDefinedStrategy", (Locale)ctx.getOriginLocale()) : _periodDepreRate.toString()});
            }
            BigDecimal periodDepreRate = new BigDecimal(_periodDepreRate.toString()).setScale(depreRatePrecision, 4);
            if (periodDepreRate.compareTo(new BigDecimal("0")) <= 0 || periodDepreRate.compareTo(new BigDecimal("1")) > 0) {
                throw new FaDpreCalcException(FaDpreCalcException.DEPRRATE_INVALID, new Object[]{faCardInfo.getNumber(), periodDepreRate});
            }
            faCardInfo.setMonthDepreRate(periodDepreRate);
            _periodDepreAmount = interpreter.eval(scheme.getMonDepExpr(), localCtx);
            if (!(_periodDepreAmount instanceof Number)) {
                throw new FaDpreCalcException(FaDpreCalcException.DEPRVALUE_NOT_NUMBER, new Object[]{faCardInfo.getNumber(), _periodDepreAmount == null ? ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"76_FaDepCalUserDefinedStrategy", (Locale)ctx.getOriginLocale()) : _periodDepreAmount.toString()});
            }
            BigDecimal periodDepreAmount = new BigDecimal(_periodDepreAmount.toString()).setScale(baseCurPrecision, 4);
            if (periodDepreAmount.compareTo(new BigDecimal("0")) < 0) {
                throw new FaDpreCalcException(FaDpreCalcException.DEPRVALUE_NEGATIVE, new Object[]{faCardInfo.getNumber(), periodDepreAmount});
            }
            periodDepreAmount = this.dealPeriodAmount(faCardInfo, periodDepreAmount);
            HashMap<Integer, BigDecimal> returnValue = new HashMap<Integer, BigDecimal>();
            returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, periodDepreAmount);
            returnValue.put(FaDepreCalculator.FA_DEP_RATE, periodDepreRate.multiply(new BigDecimal("100")));
            return returnValue;
        }
        catch (InterpreterException e) {
            logger.error((Object)e);
            throw new FaDpreCalcException(FaDpreCalcException.DEPR_EVAL_ERROR, e, new Object[]{faCardInfo.getNumber(), e.getMessage() == null ? "Unexpected Exception" : e.getMessage()});
        }
    }

    private void initDecCache(Context ctx, String companyId, String periodId) throws BOSException {
        String sql = "select entry.curcard,entry.decValue where period.id='" + periodId + "' and company.id='" + companyId + "' and checkedStatus=" + 2;
        FaDecValueCollection decInfos = FaDecValueFactory.getLocalInstance(ctx).getFaDecValueCollection(sql);
        if (decInfos.size() == 0) {
            this.decValueCache = new HashMap();
        } else {
            this.decValueCache = new HashMap();
            FaDecValueInfo decInfo = decInfos.get(0);
            for (int i = 0; i < decInfo.getEntry().size(); ++i) {
                FaDecValueEntryInfo decEntry = decInfo.getEntry().get(i);
                this.decValueCache.put(decEntry.getCurcard().getId().toString(), decEntry.getDecValue());
            }
        }
    }

    private void initWorkloadCache(Context ctx, String companyId, String periodId) throws BOSException {
        String sql = "select currentWorkLoad,curCard.id where period.id='" + periodId + "' and company.id='" + companyId + "'";
        FaWorkLoadCollection works = FaWorkLoadFactory.getLocalInstance(ctx).getFaWorkLoadCollection(sql);
        if (works.size() == 0) {
            this.workLoadCache = new HashMap();
        } else {
            this.workLoadCache = new HashMap();
            for (int i = 0; i < works.size(); ++i) {
                this.workLoadCache.put(works.get(i).getCurCard().getId().toString(), works.get(i).getCurrentWorkLoad());
            }
        }
    }

    private void initInterpreter(Context ctx, FaCurCardInfo faCardInfo, Interpreter interpreter, Map localCtx) throws DataAccessException, KScriptException, BOSException {
        localCtx.put("__bosContext", ctx);
        localCtx.put("__src", faCardInfo);
        BOTMappingInfo botMappingInfo = new BOTMappingInfo();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo srcEntity = loader.getEntity(new FaCurCardInfo().getBOSType());
        botMappingInfo.setSrcEntity(srcEntity);
        botMappingInfo.setDestEntity(srcEntity);
        List funcProviderList = new ArrayList();
        try {
            funcProviderList = BOTPTools.getBOTTransform((Context)ctx, (BOTMappingInfo)botMappingInfo).getFunctionProviderList();
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < funcProviderList.size(); ++i) {
            interpreter.addFunctionProvider((IFunctionProvider)funcProviderList.get(i));
        }
        interpreter.setProperyExprOwnerNullIgore(true);
        interpreter.setForBot(true);
        interpreter.setDefaultObject((Object)faCardInfo);
    }

    public void initModes(Context ctx) throws BOSException {
        this.deprModes = FaUtils.getUserDepreciationMode((Context)ctx, (boolean)false);
        this.hasInited = true;
    }

    private BigDecimal getThisPeriodWorkload(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo periodInfo) throws BOSException, EASBizException {
        if (this.getUserObject() != null) {
            return (BigDecimal)this.getUserObject();
        }
        IFaWorkLoad workLoad = null;
        workLoad = FaWorkLoadFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("curCard", (Object)faCardInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)periodInfo.getId().toString()));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        FaWorkLoadCollection faWorkLoadCol = workLoad.getFaWorkLoadCollection(evi);
        if (faWorkLoadCol.size() > 0) {
            FaWorkLoadInfo workLoadInfo = faWorkLoadCol.get(0);
            return workLoadInfo.getCurrentWorkLoad();
        }
        throw new FaDpreCalcException(FaDpreCalcException.THIS_PERIOD_WORKLOAD_ISNOTDEF);
    }

    @Override
    public HashMap getCalParameter(Context ctx, FaDepreciationModeInfo mode) throws BOSException {
        HashMap<String, String> hm = new HashMap<String, String>();
        if (!mode.isIsCustom()) {
            hm.put("assetValue", "");
            hm.put("accuDepr", "");
            hm.put("decValue", "");
            hm.put("neatRemValue", "");
        } else {
            if (this.customSelector.containsKey(mode.getId().toString())) {
                return (HashMap)this.customSelector.get(mode.getId().toString());
            }
            SelectorItemCollection sic = FaDepLocalUtils.getUserDepSelector(ctx, null, mode.getId().toString());
            for (int i = 0; i < sic.size(); ++i) {
                if (sic.get(i).getPropertyName().indexOf(".") != -1) continue;
                hm.put(sic.get(i).getPropertyName(), "");
            }
            this.customSelector.put(mode.getId().toString(), hm);
        }
        return hm;
    }

    @Override
    public HashMap calcuatePeriodDepreResultStatic(Context ctx, FaCurCardInfo faCardInfo, PeriodInfo period) throws BOSException, EASBizException {
        if (FaUtils.isUserDefinedMethod((FaDepreciationModeInfo)faCardInfo.getDeprMethod())) {
            return this.calcByFormula(ctx, faCardInfo, period);
        }
        HashMap<Integer, BigDecimal> returnValue = new HashMap<Integer, BigDecimal>();
        int baseCurPrecision = this.getBaseCurrencyPrecision(ctx, faCardInfo.getCompany());
        int depreRatePrecision = this.getDeprRatePrecision();
        BigDecimal depAmount = null;
        BigDecimal depRate = null;
        if (this.getLeftAmount(faCardInfo).compareTo(zero) <= 0) {
            return null;
        }
        BigDecimal assetValue = faCardInfo.getAssetValue() == null ? new BigDecimal("0") : faCardInfo.getAssetValue();
        BigDecimal useTermCount = faCardInfo.getUseTermCount() == null ? new BigDecimal("0") : faCardInfo.getUseTermCount();
        BigDecimal neatRemValue = faCardInfo.getNeatRemValue() == null ? new BigDecimal("0") : faCardInfo.getNeatRemValue();
        BigDecimal thisWorkload = this.getThisPeriodWorkload(ctx, faCardInfo, period);
        BigDecimal unitDep = assetValue.subtract(neatRemValue).divide(useTermCount, baseCurPrecision, 4);
        depAmount = unitDep.multiply(thisWorkload).setScale(baseCurPrecision, 4);
        depRate = depAmount.multiply(new BigDecimal("100")).divide(assetValue, depreRatePrecision, 4);
        depAmount = this.dealPeriodAmount(faCardInfo, depAmount);
        returnValue.put(FaDepreCalculator.FA_DEP_AMOUNT, depAmount);
        returnValue.put(FaDepreCalculator.FA_DEP_RATE, depRate);
        return returnValue;
    }

    @Override
    public boolean haveLifeForDep(FaCurCardInfo faCardInfo, Context ctx) throws BOSException {
        try {
            PeriodInfo period = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)faCardInfo.getCompany());
            if (this.getThisPeriodWorkload(ctx, faCardInfo, period).compareTo(zero) > 0) {
                return faCardInfo.getAssetValue().compareTo(new BigDecimal("0")) > 0;
            }
            return false;
        }
        catch (EASBizException eASBizException) {
            return false;
        }
    }
}

